/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.RecoveryEventListener;
import java.util.ArrayList;
import java.util.List;

public class RegisteredRecoveryEventListeners
implements RecoveryEventListener {
    private static final TraceComponent tc = Tr.register(RegisteredRecoveryEventListeners.class, "Transaction", null);
    private static final RegisteredRecoveryEventListeners _instance = new RegisteredRecoveryEventListeners();
    private List _listeners = null;

    public static RegisteredRecoveryEventListeners instance() {
        return _instance;
    }

    private RegisteredRecoveryEventListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public synchronized void add(RecoveryEventListener recoveryEventListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add", recoveryEventListener);
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(recoveryEventListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add");
        }
    }

    public void failureOccurred(FailureScope failureScope) {
        if (this._listeners == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "failureOccurred", failureScope);
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RecoveryEventListener recoveryEventListener = (RecoveryEventListener)this._listeners.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notifying " + recoveryEventListener);
            }
            try {
                recoveryEventListener.failureOccurred(failureScope);
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Exception notifying " + recoveryEventListener, throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "failureOccurred");
        }
    }

    public void clientRecoveryInitiated(FailureScope failureScope, int n) {
        if (this._listeners == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clientRecoveryInitiated", new Object[]{failureScope, new Integer(n)});
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RecoveryEventListener recoveryEventListener = (RecoveryEventListener)this._listeners.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notifying " + recoveryEventListener);
            }
            try {
                recoveryEventListener.clientRecoveryInitiated(failureScope, n);
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Exception notifying " + recoveryEventListener, throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clientRecoveryInitiated");
        }
    }

    public void clientRecoveryComplete(FailureScope failureScope, int n) {
        if (this._listeners == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clientRecoveryComplete", new Object[]{failureScope, new Integer(n)});
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RecoveryEventListener recoveryEventListener = (RecoveryEventListener)this._listeners.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notifying " + recoveryEventListener);
            }
            try {
                recoveryEventListener.clientRecoveryComplete(failureScope, n);
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Exception notifying " + recoveryEventListener, throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clientRecoveryComplete");
        }
    }

    public void recoveryComplete(FailureScope failureScope) {
        if (this._listeners == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryComplete", failureScope);
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RecoveryEventListener recoveryEventListener = (RecoveryEventListener)this._listeners.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notifying " + recoveryEventListener);
            }
            try {
                recoveryEventListener.recoveryComplete(failureScope);
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Exception notifying " + recoveryEventListener, throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryComplete");
        }
    }
}

