/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.DataItem;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl;
import java.nio.BufferUnderflowException;

public class SingleDataItem
extends DataItem {
    private static final TraceComponent tc = Tr.register(SingleDataItem.class, "Transaction", null);

    public SingleDataItem(int n, byte[] byArray, RecoverableUnitSectionImpl recoverableUnitSectionImpl) {
        super(n, byArray, recoverableUnitSectionImpl);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SingleDataItem", new Object[]{new Integer(n), RLSUtils.toHexString(byArray, 32), recoverableUnitSectionImpl});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SingleDataItem", this);
        }
    }

    public SingleDataItem(int n, ReadableLogRecord readableLogRecord, RecoverableUnitSectionImpl recoverableUnitSectionImpl) throws InternalLogException {
        super(n, readableLogRecord, recoverableUnitSectionImpl);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SingleDataItem", new Object[]{new Integer(n), readableLogRecord, recoverableUnitSectionImpl});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SingleDataItem", this);
        }
    }

    protected void setData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setData", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        int n = this._dataSize + 4;
        int n2 = 0;
        if (!this._written) {
            n2 = n;
        }
        this._rus.payloadDeleted(n, n2);
        this._data = byArray;
        this._dataSize = byArray.length;
        this._filePosition = -1;
        this._written = false;
        this._rus.payloadAdded(this._data.length + 4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setData");
        }
    }

    protected void setData(ReadableLogRecord readableLogRecord) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setData", new Object[]{this, readableLogRecord});
        }
        int n = this._dataSize + 4;
        int n2 = 0;
        if (!this._written) {
            n2 = n;
        }
        this._rus.payloadDeleted(n, n2);
        this._logRecord = readableLogRecord;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading data size field @ position " + readableLogRecord.position());
            }
            this._dataSize = readableLogRecord.getInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This data item contains " + this._dataSize + " bytes of data");
            }
            this._rus.payloadAdded(this._dataSize + 4);
            this._rus.payloadWritten(this._dataSize + 4);
            this._written = true;
            if (this._storageMode == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reading " + this._dataSize + "bytes of data @ position " + readableLogRecord.position());
                }
                this._data = new byte[this._dataSize];
                this._logRecord.get(this._data);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Tracking " + this._dataSize + "bytes of data @ position " + readableLogRecord.position());
                }
                this._filePosition = readableLogRecord.position();
                this._data = null;
                this._logRecord.advancePosition(this._dataSize);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            FFDCFilter.processException((Throwable)bufferUnderflowException, "com.ibm.ws.recoverylog.spi.SingleDataItem.setData", "180", this);
            throw new InternalLogException(bufferUnderflowException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.SingleDataItem.setData", "185", this);
            throw new InternalLogException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setData");
        }
    }
}

