/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.ByteBuffer;

public class WriteableLogRecord
extends LogRecord {
    private static final TraceComponent tc = Tr.register(WriteableLogRecord.class, "Transaction", null);
    private long _sequenceNumber = 0L;

    protected WriteableLogRecord(ByteBuffer byteBuffer, long l, int n, int n2) {
        super(byteBuffer, n2);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WriteableLogRecord", new Object[]{byteBuffer, new Long(l), new Integer(n), new Integer(n2)});
        }
        this._buffer.put(RECORD_MAGIC_NUMBER);
        this._buffer.putLong(l);
        this._buffer.putInt(n);
        this._sequenceNumber = l;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WriteableLogRecord", this);
        }
    }

    protected void put(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "put", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing at position " + this._buffer.position());
        }
        this._buffer.put(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "put");
        }
    }

    protected void putInt(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putInt", new Object[]{this, new Integer(n)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing at position " + this._buffer.position());
        }
        this._buffer.putInt(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putInt");
        }
    }

    protected void putLong(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putLong", new Object[]{this, new Long(l)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing at position " + this._buffer.position());
        }
        this._buffer.putLong(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putLong");
        }
    }

    protected void putShort(short s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putShort", new Object[]{this, new Short(s)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing at position " + this._buffer.position());
        }
        this._buffer.putShort(s);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putShort");
        }
    }

    protected void putBoolean(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putBoolean", new Object[]{this, new Boolean(bl)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing at position " + this._buffer.position());
        }
        this._buffer.put(bl ? (byte)1 : 0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putBoolean");
        }
    }

    protected void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", this);
        }
        this._buffer.putLong(this._sequenceNumber);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }
}

