/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.LongObjectHashMap;

public final class RecoverableUnitIdTable {
    private static final TraceComponent tc = Tr.register(RecoverableUnitIdTable.class, "Transaction", null);
    private long _idCount = 1L;
    private LongObjectHashMap _idMap = new LongObjectHashMap(256);

    public final synchronized long nextId(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nextId", object);
        }
        long l = this._idCount++;
        while (this._idMap.get(l) != null) {
            ++this._idCount;
        }
        this._idMap.put(l, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nextId", new Long(l));
        }
        return l;
    }

    public final synchronized void removeId(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeId", new Long(l));
        }
        this._idMap.remove(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeId");
        }
    }

    public final synchronized boolean reserveId(long l, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reserveId", new Object[]{new Long(l), object});
        }
        boolean bl = false;
        if (this._idMap.get(l) == null) {
            this._idMap.put(l, object);
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reserveId", new Boolean(bl));
        }
        return bl;
    }

    public final synchronized Object[] getAllObjects() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllObjects");
        }
        Object[] objectArray = this._idMap.values();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllObjects", objectArray);
        }
        return objectArray;
    }
}

