/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.ejs.cm.portability.PortableSQLException;
import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.ce.j2c.ConnectionWaitTimeoutException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.J2CConfigPropertiesAndStatAccess;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class AdapterUtil {
    public static final String NLS_FILE = "IBMDataStoreAdapterNLS";
    public static final String TRACE_GROUP = "RRA";
    private static final TraceComponent tc = Tr.register(AdapterUtil.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final TraceNLS NLS = TraceNLS.getTraceNLS("IBMDataStoreAdapterNLS");
    public static final String WS_SQL_STATE = "WS000";
    public static final int TRANSACTION_SNAPSHOT = 16;
    public static final int TRANSACTION_SS_SNAPSHOT = 4096;
    public static final int CONCUR_SS_SCROLL_LOCKS = 1009;
    public static final int CONCUR_SS_OPTIMISTIC_CCVAL = 1010;
    public static final int TYPE_SS_SCROLL_DYNAMIC = 1006;
    public static final int TYPE_SS_DIRECT_FORWARD_ONLY = 2003;
    public static final int TYPE_SS_SERVER_CURSOR_FORWARD_ONLY = 2004;
    public static final String PMI_SQL_STRING = "SQLString";
    public static final String PMI_JNDI_NAME = "DataSourceJNDIName";
    public static final String EOLN = System.getProperty("line.separator");
    public static final String INDENT = "                                 ";
    private static final String prepend = "eis/";
    private static final String postpend = "_CMP";
    public static final int CMX_DS_POST_INIT = 100;
    public static final int CMX_GET_CONN = 110;
    public static final int CMX_TRAN_END = 120;
    public static final int CMX_XA_END = 121;
    public static final int CMX_PRE_STMT_EXEC = 130;
    public static final int CMX_REGISTER_INTERST = 200;
    public static final int CMX_NOTIFICATION_CONNECTION_LIMIT = 400;
    public static final int RESOURCE_ADAPTER_BASE = 0;
    public static final int STATEMENT = 1;
    public static final int PS = 2;
    public static final int MC = 3;
    public static final int JDBC_CONN = 4;
    public static final int XA_RESOURCE = 5;
    public static final int DS = 6;
    public static final int SPI_LOCAL_TRAN = 7;
    public static final int ONE_PHASE_XA_RESOURCE = 8;
    public static final int TIME_TYPE_SECONDS = 0;
    public static final int TIME_TYPE_MILLISECOND = 1;
    public static final int TIME_TYPE_MICROSECOND = 2;
    public static final int TIME_TYPE_NANOSECOND = 3;
    private static final UOWCurrent uow = TransactionManagerFactory.getUOWCurrent();
    static final TransactionManager tm = TransactionManagerFactory.getTransactionManager();
    private static final HashSet classesAllowedToBeLoaded = new HashSet();
    static /* synthetic */ Class class$java$lang$Throwable;

    public static String checkName(String string, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkName " + string + ", EJB Mod Ver: " + n + ",EJB CMP Ver: " + n2);
        }
        String string2 = string;
        if (n >= 20) {
            if (n2 >= 2) {
                if (!string.startsWith(prepend) || !string.endsWith(postpend)) {
                    string2 = prepend + string + postpend;
                }
            } else if (n2 == 1 && string.startsWith(prepend) && string.endsWith(postpend)) {
                string2 = string.substring(prepend.length(), string.lastIndexOf(postpend));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkName result: " + string2);
        }
        return string2;
    }

    public static String restoreJndiName(String string) {
        String string2 = string;
        if (string != null) {
            int n = string.indexOf(prepend);
            int n2 = string.indexOf(postpend);
            if (n != -1 && n2 != -1) {
                string2 = string.substring(n += prepend.length(), n2);
            }
        }
        return string2;
    }

    public static final DataStoreAdapterException createDataStoreAdapterException(String string, Object object, Throwable throwable, Class clazz) {
        Object[] objectArray;
        if (object == null) {
            objectArray = null;
        } else if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        return new DataStoreAdapterException(string, objectArray, throwable, object == null ? AdapterUtil.getNLSMessage(string) : (object instanceof Object[] ? AdapterUtil.getNLSMessage(string, (Object[])object) : AdapterUtil.getNLSMessage(string, object)), clazz);
    }

    public static XAException createXAException(String string, Object object, int n) {
        XAException xAException = new XAException(object == null ? AdapterUtil.getNLSMessage(string) : AdapterUtil.getNLSMessage(string, object));
        xAException.errorCode = n;
        return xAException;
    }

    public static Throwable getChainedException(Throwable throwable) {
        Method[] methodArray = throwable.getClass().getMethods();
        Throwable throwable2 = null;
        for (int i = 0; i < methodArray.length && throwable2 == null; ++i) {
            if (!(class$java$lang$Throwable == null ? AdapterUtil.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(methodArray[i].getReturnType()) || methodArray[i].getName().equals("getSQLException") || !methodArray[i].getName().startsWith("get") || methodArray[i].getParameterTypes().length != 0 || !methodArray[i].getName().endsWith("Cause") && !methodArray[i].getName().endsWith("Exception") && !methodArray[i].getName().endsWith("Error") && !methodArray[i].getName().endsWith("Warning")) continue;
            try {
                throwable2 = (Throwable)methodArray[i].invoke((Object)throwable, null);
                continue;
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
        return throwable2;
    }

    public static String getConcurrencyModeString(int n) {
        switch (n) {
            case 1007: {
                return "CONCUR READ ONLY (" + n + ')';
            }
            case 1008: {
                return "CONCUR UPDATABLE (" + n + ')';
            }
            case 1009: {
                return "CONCUR SS SCROLL LOCKS (" + n + ')';
            }
            case 1010: {
                return "CONCUR SS OPTIMISTIC CCVAL (" + n + ')';
            }
        }
        return "UNKNOWN RESULT SET CONCURRENCY (" + n + ')';
    }

    public static String getConnectionEventString(int n) {
        switch (n) {
            case 1: {
                return "CONNECTION CLOSED (" + n + ')';
            }
            case 2: {
                return "LOCAL TRANSACTION STARTED (" + n + ')';
            }
            case 3: {
                return "LOCAL TRANSACTION COMMITTED (" + n + ')';
            }
            case 4: {
                return "LOCAL TRANSACTION ROLLEDBACK (" + n + ')';
            }
            case 5: {
                return "CONNECTION ERROR OCCURRED (" + n + ')';
            }
            case 900: {
                return "INTERACTION PENDING (" + n + ')';
            }
            case 51: {
                return "SINGLE_CONNECTION_ERROR_OCCURRED (" + n + ')';
            }
        }
        return "UNKNOWN CONNECTION EVENT CONSTANT (" + n + ')';
    }

    public static String getConnectionFactoryInterfaceName(Integer n) {
        if (AdapterUtil.match(n, ConnectionFactoryRefBuilder.FACTORY_WSJdbcDataSource)) {
            return DataSource.class.getName();
        }
        if (AdapterUtil.match(n, ConnectionFactoryRefBuilder.FACTORY_WSRdbConnectionFactory)) {
            return ConnectionFactory.class.getName();
        }
        return "UNKNOWN CONNECTION FACTORY TYPE: " + n;
    }

    public static String getFetchDirectionString(int n) {
        switch (n) {
            case 1000: {
                return "FETCH FORWARD (" + n + ')';
            }
            case 1001: {
                return "FETCH REVERSE (" + n + ')';
            }
            case 1002: {
                return "FETCH UNKNOWN (" + n + ')';
            }
        }
        return "UNRECOGNIZED FETCH DIRECTION CONSTANT (" + n + ')';
    }

    public static final int getGlobalTranStatus() {
        int n = 6;
        try {
            n = tm.getStatus();
        }
        catch (SystemException systemException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Recieving SystemException from TransactionManager, ignore it and change to STATUS_UNKNOWN");
            }
            n = 5;
        }
        return n;
    }

    public static final String getGlobalTranStatusAsString() {
        return AdapterUtil.getGlobalTranStatusString(AdapterUtil.getGlobalTranStatus());
    }

    public static String getGlobalTranStatusString(int n) {
        switch (n) {
            case 0: {
                return "STATUS ACTIVE (" + n + ')';
            }
            case 3: {
                return "STATUS COMMITTED (" + n + ')';
            }
            case 8: {
                return "STATUS COMMITTING (" + n + ')';
            }
            case 1: {
                return "STATUS MARKED ROLLBACK (" + n + ')';
            }
            case 6: {
                return "STATUS NO TRANSACTION (" + n + ')';
            }
            case 2: {
                return "STATUS PREPARED (" + n + ')';
            }
            case 7: {
                return "STATUS PREPARING (" + n + ')';
            }
            case 4: {
                return "STATUS ROLLEDBACK (" + n + ')';
            }
            case 9: {
                return "STATUS ROLLING BACK (" + n + ')';
            }
            case 5: {
                return "STATUS UNKNOWN (" + n + ')';
            }
        }
        return "UNKNOWN GLOBAL TRANSACTION STATUS (" + n + ')';
    }

    public static String getIsolationLevelString(int n) {
        switch (n) {
            case 0: {
                return "NONE (" + n + ')';
            }
            case 1: {
                return "READ UNCOMMITTED (" + n + ')';
            }
            case 2: {
                return "READ COMMITTED (" + n + ')';
            }
            case 4: {
                return "REPEATABLE READ (" + n + ')';
            }
            case 8: {
                return "SERIALIZABLE (" + n + ')';
            }
            case 16: 
            case 4096: {
                return "SNAPSHOT (" + n + ')';
            }
        }
        return "UNKNOWN ISOLATION LEVEL CONSTANT (" + n + ')';
    }

    public static final String getNLSMessage(String string) {
        return NLS.getString(string, string);
    }

    public static final String getNLSMessage(String string, Locale locale) {
        return locale == null ? AdapterUtil.getNLSMessage(string) : TraceNLS.getFormattedMessage(NLS_FILE, string, locale, null, string);
    }

    public static final String getNLSMessage(String string, Locale locale, Object object) {
        String string2;
        if (locale == null) {
            string2 = AdapterUtil.getNLSMessage(string, object);
        } else {
            Object[] objectArray;
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            }
            string2 = TraceNLS.getFormattedMessage(NLS_FILE, string, locale, objectArray, string);
        }
        return string2;
    }

    public static final String getNLSMessage(String string, Object object) {
        Object[] objectArray;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        return NLS.getFormattedMessage(string, objectArray, string);
    }

    public static String getResultSetTypeString(int n) {
        switch (n) {
            case 1003: {
                return "TYPE FORWARD ONLY (" + n + ')';
            }
            case 1004: {
                return "TYPE SCROLL INSENSITIVE (" + n + ')';
            }
            case 1005: {
                return "TYPE SCROLL SENSITIVE (" + n + ')';
            }
            case 1006: {
                return "TYPE SS SCROLL DYNAMIC (" + n + ')';
            }
            case 2003: {
                return "TYPE SS DIRECT FORWARD ONLY (" + n + ')';
            }
            case 2004: {
                return "TYPE SS SERVER CURSOR FORWARD ONLY (" + n + ')';
            }
        }
        return "UNKNOWN RESULT SET TYPE CONSTANT (" + n + ')';
    }

    public static String getSQLTypeString(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY (" + n + ')';
            }
            case -5: {
                return "BIGINT (" + n + ')';
            }
            case -2: {
                return "BINARY (" + n + ')';
            }
            case -7: {
                return "BIT (" + n + ')';
            }
            case 2004: {
                return "BLOB (" + n + ')';
            }
            case 1: {
                return "CHAR (" + n + ')';
            }
            case 2005: {
                return "CLOB (" + n + ')';
            }
            case 91: {
                return "DATE (" + n + ')';
            }
            case 3: {
                return "DECIMAL (" + n + ')';
            }
            case 2001: {
                return "DISTINCT (" + n + ')';
            }
            case 8: {
                return "DOUBLE (" + n + ')';
            }
            case 6: {
                return "FLOAT (" + n + ')';
            }
            case 4: {
                return "INTEGER (" + n + ')';
            }
            case 2000: {
                return "JAVA OBJECT (" + n + ')';
            }
            case -4: {
                return "LONGVARBINARY (" + n + ')';
            }
            case -1: {
                return "LONGVARCHAR (" + n + ')';
            }
            case 0: {
                return "NULL (" + n + ')';
            }
            case 2: {
                return "NUMERIC (" + n + ')';
            }
            case 1111: {
                return "OTHER (" + n + ')';
            }
            case 7: {
                return "REAL (" + n + ')';
            }
            case 2006: {
                return "REF (" + n + ')';
            }
            case 5: {
                return "SMALLINT (" + n + ')';
            }
            case 2002: {
                return "STRUCT (" + n + ')';
            }
            case 92: {
                return "TIME (" + n + ')';
            }
            case 93: {
                return "TIMESTAMP (" + n + ')';
            }
            case -6: {
                return "TINYINT (" + n + ')';
            }
            case -3: {
                return "VARBINARY (" + n + ')';
            }
            case 12: {
                return "VARCHAR (" + n + ')';
            }
        }
        return "UNKNOWN SQL TYPE (" + n + ')';
    }

    public static String getXAExceptionCodeString(int n) {
        switch (n) {
            case 107: {
                return "XA_RBTRANSIENT (" + n + ')';
            }
            case 100: {
                return "XA_RBROLLBACK (" + n + ')';
            }
            case 7: {
                return "XA_HEURCOM (" + n + ')';
            }
            case 8: {
                return "XA_HEURHAZ (" + n + ')';
            }
            case 5: {
                return "XA_HEURMIX (" + n + ')';
            }
            case 6: {
                return "XA_HEURRB (" + n + ')';
            }
            case 9: {
                return "XA_NOMIGRATE (" + n + ')';
            }
            case 101: {
                return "XA_RBCOMMFAIL (" + n + ')';
            }
            case 102: {
                return "XA_RBDEADLOCK (" + n + ')';
            }
            case 103: {
                return "XA_RBINTEGRITY (" + n + ')';
            }
            case 104: {
                return "XA_RBOTHER (" + n + ')';
            }
            case 105: {
                return "XA_RBPROTO (" + n + ')';
            }
            case 106: {
                return "XA_RBTIMEOUT (" + n + ')';
            }
            case 3: {
                return "XA_RDONLY (" + n + ')';
            }
            case 4: {
                return "XA_RETRY (" + n + ')';
            }
            case -2: {
                return "XAER_ASYNC (" + n + ')';
            }
            case -8: {
                return "XAER_DUPID (" + n + ')';
            }
            case -5: {
                return "XAER_INVAL (" + n + ')';
            }
            case -4: {
                return "XAER_NOTA (" + n + ')';
            }
            case -9: {
                return "XAER_OUTSIDE (" + n + ')';
            }
            case -6: {
                return "XAER_PROTO (" + n + ')';
            }
            case -3: {
                return "XAER_RMERR (" + n + ')';
            }
            case -7: {
                return "XAER_RMFAIL (" + n + ')';
            }
        }
        return "UNKNOWN XA EXCEPTION CODE (" + n + ')';
    }

    public static String getXAResourceEndFlagString(int n) {
        switch (n) {
            case 0x20000000: {
                return "TMFAIL (" + n + ')';
            }
            case 0x4000000: {
                return "TMSUCCESS (" + n + ')';
            }
            case 0x2000000: {
                return "TMSUSPEND (" + n + ')';
            }
        }
        return "UNKNOWN XA RESOURCE END FLAG (" + n + ')';
    }

    public static String getXAResourceRecoverFlagString(int n) {
        switch (n) {
            case 0x800000: {
                return "TMENDRSCAN (" + n + ')';
            }
            case 0: {
                return "TMNOFLAGS (" + n + ')';
            }
            case 0x1000000: {
                return "TMSTARTRSCAN (" + n + ')';
            }
            case 0x1800000: {
                return "TMSTARTRSCAN + TMENDRSCAN (" + n + ')';
            }
        }
        return "UNKNOWN XA RESOURCE RECOVER FLAG (" + n + ')';
    }

    public static String getXAResourceStartFlagString(int n) {
        switch (n) {
            case 0x200000: {
                return "TMJOIN (" + n + ')';
            }
            case 0: {
                return "TMNOFLAGS (" + n + ')';
            }
            case 0x8000000: {
                return "TMRESUME (" + n + ')';
            }
        }
        return "UNKNOWN XA RESOURCE START FLAG (" + n + ')';
    }

    public static String getXAResourceVoteString(int n) {
        switch (n) {
            case 0: {
                return "XA_OK (" + n + ')';
            }
            case 3: {
                return "XA_RDONLY (" + n + ')';
            }
        }
        return "UNKNOWN XA RESOURCE VOTE (" + n + ')';
    }

    public static Properties hidePassword(Properties properties) {
        Properties properties2 = properties;
        if (properties2 != null && (properties2 = (Properties)properties2.clone()).containsKey("password")) {
            properties2.setProperty("password", "******");
        }
        return properties2;
    }

    public static final boolean inGlobalTransaction() {
        UOWCoordinator uOWCoordinator = uow.getUOWCoord();
        return uOWCoordinator != null && uOWCoordinator.isGlobal();
    }

    public static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static String sqlWarningToString(SQLWarning sQLWarning) {
        if (sQLWarning == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        sQLWarning.printStackTrace(new PrintWriter(stringWriter));
        StringBuffer stringBuffer = new StringBuffer(stringWriter.toString());
        SQLWarning sQLWarning2 = sQLWarning.getNextWarning();
        if (sQLWarning2 != null && sQLWarning2 != sQLWarning) {
            stringBuffer.append("-------- linked warning -------").append(EOLN).append(AdapterUtil.sqlWarningToString(sQLWarning2));
        }
        return stringBuffer.toString();
    }

    public static String stackTraceToString(Throwable throwable) {
        return AdapterUtil.stackTraceToString(throwable, 10);
    }

    private static String stackTraceToString(Throwable throwable, int n) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        StringBuffer stringBuffer = new StringBuffer(stringWriter.toString());
        Throwable throwable2 = AdapterUtil.getChainedException(throwable);
        if (throwable2 != null && throwable2 != throwable) {
            stringBuffer.append("-------- chained exception -------").append(EOLN).append(n > 0 ? AdapterUtil.stackTraceToString(throwable2, n - 1) : "reached maximum chain depth");
        }
        return stringBuffer.toString();
    }

    public static DataStoreAdapterException translateSQLException(SQLException sQLException, Object object, boolean bl, Class clazz) {
        return (DataStoreAdapterException)((Object)AdapterUtil.mapException((Exception)((Object)new DataStoreAdapterException("DSA_ERROR", sQLException, clazz)), null, object, bl));
    }

    public static DataStoreAdapterException translateSQLException(SQLException sQLException, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl, Class clazz) {
        return (DataStoreAdapterException)((Object)AdapterUtil.mapException((Exception)((Object)new DataStoreAdapterException("DSA_ERROR", sQLException, clazz)), null, wSRdbManagedConnectionImpl, bl));
    }

    public static String toErrorMessage(Throwable throwable) {
        String string = throwable.getMessage();
        StringBuffer stringBuffer = new StringBuffer(string == null ? "" : string);
        Throwable throwable2 = AdapterUtil.getChainedException(throwable);
        if (throwable2 != null && throwable2 != throwable) {
            stringBuffer.append(" Chained ").append(throwable2.getClass().getName()).append(": ").append(AdapterUtil.toErrorMessage(throwable2));
        }
        return stringBuffer.toString();
    }

    public static Properties toProperties(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(string.replaceAll(";", EOLN).getBytes()));
        return properties;
    }

    public static SQLException toSQLException(ResourceException resourceException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toSQLException", (Object)resourceException);
        }
        SQLException sQLException = null;
        Throwable throwable = resourceException;
        while (throwable != null) {
            if (throwable instanceof SQLException) {
                sQLException = (SQLException)throwable;
                break;
            }
            if (throwable instanceof ResourceAllocationException && throwable.getMessage() != null && throwable.getMessage().indexOf("DSRA1110E") >= 0) {
                sQLException = new com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException(throwable.getMessage());
                sQLException.initCause(resourceException);
                break;
            }
            if (throwable instanceof ConnectionWaitTimeoutException) {
                sQLException = new com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException(throwable.getMessage());
                sQLException.initCause(resourceException);
                break;
            }
            throwable = AdapterUtil.getChainedException(throwable);
        }
        if (sQLException == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Converting ResourceException to a SQLException");
            }
            sQLException = new SQLException(resourceException.getMessage());
            sQLException.initCause(resourceException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toSQLException", new Object[]{AdapterUtil.getStackTraceWithState(sQLException)});
        }
        return sQLException;
    }

    public static SQLException toSQLException(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        SQLException sQLException = new SQLException(throwable.getClass().getName() + ": " + throwable.getMessage());
        sQLException.initCause(throwable);
        return sQLException;
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] < 0 ? 256 + byArray[i] : byArray[i];
                stringBuffer.append(Integer.toHexString(n / 16)).append(Integer.toHexString(n % 16)).append(' ');
            }
        }
        return new String(stringBuffer);
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof WSJdbcTracer) {
            return object.toString();
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    public static String toString(Xid xid) {
        StringBuffer stringBuffer = new StringBuffer();
        if (xid != null) {
            stringBuffer.append(AdapterUtil.toString((Object)xid)).append(EOLN).append(INDENT).append(xid).append(EOLN).append(INDENT).append("Global Transaction ID: ").append(AdapterUtil.toString(xid.getGlobalTransactionId())).append(EOLN).append(INDENT).append("Branch Qualifier:      ").append(AdapterUtil.toString(xid.getBranchQualifier())).append(EOLN).append(INDENT).append("Format ID:             ").append(xid.getFormatId());
        }
        return new String(stringBuffer);
    }

    public static String getLockTypeAsString(int n) {
        switch (n) {
            case 1: {
                return "LOCKTYPE_SELECT (" + n + ')';
            }
            case 2: {
                return "LOCKTYPE_SELECT_FOR_UPDATE (" + n + ')';
            }
            case 3: {
                return "LOCKTYPE_SELECT_FOR_UPDATE_WITH_RS (" + n + ')';
            }
            case 4: {
                return "LOCKTYPE_SELECT_FOR_UPDATE_WITH_RR (" + n + ')';
            }
        }
        return "UNKNOWN LOCK TYPE (" + n + ')';
    }

    public static String getHelperTypeAsString(int n) {
        switch (n) {
            case -1: {
                return "CUSTOM_HELPER (" + n + ')';
            }
            case 1: {
                return "DB2_HELPER (" + n + ')';
            }
            case 2: {
                return "DB2_400_HELPER (" + n + ')';
            }
            case 3: {
                return "DB2_390_HELPER (" + n + ')';
            }
            case 4: {
                return "DB2_UNIVERSAL_HELPER (" + n + ')';
            }
            case 5: {
                return "GENERIC_HELPER (" + n + ')';
            }
            case 6: {
                return "DATADIRECT_HELPER (" + n + ')';
            }
            case 7: {
                return "CONNECTJDBC_HELPER (" + n + ')';
            }
            case 8: {
                return "WSCONNECTJDBC_HELPER (" + n + ')';
            }
            case 9: {
                return "SEQUELINK_HELPER (" + n + ')';
            }
            case 10: {
                return "MSSQL_HELPER (" + n + ')';
            }
            case 11: {
                return "SYBASE_HELPER (" + n + ')';
            }
            case 12: {
                return "SYBASE11_HELPER (" + n + ')';
            }
            case 13: {
                return "ORACLE_HELPER (" + n + ')';
            }
            case 14: {
                return "INFORMIX_HELPER (" + n + ')';
            }
            case 15: {
                return "DB2_390_LOCAL_HELPER (" + n + ')';
            }
            case 17: {
                return "ORACLE_10G_HELPER (" + n + ')';
            }
            case 18: {
                return "DERBY_NETWORK_SERVER_HELPER (" + n + ')';
            }
            case 19: {
                return "DERBY_HELPER (" + n + ')';
            }
            case 20: {
                return "PROXY_DS_HELPER (" + n + ')';
            }
            case 22: {
                return "ORACLE_11G_HELPER (" + n + ')';
            }
        }
        return "UNKNOWN HELPER TYPE (" + n + ')';
    }

    public static StringBuffer getStackTraceWithState(SQLException sQLException) {
        SQLException sQLException2 = sQLException;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(EOLN);
        do {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            sQLException2.printStackTrace(printWriter);
            if (bl) {
                stringBuffer.append("---- Begin backtrace for Nested Throwables").append(EOLN);
            }
            stringBuffer.append("SQL STATE:  " + sQLException2.getSQLState()).append(EOLN);
            stringBuffer.append("ERROR CODE: " + sQLException2.getErrorCode()).append(EOLN);
            stringBuffer.append(stringWriter.toString());
            bl = true;
        } while ((sQLException2 = sQLException2.getNextException()) != null);
        return stringBuffer;
    }

    public static String getResultSetCloseString(int n) {
        switch (n) {
            case 3: {
                return "CLOSE ALL RESULTS (" + n + ')';
            }
            case 1: {
                return "CLOSE CURRENT RESULT (" + n + ')';
            }
            case 2: {
                return "KEEP CURRENT RESULT (" + n + ')';
            }
        }
        return "UNKNOWN CLOSE RESULTSET CONSTANT (" + n + ')';
    }

    public static String getCursorHoldabilityString(int n) {
        switch (n) {
            case 2: {
                return "CLOSE CURSORS AT COMMIT (" + n + ')';
            }
            case 1: {
                return "HOLD CURSORS OVER COMMIT (" + n + ')';
            }
            case 0: {
                return "DEFAULT CURSOR HOLDABILITY VALUE (" + n + ')';
            }
        }
        return "UNKNOWN CURSOR HOLDABILITY CONSTANT (" + n + ')';
    }

    public static String getAutoGeneratedKeyString(int n) {
        switch (n) {
            case 2: {
                return "NO GENERATED KEYS (" + n + ')';
            }
            case 1: {
                return "RETURN GENERATED KEYS (" + n + ')';
            }
        }
        return "UNKNOWN AUTO GENERATED KEYS CONSTANT (" + n + ')';
    }

    public static Object[] populateArrayForTrace(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n + 2);
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                arrayList.add(null);
                continue;
            }
            if (object.getClass().isArray()) {
                int n2;
                int n3;
                Object[] objectArray2;
                arrayList.add("{");
                if (object.getClass().getComponentType().isPrimitive()) {
                    if (object.getClass().getComponentType() == Integer.TYPE) {
                        objectArray2 = (int[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Integer((int)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Float.TYPE) {
                        objectArray2 = (float[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Float((float)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Double.TYPE) {
                        objectArray2 = (double[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Double((double)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Byte.TYPE) {
                        objectArray2 = (byte[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Byte((byte)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Short.TYPE) {
                        objectArray2 = (short[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Short((short)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Long.TYPE) {
                        objectArray2 = (long[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Long((long)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Boolean.TYPE) {
                        objectArray2 = (boolean[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Boolean((boolean)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Character.TYPE) {
                        objectArray2 = (char[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Character((char)objectArray2[n2]));
                        }
                    }
                } else {
                    objectArray2 = (Object[])object;
                    n3 = objectArray2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        arrayList.add(objectArray2[n2]);
                    }
                }
                arrayList.add("}");
                continue;
            }
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public static SQLException mapSQLException(SQLException sQLException, Object object) {
        return (SQLException)AdapterUtil.mapException(sQLException, null, object, true);
    }

    public static Level getLevelBasedOnName(String string) {
        Level level = Level.INFO;
        if (string == null) {
            return level;
        }
        char c = string.charAt(0);
        switch (c) {
            case 'I': 
            case 'i': {
                level = Level.INFO;
                break;
            }
            case 'A': 
            case 'a': {
                level = Level.ALL;
                break;
            }
            case 'S': 
            case 's': {
                level = Level.SEVERE;
                break;
            }
            case 'W': 
            case 'w': {
                level = Level.WARNING;
                break;
            }
            case 'C': 
            case 'c': {
                level = Level.CONFIG;
                break;
            }
            case 'F': 
            case 'f': {
                if (string.equalsIgnoreCase("fine")) {
                    level = Level.FINE;
                }
                if (string.equalsIgnoreCase("finer")) {
                    level = Level.FINER;
                }
                if (!string.equalsIgnoreCase("finest")) break;
                level = Level.FINEST;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The level returned is: ", level);
        }
        return level;
    }

    public static Object createDBUtility(final String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create Database utility instance using CCL: " + string);
        }
        if (!classesAllowedToBeLoaded.contains(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "utility can not load unknown class: ", string);
            }
            throw new SQLException(AdapterUtil.getNLSMessage("UNKNOWN_WAS_CLASS", string));
        }
        try {
            try {
                return AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Class.forName(string, true, (ClassLoader)ExtClassLoader.getInstance()).newInstance();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.error(tc, "Error getting classloader: " + privilegedActionException);
                throw privilegedActionException.getException();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.rsadapter.AdapterUtil.createDBUtility", "1746");
            throw exception;
        }
    }

    public static boolean isInstance(DataStoreHelper dataStoreHelper, String string) {
        try {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                clazz = Class.forName(string, false, classLoader);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.error(tc, "Error getting classloader: " + privilegedActionException);
            }
            return clazz.isInstance(dataStoreHelper);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.rsadapter.AdapterUtil.isInstance", "1804");
            return false;
        }
    }

    public static boolean isAssignableFromNamed(String string, String string2) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        ClassLoader classLoader = null;
        String string3 = "";
        try {
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.error(tc, "Error getting classloader: " + privilegedActionException);
            }
            string3 = string;
            clazz = Class.forName(string3, false, classLoader);
            string3 = string2;
            clazz2 = Class.forName(string3, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting class: " + string3 + " : " + classNotFoundException);
            }
            return false;
        }
    }

    public static Exception mapException(Exception exception, Object object, Object object2, boolean bl) {
        SQLException sQLException;
        DataStoreAdapterException dataStoreAdapterException;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapException", new Object[]{exception.getClass().getName(), AdapterUtil.toString(object), AdapterUtil.toString(object2), bl ? "Send EVENT" : "Do not send EVENT"});
        }
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = object2 instanceof WSRdbManagedConnectionImpl ? (WSRdbManagedConnectionImpl)object2 : null;
        WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl = object2 instanceof WSManagedConnectionFactoryImpl || wSRdbManagedConnectionImpl == null ? (WSManagedConnectionFactoryImpl)object2 : wSRdbManagedConnectionImpl.getManagedConnectionFactory();
        DataStoreAdapterException dataStoreAdapterException2 = dataStoreAdapterException = exception instanceof DataStoreAdapterException ? (DataStoreAdapterException)((Object)exception) : null;
        SQLException sQLException2 = exception instanceof SQLException ? (SQLException)exception : (sQLException = dataStoreAdapterException != null && dataStoreAdapterException.containsSqlException() ? (SQLException)dataStoreAdapterException.getCause() : null);
        if (wSManagedConnectionFactoryImpl == null || sQLException == null || sQLException instanceof PortableSQLException || dataStoreAdapterException != null && dataStoreAdapterException.beenMapped()) {
            if (dataStoreAdapterException == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapException", "not mapping");
                }
                return sQLException;
            }
            if (sQLException instanceof PortableSQLException) {
                dataStoreAdapterException.setBeenMapped();
            }
            if (sQLException instanceof StaleConnectionException && !(sQLException instanceof StaleStatementException)) {
                dataStoreAdapterException.setConnectionError(true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapException", "not mapping");
            }
            return dataStoreAdapterException;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        SQLException sQLException3 = wSManagedConnectionFactoryImpl.getDataStoreHelper().mapException(sQLException);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mapped to " + sQLException3.getClass().getName() + "; original exception is:", AdapterUtil.getStackTraceWithState(sQLException));
        }
        if (sQLException3 instanceof StaleStatementException) {
            if (object instanceof WSJdbcObject) {
                sQLException3 = WSJdbcUtil.handleStaleStatement((WSJdbcObject)object, sQLException3);
            } else if (object instanceof WSRdbConnectionImpl) {
                sQLException3 = ((WSRdbConnectionImpl)object).handleStaleStatement(sQLException3);
            } else {
                if (wSRdbManagedConnectionImpl != null) {
                    wSRdbManagedConnectionImpl.clearStatementCache();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remapping StaleStatementException to StaleConnectionException");
                }
                sQLException3 = new StaleConnectionException(sQLException3.getNextException());
            }
        } else if (wSManagedConnectionFactoryImpl.ispropagateClientIdentityUsingTrustedContextEnabled() && (bl3 = wSManagedConnectionFactoryImpl.getInternalDataStoreHelper().isAnAuthorizationException(sQLException3)) || sQLException3 instanceof StaleConnectionException) {
            if (bl3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SCE exception is an authorization exception not a stale");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SCE exception is NOT an authorization exception, but rather a connection error");
                }
                bl2 = true;
            }
            if (bl) {
                if (object instanceof WSJdbcConnection) {
                    ((WSJdbcConnection)object).fireConnectionErrorEvent(sQLException);
                } else if (object instanceof WSRdbConnectionImpl) {
                    ((WSRdbConnectionImpl)object).fireConnectionErrorEvent(sQLException);
                } else if (wSRdbManagedConnectionImpl != null) {
                    wSRdbManagedConnectionImpl.processConnectionErrorOccurredEvent(object, sQLException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapException", sQLException3.getClass().getName());
        }
        if (dataStoreAdapterException == null) {
            return sQLException3;
        }
        dataStoreAdapterException.setLinkedException(sQLException3);
        dataStoreAdapterException.setAuthorizationException(bl3);
        dataStoreAdapterException.setBeenMapped();
        dataStoreAdapterException.setConnectionError(bl2);
        return dataStoreAdapterException;
    }

    public static String concatWithHash(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "concatWithHash(String A, String B)", new Object[]{string, string2});
        }
        if (string == null || "".equals(string)) {
            return string2;
        }
        if (string2 == null || "".equals(string2)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 1);
        stringBuilder.append(string).append("#").append(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "concatWithHash returns: ", stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static void displayApplicationInfoAndPostCMXMsg(boolean bl, boolean bl2, J2EEName j2EEName, String string, InternalDataStoreHelper internalDataStoreHelper, int n, Object[] objectArray, Object object) {
        boolean bl3;
        boolean bl4 = bl3 = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl3) {
            Tr.debug(tc, "displayApplicationInfoAndPostCMXMsg(displayData, pushCMXMessage, j2eename, appServerName, internalHelper, cmxMessageType, cmxArgs, DBObject", new Object[]{new Boolean(bl), new Boolean(bl2), j2EEName, string, internalDataStoreHelper, new Integer(n), objectArray, object});
            if (bl) {
                Tr.debug(tc, "The application server name is: ", string);
                if (j2EEName != null) {
                    Tr.debug(tc, "The app name    is: ", j2EEName.getApplication());
                    Tr.debug(tc, "The module name is: ", j2EEName.getModule());
                    Tr.debug(tc, "The bean name   is: ", j2EEName.getComponent());
                } else {
                    Tr.debug(tc, "j2EEName is null");
                }
            }
        }
        if (bl2) {
            if (bl3) {
                Tr.debug(tc, "now posting CMX data (cmxMessageType, cmxArgs, DBObject)", new Object[]{new Integer(n), objectArray, object});
            }
            internalDataStoreHelper.postCMXMessage(n, objectArray, object, true);
        }
    }

    public static void setupCMXNotification(Object object, Object object2, InternalDataStoreHelper internalDataStoreHelper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Registering cmx interst for: ", object);
        }
        internalDataStoreHelper.postCMXMessage(200, new Object[]{object.toString(), object}, object2, true);
    }

    public static Object[] getcmxArgsObject(int n, J2EEName j2EEName, J2CConfigPropertiesAndStatAccess j2CConfigPropertiesAndStatAccess, Object object, String string, String string2, Integer n2) {
        boolean bl;
        Object[] objectArray = null;
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "getcmxArgsObject(int callerType, J2EEName _j2ename, J2CConfigPropertiesAndStatAccess poolStats, Object caller, String wasVersion,String jndiName, Integer poolInitMaxConn)", new Object[]{new Integer(n), j2EEName, j2CConfigPropertiesAndStatAccess, object, string, string2, n2});
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (j2EEName != null) {
                    objectArray = new Object[]{object.toString(), j2EEName.getApplication(), j2EEName.getComponent(), j2EEName.getModule(), RasHelper.getThreadId()};
                    break;
                }
                objectArray = new Object[]{object.toString(), null, null, null, RasHelper.getThreadId()};
                break;
            }
            case 3: {
                int n3 = j2CConfigPropertiesAndStatAccess.getCurrentFreeConnections();
                int n4 = n3 + j2CConfigPropertiesAndStatAccess.getCurrentInUseConnections();
                objectArray = new Object[]{object.toString(), new Integer(2), new Long(((WSRdbManagedConnectionImpl)object).getConnectionWaitTime()), new Integer(n3), new Integer(n4)};
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = new Object[]{object.toString()};
                break;
            }
            case 6: {
                WSRdbDataSource wSRdbDataSource = (WSRdbDataSource)object;
                objectArray = new Object[]{object.toString(), n2, string2, wSRdbDataSource.getManagedConnectionFactory().appServerName, string};
            }
        }
        if (bl) {
            Tr.debug(tc, "getcmxArgsObject: returning: ", objectArray);
        }
        return objectArray;
    }

    static {
        classesAllowedToBeLoaded.add("com.ibm.ws.rsadapter.dbutils.impl.DB2AS400NativeUtilityImpl");
        classesAllowedToBeLoaded.add("com.ibm.ws.rsadapter.dbutils.impl.DB2AS400ToolBoxUtilityImpl");
        classesAllowedToBeLoaded.add("com.ibm.ws.rsadapter.dbutils.impl.DB2UniversalUtilityImpl");
        classesAllowedToBeLoaded.add("com.ibm.ws.rsadapter.dbutils.impl.WSJccUtilityImpl");
        classesAllowedToBeLoaded.add("com.ibm.ws.rsadapter.dbutils.impl.OracleUtilityImpl");
    }
}

