/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.rsadapter.DSPropertyEntry;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.security.util.AccessController;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class DSConfigurationHelper {
    private static final TraceComponent tc = Tr.register(DSConfigurationHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    public static final String DERBY = "Derby";
    public static final String DB2 = "DB2";
    public static final String DB2_400 = "DB2/400";
    public static final String INFORMIX = "Informix";
    public static final String MS_SQL_SERVER = "Microsoft SQL Server";
    public static final String ORACLE = "Oracle";
    public static final String SYBASE = "Sybase";
    public static final String UNSUPPORTED = "Unsupported";
    public static final String CLOUDSCAPE = "Cloudscape";
    public static final String SQL_SERVER = "SQL Server";
    public static final String USER_DEFINED = "User-defined";
    public static final String DATABASE_NAME = "databaseName";
    public static final String DATA_SOURCE_NAME = "dataSourceName";
    public static final String INTEGRATED_SECURITY = "integratedSecurity";
    public static final String LOGIN_TIMEOUT = "loginTimeout";
    public static final String LOG_WRITER = "logWriter";
    public static final String PASSWORD = "password";
    public static final String PORT_NUMBER = "portNumber";
    public static final String SERVER_NAME = "serverName";
    public static final String USER = "user";
    public static final String READONLY = "readOnly";
    public static final String PKLIST = "pkList";
    public static final String PLANNAME = "planName";
    public static final String ACCOUNTINGINTERVAL = "accountingInterval";
    public static final String SECURITYmECHANISM = "securityMechanism";
    public static final String KERBEROSSERVERPRINCIPAL = "kerberosServerPrincipal";
    public static final String ZOS_LEGACY_DRIVER_NAME = "DSNAJDBC";
    public static final String BEGIN_TRAN_FOR_SCROLLING_APIS = "beginTranForResultSetScrollingAPIs";
    public static final String CONNECTION_MANAGER_CLASS = "connectionManagerClass";
    public static final String CONNECTION_SHARING = "connectionSharing";
    public static final String DATA_SOURCE_CLASS = "dataSourceClass";
    public static final String DATA_STORE_HELPER_CLASS = "dataStoreHelperClass";
    public static final String DATABASE_TYPE = "databaseType";
    public static final String ENABLE_2_PHASE = "enable2Phase";
    public static final String DISABLE_2_PHASE = "disable2Phase";
    public static final String ENABLE_MULTITHREADED_ACCESS_DETECTION = "enableMultithreadedAccessDetection";
    public static final String ENABLE_SQLJ = "enableSQLJ";
    public static final String INFORMIX_LOCK_MODE_WAIT = "informixLockModeWait";
    public static final String INFORMIX_ALLOW_NEWLINE = "informixAllowNewLine";
    public static final String STATEMENT_CACHE_SIZE = "statementCacheSize";
    public static final String USER_DEFINED_ERROR_MAP = "userDefinedErrorMap";
    public static final String ISOLATION_SWITCHING_SUPPORT = "isolationLevelSwitchingSupport";
    public static final String ORACLELOG_FILE_SIZE_LIMIT = "oracleLogFileSizeLimit";
    public static final String ORACLELOG_FILE_COUNT = "oracleLogFileCount";
    public static final String ORACLELOG_FILENAME = "oracleLogFileName";
    public static final String ORACLELOG_TRACELEVEL = "oracleLogTraceLevel";
    public static final String ORACLE9iLOG_TRACELEVEL = "oracle9iLogTraceLevel";
    public static final String ORACLELOG_FORMAT = "oracleLogFormat";
    public static final String ORACLELOG_PACKAGENAME = "oracleLogPackageName";
    public static final String DB2_TRACE_LEVEL = "traceLevel";
    public static final String DB2_TRACE_FILE = "traceFile";
    public static final String TRANSACTION_BRANCHES_LOOSELY_COUPLED = "transactionBranchesLooselyCoupled";
    public static final String DISABLE_BACKEND_ID_CHECKING = "disableBackendIdChecking";
    public static final String VALIDATE_AFTER_CONNECTION_ERROR = "validateAfterConnectionError";
    public static final String ZOS_CURRENT_SQLID = "currentSQLID";
    public static final String DB2_DRIVER_TYPE = "driverType";
    public static final String PRE_TEST_SQL_STRING = "preTestSQLString";
    public static final String JMS_ONE_PHASE_OPTIMIZATION = "jmsOnePhaseOptimization";
    public static final String REAUTHENTICATION = "reauthentication";
    public static final String RESET_CONNECTION_BY_BACKEND_DATABASE = "resetConnectionByBackendDatabase";
    public static final String DISABLE_WAS_CONNECTION_POOLING = "disableWASConnectionPooling";
    public static final String ORACLE_CONNECTION_CACHING_ENABLED = "connectionCachingEnabled";
    public static final String ORACLE_CONNECTION_CACHE_NAME = "connectionCacheName";
    public static final String REMOVE_EXISTING_ORACLE_CACHE_If_ONE_EXISTS = "removeExistingOracleConnectionPoolIfExists";
    public static final String DB_FAILOVER_ENABLED = "dbFailOverEnabled";
    public static final String DB_FAILOVER_CONNECTION_RETRY_COUNT = "connRetriesDuringDBFailover";
    public static final String DB_FAILOVER_CONNECTION_RETRY_INTERVAL = "connRetryIntervalDuringDBFailover";
    public static final String VALIDATE_CONNECTION_FAILOVER_SERVERS = "datasourceFailoverServers";
    public static final String VALIDATE_NEW_CONNECTION = "validateNewConnection";
    public static final String VALIDATE_NEW_CONNECTION_RETRY_COUNT = "validateNewConnectionRetryCount";
    public static final String VALIDATE_NEW_CONNECTION_RETRY_INTERVAL = "validateNewConnectionRetryInterval";
    public static final String WAS_DEFAULT_ISOLATION_LEVEL = "webSphereDefaultIsolationLevel";
    public static final String ENABLE_END_TO_END_MONITORING = "enableEndToEndMonitoringFeature";
    public static final String DATASOURCE_CLIENT_ACCOUNTING_INFO = "clientAccountingInformation";
    public static final String DATASOURCE_CLIENT_LOCATION = "clientWorkstation";
    public static final String DATASOURCE_CLIENT_ID = "clientUser";
    public static final String DATASOURCE_CLIENT_APPLICATION_NAME = "clientApplicationInformation";
    public static final String COMMIT_OR_ROLLBACK_ON_CLEANUP = "commitOrRollbackOnCleanup";
    public static final String OPTIMIZE_DB2_FOR_GET_USE_CLOSE = "optimizeDB2ForGetUseClose";
    public static final String PROPAGATE_CLIENT_IDENTITY_USING_TRUSTED_CONTEXT = "propagateClientIdentityUsingTrustedContext";
    public static final String CONN_FACTORY_TYPE = "ConnectionFactoryType";
    public static final String DESCRIPTION = "description";
    public static final String AGED_TIMEOUT = "agedTimeout";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String MAX_CONNECTIONS = "maxConnections";
    public static final String MIN_CONNECTIONS = "minConnections";
    public static final String PURGE_POLICY = "purgePolicy";
    public static final String REAP_TIME = "reapTime";
    public static final String UNUSED_TIMEOUT = "unusedTimeout";
    public static final String ONE_PHASE = " (single phase)";
    public static final String TWO_PHASE = " (XA)";
    public static final String DB2_VENDOR = "(DB2UDBNT)(DB2EXPRESS)";
    public static final String DB2_ZOS_VENDOR = "(DB2UDBOS390)";
    public static final String DB2_400_VENDOR = "(DB2UDBAS400)";
    public static final String CLOUDSCAPE_VENDOR = "(CLOUDSCAPE)";
    public static final String DERBY_VENDOR = "(DERBY)";
    public static final String INFORMIX_VENDOR = "(INFORMIX)";
    public static final String MS_SQL_SERVER_VENDOR = "(MSSQLSERVER)";
    public static final String ORACLE_VENDOR = "(ORACLE)";
    public static final String SYBASE_VENDOR = "(SYBASE)";
    public static final String CLOUDSCAPE_OLD_DATABASE_NAME = "CloudscapeOldDatabaseName";
    public static final String CLOUDSCAPE_OLD_CLASSPATH_NAME = "CloudscapeOldClassPathName";
    public static final String DERBY_HELPER_NAME = "com.ibm.websphere.rsadapter.DerbyDataStoreHelper";
    public static final String DERBY_NS_U_HELPER_NAME = "com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper";
    public static final String CONNECTJDBC_HELPER_NAME = "com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper";
    public static final String DB2AS400_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2AS400DataStoreHelper";
    public static final String DB2_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2DataStoreHelper";
    public static final String DB2UNIVERSAL_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper";
    public static final String INFORMIX_HELPER_NAME = "com.ibm.websphere.rsadapter.InformixDataStoreHelper";
    public static final String MICROSOFT_SQL_SERVER_HELPER_NAME = "com.ibm.websphere.rsadapter.MicrosoftSQLServerDataStoreHelper";
    public static final String ORACLE_HELPER_NAME = "com.ibm.websphere.rsadapter.OracleDataStoreHelper";
    public static final String SYBASE_HELPER_NAME = "com.ibm.websphere.rsadapter.SybaseDataStoreHelper";
    public static final String WSCONNECTJDBC_HELPER_NAME = "com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper";
    public static final String SEQUELINK_HELPER_NAME = "com.ibm.websphere.rsadapter.SequeLinkDataStoreHelper";
    public static final String GENERIC_HELPER_NAME = "com.ibm.websphere.rsadapter.GenericDataStoreHelper";
    public static final int MATCH_CURRENT_ISOLATION = 1;
    public static final int MATCH_CURRENT_READ_ONLY = 2;
    private static String[] strictlyMatchedDatabase = new String[]{"(DB2UDBOS390)", "(ORACLE)"};
    private static final HashMap databaseProductNameToBackendMap = new HashMap(10);
    public static final String[] ADAPTER_PROPS;
    public static final String[] supportedDatabases;
    public static final String[] adminSupportedDatabases;
    private static final HashMap supportedDataSourceClassMap;
    private static final HashMap commonPropListMap;
    private static final Class[] PARAM_LIST_STRING;
    private static final Class[] PARAM_LIST_PROPS;
    static Hashtable classLoaderMap;
    public static boolean _disablePK54589;
    public static boolean _allowOraUpdateableConcurrency;
    public static boolean _skipInternalClearWarnings;
    public static boolean _allowSetReadOnlyForSybase;
    public static boolean _disableCheckingForAuthorizationException;
    public static boolean _runAsSystemForClientReroutePersistence;
    private static HashMap oneToOneMap;
    private static HashMap helperClassMap;
    private static HashMap XAMap;
    private static HashMap isDep;
    private static HashMap lookupTable;
    static /* synthetic */ Class class$java$lang$Void;

    public static String getDataStoreHelperClassName(String string, Object object) {
        List list = (List)commonPropListMap.get(string);
        String string2 = null;
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DSPropertyEntry dSPropertyEntry = (DSPropertyEntry)iterator.next();
                if (!dSPropertyEntry.getPropertyName().equals(DATA_STORE_HELPER_CLASS)) continue;
                string2 = (String)dSPropertyEntry.getDefaultValue();
                if (string2.equals(DB2UNIVERSAL_HELPER_NAME) && string.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource") && object == null) {
                    string2 = DB2_HELPER_NAME;
                }
                return string2;
            }
        }
        return GENERIC_HELPER_NAME;
    }

    public static final String getBackendIDFromDatabaseProductName(String string) {
        string = string.trim();
        return (String)databaseProductNameToBackendMap.get(string);
    }

    public static final boolean backendRequiresStrictMatch(String string) {
        for (int i = 0; i < strictlyMatchedDatabase.length; ++i) {
            if (!strictlyMatchedDatabase[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getDataStoreHelperClassName(String string) {
        List list = (List)commonPropListMap.get(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DSPropertyEntry dSPropertyEntry = (DSPropertyEntry)iterator.next();
                if (!dSPropertyEntry.getPropertyName().equals(DATA_STORE_HELPER_CLASS)) continue;
                return (String)dSPropertyEntry.getDefaultValue();
            }
        }
        return GENERIC_HELPER_NAME;
    }

    public static Object createDataSource(Object object) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDataSource", object);
        }
        try {
            Class clazz = object instanceof Class ? (Class)object : DSConfigurationHelper.loadClass((String)object);
            Object t = clazz.newInstance();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataSource", t);
            }
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataSource", "410");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataSource", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("DS_CLASS_NOT_FOUND", object, classNotFoundException, DSConfigurationHelper.class);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException(instantiationException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataSource", "416");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataSource", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("DS_CREATE_ERROR", new Object[]{object, instantiationException}, instantiationException, DSConfigurationHelper.class);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException(illegalAccessException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataSource", "426");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataSource", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("DS_CREATE_ERROR", new Object[]{object, illegalAccessException}, illegalAccessException, DSConfigurationHelper.class);
        }
    }

    public static DataStoreHelper createDataStoreHelper(String string, Properties properties) throws ResourceException {
        DataStoreHelper dataStoreHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDataStoreHelper", new Object[]{string, properties});
        }
        try {
            Class clazz = DSConfigurationHelper.loadClass(string);
            if (clazz.getName().equals(GENERIC_HELPER_NAME)) {
                Tr.warning(tc, "DSH_GEN_USED");
            }
            dataStoreHelper = (DataStoreHelper)clazz.getConstructor(PARAM_LIST_PROPS).newInstance(properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", "469");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataStoreHelper", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_NOT_FOUND", string, classNotFoundException, DSConfigurationHelper.class);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException(instantiationException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", "475");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataStoreHelper", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_IMPL_ERR", string, instantiationException, DSConfigurationHelper.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException(noSuchMethodException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", "481");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataStoreHelper", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_NEW_UP_ERR", string, noSuchMethodException, DSConfigurationHelper.class);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException(illegalAccessException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", "487");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataStoreHelper", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_ACCESS_ERR", string, illegalAccessException, DSConfigurationHelper.class);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", "493");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataStoreHelper", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_CAST_ERR", string, classCastException, DSConfigurationHelper.class);
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException(invocationTargetException, "com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", "499");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDataStoreHelper", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_CTOR_ERR", new Object[]{string, invocationTargetException.getTargetException()}, invocationTargetException.getTargetException(), DSConfigurationHelper.class);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDataStoreHelper", AdapterUtil.toString(dataStoreHelper));
        }
        return dataStoreHelper;
    }

    public static PooledConnection getPooledConnection(Object object, String string, String string2, boolean bl) throws ResourceException {
        return DSConfigurationHelper.getPooledConnection(object, string, string2, bl, false);
    }

    private static PooledConnection getPooledConnection(final Object object, String string, String string2, final boolean bl, boolean bl2) throws ResourceException {
        PooledConnection pooledConnection = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPooledConnection", new Object[]{AdapterUtil.toString(object), string, "******", bl ? "two-phase" : "one-phase", String.valueOf(bl2)});
        }
        final String string3 = string == null ? null : string.trim();
        final String string4 = string2 == null ? null : string2.trim();
        final PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return bl ? (string3 == null ? ((XADataSource)object).getXAConnection() : ((XADataSource)object).getXAConnection(string3, string4)) : (string3 == null ? ((ConnectionPoolDataSource)object).getPooledConnection() : ((ConnectionPoolDataSource)object).getPooledConnection(string3, string4));
            }
        };
        PrivilegedExceptionAction privilegedExceptionAction2 = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Object object;
                try {
                    object = SecurityContext.runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (Exception)privilegedActionException.getCause();
                }
                return object;
            }
        };
        try {
            pooledConnection = _runAsSystemForClientReroutePersistence ? (PooledConnection)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction2) : (PooledConnection)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (bl2) {
                if (tc.isDebugEnabled()) {
                    Exception exception = privilegedActionException.getException();
                    Tr.debug(tc, "Ignoring exception from getPooledConnection: ", exception);
                    if (exception instanceof SQLException) {
                        SQLException sQLException = (SQLException)exception;
                        Tr.debug(tc, "SQLState: " + sQLException.getSQLState());
                        Tr.debug(tc, "Error Code: " + sQLException.getErrorCode());
                    }
                }
            }
            FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.rsadapter.DSConfigurationHelper.getPooledConnection", "568");
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", bl ? "XAConnection" : "PooledConnection", privilegedActionException.getException(), DSConfigurationHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledConnection", "Exception");
            }
            throw dataStoreAdapterException;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, "com.ibm.ws.rsadapter.DSConfigurationHelper.getPooledConnection", "583");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught ClassCastException", classCastException);
            }
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException(bl ? "NOT_A_2_PHASE_DS" : "NOT_A_1_PHASE_DS", classCastException.getMessage(), null, DSConfigurationHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledConnection", "Exception");
            }
            throw dataStoreAdapterException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPooledConnection", AdapterUtil.toString(pooledConnection));
        }
        return pooledConnection;
    }

    public static Connection getConnectionUsingDS(final Object object, String string, String string2) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionUsingDS", new Object[]{AdapterUtil.toString(object), string, "******"});
        }
        final String string3 = string == null ? null : string.trim();
        final String string4 = string2 == null ? null : string2.trim();
        try {
            Connection connection = (Connection)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return string3 == null ? ((javax.sql.DataSource)object).getConnection() : ((javax.sql.DataSource)object).getConnection(string3, string4);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionUsingDS", AdapterUtil.toString(connection));
            }
            return connection;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.rsadapter.DSConfigurationHelper.getConnectionUsingDS", "1372");
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", "Connection", privilegedActionException.getException(), DSConfigurationHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionUsingDS", "Exception");
            }
            throw dataStoreAdapterException;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, "com.ibm.ws.rsadapter.DSConfigurationHelper.getConnectionUsingDS", "1312");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught ClassCastException", classCastException);
            }
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("NOT_A_1_PHASE_DS", classCastException.getMessage(), null, DSConfigurationHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionUsingDS", "Exception");
            }
            throw dataStoreAdapterException;
        }
    }

    public static List getPropertiesForDataSource(String string, final String string2) throws ClassNotFoundException {
        int n = string.indexOf(32);
        final String string3 = n > 0 ? string.substring(0, n) : string;
        ArrayList<DSPropertyEntry> arrayList = new ArrayList<DSPropertyEntry>();
        List list = (List)commonPropListMap.get(string);
        if (list == null) {
            list = (List)commonPropListMap.get(UNSUPPORTED);
        }
        arrayList.addAll(list);
        List list2 = DSConfigurationHelper.getPropertyNames(list);
        try {
            PropertyDescriptor[] propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Introspector.getBeanInfo(DSConfigurationHelper.loadDataSourceClass(string3, string2)).getPropertyDescriptors();
                }
            });
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (list2.contains(propertyDescriptor.getName()) || propertyDescriptor.getWriteMethod() == null || !DSConfigurationHelper.isRepresentableAsString(propertyDescriptor.getPropertyType())) continue;
                arrayList.add(new DSPropertyEntry(propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), false));
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            FFDCFilter.processException(exception, "com.ibm.ws.rsadapter.DSConfigurationHelper.getPropertiesForDataSource", "692");
            Tr.warning(tc, "CANT_READ_SETTERS", exception);
        }
        return arrayList;
    }

    private static List getPropertyNames(List list) {
        int n = list == null ? 0 : list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(i, ((DSPropertyEntry)list.get(i)).getPropertyName());
        }
        return arrayList;
    }

    public static final String[] getSupportedDatabases() {
        return supportedDatabases;
    }

    public static final String[] getAdminSupportedDatabases() {
        return adminSupportedDatabases;
    }

    public static final String[] getSupportedDataSourceClasses(String string) {
        String[] stringArray = (String[])supportedDataSourceClassMap.get(string);
        return stringArray == null ? new String[]{} : stringArray;
    }

    public static final boolean is2PhaseEnabled(Properties properties, Object object) {
        return properties.getProperty(ENABLE_2_PHASE) == null ? (properties.getProperty(DISABLE_2_PHASE) == null ? object instanceof XADataSource : !new Boolean(properties.getProperty(DISABLE_2_PHASE)).booleanValue()) : new Boolean(properties.getProperty(ENABLE_2_PHASE));
    }

    public static final boolean isRepresentableAsString(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        try {
            if (clazz.getConstructor(PARAM_LIST_STRING) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz.equals(Properties.class) || clazz.equals(Character.class);
    }

    public static Class loadClass(final String string) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = (class$com$ibm$ws$rsadapter$DSConfigurationHelper == null ? (class$com$ibm$ws$rsadapter$DSConfigurationHelper = DSConfigurationHelper.class$("com.ibm.ws.rsadapter.DSConfigurationHelper")) : class$com$ibm$ws$rsadapter$DSConfigurationHelper).getClassLoader();
                    }
                    return classLoader.loadClass(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    public static Class loadDataSourceClass(String string, String string2) throws ClassNotFoundException {
        Object object;
        if (string2 == null || string2.trim().length() == 0) {
            try {
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                return Class.forName(string, true, classLoader);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Tr.error(tc, "Error getting classloader: " + privilegedActionException);
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String string3 = string2.indexOf(92) >= 0 || string2.indexOf(59) >= 0 ? ";" : File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (file.isFile()) {
                arrayList.add(file);
                continue;
            }
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.toString().endsWith(".jar") || file.toString().endsWith(".zip");
                }
            });
            if (fileArray == null) continue;
            arrayList.addAll(Arrays.asList(fileArray));
        }
        int n = arrayList.size();
        if (n < 1) {
            throw new ClassNotFoundException(AdapterUtil.getNLSMessage("JAR_ZIP_NOT_FOUND", string2));
        }
        URL[] uRLArray = new URL[n];
        try {
            for (int i = 0; i < n; ++i) {
                uRLArray[i] = ((File)arrayList.get(i)).toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException(malformedURLException, "com.ibm.ws.rsadapter.DSConfigurationHelper.loadDataSourceClass", "901");
            throw new ClassNotFoundException(AdapterUtil.getNLSMessage("CANT_READ_JAR_ZIP", malformedURLException));
        }
        ClassLoader classLoader = null;
        try {
            object = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            classLoader = object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Tr.error(tc, "Error getting classloader: " + privilegedActionException);
        }
        object = new File(uRLArray[0].getFile());
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoaderMap.get(object);
        if (uRLClassLoader == null) {
            uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
            classLoaderMap.put(object, uRLClassLoader);
        }
        return Class.forName(string, true, uRLClassLoader);
    }

    public static HashMap parseErrorMap(String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseErrorMap", new Object[]{string});
        }
        if (string == null || string.length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parseErrorMap");
            }
            return null;
        }
        HashMap<Object, Class> hashMap = new HashMap<Object, Class>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 1) continue;
            try {
                int n = string2.indexOf(61);
                object = string2.charAt(0) == '\"' ? string2.substring(1, n - 1) : Integer.valueOf(string2.substring(0, n));
                String string3 = string2.substring(n + 1);
                if (string3.length() == 0) {
                    hashMap.put(object, class$java$lang$Void == null ? DSConfigurationHelper.class$("java.lang.Void") : class$java$lang$Void);
                    continue;
                }
                hashMap.put(object, DSConfigurationHelper.loadClass(string3));
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException(classNotFoundException, DSConfigurationHelper.class.getName() + ".parseErrorMap", "2204");
                object = AdapterUtil.createDataStoreAdapterException("PROP_SET_ERROR", new Object[]{USER_DEFINED_ERROR_MAP, "", string2}, classNotFoundException, DSConfigurationHelper.class);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "parseErrorMap", object);
                }
                throw object;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, DSConfigurationHelper.class.getName() + ".parseErrorMap", "2209");
                object = AdapterUtil.createDataStoreAdapterException("PROP_SET_ERROR", new Object[]{USER_DEFINED_ERROR_MAP, " = " + string2, throwable}, throwable, DSConfigurationHelper.class);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "parseErrorMap", object);
                }
                throw object;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseErrorMap", hashMap);
        }
        return hashMap;
    }

    public static final ArrayList setDataSourceProperties(Object object, Properties properties) throws ResourceException {
        return DSConfigurationHelper.setDataSourceProperties(object, properties, null);
    }

    private static ArrayList setDataSourceProperties(Object object, Properties properties, Locale locale) throws ResourceException {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>(16);
        final Class<?> clazz = object.getClass();
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException(exception, "com.ibm.ws.rsadapter.DSConfigurationHelper.setDataSourceProperties", "969");
            throw AdapterUtil.createDataStoreAdapterException("CANT_READ_SETTERS", exception, exception, DSConfigurationHelper.class);
        }
        String string3 = properties.getProperty(USER);
        boolean bl = string3 != null && string3.trim().length() > 0;
        boolean bl2 = false;
        String string4 = System.getProperty("os.name");
        if (string4.equalsIgnoreCase("OS/390") || string4.equalsIgnoreCase("Z/OS")) {
            bl2 = true;
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            string2 = propertyDescriptorArray[i].getName();
            string3 = (String)properties.remove(string2);
            if (string3 == null) continue;
            try {
                string3 = string3.trim();
                boolean bl3 = string2.equals(PASSWORD);
                if (string3.length() <= 0 && (!bl3 || !bl)) continue;
                DSConfigurationHelper.setProperty(object, propertyDescriptorArray[i], string3, !bl3);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException(noSuchMethodException, "com.ibm.ws.rsadapter.DSConfigurationHelper.setDataSourceProperties", "989");
                if (bl2 && string3.equals(DB2_DRIVER_TYPE)) {
                    throw AdapterUtil.createDataStoreAdapterException("DB2ZOS_CONFIG_ERROR", noSuchMethodException, noSuchMethodException, DSConfigurationHelper.class);
                }
                string = AdapterUtil.getNLSMessage("PROP_NOT_FOUND", locale, new Object[]{clazz.getName(), string2});
                arrayList.add(string);
                Tr.warning(tc, "CONFIG_WARN", string);
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                FFDCFilter.processException(throwable, "com.ibm.ws.rsadapter.DSConfigurationHelper.setDataSourceProperties", "1001");
                if (throwable instanceof InvocationTargetException) {
                    throwable2 = ((InvocationTargetException)throwable).getTargetException();
                }
                String string5 = throwable2.getClass().getName();
                string = AdapterUtil.getNLSMessage("PROP_SET_ERROR", locale, new Object[]{string2, throwable2.toString().indexOf(string5) < 0 ? ": " + string5 : "", throwable2});
                arrayList.add(string);
                Tr.warning(tc, "CONFIG_WARN", string);
            }
        }
        if (!properties.isEmpty()) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (Arrays.binarySearch(ADAPTER_PROPS, string2) >= 0) continue;
                string = AdapterUtil.getNLSMessage("PROP_NOT_FOUND", locale, new Object[]{clazz.getName(), string2});
                arrayList.add(string);
                Tr.warning(tc, "CONFIG_WARN", string);
            }
        }
        return arrayList;
    }

    public static void setProperty(Object object, PropertyDescriptor propertyDescriptor, String string, boolean bl) throws Exception {
        Method method2;
        Object object2 = null;
        String string2 = propertyDescriptor.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set " + string2 + " = " + (bl ? string : "******"));
        }
        if ((method2 = propertyDescriptor.getWriteMethod()) == null) {
            throw new NoSuchMethodException(AdapterUtil.getNLSMessage("NO_SETTER_METHOD", string2));
        }
        Class<?> clazz = method2.getParameterTypes()[0];
        if (!clazz.isPrimitive()) {
            object2 = clazz.equals(String.class) ? string : (clazz.equals(Properties.class) ? AdapterUtil.toProperties(string) : (clazz.equals(Character.class) ? new Character(string.charAt(0)) : clazz.getConstructor(String.class).newInstance(string)));
        } else if (clazz.equals(Integer.TYPE)) {
            object2 = new Integer(string);
        } else if (clazz.equals(Long.TYPE)) {
            object2 = new Long(string);
        } else if (clazz.equals(Boolean.TYPE)) {
            object2 = new Boolean(string);
        } else if (clazz.equals(Double.TYPE)) {
            object2 = new Double(string);
        } else if (clazz.equals(Float.TYPE)) {
            object2 = new Float(string);
        } else if (clazz.equals(Short.TYPE)) {
            object2 = new Short(string);
        } else if (clazz.equals(Byte.TYPE)) {
            object2 = new Byte(string);
        } else if (clazz.equals(Character.TYPE)) {
            object2 = new Character(string.charAt(0));
        }
        method2.invoke(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String testConnectionToDataSource(String string, String string2, String string3, Properties properties, final String string4, String string5, String string6) throws ClassNotFoundException {
        Serializable serializable;
        Object object;
        String string7;
        int n = string.indexOf(32);
        final String string8 = n > 0 ? string.substring(0, n) : string;
        Locale locale = new Locale(string5, string6);
        Connection connection = null;
        PooledConnection pooledConnection = null;
        DataStoreHelper dataStoreHelper = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties2 = (Properties)properties.clone();
        Properties properties3 = new Properties();
        String string9 = (String)properties2.remove(DATABASE_TYPE);
        if (string9 != null) {
            properties3.put(DATABASE_TYPE, string9);
        }
        if ((string9 = (String)properties2.remove(INFORMIX_LOCK_MODE_WAIT)) != null) {
            properties3.put(INFORMIX_LOCK_MODE_WAIT, string9);
        }
        if ((string9 = (String)properties2.remove(INFORMIX_ALLOW_NEWLINE)) != null) {
            properties3.put(INFORMIX_ALLOW_NEWLINE, string9);
        }
        if ((string9 = (String)properties2.remove(ORACLELOG_FILE_SIZE_LIMIT)) != null) {
            properties3.put(ORACLELOG_FILE_SIZE_LIMIT, string9);
        }
        if ((string9 = (String)properties2.remove(ORACLELOG_FILE_COUNT)) != null) {
            properties3.put(ORACLELOG_FILE_COUNT, string9);
        }
        if ((string9 = (String)properties2.remove(ORACLELOG_FILENAME)) != null) {
            properties3.put(ORACLELOG_FILENAME, string9);
        }
        if ((string9 = (String)properties2.remove(ORACLELOG_TRACELEVEL)) != null) {
            properties3.put(ORACLELOG_TRACELEVEL, string9);
        }
        if ((string9 = (String)properties2.remove(ORACLE9iLOG_TRACELEVEL)) != null) {
            properties3.put(ORACLE9iLOG_TRACELEVEL, string9);
        }
        if ((string9 = (String)properties2.remove(ORACLELOG_PACKAGENAME)) != null) {
            properties3.put(ORACLELOG_PACKAGENAME, string9);
        }
        if ((string9 = (String)properties2.remove(ORACLELOG_FORMAT)) != null) {
            properties3.put(ORACLELOG_FORMAT, string9);
        }
        if ((string9 = (String)properties2.remove(WAS_DEFAULT_ISOLATION_LEVEL)) != null) {
            properties3.put(WAS_DEFAULT_ISOLATION_LEVEL, string9);
        }
        if ((string9 = (String)properties2.remove(ZOS_CURRENT_SQLID)) != null) {
            properties3.put(ZOS_CURRENT_SQLID, string9);
        }
        if ((string9 = (String)properties2.remove(ISOLATION_SWITCHING_SUPPORT)) != null) {
            properties3.put(ISOLATION_SWITCHING_SUPPORT, string9);
        }
        if ((string7 = (String)properties2.remove(DATA_STORE_HELPER_CLASS)) != null) {
            if (string7.equals(GENERIC_HELPER_NAME)) {
                ++n2;
                stringBuffer.append(AdapterUtil.getNLSMessage("DSH_GEN_USED", locale)).append(FFDCLogger.EOLN);
            }
            try {
                ++n2;
                dataStoreHelper = DSConfigurationHelper.createDataStoreHelper(string7, properties3);
                --n2;
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException(resourceException, "com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", "1209");
                object = resourceException instanceof DataStoreAdapterException ? ((DataStoreAdapterException)resourceException).translate(locale) : resourceException.getMessage();
                stringBuffer.append((String)object).append(FFDCLogger.EOLN);
            }
        }
        try {
            ++n2;
            serializable = DSConfigurationHelper.parseErrorMap((String)properties2.remove(USER_DEFINED_ERROR_MAP));
            if (serializable != null && dataStoreHelper != null) {
                dataStoreHelper.setUserDefinedMap((Map)((Object)serializable));
            }
            --n2;
        }
        catch (ResourceException resourceException) {
            stringBuffer.append(resourceException.getMessage()).append(FFDCLogger.EOLN);
        }
        try {
            serializable = null;
            try {
                serializable = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return DSConfigurationHelper.loadDataSourceClass(string8, string4);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
            object = DSConfigurationHelper.createDataSource(serializable);
            ArrayList arrayList = DSConfigurationHelper.setDataSourceProperties(object, properties2, locale);
            int n3 = arrayList.size();
            n2 += n3;
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.append(arrayList.get(n4++)).append(FFDCLogger.EOLN);
            }
            n4 = 0;
            if (!DSConfigurationHelper.is2PhaseEnabled(properties, object) && (string9 = properties2.getProperty(ORACLE_CONNECTION_CACHING_ENABLED)) != null) {
                n4 = new Boolean(string9).booleanValue() ? 1 : 0;
            }
            if (n4 != 0) {
                connection = DSConfigurationHelper.getConnectionUsingDS(object, string2, string3);
            } else {
                pooledConnection = DSConfigurationHelper.getPooledConnection(object, string2, string3, DSConfigurationHelper.is2PhaseEnabled(properties, object));
                connection = pooledConnection.getConnection();
            }
            if (dataStoreHelper != null) {
                try {
                    ++n2;
                    dataStoreHelper.doConnectionSetup(connection);
                    --n2;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", "1285");
                    String string10 = AdapterUtil.getNLSMessage("HELPER_EXEC_ERR", locale, new Object[]{"doConnectionSetup", throwable.getMessage()});
                    Tr.warning(tc, "CONFIG_WARN", string10);
                    stringBuffer.append(string10).append(FFDCLogger.EOLN);
                    throw throwable;
                }
            }
            connection.getAutoCommit();
            if (connection != null) {
                connection.close();
            }
            connection = null;
            if (pooledConnection != null) {
                pooledConnection.close();
            }
            pooledConnection = null;
            stringBuffer.append(n2 == 0 ? AdapterUtil.getNLSMessage("TEST_DS_SUCCESSFUL", locale) : AdapterUtil.getNLSMessage("TEST_DS_WARNINGS", locale, new Integer(n2)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassNotFoundException(AdapterUtil.stackTraceToString(noClassDefFoundError));
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException(resourceException, "com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", "1336");
            object = resourceException.getCause();
            if (object == null) {
                object = resourceException;
            }
            String string11 = object instanceof DataStoreAdapterException ? ((DataStoreAdapterException)object).translate(locale) : ((Throwable)object).getMessage();
            String string12 = AdapterUtil.getNLSMessage("TEST_DS_FAIL", locale, new Object[]{object.getClass().getName(), string11});
            stringBuffer.append(string12);
            Tr.warning(tc, "CONFIG_WARN_WITH_X", new Object[]{string12, object});
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException(sQLException, "com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", "1356");
            object = AdapterUtil.getNLSMessage("TEST_DS_FAIL_SQLX", locale, new Object[]{sQLException.getSQLState(), new Integer(sQLException.getErrorCode()), sQLException.getMessage()});
            stringBuffer.append((String)object);
            Tr.warning(tc, "CONFIG_WARN_WITH_X", new Object[]{object, sQLException});
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", "1376");
            object = AdapterUtil.getNLSMessage("TEST_DS_FAIL", locale, new Object[]{throwable.getClass().getName(), AdapterUtil.toErrorMessage(throwable)});
            stringBuffer.append((String)object);
            Tr.warning(tc, "CONFIG_WARN_WITH_X", new Object[]{object, throwable});
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
            if (pooledConnection != null) {
                try {
                    pooledConnection.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return new String(stringBuffer);
    }

    /*
     * Loose catch block
     */
    public static int testConnectionForGUI(String string, String string2, String string3, Properties properties, final String string4) throws Exception {
        int n;
        block66: {
            Object object6222;
            StringBuffer stringBuffer;
            PooledConnection pooledConnection;
            PooledConnection pooledConnection2;
            Connection connection;
            HashMap hashMap;
            block63: {
                Object object2;
                Object object3;
                HashMap hashMap2;
                String string5;
                hashMap = null;
                int n2 = string.indexOf(32);
                final String string6 = n2 > 0 ? string.substring(0, n2) : string;
                connection = null;
                pooledConnection2 = null;
                pooledConnection = null;
                DataStoreHelper dataStoreHelper = null;
                n = 0;
                stringBuffer = new StringBuffer();
                String string7 = (String)properties.remove("mbeanProcessType");
                if (string7 == null) {
                    string7 = "other";
                }
                Properties properties2 = (Properties)properties.clone();
                Properties properties3 = new Properties();
                String string8 = (String)properties2.remove(DATABASE_TYPE);
                if (string8 != null) {
                    properties3.put(DATABASE_TYPE, string8);
                }
                if ((string8 = (String)properties2.remove(INFORMIX_LOCK_MODE_WAIT)) != null) {
                    properties3.put(INFORMIX_LOCK_MODE_WAIT, string8);
                }
                if ((string8 = (String)properties2.remove(INFORMIX_ALLOW_NEWLINE)) != null) {
                    properties3.put(INFORMIX_ALLOW_NEWLINE, string8);
                }
                if ((string8 = (String)properties2.remove(ORACLELOG_FILE_SIZE_LIMIT)) != null) {
                    properties3.put(ORACLELOG_FILE_SIZE_LIMIT, string8);
                }
                if ((string8 = (String)properties2.remove(ORACLELOG_FILE_COUNT)) != null) {
                    properties3.put(ORACLELOG_FILE_COUNT, string8);
                }
                if ((string8 = (String)properties2.remove(ORACLELOG_FILENAME)) != null) {
                    properties3.put(ORACLELOG_FILENAME, string8);
                }
                if ((string8 = (String)properties2.remove(ORACLELOG_TRACELEVEL)) != null) {
                    properties3.put(ORACLELOG_TRACELEVEL, string8);
                }
                if ((string8 = (String)properties2.remove(ORACLE9iLOG_TRACELEVEL)) != null) {
                    properties3.put(ORACLE9iLOG_TRACELEVEL, string8);
                }
                if ((string8 = (String)properties2.remove(ORACLELOG_PACKAGENAME)) != null) {
                    properties3.put(ORACLELOG_PACKAGENAME, string8);
                }
                if ((string8 = (String)properties2.remove(ORACLELOG_FORMAT)) != null) {
                    properties3.put(ORACLELOG_FORMAT, string8);
                }
                if ((string8 = (String)properties2.remove(WAS_DEFAULT_ISOLATION_LEVEL)) != null) {
                    properties3.put(WAS_DEFAULT_ISOLATION_LEVEL, string8);
                }
                if ((string8 = (String)properties2.remove(ZOS_CURRENT_SQLID)) != null) {
                    properties3.put(ZOS_CURRENT_SQLID, string8);
                }
                if ((string8 = (String)properties2.remove(ISOLATION_SWITCHING_SUPPORT)) != null) {
                    properties3.put(ISOLATION_SWITCHING_SUPPORT, string8);
                }
                if ((string5 = (String)properties2.remove(DATA_STORE_HELPER_CLASS)) != null) {
                    if (string5.equals(GENERIC_HELPER_NAME)) {
                        ++n;
                        stringBuffer.append(AdapterUtil.getNLSMessage("DSH_GEN_USED")).append(FFDCLogger.EOLN);
                    }
                    dataStoreHelper = DSConfigurationHelper.createDataStoreHelper(string5, properties3);
                }
                if ((hashMap2 = DSConfigurationHelper.parseErrorMap((String)properties2.remove(USER_DEFINED_ERROR_MAP))) != null && dataStoreHelper != null) {
                    dataStoreHelper.setUserDefinedMap(hashMap2);
                }
                hashMap = DSConfigurationHelper.setupMap(string4);
                Class clazz = null;
                try {
                    clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return DSConfigurationHelper.loadDataSourceClass(string6, string4);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (ClassNotFoundException)privilegedActionException.getException();
                }
                Object object4 = DSConfigurationHelper.createDataSource(clazz);
                ArrayList arrayList = DSConfigurationHelper.setDataSourceProperties(object4, properties2);
                int n3 = arrayList.size();
                n += n3;
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append(arrayList.get(n4++)).append(FFDCLogger.EOLN);
                }
                n4 = 0;
                if (!DSConfigurationHelper.is2PhaseEnabled(properties, object4) && (string8 = properties.getProperty(ORACLE_CONNECTION_CACHING_ENABLED)) != null) {
                    n4 = new Boolean(string8).booleanValue() ? 1 : 0;
                }
                if (n4 != 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using datasource");
                    }
                    connection = DSConfigurationHelper.getConnectionUsingDS(object4, string2, string3);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getting PooledConnection");
                    }
                    pooledConnection2 = DSConfigurationHelper.getPooledConnection(object4, string2, string3, DSConfigurationHelper.is2PhaseEnabled(properties, object4), false);
                    connection = pooledConnection2.getConnection();
                }
                if (connection != null && string.startsWith("com.sybase") && (object3 = connection.getWarnings()) != null) {
                    object2 = null;
                    String string9 = ((SQLException)object3).getSQLState();
                    if (string9.equals("010UF")) {
                        Object object5 = object2 = new SQLException(((Throwable)object3).getMessage(), string9);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string9 + ((Throwable)object3).getMessage());
                        }
                        for (object3 = ((SQLWarning)object3).getNextWarning(); object3 != null; object3 = ((SQLWarning)object3).getNextWarning()) {
                            object5 = new SQLException(((Throwable)object3).getMessage(), ((SQLException)object3).getSQLState());
                            ((SQLException)object2).setNextException((SQLException)object5);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, ((SQLException)object3).getSQLState() + ((Throwable)object3).getMessage());
                        }
                        throw object2;
                    }
                }
                if (dataStoreHelper != null) {
                    try {
                        ++n;
                        dataStoreHelper.doConnectionSetup(connection);
                        --n;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", "1285");
                        object2 = AdapterUtil.getNLSMessage("HELPER_EXEC_ERR", new Object[]{"doConnectionSetup", exception.getMessage()});
                        Tr.warning(tc, "CONFIG_WARN", object2);
                        stringBuffer.append((String)object2).append(FFDCLogger.EOLN);
                        throw exception;
                    }
                }
                connection.getAutoCommit();
                object3 = connection.getMetaData();
                Tr.info(tc, "DB_PRODUCT_NAME", object3.getDatabaseProductName());
                Tr.info(tc, "DB_PRODUCT_VERSION", object3.getDatabaseProductVersion());
                Tr.info(tc, "JDBC_DRIVER_NAME", object3.getDriverName());
                Tr.info(tc, "JDBC_DRIVER_VERSION", object3.getDriverVersion());
                if (connection != null && string.startsWith("org.apache.derby.jdbc.Embedded") && !string7.equals("server")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Do setup for Derby DB shutdown.");
                    }
                    object2 = new Properties();
                    ((Properties)object2).put("shutdownDatabase", "shutdown");
                    arrayList = DSConfigurationHelper.setDataSourceProperties(object4, (Properties)object2);
                    n3 = arrayList.size();
                    n += n3;
                    int n5 = 0;
                    while (n5 < n3) {
                        stringBuffer.append(arrayList.get(n5++)).append(FFDCLogger.EOLN);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting another getPooledConnection to do DB shutdown.");
                    }
                    pooledConnection = DSConfigurationHelper.getPooledConnection(object4, string2, string3, DSConfigurationHelper.is2PhaseEnabled(properties, object4), true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Completed getPooledConnection for DB shutdown.");
                    }
                    if (pooledConnection != null) {
                        pooledConnection.close();
                    }
                    pooledConnection = null;
                }
                if (connection != null) {
                    connection.close();
                }
                connection = null;
                if (pooledConnection2 != null) {
                    pooledConnection2.close();
                }
                pooledConnection2 = null;
                stringBuffer.append(n == 0 ? AdapterUtil.getNLSMessage("TEST_DS_SUCCESSFUL") : AdapterUtil.getNLSMessage("TEST_DS_WARNINGS", new Integer(n)));
                Object var30_38 = null;
                if (pooledConnection == null) break block63;
                try {
                    pooledConnection.close();
                }
                catch (Throwable object6222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable object6222) {
                    // empty catch block
                }
            }
            if (pooledConnection2 != null) {
                try {
                    pooledConnection2.close();
                }
                catch (Throwable object6222) {
                    // empty catch block
                }
            }
            if (hashMap != null && (object6222 = DynamicPolicyFactory.getInstance()) != null) {
                object6222.removePolicy(hashMap);
            }
            break block66;
            {
                catch (ResourceException resourceException) {
                    FFDCFilter.processException(resourceException, "com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", "1486");
                    Throwable throwable = resourceException.getCause();
                    if (throwable == null) {
                        throwable = resourceException;
                    }
                    String string10 = throwable.getMessage();
                    String string11 = AdapterUtil.getNLSMessage("TEST_DS_FAIL", new Object[]{throwable.getClass().getName(), string10});
                    stringBuffer.append(string11);
                    Tr.warning(tc, "CONFIG_WARN_WITH_X", new Object[]{string11, throwable});
                    throw throwable instanceof Exception ? (Exception)throwable : resourceException;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException(sQLException, "com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", "1504");
                    String string12 = AdapterUtil.getNLSMessage("TEST_DS_FAIL_SQLX", new Object[]{sQLException.getSQLState(), new Integer(sQLException.getErrorCode()), sQLException.getMessage()});
                    stringBuffer.append(string12);
                    Tr.warning(tc, "CONFIG_WARN_WITH_X", new Object[]{string12, sQLException});
                    throw sQLException;
                }
            }
            catch (Throwable throwable) {
                Object object72222;
                Object var30_39 = null;
                if (pooledConnection != null) {
                    try {
                        pooledConnection.close();
                    }
                    catch (Throwable object72222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable object72222) {
                        // empty catch block
                    }
                }
                if (pooledConnection2 != null) {
                    try {
                        pooledConnection2.close();
                    }
                    catch (Throwable object72222) {
                        // empty catch block
                    }
                }
                if (hashMap != null && (object72222 = DynamicPolicyFactory.getInstance()) != null) {
                    object72222.removePolicy(hashMap);
                }
                throw throwable;
            }
        }
        if (n == 0) {
            Tr.info(tc, "TEST_DS_SUCCESSFUL");
            return 0;
        }
        Tr.info(tc, "TEST_DS_WARNINGS", new Integer(n));
        return n;
    }

    private static HashMap setupMap(String string) {
        String string2 = string.indexOf(92) >= 0 || string.indexOf(59) >= 0 ? ";" : File.pathSeparator;
        HashMap<String, Object> hashMap = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        int n = arrayList.size();
        ObjectName objectName = AdminServiceFactory.getAdminService().getLocalServer();
        String string3 = objectName.getKeyProperty("processType");
        if (string3.equals("DeploymentManager") || string3.equals("NodeAgent")) {
            hashMap = new HashMap<String, Object>(2);
            hashMap.put("type", "spi");
            hashMap.put("classpath", arrayList.toArray(new String[n]));
            DynamicPolicy dynamicPolicy = DynamicPolicyFactory.getInstance();
            if (dynamicPolicy != null) {
                dynamicPolicy.setupPolicy(hashMap);
            }
        }
        return hashMap;
    }

    public static ArrayList getHelperListForDataSource(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource") || string.equals("com.ibm.db2.jcc.DB2XADataSource")) {
            if (string2.equals("DB2 Universal JDBC Driver Provider") || string2.equals("DB2 Universal JDBC Driver Provider (XA)")) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(0, DB2UNIVERSAL_HELPER_NAME);
                arrayList2.add(1, "DB2_Universal_DataStoreHelper");
                arrayList.add(0, arrayList2);
                arrayList2 = new ArrayList();
                arrayList2.add(0, DB2AS400_HELPER_NAME);
                arrayList2.add(1, "DB2_for_iSeries_DataStoreHelper");
                arrayList.add(1, arrayList2);
            } else if (string2.equals("DB2 for zOS Local JDBC Provider (RRS)")) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList3.add(0, DB2_HELPER_NAME);
                arrayList3.add(1, "DB2_DataStoreHelper");
                arrayList.add(0, arrayList3);
            } else if (string2.equals("Derby Network Server Using Universal JDBC Driver")) {
                ArrayList<String> arrayList4 = new ArrayList<String>();
                arrayList4.add(0, DERBY_NS_U_HELPER_NAME);
                arrayList4.add(1, "Derby_Network_Server_DataStoreHelper");
                arrayList.add(0, arrayList4);
            } else {
                ArrayList<String> arrayList5 = new ArrayList<String>();
                arrayList5.add(0, DB2UNIVERSAL_HELPER_NAME);
                arrayList5.add(1, "DB2_Universal_DataStoreHelper");
                arrayList.add(0, arrayList5);
                arrayList5 = new ArrayList();
                arrayList5.add(0, DB2AS400_HELPER_NAME);
                arrayList5.add(1, "DB2_for_iSeries_DataStoreHelper");
                arrayList.add(1, arrayList5);
                arrayList5 = new ArrayList();
                arrayList5.add(0, DERBY_NS_U_HELPER_NAME);
                arrayList5.add(1, "Derby_Network_Server_DataStoreHelper");
                arrayList.add(2, arrayList5);
            }
        } else if (string.equals("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource") || string.equals("COM.ibm.db2.jdbc.DB2XADataSource")) {
            ArrayList<String> arrayList6 = new ArrayList<String>();
            arrayList6.add(0, DB2_HELPER_NAME);
            arrayList6.add(1, "DB2_DataStoreHelper");
            arrayList.add(0, arrayList6);
        } else if (string.equals("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource") || string.equals("com.ibm.db2.jdbc.app.UDBXADataSource") || string.equals("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource") || string.equals("com.ibm.as400.access.AS400JDBCXADataSource")) {
            ArrayList<String> arrayList7 = new ArrayList<String>();
            arrayList7.add(0, DB2AS400_HELPER_NAME);
            arrayList7.add(1, "DB2_for_iSeries_DataStoreHelper");
            arrayList.add(0, arrayList7);
        } else if (string.equals("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource") || string.equals("org.apache.derby.jdbc.EmbeddedXADataSource")) {
            ArrayList<String> arrayList8 = new ArrayList<String>();
            arrayList8.add(0, DERBY_HELPER_NAME);
            arrayList8.add(1, "Derby_DataStoreHelper");
            arrayList.add(0, arrayList8);
        } else if (string.equals("org.apache.derby.jdbc.ClientXADataSource") || string.equals("org.apache.derby.jdbc.ClientConnectionPoolDataSource")) {
            ArrayList<String> arrayList9 = new ArrayList<String>();
            arrayList9.add(0, DERBY_NS_U_HELPER_NAME);
            arrayList9.add(1, "Derby_Network_Server_DataStoreHelper");
            arrayList.add(0, arrayList9);
        } else if (string.equals("com.informix.jdbcx.IfxConnectionPoolDataSource") || string.equals("com.informix.jdbcx.IfxXADataSource")) {
            ArrayList<String> arrayList10 = new ArrayList<String>();
            arrayList10.add(0, INFORMIX_HELPER_NAME);
            arrayList10.add(1, "Informix_DataStoreHelper");
            arrayList.add(0, arrayList10);
        } else if (string.equals("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource") || string.equals("com.sybase.jdbc2.jdbc.SybXADataSource")) {
            ArrayList<String> arrayList11 = new ArrayList<String>();
            arrayList11.add(0, SYBASE_HELPER_NAME);
            arrayList11.add(1, "Sybase_DataStoreHelper");
            arrayList.add(0, arrayList11);
        } else if (string.equals("oracle.jdbc.pool.OracleConnectionPoolDataSource") || string.equals("oracle.jdbc.xa.client.OracleXADataSource")) {
            ArrayList<String> arrayList12 = new ArrayList<String>();
            arrayList12.add(0, ORACLE_HELPER_NAME);
            arrayList12.add(1, "Oracle9i_and_prior_DataStoreHelper");
            arrayList.add(0, arrayList12);
            arrayList12 = new ArrayList();
            arrayList12.add(0, "com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper");
            arrayList12.add(1, "Oracle10g_DataStoreHelper");
            arrayList.add(1, arrayList12);
            arrayList12 = new ArrayList();
            arrayList12.add(0, "com.ibm.websphere.rsadapter.Oracle11gDataStoreHelper");
            arrayList12.add(1, "Oracle11g_DataStoreHelper");
            arrayList.add(2, arrayList12);
        } else if (string.equals("com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource") || string.equals("com.microsoft.sqlserver.jdbc.SQLServerXADataSource")) {
            ArrayList<String> arrayList13 = new ArrayList<String>();
            arrayList13.add(0, MICROSOFT_SQL_SERVER_HELPER_NAME);
            arrayList13.add(1, "Microsoft_SQL_Server_DataStoreHelper");
            arrayList.add(0, arrayList13);
        } else if (string.equals("com.ddtek.jdbcx.sqlserver.SQLServerDataSource")) {
            ArrayList<String> arrayList14 = new ArrayList<String>();
            arrayList14.add(0, CONNECTJDBC_HELPER_NAME);
            arrayList14.add(1, "DataDirect_ConnectJDBC_DataStoreHelper");
            arrayList.add(0, arrayList14);
        } else if (string.equals("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource")) {
            ArrayList<String> arrayList15 = new ArrayList<String>();
            arrayList15.add(0, WSCONNECTJDBC_HELPER_NAME);
            arrayList15.add(1, "WebSphere_Branded_ConnectJDBC_DataStoreHelper");
            arrayList.add(0, arrayList15);
        } else {
            ArrayList<String> arrayList16 = new ArrayList<String>();
            arrayList16.add(0, GENERIC_HELPER_NAME);
            arrayList16.add(1, "Generic_DataStoreHelper");
            arrayList.add(0, arrayList16);
        }
        return arrayList;
    }

    public static Properties validateAndAdjustHPProps(final Class clazz, Properties properties) throws ResourceException {
        String string;
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException(exception, "com.ibm.ws.rsadapter.DSConfigurationHelper.validateAndAdjustHPProps", "2610");
            throw AdapterUtil.createDataStoreAdapterException("CANT_READ_SETTERS", exception, exception, DSConfigurationHelper.class);
        }
        Properties properties2 = new Properties();
        properties.remove(DATABASE_NAME);
        properties.remove(PORT_NUMBER);
        properties.remove(SERVER_NAME);
        properties.remove(DB2_DRIVER_TYPE);
        properties.remove(READONLY);
        properties.remove(PKLIST);
        properties.remove(PLANNAME);
        properties.remove(ACCOUNTINGINTERVAL);
        properties.remove(SECURITYmECHANISM);
        properties.remove(KERBEROSSERVERPRINCIPAL);
        if (properties.remove(USER) != null) {
            Tr.warning(tc, "INVALID_EXTENDED_PROPERTY", new Object[]{USER, "Datasource extended properties"});
        }
        if (properties.remove(PASSWORD) != null) {
            Tr.warning(tc, "INVALID_EXTENDED_PROPERTY", new Object[]{PASSWORD, "Datasource extended properties"});
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            string = propertyDescriptorArray[i].getName();
            String string2 = (String)properties.remove(string);
            if (string2 == null || (string2 = string2.trim()).length() <= 0) continue;
            properties2.put(string, string2);
        }
        if (!properties.isEmpty()) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                Tr.warning(tc, "CONFIG_WARN", AdapterUtil.getNLSMessage("PROP_NOT_FOUND", null, new Object[]{clazz.getName(), string}));
            }
        }
        return properties2;
    }

    public static final String getProviderType(JDBCProvider jDBCProvider) throws Exception {
        Boolean bl;
        TraceComponent traceComponent = Tr.register(DSConfigurationHelper.class, "com.ibm.ws.migration.WASUpgrade", null);
        if (traceComponent.isEntryEnabled()) {
            Tr.entry(traceComponent, "getProviderType(JDBCProvider jdbcProv): ", jDBCProvider);
        }
        String string = null;
        String string2 = null;
        String string3 = jDBCProvider.getImplementationClassName();
        HashMap hashMap = (HashMap)lookupTable.get(string3);
        boolean bl2 = jDBCProvider.isXa();
        Boolean bl3 = new Boolean(bl2);
        Iterator iterator = null;
        try {
            iterator = jDBCProvider.getFactories().iterator();
            while (string2 == null && iterator.hasNext()) {
                bl = iterator.next();
                if (!(bl instanceof DataSource)) continue;
                DataSource dataSource = (DataSource)bl;
                string2 = dataSource.getDatasourceHelperClassname();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        bl = new Boolean(false);
        try {
            bl = new Boolean(jDBCProvider.getDescription().startsWith("Deprecated"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (hashMap == oneToOneMap) {
            string = (String)hashMap.get(string3);
        } else if (hashMap == XAMap) {
            string = (String)((HashMap)hashMap.get(string3)).get(bl3);
        } else if (hashMap == helperClassMap) {
            string = (String)((HashMap)hashMap.get(string3)).get(string2);
        } else if (hashMap == isDep) {
            string = (String)((HashMap)hashMap.get(string3)).get(bl);
        }
        if (string == null) {
            throw new Exception(AdapterUtil.getNLSMessage("PROVIDER_NOT_FOUND", jDBCProvider));
        }
        if (traceComponent.isEntryEnabled()) {
            Tr.exit(traceComponent, "getProviderType: returns", string);
        }
        return string;
    }

    public static boolean doesDSCustomProprtyExistInDS(String string, String string2) throws Exception {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesDSCustomProprtyExistInDS", new Object[]{string, string2});
        }
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            Class<?> clazz;
            try {
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                clazz = Class.forName(string, true, classLoader);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doesDSCustomProprtyExistInDS with exception: ", privilegedActionException);
                }
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
            propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                }
            });
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals(string2)) continue;
                bl = true;
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doesDSCustomProprtyExistInDS with exception: ", classNotFoundException);
            }
            throw AdapterUtil.createDataStoreAdapterException("DS_CLASS_NOT_FOUND", string, classNotFoundException, DSConfigurationHelper.class);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doesDSCustomProprtyExistInDS with exception ", privilegedActionException.getException());
            }
            throw privilegedActionException.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesDSCustomProprtyExistInDS: ", new Boolean(bl));
        }
        return bl;
    }

    static {
        databaseProductNameToBackendMap.put("DB2/", DB2_VENDOR);
        databaseProductNameToBackendMap.put(DB2, DB2_ZOS_VENDOR);
        databaseProductNameToBackendMap.put("DSN", DB2_ZOS_VENDOR);
        databaseProductNameToBackendMap.put("DB2 UDB for AS/400", DB2_400_VENDOR);
        databaseProductNameToBackendMap.put(ORACLE, ORACLE_VENDOR);
        databaseProductNameToBackendMap.put("DBMS:db2j", CLOUDSCAPE_VENDOR);
        databaseProductNameToBackendMap.put(CLOUDSCAPE, CLOUDSCAPE_VENDOR);
        databaseProductNameToBackendMap.put("Apache Derby", DERBY_VENDOR);
        databaseProductNameToBackendMap.put("Informix Dynamic Server", INFORMIX_VENDOR);
        databaseProductNameToBackendMap.put("Sybase SQL Server", SYBASE_VENDOR);
        databaseProductNameToBackendMap.put("Adaptive Server Enterprise", SYBASE_VENDOR);
        databaseProductNameToBackendMap.put(MS_SQL_SERVER, MS_SQL_SERVER_VENDOR);
        ADAPTER_PROPS = new String[]{CONN_FACTORY_TYPE, CONNECTION_MANAGER_CLASS, CONNECTION_SHARING, "name", DATA_SOURCE_CLASS, DATA_STORE_HELPER_CLASS, DATABASE_TYPE, DESCRIPTION, MAX_CONNECTIONS, MIN_CONNECTIONS, STATEMENT_CACHE_SIZE, AGED_TIMEOUT, CONNECTION_TIMEOUT, PURGE_POLICY, REAP_TIME, UNUSED_TIMEOUT, ENABLE_2_PHASE, DISABLE_2_PHASE, BEGIN_TRAN_FOR_SCROLLING_APIS, ENABLE_MULTITHREADED_ACCESS_DETECTION, ENABLE_SQLJ, INFORMIX_LOCK_MODE_WAIT, INFORMIX_ALLOW_NEWLINE, ISOLATION_SWITCHING_SUPPORT, ORACLELOG_FILE_SIZE_LIMIT, ORACLELOG_FILE_COUNT, ORACLELOG_FILENAME, ORACLELOG_TRACELEVEL, ORACLE9iLOG_TRACELEVEL, ORACLELOG_FORMAT, ORACLELOG_PACKAGENAME, TRANSACTION_BRANCHES_LOOSELY_COUPLED, DISABLE_BACKEND_ID_CHECKING, DB2_DRIVER_TYPE, PRE_TEST_SQL_STRING, ZOS_CURRENT_SQLID, JMS_ONE_PHASE_OPTIMIZATION, REAUTHENTICATION, RESET_CONNECTION_BY_BACKEND_DATABASE, DISABLE_WAS_CONNECTION_POOLING, REMOVE_EXISTING_ORACLE_CACHE_If_ONE_EXISTS, DB_FAILOVER_ENABLED, DB_FAILOVER_CONNECTION_RETRY_COUNT, DB_FAILOVER_CONNECTION_RETRY_INTERVAL, PROPAGATE_CLIENT_IDENTITY_USING_TRUSTED_CONTEXT, COMMIT_OR_ROLLBACK_ON_CLEANUP, USER_DEFINED_ERROR_MAP, VALIDATE_CONNECTION_FAILOVER_SERVERS, VALIDATE_NEW_CONNECTION, VALIDATE_NEW_CONNECTION_RETRY_COUNT, VALIDATE_NEW_CONNECTION_RETRY_INTERVAL, WAS_DEFAULT_ISOLATION_LEVEL, ENABLE_END_TO_END_MONITORING, CLOUDSCAPE_OLD_DATABASE_NAME};
        supportedDatabases = new String[]{DB2, DB2_400, INFORMIX, MS_SQL_SERVER, ORACLE, SYBASE, DERBY};
        adminSupportedDatabases = new String[]{DB2, CLOUDSCAPE, DERBY, INFORMIX, ORACLE, SYBASE, SQL_SERVER, USER_DEFINED};
        PARAM_LIST_STRING = new Class[]{String.class};
        PARAM_LIST_PROPS = new Class[]{Properties.class};
        classLoaderMap = new Hashtable();
        Arrays.sort(ADAPTER_PROPS);
        supportedDataSourceClassMap = new HashMap(2 * supportedDatabases.length + 1);
        supportedDataSourceClassMap.put(DERBY, new String[]{"org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", "org.apache.derby.jdbc.EmbeddedXADataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource", "org.apache.derby.jdbc.ClientConnectionPoolDataSource", "org.apache.derby.jdbc.ClientXADataSource"});
        supportedDataSourceClassMap.put(DB2, new String[]{"COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource", "COM.ibm.db2.jdbc.DB2XADataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource", "com.ibm.db2.jcc.DB2XADataSource"});
        supportedDataSourceClassMap.put(DB2_400, new String[]{"com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.as400.access.AS400JDBCXADataSource", "com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", "com.ibm.db2.jdbc.app.DB2StdXADataSource", "com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "com.ibm.db2.jdbc.app.UDBXADataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource"});
        supportedDataSourceClassMap.put(INFORMIX, new String[]{"com.informix.jdbcx.IfxConnectionPoolDataSource", "com.informix.jdbcx.IfxXADataSource"});
        supportedDataSourceClassMap.put(MS_SQL_SERVER, new String[]{"com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource", "com.microsoft.sqlserver.jdbc.SQLServerXADataSource", "com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource (single phase)", "com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource (XA)", "com.ddtek.jdbcx.sqlserver.SQLServerDataSource (single phase)", "com.ddtek.jdbcx.sqlserver.SQLServerDataSource (XA)", "com.ddtek.jdbcx.sequelink.SequeLinkDataSource (single phase)", "com.ddtek.jdbcx.sequelink.SequeLinkDataSource (XA)", "com.microsoft.jdbcx.sqlserver.SQLServerDataSource (single phase)", "com.microsoft.jdbcx.sqlserver.SQLServerDataSource (XA)"});
        supportedDataSourceClassMap.put(ORACLE, new String[]{"oracle.jdbc.pool.OracleConnectionPoolDataSource", "oracle.jdbc.xa.client.OracleXADataSource"});
        supportedDataSourceClassMap.put(SYBASE, new String[]{"com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", "com.sybase.jdbc2.jdbc.SybXADataSource"});
        commonPropListMap = new HashMap(61);
        Cloneable cloneable = new ArrayList<DSPropertyEntry>(1);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, GENERIC_HELPER_NAME));
        commonPropListMap.put(UNSUPPORTED, cloneable);
        cloneable = new ArrayList(6);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, DB2UNIVERSAL_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sample"));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, "localhost"));
        cloneable.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, new Integer(6789)));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource", cloneable);
        commonPropListMap.put("com.ibm.db2.jcc.DB2XADataSource", cloneable);
        cloneable = new ArrayList(5);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, DB2_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sample"));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        cloneable.add(new DSPropertyEntry("connectionAttribute", String.class, false, "cursorhold=0"));
        commonPropListMap.put("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource", cloneable);
        commonPropListMap.put("COM.ibm.db2.jdbc.DB2XADataSource", cloneable);
        cloneable = new ArrayList(5);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, DB2AS400_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, null));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        cloneable.add(new DSPropertyEntry("connectionAttribute", String.class, false, "cursorhold=0"));
        commonPropListMap.put("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", cloneable);
        commonPropListMap.put("com.ibm.as400.access.AS400JDBCXADataSource", cloneable);
        cloneable = new ArrayList(5);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, DB2AS400_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, false, "localhost"));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        cloneable.add(new DSPropertyEntry("connectionAttribute", String.class, false, "cursorhold=0"));
        commonPropListMap.put("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", cloneable);
        commonPropListMap.put("com.ibm.db2.jdbc.app.DB2StdXADataSource", cloneable);
        commonPropListMap.put("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", cloneable);
        commonPropListMap.put("com.ibm.db2.jdbc.app.UDBXADataSource", cloneable);
        cloneable = new ArrayList(8);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, INFORMIX_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sample"));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, "informix_server"));
        cloneable.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, new Integer(1526)));
        cloneable.add(new DSPropertyEntry("ifxIFXHOST", String.class, true, "localhost"));
        cloneable.add(new DSPropertyEntry(INFORMIX_LOCK_MODE_WAIT, Integer.TYPE, true, new Integer(2)));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.informix.jdbcx.IfxConnectionPoolDataSource", cloneable);
        commonPropListMap.put("com.informix.jdbcx.IfxXADataSource", cloneable);
        cloneable = new ArrayList(2);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, GENERIC_HELPER_NAME));
        cloneable.add(new DSPropertyEntry("url", String.class, true, "jdbc:idb:sample.prp"));
        commonPropListMap.put("com.ibm.ejs.cm.portability.IDBConnectionPoolDataSource", cloneable);
        cloneable = new ArrayList(6);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, MICROSOFT_SQL_SERVER_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, false, "sample"));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, "localhost"));
        cloneable.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, new Integer(1433)));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource", cloneable);
        commonPropListMap.put("com.microsoft.sqlserver.jdbc.SQLServerXADataSource", cloneable);
        cloneable = new ArrayList(6);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, WSCONNECTJDBC_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sample"));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, "localhost"));
        cloneable.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, new Integer(1433)));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource", cloneable);
        commonPropListMap.put("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource (single phase)", cloneable);
        commonPropListMap.put("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource (XA)", cloneable);
        cloneable = new ArrayList(6);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, CONNECTJDBC_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sample"));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, "localhost"));
        cloneable.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, new Integer(1433)));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.ddtek.jdbcx.sqlserver.SQLServerDataSource", cloneable);
        commonPropListMap.put("com.ddtek.jdbcx.sqlserver.SQLServerDataSource (single phase)", cloneable);
        commonPropListMap.put("com.ddtek.jdbcx.sqlserver.SQLServerDataSource (XA)", cloneable);
        cloneable = new ArrayList(7);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, CONNECTJDBC_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sample"));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, "localhost"));
        cloneable.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, new Integer(1433)));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        cloneable.add(new DSPropertyEntry("selectMethod", String.class, false, "cursor"));
        commonPropListMap.put("com.microsoft.jdbcx.sqlserver.SQLServerDataSource", cloneable);
        commonPropListMap.put("com.microsoft.jdbcx.sqlserver.SQLServerDataSource (single phase)", cloneable);
        commonPropListMap.put("com.microsoft.jdbcx.sqlserver.SQLServerDataSource (XA)", cloneable);
        cloneable = new ArrayList(6);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, SEQUELINK_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sample"));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, "localhost"));
        cloneable.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, new Integer(19996)));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.ddtek.jdbcx.sequelink.SequeLinkDataSource", cloneable);
        commonPropListMap.put("com.ddtek.jdbcx.sequelink.SequeLinkDataSource (single phase)", cloneable);
        commonPropListMap.put("com.ddtek.jdbcx.sequelink.SequeLinkDataSource (XA)", cloneable);
        cloneable = new ArrayList(4);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, ORACLE_HELPER_NAME));
        cloneable.add(new DSPropertyEntry("URL", String.class, true, "jdbc:oracle:thin:dbuser1/dbpwd1@localhost:1521:sample"));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("oracle.jdbc.pool.OracleConnectionPoolDataSource", cloneable);
        commonPropListMap.put("oracle.jdbc.xa.client.OracleXADataSource", cloneable);
        cloneable = new ArrayList(6);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, SYBASE_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sample"));
        cloneable.add(new DSPropertyEntry(SERVER_NAME, String.class, true, "localhost"));
        cloneable.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, new Integer(4100)));
        cloneable.add(new DSPropertyEntry(USER, String.class, false, null));
        cloneable.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", cloneable);
        commonPropListMap.put("com.sybase.jdbc2.jdbc.SybXADataSource", cloneable);
        cloneable = new ArrayList(2);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, DERBY_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sampledb"));
        commonPropListMap.put("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", cloneable);
        commonPropListMap.put("org.apache.derby.jdbc.EmbeddedXADataSource", cloneable);
        cloneable = new ArrayList(2);
        cloneable.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, DERBY_NS_U_HELPER_NAME));
        cloneable.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, "sampledb"));
        commonPropListMap.put("org.apache.derby.jdbc.ClientXADataSource", cloneable);
        commonPropListMap.put("org.apache.derby.jdbc.ClientConnectionPoolDataSource", cloneable);
        _disablePK54589 = Boolean.valueOf(System.getProperty("disablePK54589"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Property disablePK54589 (PK54589 fixes CRI matching problem): " + _disablePK54589);
        }
        _disableCheckingForAuthorizationException = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.disableCheckingForAuthorizationException"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Property com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.disableCheckingForAuthorizationException: " + _disableCheckingForAuthorizationException);
        }
        _allowOraUpdateableConcurrency = Boolean.valueOf(System.getProperty("com.ibm.websphere.rsadapter.OracleDataStoreHelper.allowOraUpdateableConcurrency"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Property com.ibm.websphere.rsadapter.OracleDataStoreHelper.allowOraUpdateableConcurrency: " + _allowOraUpdateableConcurrency);
        }
        _skipInternalClearWarnings = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.spi.InternalDataStoreHelper.skipInternalClearWarnings"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Property com.ibm.ws.rsadapter.spi.InternalDataStoreHelper.skipInternalClearWarnings: " + _skipInternalClearWarnings);
        }
        _allowSetReadOnlyForSybase = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper.allowSetReadOnlyForSybase"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Property com.ibm.ws.rsadapter.spi.InternalDataStoreHelper.allowSetReadOnlyForSybase: " + _allowSetReadOnlyForSybase);
        }
        _runAsSystemForClientReroutePersistence = Boolean.valueOf(System.getProperty("com.ibm.ws.rsadapter.WSRdbDataSource.runAsSystemForClientReroutePersistence"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Property com.ibm.ws.rsadapter.WSRdbDataSource.runAsSystemForClientReroutePersistence: " + _runAsSystemForClientReroutePersistence);
        }
        oneToOneMap = new HashMap(43);
        oneToOneMap.put("org.apache.derby.jdbc.ClientXADataSource", "Derby Network Server Using Derby Client (XA)");
        oneToOneMap.put("org.apache.derby.jdbc.ClientConnectionPoolDataSource", "Derby Network Server Using Derby Client");
        oneToOneMap.put("org.apache.derby.jdbc.EmbeddedXADataSource", "Derby JDBC Provider (XA)");
        oneToOneMap.put("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", "Derby JDBC Provider");
        oneToOneMap.put("oracle.jdbc.xa.client.OracleXADataSource", "Oracle JDBC Driver (XA)");
        oneToOneMap.put("oracle.jdbc.pool.OracleConnectionPoolDataSource", "Oracle JDBC Driver");
        oneToOneMap.put("com.microsoft.sqlserver.jdbc.SQLServerXADataSource", "Microsoft SQL Server JDBC Driver (XA)");
        oneToOneMap.put("com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource", "Microsoft SQL Server JDBC Driver");
        oneToOneMap.put("com.sybase.jdbc3.jdbc.SybXADataSource", "Sybase JDBC 3 Driver (XA)");
        oneToOneMap.put("com.sybase.jdbc3.jdbc.SybConnectionPoolDataSource", "Sybase JDBC 3 Driver");
        oneToOneMap.put("com.sybase.jdbc2.jdbc.SybXADataSource", "Sybase JDBC 2 Driver (XA)");
        oneToOneMap.put("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", "Sybase JDBC 2 Driver");
        oneToOneMap.put("com.informix.jdbcx.IfxXADataSource", "Informix JDBC Driver (XA)");
        oneToOneMap.put("com.informix.jdbcx.IfxConnectionPoolDataSource", "Informix JDBC Driver");
        oneToOneMap.put("com.ibm.db2j.jdbc.DB2jXADataSource", "Cloudscape JDBC Provider (XA)");
        oneToOneMap.put("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource", "Cloudscape JDBC Provider");
        oneToOneMap.put("com.ibm.as400.access.AS400JDBCXADataSource", "DB2 UDB for iSeries (Toolbox XA)");
        oneToOneMap.put("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "DB2 UDB for iSeries (Toolbox)");
        oneToOneMap.put("com.ibm.db2.jdbc.app.DB2StdXADataSource", "DB2 UDB for iSeries (Native XA - V5R1 and earlier)");
        oneToOneMap.put("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", "DB2 UDB for iSeries (Native - V5R1 and earlier)");
        oneToOneMap.put("COM.ibm.db2.jdbc.DB2XADataSource", "DB2 Legacy CLI-based Type 2 JDBC Driver (XA)");
        oneToOneMap.put("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource", "DB2 Legacy CLI-based Type 2 JDBC Driver");
        oneToOneMap.put("com.ibm.db2.jcc.DB2XADataSource", "DB2 Universal JDBC Driver Provider (XA)");
        XAMap = new HashMap(7);
        cloneable = new HashMap(3);
        ((HashMap)cloneable).put(new Boolean(false), "DB2 Legacy CLI-based Type 2 JDBC Driver");
        ((HashMap)cloneable).put(new Boolean(true), "DB2 Legacy CLI-based Type 2 JDBC Driver (XA)");
        XAMap.put("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource", cloneable);
        cloneable = new HashMap(3);
        ((HashMap)cloneable).put(new Boolean(false), "DataDirect ConnectJDBC type 4 driver for MS SQL Server");
        ((HashMap)cloneable).put(new Boolean(true), "DataDirect ConnectJDBC type 4 driver for MS SQL Server (XA)");
        XAMap.put("com.ddtek.jdbcx.sqlserver.SQLServerDataSource", cloneable);
        cloneable = new HashMap(3);
        ((HashMap)cloneable).put(new Boolean(false), "WebSphere embedded ConnectJDBC driver for MS SQL Server");
        ((HashMap)cloneable).put(new Boolean(true), "WebSphere embedded ConnectJDBC driver for MS SQL Server (XA)");
        XAMap.put("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource", cloneable);
        cloneable = new HashMap(3);
        ((HashMap)cloneable).put(new Boolean(false), "DataDirect SequeLink type 3 JDBC driver for MS SQL Server");
        ((HashMap)cloneable).put(new Boolean(true), "DataDirect SequeLink type 3 JDBC driver for MS SQL Server (XA)");
        XAMap.put("com.ddtek.jdbcx.sequelink.SequeLinkDataSource", cloneable);
        cloneable = new HashMap(3);
        ((HashMap)cloneable).put(new Boolean(false), "Microsoft JDBC driver for MSSQLServer 2000");
        ((HashMap)cloneable).put(new Boolean(true), "Microsoft JDBC driver for MSSQLServer 2000 (XA)");
        XAMap.put("com.microsoft.jdbcx.sqlserver.SQLServerDataSource", cloneable);
        helperClassMap = new HashMap(5);
        HashMap<Object, String> hashMap = new HashMap<Object, String>(5);
        hashMap.put("com.ibm.websphere.rsadapter.CloudscapeNetworkServerDataStoreHelper", "Cloudscape Network Server Using Universal JDBC Driver");
        hashMap.put(DERBY_NS_U_HELPER_NAME, "Derby Network Server Using Universal JDBC Driver");
        hashMap.put(DB2UNIVERSAL_HELPER_NAME, "DB2 Universal JDBC Driver Provider");
        hashMap.put(DB2_HELPER_NAME, "DB2 for zOS Local JDBC Provider (RRS)");
        helperClassMap.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource", hashMap);
        helperClassMap.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource for DB2 zOS Local JDBC Provider", hashMap);
        helperClassMap.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource for NonXa DB2 Universal Provider", hashMap);
        helperClassMap.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource for Cloudscape Network Server Universal JDBC Provider", hashMap);
        isDep = new HashMap(5);
        hashMap = new HashMap(3);
        hashMap.put(new Boolean(false), "DB2 UDB for iSeries (Native)");
        hashMap.put(new Boolean(true), "DB2 UDB for iSeries (Native - V5R2 and later)");
        isDep.put("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", hashMap);
        hashMap = new HashMap(3);
        hashMap.put(new Boolean(false), "DB2 UDB for iSeries (Native XA)");
        hashMap.put(new Boolean(true), "DB2 UDB for iSeries (Native XA - V5R2 and later)");
        isDep.put("com.ibm.db2.jdbc.app.UDBXADataSource", hashMap);
        lookupTable = new HashMap(63);
        lookupTable.put("org.apache.derby.jdbc.ClientXADataSource", oneToOneMap);
        lookupTable.put("org.apache.derby.jdbc.ClientConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("org.apache.derby.jdbc.EmbeddedXADataSource", oneToOneMap);
        lookupTable.put("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("oracle.jdbc.xa.client.OracleXADataSource", oneToOneMap);
        lookupTable.put("oracle.jdbc.pool.OracleConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("com.microsoft.sqlserver.jdbc.SQLServerXADataSource", oneToOneMap);
        lookupTable.put("com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("com.sybase.jdbc3.jdbc.SybXADataSource", oneToOneMap);
        lookupTable.put("com.sybase.jdbc3.jdbc.SybConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("com.sybase.jdbc2.jdbc.SybXADataSource", oneToOneMap);
        lookupTable.put("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("com.informix.jdbcx.IfxXADataSource", oneToOneMap);
        lookupTable.put("com.informix.jdbcx.IfxConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("com.ibm.db2j.jdbc.DB2jXADataSource", oneToOneMap);
        lookupTable.put("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("com.ibm.as400.access.AS400JDBCXADataSource", oneToOneMap);
        lookupTable.put("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("com.ibm.db2.jdbc.app.DB2StdXADataSource", oneToOneMap);
        lookupTable.put("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("COM.ibm.db2.jdbc.DB2XADataSource", oneToOneMap);
        lookupTable.put("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource", oneToOneMap);
        lookupTable.put("com.ibm.db2.jcc.DB2XADataSource", oneToOneMap);
        lookupTable.put("com.ddtek.jdbcx.sqlserver.SQLServerDataSource", XAMap);
        lookupTable.put("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource", XAMap);
        lookupTable.put("com.ddtek.jdbcx.sequelink.SequeLinkDataSource", XAMap);
        lookupTable.put("com.microsoft.jdbcx.sqlserver.SQLServerDataSource", XAMap);
        lookupTable.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource", helperClassMap);
        lookupTable.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource for DB2 zOS Local JDBC Provider", helperClassMap);
        lookupTable.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource for NonXa DB2 Universal Provider", helperClassMap);
        lookupTable.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource for Cloudscape Network Server Universal JDBC Provider", helperClassMap);
        lookupTable.put("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", isDep);
        lookupTable.put("com.ibm.db2.jdbc.app.UDBXADataSource", isDep);
    }
}

