/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.rsadapter.DataAccessFunctionSet;
import com.ibm.websphere.rsadapter.WSInteractionSpec;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSInteractionSpecImpl;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbUtil;
import com.ibm.ws.rsadapter.exceptions.BadParameterException;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import java.sql.SQLException;
import javax.ejb.NoSuchEntityException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;

public class WSInteractionImpl
implements Interaction {
    private static final TraceComponent tc = Tr.register(WSInteractionImpl.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final TraceComponent tcMore = Tr.register("RRAMORE", "RRAMORE", "IBMDataStoreAdapterNLS");
    private WSRdbConnectionImpl cciConn;
    boolean isClosed;
    boolean batchRead = false;
    protected AccessIntent acIntent = null;
    protected IndexedRecord ivPredicates = null;
    protected boolean[] ivChangeFieldsIndexes = null;

    public WSInteractionImpl(WSRdbConnectionImpl wSRdbConnectionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", wSRdbConnectionImpl);
        }
        this.cciConn = wSRdbConnectionImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public final void clearWarnings() throws ResourceException {
        throw new NotSupportedException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"clearWarnings", "Interaction"}));
    }

    public final void close() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "close", this);
        }
        if (this.isClosed) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Interaction", null, WSInteractionImpl.class);
        }
        this.isClosed = true;
    }

    public boolean[] executeBatchRead(InteractionSpec interactionSpec, IndexedRecord[] indexedRecordArray) throws ResourceException {
        this.batchRead = true;
        this.executeBatch(interactionSpec, indexedRecordArray, null, null);
        return this.cciConn.batchReadBooleanArray;
    }

    public void executeBatch(InteractionSpec interactionSpec, IndexedRecord[] indexedRecordArray, IndexedRecord[] indexedRecordArray2, boolean[][] blArray) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tcMore.isEntryEnabled()) {
            Tr.entry(tcMore, "executeBatch(InteractionSpec ispec, IndexedRecord[] inputRecord, IndexedRecord[] predicates, boolean[][] dirtyBits )", new Object[]{this, interactionSpec, indexedRecordArray, indexedRecordArray2, blArray});
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "executeBatch(InteractionSpec ispec, boolean[][] dirtyBits )", new Object[]{this, interactionSpec, blArray});
        }
        boolean bl = false;
        try {
            int n;
            int n2;
            DataAccessFunctionSet dataAccessFunctionSet;
            WSInteractionSpecImpl wSInteractionSpecImpl = (WSInteractionSpecImpl)interactionSpec;
            try {
                wSInteractionSpecImpl = (WSInteractionSpecImpl)wSInteractionSpecImpl.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.acIntent != null) {
                wSInteractionSpecImpl.setAccessIntent(this.acIntent);
            }
            this.cciConn.batchOperation = true;
            this.cciConn.batchRead = this.batchRead;
            if (indexedRecordArray2 != null) {
                bl = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Predicates != null: ");
                }
                wSInteractionSpecImpl.batchupdate = true;
                wSInteractionSpecImpl.setOldRecords(indexedRecordArray2);
            }
            this.cciConn.enlistIfNecessary();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                try {
                    Tr.debug(tc, "the autoCommit setting on the physical: ", new Boolean(this.cciConn.jdbcConn.getAutoCommit()));
                }
                catch (SQLException sQLException) {
                    Tr.debug(tc, "got an sql exception trying to get the autoCommit value for the physical conn.  This is a debug path, exception is: ", sQLException);
                }
            }
            if ((dataAccessFunctionSet = wSInteractionSpecImpl._dafs) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "FunctionSet instance in ISpec is null, It should have never been null (PM issue as they should have set it)");
                }
                throw new BadParameterException("DataAccessFunctionSet instance", "null", "non-null", WSInteractionImpl.class);
            }
            this.cciConn.numBatchRecords = n2 = indexedRecordArray.length;
            this.cciConn.numParameters = indexedRecordArray[0] == null ? 0 : indexedRecordArray[0].size();
            for (n = 0; n < n2; ++n) {
                wSInteractionSpecImpl.ivChangedFieldsIndexes = (boolean[])(blArray != null ? blArray[n] : null);
                dataAccessFunctionSet.execute(wSInteractionSpecImpl, indexedRecordArray[n], this.cciConn);
            }
            if (!this.batchRead) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "the returned int[] length from executeBatch is: ", new Integer(n2));
                }
                block14: for (int i = n2 - 1; i >= 0; --i) {
                    n = this.cciConn.batchUpdateCount[i];
                    switch (n) {
                        case -3: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "got -3 in the batch, which means an error happened executing one of the batched updates, will throw an exception to rollback the tran");
                            }
                            throw new DataStoreAdapterException("DSA_BATCH_ERROR", "-3 is gotten in the batch update count, an error happened in one of the execute batch entries", WSInteractionImpl.class);
                        }
                        case -2: {
                            if (!bl) continue block14;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "got -2 in the batch update count, which doesn't tell how many rows got updated, will throw a NoSuchEntityException exception");
                            }
                            throw new DataStoreAdapterException("DSA_BATCH_UNKNOWN", null, new NoSuchEntityException(), "-2 is gotten in the batch update count, rows update count is unknown", WSInteractionImpl.class);
                        }
                        case 0: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "got 0 in the batch update count, which means no rows were updated, will throw a NoSuchEntityException exception");
                            }
                            throw new DataStoreAdapterException("DSA_BATCH_NO_UPDATE", new NoSuchEntityException(), "0 is gotten in the batch update count, no rows were updated", WSInteractionImpl.class);
                        }
                    }
                }
            }
            this.cciConn.batchOperation = false;
            this.cciConn.batchRead = false;
            wSInteractionSpecImpl.batchupdate = false;
            this.batchRead = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "executeBatch");
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSInteractionImpl.executeBatch", "208", this);
            if (resourceException instanceof DataStoreAdapterException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "executeBatch with DataStoreAdapterException", (Object)resourceException);
                }
                throw WSRdbUtil.mapException(this.cciConn, (DataStoreAdapterException)resourceException);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "executeBatch with ResourceException", (Object)resourceException);
            }
            throw resourceException;
        }
        catch (NullPointerException nullPointerException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "executeBatch with NullPointerException", nullPointerException);
            }
            if (interactionSpec == null) {
                throw new BadParameterException("InteractionSpec", null, "non-null", WSInteractionImpl.class);
            }
            if (indexedRecordArray == null) {
                throw new BadParameterException("IndexedRecord[]", null, "non-null", WSInteractionImpl.class);
            }
            if (this.isClosed) {
                throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Interaction", null, WSInteractionImpl.class);
            }
            if (this.cciConn.batchUpdateCount == null) {
                throw new DataStoreAdapterException("DSA_ERROR_BATCH", "the Batch update count is null, possible reasons: 1) database returned null, or something bad happend and executeBatch was never called, contact IBM support", WSInteractionImpl.class);
            }
            throw nullPointerException;
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "executeBatch with ClassCastException ", classCastException);
            }
            if (!(interactionSpec instanceof WSInteractionSpec)) {
                throw new BadParameterException("InteractionSpec", "type " + (interactionSpec == null ? "null" : interactionSpec.getClass().getName()), "type " + WSInteractionSpec.class.getName(), WSInteractionImpl.class);
            }
            if (!(indexedRecordArray instanceof IndexedRecord[])) {
                throw new BadParameterException("Record", "type " + (indexedRecordArray == null ? "null" : indexedRecordArray.getClass().getName()), "type " + IndexedRecord.class.getName(), WSInteractionImpl.class);
            }
            throw classCastException;
        }
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        Record record2;
        if (TraceComponent.isAnyTracingEnabled() && tcMore.isEntryEnabled()) {
            Tr.entry(tcMore, "execute", new Object[]{this, interactionSpec, record});
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{this, interactionSpec});
        }
        try {
            IndexedRecord indexedRecord;
            WSInteractionSpecImpl wSInteractionSpecImpl = (WSInteractionSpecImpl)interactionSpec;
            try {
                wSInteractionSpecImpl = (WSInteractionSpecImpl)wSInteractionSpecImpl.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.acIntent != null) {
                wSInteractionSpecImpl.setAccessIntent(this.acIntent);
            }
            if (this.ivPredicates != null) {
                wSInteractionSpecImpl.setOldRecord(this.ivPredicates);
            }
            wSInteractionSpecImpl.ivChangedFieldsIndexes = this.ivChangeFieldsIndexes;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "InteractionSpec =", wSInteractionSpecImpl.toString());
            }
            this.cciConn.enlistIfNecessary();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                try {
                    Tr.debug(tc, "the autoCommit setting on the physical: ", new Boolean(this.cciConn.jdbcConn.getAutoCommit()));
                }
                catch (SQLException sQLException) {
                    Tr.debug(tc, "got an sql exception trying to get the autoCommit value for the physical conn.  This is a debug path, exception is: ", sQLException);
                }
            }
            this.cciConn.numParameters = (indexedRecord = (IndexedRecord)record) == null ? 0 : indexedRecord.size();
            DataAccessFunctionSet dataAccessFunctionSet = wSInteractionSpecImpl._dafs;
            if (dataAccessFunctionSet == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "FunctionSet instance in ISpec is null, It should have never been null (PM issue as they should have set it)");
                }
                throw new BadParameterException("DataAccessFunctionSet instance", "null", "non-null", WSInteractionImpl.class);
            }
            record2 = dataAccessFunctionSet.execute(wSInteractionSpecImpl, indexedRecord, this.cciConn);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSInteractionImpl.execute", "139", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "execute with ResourceException", (Object)resourceException);
            }
            throw resourceException instanceof DataStoreAdapterException ? WSRdbUtil.mapException(this.cciConn, (DataStoreAdapterException)resourceException) : resourceException;
        }
        catch (NullPointerException nullPointerException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "execute with NullPointerException ", nullPointerException);
            }
            if (interactionSpec == null) {
                throw new BadParameterException("InteractionSpec", null, "non-null", WSInteractionImpl.class);
            }
            if (this.isClosed) {
                throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Interaction", null, WSInteractionImpl.class);
            }
            throw nullPointerException;
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "execute with ClassCastException ", classCastException);
            }
            if (!(interactionSpec instanceof WSInteractionSpec)) {
                throw new BadParameterException("InteractionSpec", "type " + (interactionSpec == null ? "null" : interactionSpec.getClass().getName()), "type " + WSInteractionSpec.class.getName(), WSInteractionImpl.class);
            }
            if (!(record instanceof IndexedRecord)) {
                throw new BadParameterException("Record", "type " + (record == null ? "null" : record.getClass().getName()), "type " + IndexedRecord.class.getName(), WSInteractionImpl.class);
            }
            throw classCastException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tcMore.isEntryEnabled()) {
            Tr.exit(tcMore, "execute", record2);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
        return record2;
    }

    public final boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        throw new NotSupportedException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"execute(InteractionSpec, Record, Record)", "Interaction"}));
    }

    public final Connection getConnection() {
        return this.cciConn;
    }

    public final ResourceWarning getWarnings() throws ResourceException {
        throw new NotSupportedException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getWarnings", "Interaction"}));
    }

    final WSInteractionImpl recycle() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "recycle", this);
        }
        this.isClosed = false;
        this.ivPredicates = null;
        this.ivChangeFieldsIndexes = null;
        this.acIntent = null;
        return this;
    }
}

