/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.websphere.j2c.InteractionMetrics;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbResultSetImpl;
import com.ibm.ws.rsadapter.cci.WSRdbUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;

public class WSRdbCallableStatement
implements CallableStatement {
    private static final String currClassName = WSRdbCallableStatement.class.getName();
    CallableStatement cstmt;
    WSRdbConnectionImpl rdbConn;
    private static final TraceComponent tc = Tr.register(WSRdbCallableStatement.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final String[] PMI_EXECUTE = new String[]{CallableStatement.class.getName(), "execute()"};
    J2CPerf pmi;
    private boolean isClosed = false;
    StatementCacheKey statementCacheKey;
    private String sql;
    private WSRdbResultSetImpl[] rsetWrappers;
    private int numRSetWrappers;
    private static final int INIT_NUM_RSET = 5;
    private static final int INCREMNT_SIZE_RSET = 10;

    public WSRdbCallableStatement(CallableStatement callableStatement, WSRdbConnectionImpl wSRdbConnectionImpl, StatementCacheKey statementCacheKey, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(callableStatement), wSRdbConnectionImpl, statementCacheKey});
        }
        this.cstmt = callableStatement;
        this.rdbConn = wSRdbConnectionImpl;
        this.pmi = this.rdbConn.pmi;
        this.statementCacheKey = statementCacheKey;
        this.sql = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2)});
        }
        try {
            this.cstmt.registerOutParameter(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.registerOutParameter", "73", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2), new Integer(n3)});
        }
        try {
            this.cstmt.registerOutParameter(n, n2, n3);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.registerOutParameter", "98", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean wasNull() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wasNull", this);
        }
        try {
            return this.cstmt.wasNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.wasNull", "108", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getString(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getString", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getString(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getString", "118", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBoolean", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getBoolean(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getBoolean", "128", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getByte", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getByte(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getByte", "138", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getShort", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getShort(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getShort", "148", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInt", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getInt(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getInt", "158", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public long getLong(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLong", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getLong(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getLong", "168", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFloat", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getFloat(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getFloat", "178", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDouble", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getDouble(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getDouble", "188", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBigDecimal", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getBigDecimal", "198", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBytes", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getBytes(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getBytes", "208", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDate", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getDate(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getDate", "218", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTime", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getTime(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getTime", "228", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimestamp", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getTimestamp", "238", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getObject", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getObject(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getObject", "248", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBigDecimal", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getBigDecimal", "258", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getObject", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getObject(n, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getObject", "268", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRef", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getRef(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getRef", "278", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBlob", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getBlob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getBlob", "288", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClob", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getClob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getClob", "298", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Array getArray(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getArray", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getArray(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getArray", "308", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDate", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getDate", "318", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTime", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getTime", "328", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimestamp", new Object[]{this, new Integer(n)});
        }
        try {
            return this.cstmt.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getTimestamp", "338", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2), string});
        }
        try {
            this.cstmt.registerOutParameter(n, n2, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.registerOutParameter", "579", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeQuery()", CallableStatement.class.getName()}));
    }

    public int executeUpdate() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeUpdate()", CallableStatement.class.getName()}));
    }

    public void setNull(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNull", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setNull", "639", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBoolean", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBoolean", "658", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setByte", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setByte(n, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setByte", "677", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setShort", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setShort(n, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setShort", "696", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setInt", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setInt", "715", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setLong", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setLong(n, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setLong", "734", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFloat", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setFloat", "753", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDouble", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setDouble", "772", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBigDecimal", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBigDecimal", "791", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setString(int n, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setString", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setString(n, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setString", "810", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBytes", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBytes", "829", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDate", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setDate(n, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setDate", "848", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTime", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setTime(n, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setTime", "867", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimestamp", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setTimestamp", "886", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setAsciiStream", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setAsciiStream", "905", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setUnicodeStream", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setUnicodeStream", "926", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBinaryStream", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBinaryStream", "946", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void clearParameters() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearParameters", this);
        }
        try {
            this.cstmt.clearParameters();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.clearParameters", "965", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setObject", "985", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setObject", "1004", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setObject(n, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setObject", "1023", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean execute() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", this);
        }
        boolean bl = false;
        try {
            this.closeResultSets();
            bl = this.pmi == null && !this.rdbConn.metrics.isInteractionMetricsEnabled() ? this.cstmt.execute() : this.pmiExecute();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.execute", "1044", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", "Exception");
            }
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    public void addBatch() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addBatch", this);
        }
        try {
            this.cstmt.addBatch();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.addBatch", "1054", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCharacterStream", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setCharacterStream", "1083", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRef", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setRef(n, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setRef", "1102", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBlob", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBlob", "1121", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setClob", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setClob(n, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setClob", "1140", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setArray", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setArray(n, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setArray", "1159", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMetaData", this);
        }
        try {
            return this.cstmt.getMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getMetaData", "1178", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDate", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setDate", "1197", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTime", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setTime", "1216", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimestamp", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setTimestamp", "1235", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNull", new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2), string});
        }
        try {
            this.cstmt.setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setNull", "1254", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeQuery(String)", CallableStatement.class.getName()}));
    }

    public int executeUpdate(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeUpdate(String)", CallableStatement.class.getName()}));
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", this);
        }
        if (this.isClosed) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close", "(Already closed)");
            }
            return;
        }
        this.isClosed = true;
        try {
            if (this.statementCacheKey == null) {
                if (tc.isEventEnabled()) {
                    Tr.debug(tc, "Close Statement.", new Object[]{this, AdapterUtil.toString(this.cstmt)});
                }
                this.cstmt.close();
            } else {
                if (tc.isEventEnabled()) {
                    Tr.debug(tc, "Cache Statement.", new Object[]{this, AdapterUtil.toString(this.cstmt)});
                }
                this.cstmt.clearParameters();
                try {
                    ResultSet resultSet = null;
                    while (this.cstmt.getMoreResults() | this.cstmt.getUpdateCount() != -1) {
                        resultSet = this.cstmt.getResultSet();
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                    this.rdbConn.managedConn.cacheStatement(this.cstmt, this.statementCacheKey);
                    this.statementCacheKey = null;
                }
                catch (SQLException sQLException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Errors while caching. Statement cannot be cached.");
                    }
                    this.cstmt.close();
                }
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.close", "1285", this);
            Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{AdapterUtil.toString(this.cstmt), sQLException});
        }
        this.cstmt = null;
        this.statementCacheKey = null;
        this.rdbConn = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public int getMaxFieldSize() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMaxFieldSize", this);
        }
        try {
            return this.cstmt.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getMaxFieldSize", "1255", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMaxFieldSize", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setMaxFieldSize", "1256", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxRows() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMaxRows", this);
        }
        try {
            return this.cstmt.getMaxRows();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getMaxRows", "1257", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setMaxRows(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMaxRows", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setMaxRows", "1258", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setEscapeProcessing", new Object[]{this, new Boolean(bl)});
        }
        try {
            this.cstmt.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setEscapeProcessing", "1259", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getQueryTimeout() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getQueryTimeout", this);
        }
        try {
            return this.cstmt.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getQueryTimeout", "1260", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setQueryTimeout", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setQueryTimeout", "1261", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void cancel() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cancel", this);
        }
        try {
            this.cstmt.cancel();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.cancel", "1270", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getWarnings", this);
        }
        try {
            return this.cstmt.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getWarnings", "1498", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void clearWarnings() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearWarnings", this);
        }
        try {
            this.cstmt.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.clearWarnings", "1517", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setCursorName(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCursorName", new Object[]{this, string});
        }
        try {
            this.cstmt.setCursorName(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setCursorName", "1518", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean execute(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getConnection()", CallableStatement.class.getName()}));
    }

    public ResultSet getResultSet() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResultSet", this);
        }
        try {
            ResultSet resultSet = this.cstmt.getResultSet();
            if (resultSet == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResultSet", null);
                }
                return null;
            }
            this.createResultSetWrapper(resultSet);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getResultSet", "1538", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResultSet", "Exception");
            }
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResultSet", this.rsetWrappers[this.numRSetWrappers - 1]);
        }
        return this.rsetWrappers[this.numRSetWrappers - 1];
    }

    public int getUpdateCount() throws SQLException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUpdateCount", this);
        }
        try {
            n = this.cstmt.getUpdateCount();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getUpdateCount", "1548", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUpdateCount", "Exception");
            }
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUpdateCount", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUpdateCount", new Integer(n));
        }
        return n;
    }

    public boolean getMoreResults() throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMoreResults", this);
        }
        try {
            bl = this.cstmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getMoreResults", "1558", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMoreResults", "Exception");
            }
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        try {
            if (this.numRSetWrappers > 0 && !this.rsetWrappers[this.numRSetWrappers - 1].isClosed()) {
                this.rsetWrappers[this.numRSetWrappers - 1].close();
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getMoreResults", "1568", this);
            Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{this.rsetWrappers, sQLException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMoreResults", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFetchDirection", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setFetchDirection", "1693", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getFetchDirection() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFetchDirection", this);
        }
        try {
            return this.cstmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getFetchDirection", "1712", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFetchSize(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFetchSize", new Object[]{this, new Integer(n)});
        }
        try {
            this.cstmt.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setFetchSize", "1731", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getFetchSize() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFetchSize", this);
        }
        try {
            return this.cstmt.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getFetchSize", "1750", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getResultSetConcurrency", this);
        }
        try {
            return this.cstmt.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getResultSetConcurrency", "1769", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getResultSetType() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getResultSetType", this);
        }
        try {
            return this.cstmt.getResultSetType();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getResultSetType", "1788", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void addBatch(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addBatch", new Object[]{this, string});
        }
        try {
            this.cstmt.addBatch(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.addBatch", "1798", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void clearBatch() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearBatch", this);
        }
        try {
            this.cstmt.clearBatch();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.clearBatch", "1808", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int[] executeBatch() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeBatch()", CallableStatement.class.getName()}));
    }

    public Connection getConnection() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getConnection()", CallableStatement.class.getName()}));
    }

    public final WSRdbCallableStatement recycle(CallableStatement callableStatement, WSRdbConnectionImpl wSRdbConnectionImpl, StatementCacheKey statementCacheKey) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "recycle", new Object[]{this, AdapterUtil.toString(callableStatement), wSRdbConnectionImpl, statementCacheKey});
        }
        this.cstmt = callableStatement;
        this.rdbConn = wSRdbConnectionImpl;
        this.pmi = this.rdbConn.pmi;
        this.statementCacheKey = statementCacheKey;
        this.isClosed = false;
        return this;
    }

    final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        if (this.isClosed) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "CallableStatement"));
        }
        return runtimeException;
    }

    private boolean pmiExecute() throws SQLException {
        boolean bl = false;
        Object object = null;
        InteractionMetrics cfr_ignored_0 = this.rdbConn.metrics;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.rdbConn.metrics.isInteractionMetricsEnabled()) {
            object = this.rdbConn.metrics.preInteraction(PMI_EXECUTE);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            bl = this.cstmt.execute();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecute", "2206", this);
            exception = sQLException;
            InteractionMetrics cfr_ignored_1 = this.rdbConn.metrics;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecute", "2213", this);
            exception = runtimeException;
            InteractionMetrics cfr_ignored_2 = this.rdbConn.metrics;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.rdbConn.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", this.sql);
                properties.setProperty("DataSourceJNDIName", this.rdbConn.mcf.getJndiName());
            }
            case 1: {
                this.rdbConn.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return bl;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private void createResultSetWrapper(ResultSet resultSet) {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createResultSetWrapper", new Object[]{this, AdapterUtil.toString(resultSet)});
        }
        if (this.rsetWrappers == null) {
            this.rsetWrappers = new WSRdbResultSetImpl[5];
        } else if (this.numRSetWrappers >= this.rsetWrappers.length) {
            object = this.rsetWrappers;
            this.rsetWrappers = new WSRdbResultSetImpl[this.numRSetWrappers + 10];
            System.arraycopy(object, 0, this.rsetWrappers, 0, ((Object)object).length);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createResultSetWrapper", "Get more result sets than expected, increased array size to " + this.rsetWrappers.length);
            }
        }
        object = new WSRdbResultSetImpl(resultSet, true);
        ((WSRdbResultSetImpl)object).initialize(this.rdbConn);
        this.rsetWrappers[this.numRSetWrappers++] = object;
    }

    private void returnResultSetWrappersToCache() {
        if (this.numRSetWrappers > 0) {
            if (!this.rsetWrappers[this.numRSetWrappers - 1].isClosed()) {
                try {
                    this.rsetWrappers[this.numRSetWrappers - 1].close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.returnResultSetWrappersToCache", "2612", this);
                    Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{this.rsetWrappers, sQLException});
                }
            }
            int n = this.numRSetWrappers;
            while (n > 0) {
                this.rsetWrappers[--n].setStatementCallable(false);
                this.rsetWrappers[n] = null;
            }
            this.numRSetWrappers = 0;
        }
    }

    void returnStatementWrapperToCache() {
        if (!this.isClosed) {
            this.close();
        }
        this.returnResultSetWrappersToCache();
    }

    final void closeResultSets() {
        try {
            if (this.numRSetWrappers > 0 && !this.rsetWrappers[this.numRSetWrappers - 1].isClosed()) {
                this.rsetWrappers[this.numRSetWrappers - 1].close();
                if (this.rsetWrappers.length > 5) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result set wrapper array is too big, discard it.");
                    }
                    this.rsetWrappers = null;
                }
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.closeResultSets", "2689", this);
            Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{this.rsetWrappers, sQLException});
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getMoreResults(int)", Statement.class.getName()}));
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getGeneratedKeys()", Statement.class.getName()}));
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeUpdate(String, int)", Statement.class.getName()}));
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeUpdate(String, int[])", Statement.class.getName()}));
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeUpdate(String, String[])", Statement.class.getName()}));
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"execute(String, int)", Statement.class.getName()}));
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"execute(String, int[])", Statement.class.getName()}));
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"execute(String, String[])", Statement.class.getName()}));
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.cstmt.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getResultSetHoldability", "1835", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setURL", new Integer(n));
        }
        try {
            this.cstmt.setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setURL", "1873", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getParameterMetaData");
        }
        try {
            return this.cstmt.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.getParameterMetaData", "1990", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, string, AdapterUtil.getSQLTypeString(n)});
        }
        try {
            this.cstmt.registerOutParameter(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.registerOutParameter", "2012", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, string, AdapterUtil.getSQLTypeString(n), new Integer(n2)});
        }
        try {
            this.cstmt.registerOutParameter(string, n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.registerOutParameter", "2038", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, string, AdapterUtil.getSQLTypeString(n), string2});
        }
        try {
            this.cstmt.registerOutParameter(string, n, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.registerOutParameter", "2063", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setURL(String string, URL uRL) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setURL", string);
        }
        try {
            this.cstmt.setURL(string, uRL);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setURL", "2081", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNull", new Object[]{string, AdapterUtil.getSQLTypeString(n)});
        }
        try {
            this.cstmt.setNull(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setNull", "2101", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBoolean", new Object[]{string, new Boolean(bl)});
        }
        try {
            this.cstmt.setBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBoolean", "2121", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setByte(String string, byte by) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setByte", string);
        }
        try {
            this.cstmt.setByte(string, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setByte", "2140", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setShort(String string, short s) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setShort", string);
        }
        try {
            this.cstmt.setShort(string, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setShort", "2160", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setInt(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setInt", string);
        }
        try {
            this.cstmt.setInt(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setInt", "2179", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setLong(String string, long l) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setLong", string);
        }
        try {
            this.cstmt.setLong(string, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setLong", "2198", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFloat(String string, float f) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFloat", string);
        }
        try {
            this.cstmt.setFloat(string, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setFloat", "2217", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDouble(String string, double d) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDouble", string);
        }
        try {
            this.cstmt.setDouble(string, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setDouble", "2236", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBigDecimal", string);
        }
        try {
            this.cstmt.setBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBigDecimal", "2256", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setString(String string, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setString", string);
        }
        try {
            this.cstmt.setString(string, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setString", "2275", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBytes", string);
        }
        try {
            this.cstmt.setBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBytes", "2294", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(String string, Date date) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDate", string);
        }
        try {
            this.cstmt.setDate(string, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setDate", "2314", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(String string, Time time) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTime", string);
        }
        try {
            this.cstmt.setTime(string, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setTime", "2334", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimestamp", string);
        }
        try {
            this.cstmt.setTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setTimestamp", "2354", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setAsciiStream", string);
        }
        try {
            this.cstmt.setAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setAscciStream", "2377", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBinaryStream", string);
        }
        try {
            this.cstmt.setBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setBinaryStream", "2399", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject", new Object[]{string, AdapterUtil.getSQLTypeString(n), new Integer(n2)});
        }
        try {
            this.cstmt.setObject(string, object, n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setObject", "2424", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject", new Object[]{string, AdapterUtil.getSQLTypeString(n)});
        }
        try {
            this.cstmt.setObject(string, object, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setObject", "2445", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject", string);
        }
        try {
            this.cstmt.setObject(string, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setObject", "2463", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCharacterStream", new Object[]{string, new Integer(n)});
        }
        try {
            this.cstmt.setObject(string, (Object)reader, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setCharacterStream", "2487", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDate", new Object[]{string, calendar});
        }
        try {
            this.cstmt.setDate(string, date, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setDate", "2511", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTime", new Object[]{string, calendar});
        }
        try {
            this.cstmt.setTime(string, time, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setTime", "2535", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimestamp", new Object[]{string, timestamp, calendar});
        }
        try {
            this.cstmt.setTimestamp(string, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setTimestamp", "2559", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNull", new Object[]{string, AdapterUtil.getSQLTypeString(n)});
        }
        try {
            this.cstmt.setNull(string, n, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement.setNull", "2579", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getArray(String)", CallableStatement.class.getName()}));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getBigDecimal(String)", CallableStatement.class.getName()}));
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getBlob(String)", CallableStatement.class.getName()}));
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getBoolean(String)", CallableStatement.class.getName()}));
    }

    public byte getByte(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getByte(String)", CallableStatement.class.getName()}));
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getBytes(String)", CallableStatement.class.getName()}));
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getClob(String)", CallableStatement.class.getName()}));
    }

    public Date getDate(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getDate(String)", CallableStatement.class.getName()}));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getDate(String, Calendar)", CallableStatement.class.getName()}));
    }

    public double getDouble(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getDouble(String)", CallableStatement.class.getName()}));
    }

    public float getFloat(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getFloat(String)", CallableStatement.class.getName()}));
    }

    public int getInt(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getInt(String)", CallableStatement.class.getName()}));
    }

    public long getLong(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getLong(String)", CallableStatement.class.getName()}));
    }

    public Object getObject(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getObject(String)", CallableStatement.class.getName()}));
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getObject(String, Map)", CallableStatement.class.getName()}));
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getRef(String)", CallableStatement.class.getName()}));
    }

    public short getShort(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getShort(String)", CallableStatement.class.getName()}));
    }

    public String getString(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getString(String)", CallableStatement.class.getName()}));
    }

    public Time getTime(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getTime(String)", CallableStatement.class.getName()}));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getTime(String, Calendar)", CallableStatement.class.getName()}));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getTimestamp(String)", CallableStatement.class.getName()}));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getTimestamp(String, Calendar)", CallableStatement.class.getName()}));
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getURL(int)", CallableStatement.class.getName()}));
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getURL(String)", CallableStatement.class.getName()}));
    }
}

