/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.ProxyDataSource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionSpecImpl;
import com.ibm.ws.rsadapter.cci.WSRdbResourceAdapterMetaDataImpl;
import com.ibm.ws.rsadapter.cci.WSRecordFactoryImpl;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class WSRdbConnectionFactoryImpl
implements ConnectionFactory {
    private static final long serialVersionUID = 3520140975323933254L;
    private static final TraceComponent tc = Tr.register(WSRdbConnectionFactoryImpl.class, "RRA", "IBMDataStoreAdapterNLS");
    private transient J2EEName _j2eeName = null;
    private RecordFactory ivRecordFactory;
    private Reference ivReference;
    private WSRdbResourceAdapterMetaDataImpl ivResourceAdapterMetaData;
    WSManagedConnectionFactoryImpl mcf;
    DataStoreHelper helper;
    InternalDataStoreHelper internalHelper;
    private ConnectionManager connMgr;
    private int defaultIsolationLevel;
    private boolean supportIsolvlSwitching;
    private transient Properties extendedDSProps;
    private int extendedDSPropsKey;
    private int dsHelperType = -2;
    private String jndiName = null;
    ProxyDataSource proxyDataSource = null;
    private static final WSConnectionRequestInfoImpl[] defaultCRIs;
    private static final WSConnectionRequestInfoImpl[] defaultCRIsWithSwitch;
    private static final WSConnectionRequestInfoImpl[] defaultCRIsWithIW_CMPShare;
    private static final WSConnectionRequestInfoImpl[] defaultCRIsWithCMPShare;

    public WSRdbConnectionFactoryImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WebSphere code should never call this method.");
        }
    }

    public WSRdbConnectionFactoryImpl(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl, ConnectionManager connectionManager) {
        this.mcf = wSManagedConnectionFactoryImpl;
        this.connMgr = connectionManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{wSManagedConnectionFactoryImpl, connectionManager});
        }
        this.helper = wSManagedConnectionFactoryImpl.getDataStoreHelper();
        this.internalHelper = wSManagedConnectionFactoryImpl.getInternalDataStoreHelper();
        this.dsHelperType = this.helper.getMetaData().getHelperType();
        this.jndiName = wSManagedConnectionFactoryImpl.getJndiName();
        if (this.dsHelperType == 20) {
            try {
                this.proxyDataSource = (ProxyDataSource)wSManagedConnectionFactoryImpl.getUnderlyingDataSource(29497789L, 0);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".<init>", "236", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "<init>", sQLException);
                }
                throw new UnsupportedOperationException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"ProxyDataSource", "validateConnectionFailoverServers"}), sQLException);
            }
        }
        CMConfigData cMConfigData = WSManagedConnectionFactoryImpl.locationRestrictedFunction.getCMConfigData(connectionManager);
        try {
            if (cMConfigData != null) {
                String string;
                this._j2eeName = cMConfigData.getJ2EEName();
                this.defaultIsolationLevel = cMConfigData.getIsolationLevel();
                if (this.defaultIsolationLevel == 0) {
                    this.defaultIsolationLevel = this.helper.getIsolationLevel(null);
                }
                if ((string = cMConfigData.getPurgePolicy()) != null) {
                    wSManagedConnectionFactoryImpl.setPurgePolicyInternal(string);
                } else {
                    wSManagedConnectionFactoryImpl.setPurgePolicyInternal("FailingConnectionOnly");
                }
                this.extendedDSProps = cMConfigData.getHPproperties();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "J2EEName connection prop (i.e. Heterogenous pooling properties) are set to : ", this.extendedDSProps);
                }
                if (this.extendedDSProps != null) {
                    this.extendedDSPropsKey = cMConfigData.getPrimeID();
                    Properties properties = (Properties)wSManagedConnectionFactoryImpl.getDBDSProperties().clone();
                    properties.putAll((Map<?, ?>)this.extendedDSProps);
                    this.extendedDSProps = properties;
                    this.extendedDSProps = DSConfigurationHelper.validateAndAdjustHPProps(wSManagedConnectionFactoryImpl.getDataSourceClassName(), this.extendedDSProps);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Combined and verified DS and Res-Ref connection prop is : ", this.extendedDSProps);
                    }
                }
            } else {
                this.defaultIsolationLevel = this.helper.getIsolationLevel(null);
                wSManagedConnectionFactoryImpl.setPurgePolicyInternal("FailingConnectionOnly");
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSRdbConnectionFactoryImpl.<init>", "68", this);
            String string = System.getProperty("line.separator");
            Tr.warning(tc, "DSA_ERROR", new Object[]{"Unable to determine the WebSphere default isolation level from the DataStoreHelper" + string + "Defaulting to READ COMMITTED." + string + this.helper + string + AdapterUtil.stackTraceToString(resourceException)});
            this.defaultIsolationLevel = 2;
        }
        this.supportIsolvlSwitching = this.internalHelper.isIsolationLevelSwitchingSupport();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public final boolean equals(Object object) {
        try {
            WSRdbConnectionFactoryImpl wSRdbConnectionFactoryImpl = (WSRdbConnectionFactoryImpl)object;
            return this.mcf.equals(wSRdbConnectionFactoryImpl.mcf) && this.connMgr.equals(wSRdbConnectionFactoryImpl.connMgr);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final Connection getConnection() throws ResourceException {
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnection", this);
            Tr.debug(tc, "Using isolation level: " + AdapterUtil.getIsolationLevelString(this.defaultIsolationLevel));
            Tr.debug(tc, "support IsolationLevel switching : " + this.supportIsolvlSwitching);
            Tr.debug(tc, "ShareWithCMPOnly flag is set to :", new Boolean(this.mcf.jmsOnePhaseOptimization));
        }
        if (!(this.mcf.ispropagateClientIdentityUsingTrustedContextEnabled() || this.extendedDSProps != null || this.mcf.getOptimizedForGetUseClose() || this.mcf.shouldDataBeCollectedAndPshedDownToCMX())) {
            wSConnectionRequestInfoImpl = this.supportIsolvlSwitching ? (this.mcf.jmsOnePhaseOptimization ? (this.defaultIsolationLevel < defaultCRIsWithIW_CMPShare.length ? defaultCRIsWithIW_CMPShare[this.defaultIsolationLevel] : new WSConnectionRequestInfoImpl(this.defaultIsolationLevel, false, true, true)) : (this.defaultIsolationLevel < defaultCRIsWithSwitch.length ? defaultCRIsWithSwitch[this.defaultIsolationLevel] : new WSConnectionRequestInfoImpl(this.defaultIsolationLevel, false, true, false))) : (this.mcf.jmsOnePhaseOptimization ? (this.defaultIsolationLevel < defaultCRIsWithCMPShare.length ? defaultCRIsWithCMPShare[this.defaultIsolationLevel] : new WSConnectionRequestInfoImpl(this.defaultIsolationLevel, false, false, true)) : (this.defaultIsolationLevel < defaultCRIs.length ? defaultCRIs[this.defaultIsolationLevel] : new WSConnectionRequestInfoImpl(this.defaultIsolationLevel, false)));
        } else {
            wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(this.defaultIsolationLevel, false, this.supportIsolvlSwitching, this.mcf.jmsOnePhaseOptimization);
            wSConnectionRequestInfoImpl.markAsChangable();
            try {
                wSConnectionRequestInfoImpl.setHeterogeneousProperties(this.extendedDSProps, this.extendedDSPropsKey);
                wSConnectionRequestInfoImpl.setOptimizeForGetUseClose(this.mcf.getOptimizedForGetUseClose());
                wSConnectionRequestInfoImpl.setJ2EEName(this._j2eeName);
            }
            catch (SQLException sQLException) {
                throw new DataStoreAdapterException("DSA_ERROR", sQLException, this.getClass());
            }
        }
        return ((WSRdbConnectionImpl)this.connMgr.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)wSConnectionRequestInfoImpl)).initialize(this.connMgr, null);
    }

    public final Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl;
        int n;
        WSRdbConnectionSpecImpl wSRdbConnectionSpecImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnection", new Object[]{this, connectionSpec});
        }
        try {
            wSRdbConnectionSpecImpl = (WSRdbConnectionSpecImpl)connectionSpec;
        }
        catch (ClassCastException classCastException) {
            throw new ResourceException("Must pass in a WSRdbConnectionSpecImpl for the ConnectionSpec. You sent in " + connectionSpec);
        }
        AccessIntent accessIntent = wSRdbConnectionSpecImpl.ivAccessIntent;
        try {
            n = accessIntent == null || (n = this.helper.getIsolationLevel(accessIntent)) == 0 ? this.defaultIsolationLevel : n;
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSRdbConnectionFactoryImpl.getConnection", "223", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getConnection", "Exception");
            }
            throw resourceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Using isolation level: " + AdapterUtil.getIsolationLevelString(n));
            Tr.debug(tc, "support isolation level switching: " + this.supportIsolvlSwitching);
        }
        if (!(this.mcf.ispropagateClientIdentityUsingTrustedContextEnabled() || this.extendedDSProps != null || this.mcf.getOptimizedForGetUseClose() || this.mcf.shouldDataBeCollectedAndPshedDownToCMX())) {
            wSConnectionRequestInfoImpl = this.supportIsolvlSwitching ? (this.mcf.jmsOnePhaseOptimization ? (n < defaultCRIsWithIW_CMPShare.length ? defaultCRIsWithIW_CMPShare[n] : new WSConnectionRequestInfoImpl(n, false, true, true)) : (n < defaultCRIsWithSwitch.length ? defaultCRIsWithSwitch[n] : new WSConnectionRequestInfoImpl(n, false, true, false))) : (this.mcf.jmsOnePhaseOptimization ? (n < defaultCRIsWithCMPShare.length ? defaultCRIsWithCMPShare[n] : new WSConnectionRequestInfoImpl(n, false, false, true)) : (n < defaultCRIs.length ? defaultCRIs[n] : new WSConnectionRequestInfoImpl(n, false)));
        } else {
            wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(n, false, this.supportIsolvlSwitching, this.mcf.jmsOnePhaseOptimization);
            wSConnectionRequestInfoImpl.markAsChangable();
            try {
                wSConnectionRequestInfoImpl.setHeterogeneousProperties(this.extendedDSProps, this.extendedDSPropsKey);
                wSConnectionRequestInfoImpl.setOptimizeForGetUseClose(this.mcf.getOptimizedForGetUseClose());
                wSConnectionRequestInfoImpl.setJ2EEName(this._j2eeName);
            }
            catch (SQLException sQLException) {
                throw new DataStoreAdapterException("DSA_ERROR", sQLException, this.getClass());
            }
        }
        return ((WSRdbConnectionImpl)this.connMgr.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)wSConnectionRequestInfoImpl)).initialize(this.connMgr, accessIntent);
    }

    public final ResourceAdapterMetaData getMetaData() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetaData()");
        }
        if (this.ivResourceAdapterMetaData == null) {
            this.ivResourceAdapterMetaData = WSRdbResourceAdapterMetaDataImpl.createResourceAdapterMetaData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetaData()", this.ivResourceAdapterMetaData);
        }
        return this.ivResourceAdapterMetaData;
    }

    public final RecordFactory getRecordFactory() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecordFactory()");
        }
        if (this.ivRecordFactory == null) {
            this.ivRecordFactory = WSRecordFactoryImpl.createRecordFactory();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecordFactory()", this.ivRecordFactory);
        }
        return this.ivRecordFactory;
    }

    public final Reference getReference() throws NamingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getReference()", this.ivReference);
        }
        return this.ivReference;
    }

    public final int hashCode() {
        return this.mcf.hashCode() + this.connMgr.hashCode();
    }

    public final void setReference(Reference reference) {
        this.ivReference = reference;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setReference()", this.ivReference);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public int getDSHelperType() {
        return this.dsHelperType;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating default, reusable ConnectionRequestInfo instances.");
        }
        defaultCRIs = new WSConnectionRequestInfoImpl[9];
        WSRdbConnectionFactoryImpl.defaultCRIs[0] = new WSConnectionRequestInfoImpl(0, false);
        WSRdbConnectionFactoryImpl.defaultCRIs[1] = new WSConnectionRequestInfoImpl(1, false);
        WSRdbConnectionFactoryImpl.defaultCRIs[2] = new WSConnectionRequestInfoImpl(2, false);
        WSRdbConnectionFactoryImpl.defaultCRIs[4] = new WSConnectionRequestInfoImpl(4, false);
        WSRdbConnectionFactoryImpl.defaultCRIs[8] = new WSConnectionRequestInfoImpl(8, false);
        defaultCRIsWithSwitch = new WSConnectionRequestInfoImpl[9];
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[0] = new WSConnectionRequestInfoImpl(0, false, true, false);
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[1] = new WSConnectionRequestInfoImpl(1, false, true, false);
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[2] = new WSConnectionRequestInfoImpl(2, false, true, false);
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[4] = new WSConnectionRequestInfoImpl(4, false, true, false);
        WSRdbConnectionFactoryImpl.defaultCRIsWithSwitch[8] = new WSConnectionRequestInfoImpl(8, false, true, false);
        defaultCRIsWithIW_CMPShare = new WSConnectionRequestInfoImpl[9];
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[0] = new WSConnectionRequestInfoImpl(0, false, true, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[1] = new WSConnectionRequestInfoImpl(1, false, true, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[2] = new WSConnectionRequestInfoImpl(2, false, true, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[4] = new WSConnectionRequestInfoImpl(4, false, true, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithIW_CMPShare[8] = new WSConnectionRequestInfoImpl(8, false, true, true);
        defaultCRIsWithCMPShare = new WSConnectionRequestInfoImpl[9];
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[0] = new WSConnectionRequestInfoImpl(0, false, false, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[1] = new WSConnectionRequestInfoImpl(1, false, false, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[2] = new WSConnectionRequestInfoImpl(2, false, false, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[4] = new WSConnectionRequestInfoImpl(4, false, false, true);
        WSRdbConnectionFactoryImpl.defaultCRIsWithCMPShare[8] = new WSConnectionRequestInfoImpl(8, false, false, true);
    }
}

