/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.db2.jcc.DB2Wrapper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.j2c.InteractionMetrics;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.cci.WSInteractionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbCallableStatement;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionMetaDataImpl;
import com.ibm.ws.rsadapter.cci.WSRdbLocalTransactionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbPreparedStatement;
import com.ibm.ws.rsadapter.cci.WSRdbRecordImpl;
import com.ibm.ws.rsadapter.cci.WSRdbResultSetInfoImpl;
import com.ibm.ws.rsadapter.cci.WSRdbUtil;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.spi.CSCacheKey;
import com.ibm.ws.rsadapter.spi.PSCacheKey;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSet;
import javax.resource.cci.ResultSetInfo;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class WSRdbConnectionImpl
implements Reassociateable,
FFDCSelfIntrospectable,
Connection,
DB2Wrapper {
    private static final TraceComponent tc = Tr.register(WSRdbConnectionImpl.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final long PASSKEY = 262144L;
    private int state;
    private boolean isReserved;
    WSRdbManagedConnectionImpl managedConn;
    java.sql.Connection jdbcConn;
    private Object managedConnKey;
    WSInteractionImpl interaction;
    private WSRdbLocalTransactionImpl localTran;
    private WSRdbConnectionMetaDataImpl metaData;
    private WSRdbResultSetInfoImpl rsetInfo;
    StatementCacheKey statementCacheKey;
    int numParameters;
    private ResultSet[] resultSets = new ResultSet[maxResultSets];
    private int numResultSets;
    private static int maxResultSets = 20;
    J2CPerf pmi;
    InteractionMetrics metrics;
    WSManagedConnectionFactoryImpl mcf;
    private ConnectionManager cm;
    private LazyEnlistableConnectionManager lazyEnlistableCM;
    private LazyAssociatableConnectionManager lazyAssociatableCM;
    private Subject subject;
    private ConnectionRequestInfo connRequestInfo;
    int rsType;
    int rsConcurrency;
    int fetchSize;
    Statement stmtImpl;
    boolean batchOperation;
    int numBatchRecords = 0;
    int[] batchUpdateCount;
    WSRdbPreparedStatement bPstmt;
    boolean[] batchReadBooleanArray = null;
    boolean batchRead = false;
    private WSRdbCallableStatement[] cStmtWrappers;
    private int numCStmtWrappers;
    private static final int INIT_NUM_CSTMT = 5;
    private static final int INCREMNT_SIZE_CSTMT = 10;
    WSRdbRecordImpl rdbRecord = null;
    int currentTransactionIsolation = 2;
    boolean supportIsolvlSwitching = false;

    public WSRdbConnectionImpl(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, java.sql.Connection connection, Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{wSRdbManagedConnectionImpl, AdapterUtil.toString(connection)});
        }
        this.managedConn = wSRdbManagedConnectionImpl;
        this.jdbcConn = connection;
        this.managedConnKey = object;
        this.mcf = this.managedConn.getManagedConnectionFactory();
        this.pmi = this.mcf.getPMI();
        this.metrics = this.managedConn.getInteractionMetrics();
        this.supportIsolvlSwitching = this.mcf.getInternalDataStoreHelper().isIsolationLevelSwitchingSupport();
        this.currentTransactionIsolation = this.managedConn.getTransactionIsolation();
        this.state = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    final void addResultSet(ResultSet resultSet) {
        (this.numResultSets < this.resultSets.length - 1 ? this.resultSets : this.resizeResultSetList())[this.numResultSets++] = resultSet;
    }

    public void close() throws ResourceException {
        ResourceException resourceException;
        block26: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "close", this);
            }
            resourceException = null;
            ResourceException resourceException2 = null;
            this.batchUpdateCount = null;
            if (this.state == 2) {
                throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSRdbConnectionImpl.class);
            }
            this.state = 2;
            if (this.managedConn != null && this.managedConn.getNumberOfInUseHandles() == 1) {
                try {
                    boolean bl = this.mcf.getDataStoreHelper().doConnectionCleanupPerCloseConnection(this.jdbcConn, true, null);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "doConnectionCleanupPerCloseConnection on [helper, mc, sqlCon, returned value]", new Object[]{this.mcf.getDataStoreHelper(), this.managedConn, this.jdbcConn, new Boolean(bl)});
                    }
                }
                catch (Throwable throwable) {
                    SQLException sQLException;
                    FFDCFilter.processException(throwable, "WSRdbConnectionImpl.close", "340", this);
                    if (throwable instanceof SQLException) {
                        sQLException = WSRdbUtil.mapException(this, (SQLException)throwable);
                    }
                    resourceException = new DataStoreAdapterException("DSA_ERROR", sQLException, WSRdbConnectionImpl.class);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "doConnectionCleanupPerCloseConnection is not called on mc because number of handles is not 1  or MC is null(i.e. get=>use=>close is not followed", new Object[]{this.managedConn, this.managedConn == null ? new Integer(0) : new Integer(this.managedConn.getNumberOfInUseHandles())});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "state --> CLOSED");
            }
            ResourceException resourceException3 = resourceException2 = this.numResultSets == 0 ? null : this.closeResultSets();
            if (resourceException == null) {
                resourceException = resourceException2;
            }
            if (this.interaction != null && !this.interaction.isClosed) {
                try {
                    this.interaction.close();
                }
                catch (ResourceException resourceException4) {
                    FFDCFilter.processException((Throwable)resourceException4, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.close", "134", this);
                    if (resourceException != null) break block26;
                    resourceException = resourceException4;
                }
            }
        }
        if (this.rdbRecord != null) {
            this.rdbRecord.close();
            this.rdbRecord = null;
        }
        this.returnCallableStatementToCache();
        if (this.managedConn != null) {
            try {
                this.managedConn.processConnectionClosedEvent(this);
            }
            catch (ResourceException resourceException5) {
                FFDCFilter.processException((Throwable)resourceException5, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.close", "193", this);
                if (resourceException == null) {
                    resourceException = resourceException5;
                }
            }
        } else {
            WSManagedConnectionFactoryImpl.locationRestrictedFunction.inactiveConnectionClosed(this, this.cm);
        }
        this.managedConn = null;
        this.jdbcConn = null;
        this.mcf = null;
        this.cm = null;
        this.subject = null;
        this.connRequestInfo = null;
        this.statementCacheKey = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "destroying Handle:", this);
        }
        this.managedConnKey = null;
        this.metaData = null;
        this.interaction = null;
        this.localTran = null;
        this.rsetInfo = null;
        this.resultSets = null;
        this.isReserved = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (resourceException == null) {
                Tr.exit(tc, "close");
            } else {
                Tr.exit(tc, "close", "Exception");
            }
        }
        if (resourceException != null) {
            throw resourceException;
        }
    }

    private ResourceException closeResultSets() {
        DataStoreAdapterException dataStoreAdapterException = null;
        Object var2_2 = null;
        int n = this.numResultSets;
        while (n > 0) {
            try {
                this.resultSets[--n].close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.closeResultSets", "183", this);
                DataStoreAdapterException dataStoreAdapterException2 = AdapterUtil.createDataStoreAdapterException("ERR_CLOSING_OBJECT", new Object[]{this.resultSets[n], sQLException}, sQLException, class$com$ibm$ws$rsadapter$cci$WSRdbConnectionImpl == null ? WSRdbConnectionImpl.class$("com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl") : class$com$ibm$ws$rsadapter$cci$WSRdbConnectionImpl);
                if (dataStoreAdapterException != null) continue;
                dataStoreAdapterException = dataStoreAdapterException2;
            }
        }
        return dataStoreAdapterException;
    }

    public final Interaction createInteraction() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "createInteraction", this);
        }
        this.reactivateIfNecessary();
        if (this.supportIsolvlSwitching) {
            try {
                this.managedConn.setTransactionIsolation(this.currentTransactionIsolation);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, WSRdbConnectionImpl.class.getName() + ".createInteration", "446", this);
                throw new DataStoreAdapterException("DSA_ERROR", sQLException, WSRdbConnectionImpl.class);
            }
        }
        return this.interaction == null ? (this.interaction = new WSInteractionImpl(this)) : (this.interaction.isClosed ? this.interaction.recycle() : this.interaction);
    }

    public void dissociate() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "dissociate", this);
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isReserved) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Unreserving handle for dissociation", this);
                    }
                    this.isReserved = false;
                    this.state = 0;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break;
                    Tr.event(tc, "state --> ACTIVE");
                    break;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handle is already dissociated.", this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "dissociate");
                }
                return;
            }
            case 2: {
                throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSRdbConnectionImpl.class);
            }
        }
        if (this.numResultSets > 0) {
            this.closeResultSets();
        }
        this.connRequestInfo = this.managedConn.createConnectionRequestInfo();
        this.subject = this.managedConn.getSubject();
        this.managedConn.dissociateHandle(this);
        this.jdbcConn = null;
        this.managedConn = null;
        this.state = 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "state --> INACTIVE");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "dissociate");
        }
    }

    final void enlistIfNecessary() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enlistIfNecessary()");
        }
        if (this.managedConn.isMCStale()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale", this.managedConn);
            }
            throw new DataStoreAdapterException("INVALID_CONNECTION", new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION")), WSRdbConnectionImpl.class);
        }
        switch (this.managedConn.getTransactionState()) {
            case 2: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "Global Transaction is active.");
                break;
            }
            case 7: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "RRS_GLOBAL_TRANSACTION_ACTIVE but marking the internal flag of rrsGlobalTransactionReallyActive since we know we are enlisting.");
                }
                this.managedConn.setRrsGlobalTransactionReallyActive(true);
                break;
            }
            case 1: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "Local Transaction is active.");
                break;
            }
            case 0: {
                this.managedConn.lazyEnlist(this.lazyEnlistableCM == null ? (this.lazyEnlistableCM = (LazyEnlistableConnectionManager)this.cm) : this.lazyEnlistableCM);
                break;
            }
            default: {
                throw AdapterUtil.createDataStoreAdapterException("INVALID_TRAN_STATE", this.managedConn.getTransactionStateAsString(), null, WSRdbConnectionImpl.class);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enlistIfNecessary()");
        }
    }

    public final void fireConnectionErrorEvent(Exception exception) {
        switch (this.state) {
            case 0: {
                this.managedConn.processConnectionErrorOccurredEvent(this, exception);
                break;
            }
            case 2: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break;
                Tr.event(tc, "Connection already closed. Not sending CONNECTION_ERROR_OCCURRED.", this);
                break;
            }
            case 1: {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Handle is INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", this);
                    }
                    this.close();
                    break;
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.fireConnectionErrorEvent", "374", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Error closing connection:", (Object)resourceException);
                }
            }
        }
    }

    final CallableStatement getCallableStatement(String string) throws SQLException {
        return this.getCallableStatement(string, this.rsType, this.rsConcurrency);
    }

    final CallableStatement getCallableStatement(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement;
        Object object;
        if (this.managedConn.isStatementCachingEnabled()) {
            this.statementCacheKey = new CSCacheKey(string, n, n2, this.managedConn.getCurrentHoldability(), this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
            object = this.managedConn.getStatement(this.statementCacheKey);
            callableStatement = object == null ? (this.pmi == null ? this.jdbcConn.prepareCall(string, n, n2) : this.pmiPrepareCall(string, n, n2)) : (CallableStatement)object;
        } else {
            CallableStatement callableStatement2 = callableStatement = this.pmi == null ? this.jdbcConn.prepareCall(string, n, n2) : this.pmiPrepareCall(string, n, n2);
        }
        if (this.fetchSize != callableStatement.getFetchSize()) {
            callableStatement.setFetchSize(this.fetchSize);
        }
        object = new WSRdbCallableStatement(callableStatement, this, this.statementCacheKey, string);
        if (this.cStmtWrappers == null) {
            this.cStmtWrappers = new WSRdbCallableStatement[5];
        } else if (this.numCStmtWrappers >= this.cStmtWrappers.length) {
            WSRdbCallableStatement[] wSRdbCallableStatementArray = this.cStmtWrappers;
            this.cStmtWrappers = new WSRdbCallableStatement[this.numCStmtWrappers + 10];
            System.arraycopy(wSRdbCallableStatementArray, 0, this.cStmtWrappers, 0, wSRdbCallableStatementArray.length);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Get more CallableStatements than expected, increased array size to " + this.cStmtWrappers.length);
            }
        }
        this.cStmtWrappers[this.numCStmtWrappers++] = object;
        return object;
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        this.reactivateIfNecessary();
        return this.localTran == null ? (this.localTran = new WSRdbLocalTransactionImpl(this)) : this.localTran;
    }

    public final ManagedConnection getManagedConnection(Object object) throws ResourceException {
        if (object == this.managedConnKey && this.managedConnKey != null) {
            return this.managedConn;
        }
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSRdbConnectionImpl.class);
        }
        throw AdapterUtil.createDataStoreAdapterException("METHOD_UNSUPPORTED", new Object[]{"getManagedConnection", Connection.class.getName()}, null, WSRdbConnectionImpl.class);
    }

    public final ConnectionMetaData getMetaData() throws ResourceException {
        this.reactivateIfNecessary();
        if (this.metaData == null || !this.metaData.isInitialized) {
            try {
                DatabaseMetaData databaseMetaData = this.jdbcConn.getMetaData();
                if (this.metaData == null) {
                    this.metaData = new WSRdbConnectionMetaDataImpl(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getUserName());
                } else {
                    this.metaData.recycle(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getUserName());
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.getMetaData", "430", this);
                throw WSRdbUtil.mapToResourceException(this, sQLException);
            }
        }
        return this.metaData;
    }

    final PreparedStatement getPreparedStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreparedStatement(String sql)", new Object[]{string});
        }
        try {
            this.enlistIfNecessary();
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.getPreparedStatement", "865", this);
            throw AdapterUtil.toSQLException(resourceException);
        }
        if (this.managedConn.isStatementCachingEnabled()) {
            this.statementCacheKey = new PSCacheKey(string, this.rsType, this.rsConcurrency, this.managedConn.getCurrentHoldability(), 0, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
            Object object = this.managedConn.getStatement(this.statementCacheKey);
            preparedStatement = object == null ? (this.pmi == null ? this.jdbcConn.prepareStatement(string, this.rsType, this.rsConcurrency) : this.pmiPrepareStatement(string)) : (PreparedStatement)object;
        } else {
            PreparedStatement preparedStatement2 = preparedStatement = this.pmi == null ? this.jdbcConn.prepareStatement(string, this.rsType, this.rsConcurrency) : this.pmiPrepareStatement(string);
        }
        if (this.fetchSize != preparedStatement.getFetchSize()) {
            preparedStatement.setFetchSize(this.fetchSize);
        }
        this.stmtImpl = preparedStatement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreparedStatement", preparedStatement);
        }
        return preparedStatement;
    }

    public final ResultSetInfo getResultSetInfo() throws ResourceException {
        this.reactivateIfNecessary();
        return this.rsetInfo == null ? (this.rsetInfo = new WSRdbResultSetInfoImpl(this)) : this.rsetInfo;
    }

    public final int getState() {
        return this.state;
    }

    public final String getStateString() {
        return STATE_STRINGS[this.state];
    }

    public SQLException handleStaleStatement(SQLException sQLException) {
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Encountered a Stale Statement on Connection: " + this);
            }
            wSRdbManagedConnectionImpl = this.managedConn;
            try {
                this.close();
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.handleStaleStatement", "563", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error closing the Connection", (Object)resourceException);
            }
        }
        wSRdbManagedConnectionImpl.clearStatementCache();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "remapping StaleStatementException to StaleConnectionException");
        }
        return new StaleConnectionException(sQLException.getNextException());
    }

    final Connection initialize(ConnectionManager connectionManager, AccessIntent accessIntent) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", accessIntent);
        }
        this.cm = connectionManager;
        this.lazyAssociatableCM = this.lazyAssociatableCM == this.cm ? this.lazyAssociatableCM : null;
        LazyEnlistableConnectionManager lazyEnlistableConnectionManager = this.lazyEnlistableCM = this.lazyEnlistableCM == this.cm ? this.lazyEnlistableCM : null;
        if (accessIntent == null) {
            this.rsType = 1003;
            this.rsConcurrency = 1007;
        } else {
            DataStoreHelper dataStoreHelper = this.mcf.getDataStoreHelper();
            this.rsType = dataStoreHelper.getResultSetType(accessIntent);
            this.rsConcurrency = dataStoreHelper.getResultSetConcurrency(accessIntent);
            this.fetchSize = accessIntent.getResourceManagerPreFetchIncrement();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        return this;
    }

    public final boolean isReserved() {
        return this.isReserved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallableStatement pmiPrepareCall(String string) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            CallableStatement callableStatement = this.jdbcConn.prepareCall(string, this.rsType, this.rsConcurrency);
            return callableStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallableStatement pmiPrepareCall(String string, int n, int n2) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            CallableStatement callableStatement = this.jdbcConn.prepareCall(string, n, n2);
            return callableStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.jdbcConn.prepareStatement(string, this.rsType, this.rsConcurrency);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    final void reactivateIfNecessary() throws ResourceException {
        switch (this.state) {
            case 0: {
                return;
            }
            case 2: {
                throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSRdbConnectionImpl.class);
            }
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Handle is INACTIVE. Implicitly requesting reassociation.", this);
                }
                this.lazyAssociatableCM = this.lazyAssociatableCM == null ? (LazyAssociatableConnectionManager)this.cm : this.lazyAssociatableCM;
                this.lazyAssociatableCM.associateConnection((Object)this, (ManagedConnectionFactory)this.mcf, this.connRequestInfo);
            }
        }
    }

    public final void reassociate(ManagedConnection managedConnection, java.sql.Connection connection, Object object) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reassociate", new Object[]{this, managedConnection, AdapterUtil.toString(connection)});
        }
        if (this.managedConnKey == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSRdbConnectionImpl.class);
        }
        if (object != this.managedConnKey) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("METHOD_UNSUPPORTED", new Object[]{"reassociate", Connection.class.getName()}, null, WSRdbConnectionImpl.class);
        }
        if (this.isReserved) {
            if (managedConnection != this.managedConn) {
                String string = "Connection handle is reserved for reassociation with a specific ManagedConnection, which does not match the ManagedConnection provided.";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, string, new Object[]{this, this.managedConn, managedConnection});
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "reassociate", "Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("DSA_INTERNAL_ERROR", new Object[]{string, " See trace for more details."}, null, WSRdbConnectionImpl.class);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Handle is reserved, reassociating back to original ManagedConnection.");
            }
            this.state = 0;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "state --> ACTIVE");
            }
            this.isReserved = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate");
            }
            return;
        }
        if (this.state != 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CANNOT_REASSOCIATE", this.getStateString(), null, WSRdbConnectionImpl.class);
        }
        if (this.numResultSets > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CHILDREN_STILL_OPEN", null, null, WSRdbConnectionImpl.class);
        }
        this.managedConn = (WSRdbManagedConnectionImpl)managedConnection;
        this.jdbcConn = connection;
        this.connRequestInfo = null;
        this.subject = null;
        if (PmiReqMetrics.isPassCorrelatorToDB() && this.managedConn.getStateManager().getState() == 0) {
            this.mcf.getInternalDataStoreHelper().setEwlmCorrelator(this.metrics.getCorrelator(), this.managedConn);
        }
        this.state = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "state --> ACTIVE");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reassociate");
        }
    }

    public final WSRdbConnectionImpl recycle(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, java.sql.Connection connection, Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recycle", new Object[]{wSRdbManagedConnectionImpl, AdapterUtil.toString(connection)});
        }
        if (object != this.managedConnKey) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "recycle", "Error: Unauthorized Access");
            }
            throw new UnsupportedOperationException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"recycle", Connection.class.getName()}));
        }
        this.managedConn = wSRdbManagedConnectionImpl;
        this.jdbcConn = connection;
        this.mcf = this.managedConn.getManagedConnectionFactory();
        this.statementCacheKey = null;
        this.currentTransactionIsolation = this.managedConn.getTransactionIsolation();
        this.isReserved = false;
        this.state = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "state --> ACTIVE");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recycle", this);
        }
        return this;
    }

    final void removeResultSet(ResultSet resultSet) {
        int n = this.numResultSets;
        while (n > 0) {
            if (resultSet != this.resultSets[--n]) continue;
            this.resultSets[n] = this.resultSets[--this.numResultSets];
            this.resultSets[this.numResultSets] = null;
            break;
        }
    }

    public final void reserve(Object object) throws ResourceException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSRdbConnectionImpl.class);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("METHOD_UNSUPPORTED", new Object[]{"reserve", Connection.class.getName()}, null, WSRdbConnectionImpl.class);
        }
        this.isReserved = true;
        this.state = 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Reserving handle", this);
            Tr.event(tc, "state --> INACTIVE");
        }
    }

    private ResultSet[] resizeResultSetList() {
        this.resultSets = new ResultSet[maxResultSets > this.numResultSets ? maxResultSets : (maxResultSets = this.numResultSets * 2)];
        System.arraycopy(this.resultSets, 0, this.resultSets, 0, this.numResultSets);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ResultSet limit increased to: " + maxResultSets);
        }
        return this.resultSets;
    }

    public boolean supportsImplicitReactivation() {
        return true;
    }

    final void returnCallableStatementToCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "returnCallableStatementToCache", this);
        }
        if (this.numCStmtWrappers > 0) {
            for (int i = 0; i < this.numCStmtWrappers; ++i) {
                this.cStmtWrappers[i].returnStatementWrapperToCache();
                this.cStmtWrappers[i] = null;
            }
            this.numCStmtWrappers = 0;
            if (this.cStmtWrappers.length > 5) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Callable statement wrapper array is too big, discard it.");
                }
                this.cStmtWrappers = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "returnCallableStatementToCache");
        }
    }

    final void addRdbRecord(WSRdbRecordImpl wSRdbRecordImpl) {
        this.rdbRecord = wSRdbRecordImpl;
    }

    public ConnectionRequestInfo getCRI() {
        return this.connRequestInfo;
    }

    public void cacheOrCloseNativeCStmt(WSRdbCallableStatement wSRdbCallableStatement) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "cacheOrCloseNativeCStmt", new Object[]{this, wSRdbCallableStatement});
        }
        if (this.numCStmtWrappers > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cacheOrCloseNativeCStmt", "number of CallableStatement wrappers is " + this.numCStmtWrappers);
            }
            for (int i = 0; i < this.numCStmtWrappers; ++i) {
                if (wSRdbCallableStatement != null && this.cStmtWrappers[i] == wSRdbCallableStatement) continue;
                CallableStatement callableStatement = this.cStmtWrappers[i].cstmt;
                if (this.cStmtWrappers[i].statementCacheKey == null) {
                    try {
                        callableStatement.close();
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, AdapterUtil.toString(callableStatement) + " is closed");
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.cacheOrCloseNativeCStmt", "1547", this);
                        Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{AdapterUtil.toString(callableStatement), sQLException});
                    }
                    continue;
                }
                callableStatement.clearParameters();
                try {
                    java.sql.ResultSet resultSet = null;
                    while (callableStatement.getMoreResults() | callableStatement.getUpdateCount() != -1) {
                        resultSet = callableStatement.getResultSet();
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                    this.managedConn.cacheStatement(callableStatement, this.cStmtWrappers[i].statementCacheKey);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, AdapterUtil.toString(callableStatement) + " is cached");
                    continue;
                }
                catch (SQLException sQLException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Errors while caching. Statement cannot be cached.");
                    }
                    try {
                        callableStatement.close();
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, AdapterUtil.toString(callableStatement) + " is closed");
                        continue;
                    }
                    catch (SQLException sQLException2) {
                        FFDCFilter.processException((Throwable)sQLException2, "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl.cacheOrCloseNativeCStmt", "1762", this);
                        Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{AdapterUtil.toString(callableStatement), sQLException2});
                    }
                }
            }
        }
    }

    public final Object getDB2Object() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getDB2Object", this.jdbcConn);
        }
        return this.jdbcConn;
    }

    public final WSRdbManagedConnectionImpl getMC(long l) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMC(passkey)", "******");
        }
        if (l != 262144L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "passkey not valid");
            }
            throw new SQLException(AdapterUtil.getNLSMessage("INVALID_OPERATION"));
        }
        return this.managedConn;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("Interaction for this Connection ", this.interaction);
        fFDCLogger.append("Application level local transaction ", this.localTran);
        fFDCLogger.append("Meta data", this.metaData);
        fFDCLogger.append("ResultSet information  ", this.rsetInfo);
        fFDCLogger.append("ResultSet information  ", this.rsetInfo);
        fFDCLogger.append("List of ResultSets associated with this Connection ", this.resultSets);
        fFDCLogger.append("Statement cache key for ResultSets ", this.statementCacheKey);
        fFDCLogger.append("JDBC Connection ", AdapterUtil.toString(this.jdbcConn));
        fFDCLogger.introspect("WSManagedConnectionFactoryImpl", this.mcf);
        fFDCLogger.introspect("WSRdbManagedConnectionImpl", this.managedConn);
        return fFDCLogger.toStringArray();
    }
}

