/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.rsadapter.WSCciConnectionSpec;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.cci.WSConnectionSpecImpl;

public class WSRdbConnectionSpecImpl
extends WSConnectionSpecImpl
implements WSCciConnectionSpec,
FFDCSelfIntrospectable {
    private static final long serialVersionUID = 1079931785367334296L;
    AccessIntent ivAccessIntent;

    public boolean equals(Object object) {
        WSRdbConnectionSpecImpl wSRdbConnectionSpecImpl = null;
        try {
            wSRdbConnectionSpecImpl = (WSRdbConnectionSpecImpl)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return WSRdbConnectionSpecImpl.match(this.ivAccessIntent, wSRdbConnectionSpecImpl.ivAccessIntent) && WSRdbConnectionSpecImpl.match(this.ivUserName, wSRdbConnectionSpecImpl.ivUserName) && WSRdbConnectionSpecImpl.match(this.ivPassword, wSRdbConnectionSpecImpl.ivPassword) && this.ivHoldability == wSRdbConnectionSpecImpl.ivHoldability && WSRdbConnectionSpecImpl.match(this.ivCatalog, wSRdbConnectionSpecImpl.ivCatalog) && WSRdbConnectionSpecImpl.match(this.ivReadOnly, wSRdbConnectionSpecImpl.ivReadOnly) && WSRdbConnectionSpecImpl.match(this.ivTypeMap, wSRdbConnectionSpecImpl.ivTypeMap);
    }

    public final AccessIntent getAccessIntent() {
        return this.ivAccessIntent;
    }

    public int hashCode() {
        return (this.ivAccessIntent == null ? 0 : this.ivAccessIntent.hashCode()) + (this.ivUserName == null ? 0 : this.ivUserName.hashCode()) + (this.ivPassword == null ? 0 : this.ivPassword.hashCode()) + (this.ivCatalog == null ? 0 : this.ivCatalog.hashCode()) + (this.ivReadOnly == null ? 0 : this.ivReadOnly.hashCode()) + this.ivHoldability + (this.ivTypeMap == null ? 0 : ((Object)this.ivTypeMap).hashCode());
    }

    public final void setAccessIntent(AccessIntent accessIntent) {
        this.ivAccessIntent = accessIntent;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("User Name:", this.ivUserName);
        fFDCLogger.append("Password:", this.ivPassword == null ? null : "******");
        fFDCLogger.append("Access Intent:", this.ivAccessIntent);
        fFDCLogger.append("Catalog:", this.ivCatalog);
        fFDCLogger.append("Is Read Only?", this.ivReadOnly);
        fFDCLogger.append("Type Map:", this.ivTypeMap);
        fFDCLogger.append("Cursor Holdability:", AdapterUtil.getCursorHoldabilityString(this.ivHoldability));
        fFDCLogger.append("Hash Code:", Integer.toHexString(this.hashCode()));
        return fFDCLogger.toStringArray();
    }

    private static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public final WSRdbConnectionSpecImpl recycle() {
        this.ivAccessIntent = null;
        this.ivUserName = null;
        this.ivPassword = null;
        this.ivCatalog = null;
        this.ivReadOnly = null;
        this.ivTypeMap = null;
        this.ivHoldability = 0;
        return this;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return new String(new StringBuffer(300).append(AdapterUtil.toString(this)).append(string + "  UserName     = ").append(this.ivUserName).append(string + "  Password     = ").append(this.ivPassword == null ? this.ivPassword : "******").append(string + "  Catalog      = ").append(this.ivCatalog).append(string + "  IsReadOnly   = ").append(this.ivReadOnly).append(string + "  TypeMap      = ").append(this.ivTypeMap).append(string + "  Holdability  = ").append(AdapterUtil.getCursorHoldabilityString(this.ivHoldability)).append(string + "  AccessIntent = ").append(this.ivAccessIntent));
    }
}

