/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class WSRdbPreparedStatement
implements PreparedStatement {
    private static final TraceComponent tc = Tr.register(WSRdbPreparedStatement.class, "RRA", "IBMDataStoreAdapterNLS");
    int numBatchRecords;
    int currentBatchValue = 1;
    int[] batchUpdateCount;
    PreparedStatement _pstmt;
    private boolean[] boolArray;
    boolean supportsBatchRead = false;

    boolean[] getBooleanArray() {
        return this.boolArray;
    }

    public WSRdbPreparedStatement(PreparedStatement preparedStatement) {
        this._pstmt = preparedStatement;
    }

    public final int getNumBatchRecords() {
        return this.numBatchRecords;
    }

    public final void setNumBatchRecords(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNumBatchRecords ", new Integer(n));
        }
        this.numBatchRecords = n;
        this.boolArray = new boolean[n];
    }

    public final int getCurrentBatchValue() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCurrentBatchValue ", new Integer(this.currentBatchValue));
        }
        return this.currentBatchValue;
    }

    public final int[] getBatchUpdateCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBatchUpdateCount ", this.batchUpdateCount);
        }
        return this.batchUpdateCount;
    }

    PreparedStatement getContainedStatement() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getContainedStatement ", this._pstmt);
        }
        return this._pstmt;
    }

    final void removeContainedStatement() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting the contained to null ");
        }
        this._pstmt = null;
    }

    public int executeUpdate() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeUpdate", this);
        }
        try {
            if (this.currentBatchValue == this.numBatchRecords) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doing addBatch then executeBatch since its last statement in the batch");
                }
                this._pstmt.addBatch();
                this.batchUpdateCount = this._pstmt.executeBatch();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doing addBatch only since its NOT last statement in the batch");
                }
                this._pstmt.addBatch();
            }
            ++this.currentBatchValue;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbPreparedStatement.executeUpdate", "102", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught an exception will set the currentBatchValue to -1 and clear the batch and continue", sQLException);
            }
            this.currentBatchValue = -1;
            try {
                this.clearBatch();
            }
            catch (SQLException sQLException2) {
                Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"clearBatch()", sQLException2, "method not supported on backend database"});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeUpdate with exception", sQLException);
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeUpdate");
        }
        return -1;
    }

    public void addBatch() throws SQLException {
        this._pstmt.addBatch();
    }

    public void clearParameters() throws SQLException {
        this._pstmt.clearParameters();
    }

    public boolean execute() throws SQLException {
        return this._pstmt.execute();
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = null;
        try {
            if (this.supportsBatchRead) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "executeQuery: doing batchRead where db supports batch read", this);
                }
                if (this.currentBatchValue == this.numBatchRecords) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "doing addBatch then executeBatch since its last statement in the batch");
                    }
                    this._pstmt.addBatch();
                    this._pstmt.executeBatch();
                    int n = 1;
                    ResultSet resultSet2 = null;
                    while (this._pstmt.getMoreResults()) {
                        resultSet2 = this._pstmt.getResultSet();
                        if (resultSet2.next()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "row found");
                            }
                            this.boolArray[n - 1] = true;
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "NO row found");
                            }
                            this.boolArray[n - 1] = false;
                        }
                        resultSet2.close();
                        ++n;
                    }
                    if (n < this.numBatchRecords) {
                        throw new SQLException(AdapterUtil.getNLSMessage("DSA_BATCH_PROBLEM", new Object[]{"executeBatch", "operation did not return correct number of ResultSets"}));
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "doing addBatch only since its NOT last statement in the batch");
                    }
                    this._pstmt.addBatch();
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "executeQuery: doing batchRead one by one, real batchRead is not supported on backend", this);
                }
                if ((resultSet = this._pstmt.executeQuery()).next()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "row found");
                    }
                    this.boolArray[this.currentBatchValue - 1] = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NO row found");
                    }
                    this.boolArray[this.currentBatchValue - 1] = false;
                }
            }
            ++this.currentBatchValue;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbPreparedStatement.executeUpdate", "238", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught an exception will set the currentBatchValue to -1 and clear the batch and continue", sQLException);
            }
            this.currentBatchValue = -1;
            if (this.supportsBatchRead) {
                try {
                    this.clearBatch();
                }
                catch (SQLException sQLException2) {
                    Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"clearBatch()", sQLException2, ""});
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeQuery: sqlException caught on addBatch() or executeBatch() ", sQLException);
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeQuery: addBatch() or executeBatch() was successful");
        }
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._pstmt.getMetaData();
    }

    public void setArray(int n, Array array) throws SQLException {
        this._pstmt.setArray(n, array);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this._pstmt.setAsciiStream(n, inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this._pstmt.setBigDecimal(n, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this._pstmt.setBinaryStream(n, inputStream, n2);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this._pstmt.setBlob(n, blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this._pstmt.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this._pstmt.setByte(n, by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this._pstmt.setBytes(n, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this._pstmt.setCharacterStream(n, reader, n2);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this._pstmt.setClob(n, clob);
    }

    public void setDate(int n, Date date) throws SQLException {
        this._pstmt.setDate(n, date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this._pstmt.setDate(n, date, calendar);
    }

    public void setDouble(int n, double d) throws SQLException {
        this._pstmt.setDouble(n, d);
    }

    public void setFloat(int n, float f) throws SQLException {
        this._pstmt.setFloat(n, f);
    }

    public void setInt(int n, int n2) throws SQLException {
        this._pstmt.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this._pstmt.setLong(n, l);
    }

    public void setNull(int n, int n2) throws SQLException {
        this._pstmt.setNull(n, n2);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this._pstmt.setNull(n, n2, string);
    }

    public void setObject(int n, Object object) throws SQLException {
        this._pstmt.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this._pstmt.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this._pstmt.setObject(n, object, n2, n3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this._pstmt.setRef(n, ref);
    }

    public void setShort(int n, short s) throws SQLException {
        this._pstmt.setShort(n, s);
    }

    public void setString(int n, String string) throws SQLException {
        this._pstmt.setString(n, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this._pstmt.setTime(n, time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this._pstmt.setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this._pstmt.setTimestamp(n, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this._pstmt.setTimestamp(n, timestamp, calendar);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this._pstmt.setUnicodeStream(n, inputStream, n2);
    }

    public void addBatch(String string) throws SQLException {
        this._pstmt.addBatch(string);
    }

    public void cancel() throws SQLException {
        this._pstmt.cancel();
    }

    public void clearBatch() throws SQLException {
        this._pstmt.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this._pstmt.clearWarnings();
    }

    public void close() throws SQLException {
        this._pstmt.close();
    }

    public boolean execute(String string) throws SQLException {
        return this._pstmt.execute(string);
    }

    public int[] executeBatch() throws SQLException {
        return this._pstmt.executeBatch();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        return this._pstmt.executeQuery(string);
    }

    public int executeUpdate(String string) throws SQLException {
        return this._pstmt.executeUpdate(string);
    }

    public Connection getConnection() throws SQLException {
        return this._pstmt.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this._pstmt.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this._pstmt.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this._pstmt.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this._pstmt.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this._pstmt.getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        return this._pstmt.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this._pstmt.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this._pstmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this._pstmt.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this._pstmt.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._pstmt.getWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this._pstmt.setCursorName(string);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this._pstmt.setEscapeProcessing(bl);
    }

    public void setFetchDirection(int n) throws SQLException {
        this._pstmt.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this._pstmt.setFetchSize(n);
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this._pstmt.setMaxFieldSize(n);
    }

    public void setMaxRows(int n) throws SQLException {
        this._pstmt.setMaxRows(n);
    }

    public void setQueryTimeout(int n) throws SQLException {
        this._pstmt.setQueryTimeout(n);
    }

    public boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    public ResultSet getGeneratedKeys() {
        return null;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        return 0;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return 0;
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return 0;
    }

    public boolean execute(String string, int n) throws SQLException {
        return false;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        return false;
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public void setURL(int n, URL uRL) throws SQLException {
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }
}

