/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.rsadapter.WSRdbRecord;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbResultSetImpl;
import com.ibm.ws.rsadapter.cci.WSRdbUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class WSRdbRecordImpl
implements WSRdbRecord {
    private static final long serialVersionUID = 4414887319863033619L;
    private static final TraceComponent tc = Tr.register(WSRdbRecordImpl.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final String currClassName = WSRdbRecordImpl.class.getName();
    private String ivRecordName;
    private String ivRecordShortDescription;
    private CallableStatement cstmt;
    private StatementCacheKey statementCacheKey;
    private WSRdbConnectionImpl rdbConn;
    private WSRdbResultSetImpl[] rsetWrappers;
    private int numRSetWrappers;
    private static final int MAX_NUM_RSET = 5;
    private static final int INCREMNT_SIZE_RSET = 10;

    public WSRdbRecordImpl(CallableStatement callableStatement, Object object, StatementCacheKey statementCacheKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{AdapterUtil.toString(callableStatement), AdapterUtil.toString(object), statementCacheKey});
        }
        this.cstmt = callableStatement;
        try {
            this.rdbConn = (WSRdbConnectionImpl)object;
            this.rdbConn.addRdbRecord(this);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.<init>", "129", this);
            Tr.error(tc, "CAST_EXCEPTION", new Object[]{object.getClass().getName(), "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl"});
            throw classCastException;
        }
        this.statementCacheKey = statementCacheKey;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init", this);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResultSet", this);
        }
        try {
            Object object;
            ResultSet resultSet = this.cstmt.getResultSet();
            if (resultSet == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getResultSet", null);
                }
                return null;
            }
            if (this.rsetWrappers == null) {
                this.rsetWrappers = new WSRdbResultSetImpl[5];
            } else if (this.numRSetWrappers >= this.rsetWrappers.length) {
                object = this.rsetWrappers;
                this.rsetWrappers = new WSRdbResultSetImpl[this.numRSetWrappers + 10];
                System.arraycopy(object, 0, this.rsetWrappers, 0, ((Object)object).length);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Get more result sets than expected, increased array size to " + this.rsetWrappers.length);
                }
            }
            object = new WSRdbResultSetImpl(resultSet, true);
            ((WSRdbResultSetImpl)object).initialize(this.rdbConn);
            this.rsetWrappers[this.numRSetWrappers++] = object;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getResultSet", "136", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResultSet", "Exception");
            }
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResultSet", this.rsetWrappers[this.numRSetWrappers - 1]);
        }
        return this.rsetWrappers[this.numRSetWrappers - 1];
    }

    public int getUpdateCount() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUpdateCount");
        }
        try {
            return this.cstmt.getUpdateCount();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getUpdateCount", "163", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public boolean getMoreResults() throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMoreResults", this);
        }
        try {
            if (this.numRSetWrappers > 0 && !this.rsetWrappers[this.numRSetWrappers - 1].isClosed()) {
                this.rsetWrappers[this.numRSetWrappers - 1].close();
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getMoreResults", "201", this);
            Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{AdapterUtil.toString(this.rsetWrappers[this.numRSetWrappers - 1]), sQLException});
        }
        try {
            bl = this.cstmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getMoreResults", "213", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMoreResults", "Exception");
            }
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMoreResults", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", this);
        }
        if (this.numRSetWrappers > 0) {
            if (!this.rsetWrappers[this.numRSetWrappers - 1].isClosed()) {
                try {
                    this.rsetWrappers[this.numRSetWrappers - 1].close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.close", "255", this);
                    Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{AdapterUtil.toString(this.rsetWrappers[this.numRSetWrappers - 1]), sQLException});
                }
            }
            int n = this.numRSetWrappers;
            while (n > 0) {
                this.rsetWrappers[--n].setStatementCallable(false);
                this.rsetWrappers[n] = null;
            }
            this.numRSetWrappers = 0;
        }
        this.cstmt = null;
        this.ivRecordName = null;
        this.ivRecordShortDescription = null;
        this.rdbConn = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public final WSRdbRecordImpl recycle(CallableStatement callableStatement, Object object, StatementCacheKey statementCacheKey) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "recycle", new Object[]{AdapterUtil.toString(callableStatement), AdapterUtil.toString(object), statementCacheKey});
        }
        this.cstmt = callableStatement;
        try {
            this.rdbConn = (WSRdbConnectionImpl)object;
            this.rdbConn.addRdbRecord(this);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.<init>", "402", this);
            Tr.error(tc, "CAST_EXCEPTION", new Object[]{object.getClass().getName(), currClassName});
            throw classCastException;
        }
        this.statementCacheKey = statementCacheKey;
        this.ivRecordName = null;
        this.ivRecordShortDescription = null;
        return this;
    }

    public Array getArray(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getArray", new Integer(n));
        }
        try {
            return this.cstmt.getArray(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getArray", "433", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Array getArray(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getArray", string);
        }
        try {
            return this.cstmt.getArray(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getArray", "442", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBigDecimal", new Integer(n));
        }
        try {
            return this.cstmt.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBigDecimal", "473", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBigDecimal", new Object[]{new Integer(n), new Integer(n2)});
        }
        try {
            return this.cstmt.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBigDecimal", "499", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBigDecimal", string);
        }
        try {
            return this.cstmt.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBigDecimal", "508", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Blob getBlob(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBlob", new Integer(n));
        }
        try {
            return this.cstmt.getBlob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBlob", "537", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBlob", string);
        }
        try {
            return this.cstmt.getBlob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBlob", "546", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBoolean", new Integer(n));
        }
        try {
            return this.cstmt.getBoolean(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBoolean", "576", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBoolean", string);
        }
        try {
            return this.cstmt.getBoolean(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBoolean", "585", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public byte getByte(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getByte", new Integer(n));
        }
        try {
            return this.cstmt.getByte(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getByte", "613", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public byte getByte(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getByte", string);
        }
        try {
            return this.cstmt.getByte(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getByte", "622", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBytes", new Integer(n));
        }
        try {
            return this.cstmt.getBytes(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBytes", "650", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBytes", string);
        }
        try {
            return this.cstmt.getBytes(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getBytes", "659", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Clob getClob(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClob", new Integer(n));
        }
        try {
            return this.cstmt.getClob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getClob", "688", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClob", string);
        }
        try {
            return this.cstmt.getClob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getClob", "697", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Date getDate(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDate", new Integer(n));
        }
        try {
            return this.cstmt.getDate(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDate", "729", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDate", new Object[]{new Integer(n), calendar});
        }
        try {
            return this.cstmt.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDate", "755", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Date getDate(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDate", string);
        }
        try {
            return this.cstmt.getDate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDate", "764", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDate", new Object[]{string, calendar});
        }
        try {
            return this.cstmt.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDate", "773", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public double getDouble(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDouble", new Integer(n));
        }
        try {
            return this.cstmt.getDouble(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDouble", "809", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public double getDouble(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDouble", string);
        }
        try {
            return this.cstmt.getDouble(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getDouble", "818", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public float getFloat(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFloat", new Integer(n));
        }
        try {
            return this.cstmt.getFloat(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getFloat", "846", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public float getFloat(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFloat", string);
        }
        try {
            return this.cstmt.getFloat(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getFloat", "855", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public int getInt(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInt", new Integer(n));
        }
        try {
            return this.cstmt.getInt(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getInt", "885", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public int getInt(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInt", string);
        }
        try {
            return this.cstmt.getInt(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getInt", "894", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public long getLong(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLong", new Integer(n));
        }
        try {
            return this.cstmt.getLong(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getLong", "923", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public long getLong(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLong", string);
        }
        try {
            return this.cstmt.getLong(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getLong", "931", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Object getObject(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getObject", new Integer(n));
        }
        try {
            return this.cstmt.getObject(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getObject", "966", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getObject", new Object[]{new Integer(n), map});
        }
        try {
            return this.cstmt.getObject(n, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getObject", "994", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Object getObject(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getObject", string);
        }
        try {
            return this.cstmt.getObject(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getObject", "1003", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getObject", new Object[]{string, map});
        }
        try {
            return this.cstmt.getObject(string, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getObject", "1012", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Ref getRef(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRef", new Integer(n));
        }
        try {
            return this.cstmt.getRef(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getRef", "1059", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Ref getRef(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRef", string);
        }
        try {
            return this.cstmt.getRef(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getRef", "1068", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public short getShort(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getShort", new Integer(n));
        }
        try {
            return this.cstmt.getShort(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getShort", "1098", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public short getShort(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getShort", string);
        }
        try {
            return this.cstmt.getShort(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getShort", "1107", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public String getString(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getString", new Integer(n));
        }
        try {
            return this.cstmt.getString(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getString", "1139", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public String getString(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getString", string);
        }
        try {
            return this.cstmt.getString(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getString", "1148", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Time getTime(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTime", new Integer(n));
        }
        try {
            return this.cstmt.getTime(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTime", "1181", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTime", new Object[]{new Integer(n), calendar});
        }
        try {
            return this.cstmt.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTime", "1206", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Time getTime(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTime", string);
        }
        try {
            return this.cstmt.getTime(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTime", "1215", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTime", new Object[]{string, calendar});
        }
        try {
            return this.cstmt.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTime", "1224", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimestamp", new Integer(n));
        }
        try {
            return this.cstmt.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTimestamp", "1261", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimestamp", new Object[]{new Integer(n), calendar});
        }
        try {
            return this.cstmt.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTimestamp", "1288", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimestamp", string);
        }
        try {
            return this.cstmt.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTimestamp", "1297", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimestamp", new Object[]{string, calendar});
        }
        try {
            return this.cstmt.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getTimestamp", "1306", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public URL getURL(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getURL", new Integer(n));
        }
        try {
            return this.cstmt.getURL(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getURL", "1315", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public URL getURL(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getURL", string);
        }
        try {
            return this.cstmt.getURL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.getURL", "1324", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public boolean wasNull() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wasNull");
        }
        try {
            return this.cstmt.wasNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSRdbRecordImpl.wasNull", "1386", this);
            throw WSRdbUtil.mapException(this.rdbConn, sQLException);
        }
    }

    public final void setRecordName(String string) {
        this.ivRecordName = string;
    }

    public final String getRecordName() {
        return this.ivRecordName;
    }

    public final void setRecordShortDescription(String string) {
        this.ivRecordShortDescription = string;
    }

    public final String getRecordShortDescription() {
        return this.ivRecordShortDescription;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException(AdapterUtil.getNLSMessage("OBJECT_CANNOT_BE_CLONED", "com.ibm.websphere.rsadapter.WSRdbRecord"));
    }
}

