/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbResultSet;
import com.ibm.ws.rsadapter.cci.WSRdbUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ResultSet;

public class WSRdbResultSetImpl
implements WSRdbResultSet {
    private static final long serialVersionUID = 8656967234064114727L;
    private int ivNumParameters;
    private static final TraceComponent tc = Tr.register(WSRdbResultSetImpl.class, "RRA", "IBMDataStoreAdapterNLS");
    private String ivRecordName;
    private String ivRecordShortDescription;
    private java.sql.ResultSet ivResultSet;
    private Object ivsqljIterator;
    private Statement ivStatement;
    WSRdbConnectionImpl ivConn;
    StatementCacheKey ivStatementCacheKey;
    private J2CPerf ivPMI;
    private boolean isStatementCallable = false;

    public WSRdbResultSetImpl(java.sql.ResultSet resultSet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", AdapterUtil.toString(resultSet));
        }
        this.ivResultSet = resultSet;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", AdapterUtil.toString(this));
        }
    }

    public WSRdbResultSetImpl(java.sql.ResultSet resultSet, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(resultSet), AdapterUtil.toString(object)});
        }
        this.ivResultSet = resultSet;
        this.ivsqljIterator = object;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", AdapterUtil.toString(this));
        }
    }

    public WSRdbResultSetImpl(java.sql.ResultSet resultSet, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(resultSet), new Boolean(bl)});
        }
        this.ivResultSet = resultSet;
        this.isStatementCallable = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", AdapterUtil.toString(this));
        }
    }

    void setStatementCallable(boolean bl) {
        this.isStatementCallable = bl;
    }

    public final void initialize(WSRdbConnectionImpl wSRdbConnectionImpl) {
        this.ivConn = wSRdbConnectionImpl;
        if (!this.isStatementCallable) {
            this.ivStatementCacheKey = this.ivConn.statementCacheKey;
            this.ivStatement = this.ivConn.stmtImpl;
            this.ivConn.addResultSet(this);
        }
        this.ivPMI = this.ivConn.pmi;
    }

    final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        if (this.ivResultSet == null) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "ResultSet"));
        }
        return runtimeException;
    }

    public final void addResultSet(java.sql.ResultSet resultSet) throws ResourceException {
        throw new NotSupportedException("Method not allowed, this is not a Composite ResultSet");
    }

    String internalToString() {
        return AdapterUtil.toString(this) + AdapterUtil.EOLN + "  RecordName=" + this.ivRecordName + ",  RecordShortDescription=" + this.ivRecordShortDescription + AdapterUtil.EOLN + "  ResultSet=" + this.ivResultSet + AdapterUtil.EOLN + "  Connection=" + this.ivConn;
    }

    public final void setRecordName(String string) {
        this.ivRecordName = string;
    }

    public final String getRecordName() {
        return this.ivRecordName;
    }

    public final void setRecordShortDescription(String string) {
        this.ivRecordShortDescription = string;
    }

    public final String getRecordShortDescription() {
        return this.ivRecordShortDescription;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException(AdapterUtil.getNLSMessage("OBJECT_CANNOT_BE_CLONED", "java.sql.ResultSet"));
    }

    public final boolean absolute(int n) throws SQLException {
        try {
            return this.ivResultSet.absolute(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".absolute", "1", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void afterLast() throws SQLException {
        try {
            this.ivResultSet.afterLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".afterLast", "2", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void beforeFirst() throws SQLException {
        try {
            this.ivResultSet.beforeFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".beforeFirst", "3", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelRowUpdates() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelRowUpdates", this);
            }
            try {
                if (this.ivPMI == null) {
                    this.ivResultSet.cancelRowUpdates();
                    break block8;
                }
                try {
                    this.ivPMI.jdbcOperationStarted();
                    this.ivResultSet.cancelRowUpdates();
                }
                finally {
                    this.ivPMI.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".cancelRowUpdates", "4", this);
                throw WSRdbUtil.mapException(this.ivConn, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public final void clearWarnings() throws SQLException {
        try {
            this.ivResultSet.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".clearWarnings", "5", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void close() throws SQLException {
        SQLException sQLException;
        block29: {
            block28: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "close", this);
                }
                if (this.ivResultSet == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Already Closed.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "close");
                    }
                    return;
                }
                sQLException = null;
                if (!this.isStatementCallable && this.ivConn != null) {
                    this.ivConn.removeResultSet(this);
                }
                try {
                    this.ivResultSet.close();
                }
                catch (SQLException sQLException2) {
                    FFDCFilter.processException((Throwable)sQLException2, "com.ibm.ws.rsadapter.cci.WSRdbResultSetImpl.close", "418", this);
                    if (sQLException != null) break block28;
                    sQLException = sQLException2;
                }
            }
            if (this.ivsqljIterator == null && !this.isStatementCallable && this.ivConn != null && this.ivStatementCacheKey != null && this.ivStatement != null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "ResultSet closed. Implicitly caching the parent Statement.");
                }
                try {
                    java.sql.ResultSet resultSet = null;
                    while (this.ivStatement.getMoreResults() | this.ivStatement.getUpdateCount() != -1) {
                        resultSet = this.ivStatement.getResultSet();
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                    this.ivConn.managedConn.cacheStatement(this.ivStatement, this.ivStatementCacheKey);
                }
                catch (SQLException sQLException3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Errors while caching. Statement cannot be cached.");
                    }
                    try {
                        this.ivStatement.close();
                    }
                    catch (SQLException sQLException4) {
                        FFDCFilter.processException((Throwable)sQLException4, "com.ibm.ws.rsadapter.cci.WSRdbResultSetImpl.close", "645", this);
                        Tr.warning(tc, "ERR_CLOSING_PARENT", new Object[]{AdapterUtil.toString(this.ivStatement), sQLException4});
                    }
                }
            } else {
                if (this.ivsqljIterator != null) {
                    try {
                        this.ivConn.mcf.getInternalDataStoreHelper().closeSQLjIterator(this.ivsqljIterator);
                        this.ivsqljIterator = null;
                    }
                    catch (SQLException sQLException5) {
                        FFDCFilter.processException((Throwable)sQLException5, "com.ibm.ws.rsadapter.cci.WSRdbResultSetImpl.close", "513", this);
                        if (sQLException == null) {
                            sQLException = sQLException5;
                        }
                        break block29;
                    }
                }
                if (!this.isStatementCallable) {
                    try {
                        if (this.ivStatement != null) {
                            this.ivStatement.close();
                        }
                    }
                    catch (SQLException sQLException6) {
                        FFDCFilter.processException((Throwable)sQLException6, "com.ibm.ws.rsadapter.cci.WSRdbResultSetImpl.close", "352", this);
                        Tr.warning(tc, "ERR_CLOSING_PARENT", new Object[]{AdapterUtil.toString(this.ivStatement), sQLException6});
                    }
                }
            }
        }
        this.ivResultSet = null;
        this.ivRecordName = null;
        this.ivRecordShortDescription = null;
        this.ivStatementCacheKey = null;
        this.ivConn = null;
        if (sQLException == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close", sQLException);
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleteRow", this);
            }
            try {
                if (this.ivPMI == null) {
                    this.ivResultSet.deleteRow();
                    break block8;
                }
                try {
                    this.ivPMI.jdbcOperationStarted();
                    this.ivResultSet.deleteRow();
                }
                finally {
                    this.ivPMI.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".deleteRow", "6", this);
                throw WSRdbUtil.mapException(this.ivConn, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public final int findColumn(String string) throws SQLException {
        try {
            return this.ivResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".findColumn", "7", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean first() throws SQLException {
        try {
            return this.ivResultSet.first();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".first", "8", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Array getArray(int n) throws SQLException {
        try {
            return this.ivResultSet.getArray(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getArray", "9", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Array getArray(String string) throws SQLException {
        try {
            return this.ivResultSet.getArray(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getArray", "10", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final InputStream getAsciiStream(int n) throws SQLException {
        try {
            return this.ivResultSet.getAsciiStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getAsciiStream", "11", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final InputStream getAsciiStream(String string) throws SQLException {
        try {
            return this.ivResultSet.getAsciiStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getAsciiStream", "12", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return this.ivResultSet.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBigDecimal", "13", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return this.ivResultSet.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBigDecimal", "14", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this.ivResultSet.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBigDecimal", "15", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            return this.ivResultSet.getBigDecimal(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBigDecimal", "126", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final InputStream getBinaryStream(int n) throws SQLException {
        try {
            return this.ivResultSet.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBinaryStream", "16", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final InputStream getBinaryStream(String string) throws SQLException {
        try {
            return this.ivResultSet.getBinaryStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBinaryStream", "17", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Blob getBlob(int n) throws SQLException {
        try {
            return this.ivResultSet.getBlob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBinaryStream", "18", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean getBoolean(int n) throws SQLException {
        try {
            return this.ivResultSet.getBoolean(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBoolean", "19", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean getBoolean(String string) throws SQLException {
        try {
            return this.ivResultSet.getBoolean(string);
        }
        catch (SQLException sQLException) {
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final byte getByte(int n) throws SQLException {
        try {
            return this.ivResultSet.getByte(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getByte", "20", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final byte getByte(String string) throws SQLException {
        try {
            return this.ivResultSet.getByte(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getByte", "21", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final byte[] getBytes(int n) throws SQLException {
        try {
            return this.ivResultSet.getBytes(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBytes", "22", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final byte[] getBytes(String string) throws SQLException {
        try {
            return this.ivResultSet.getBytes(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBytes", "23", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Blob getBlob(String string) throws SQLException {
        try {
            return this.ivResultSet.getBlob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getBlob", "24", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Reader getCharacterStream(int n) throws SQLException {
        try {
            return this.ivResultSet.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getCharacterStream", "25", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Reader getCharacterStream(String string) throws SQLException {
        try {
            return this.ivResultSet.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getCharacterStream", "26", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Clob getClob(int n) throws SQLException {
        try {
            return this.ivResultSet.getClob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getClob", "27", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Clob getClob(String string) throws SQLException {
        try {
            return this.ivResultSet.getClob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getClob", "28", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getConcurrency() throws SQLException {
        try {
            return this.ivResultSet.getConcurrency();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getConcurrency", "29", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final String getCursorName() throws SQLException {
        try {
            return this.ivResultSet.getCursorName();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getCursorName", "30", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Date getDate(int n) throws SQLException {
        try {
            return this.ivResultSet.getDate(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getDate", "31", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this.ivResultSet.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getDate", "32", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Date getDate(String string) throws SQLException {
        try {
            return this.ivResultSet.getDate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getDate", "33", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this.ivResultSet.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getDate", "34", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final double getDouble(int n) throws SQLException {
        try {
            return this.ivResultSet.getDouble(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getDouble", "35", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final double getDouble(String string) throws SQLException {
        try {
            return this.ivResultSet.getDouble(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getDouble", "36", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getFetchDirection() throws SQLException {
        try {
            return this.ivResultSet.getFetchDirection();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getFetchDirection", "37", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getFetchSize() throws SQLException {
        try {
            return this.ivResultSet.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getFetchSize", "38", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final float getFloat(int n) throws SQLException {
        try {
            return this.ivResultSet.getFloat(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getFloat", "39", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final float getFloat(String string) throws SQLException {
        try {
            return this.ivResultSet.getFloat(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getFloat", "40", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getInt(int n) throws SQLException {
        try {
            return this.ivResultSet.getInt(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getInt", "41", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getInt(String string) throws SQLException {
        try {
            return this.ivResultSet.getInt(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getInt", "42", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final long getLong(int n) throws SQLException {
        try {
            return this.ivResultSet.getLong(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getLong", "43", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final long getLong(String string) throws SQLException {
        try {
            return this.ivResultSet.getLong(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getLong", "44", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.ivResultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getMetaData", "45", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Object getObject(int n) throws SQLException {
        try {
            return this.ivResultSet.getObject(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getObject", "46", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Object getObject(int n, Map map) throws SQLException {
        try {
            return this.ivResultSet.getObject(n, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getObject", "47", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Object getObject(String string) throws SQLException {
        try {
            return this.ivResultSet.getObject(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getObject", "48", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Object getObject(String string, Map map) throws SQLException {
        try {
            return this.ivResultSet.getObject(string, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getObject", "49", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Ref getRef(int n) throws SQLException {
        try {
            return this.ivResultSet.getRef(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getRef", "50", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Ref getRef(String string) throws SQLException {
        try {
            return this.ivResultSet.getRef(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getRef", "51", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getRow() throws SQLException {
        try {
            return this.ivResultSet.getRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getRow", "52", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final short getShort(int n) throws SQLException {
        try {
            return this.ivResultSet.getShort(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getShort", "53", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final short getShort(String string) throws SQLException {
        try {
            return this.ivResultSet.getShort(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getShort", "54", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Statement getStatement() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getStatement", ResultSet.class.getName()}));
    }

    public final String getString(int n) throws SQLException {
        try {
            return this.ivResultSet.getString(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getString", "55", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final String getString(String string) throws SQLException {
        try {
            return this.ivResultSet.getString(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getString", "56", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Time getTime(int n) throws SQLException {
        try {
            return this.ivResultSet.getTime(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getTime", "57", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this.ivResultSet.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getTime", "58", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Time getTime(String string) throws SQLException {
        try {
            return this.ivResultSet.getTime(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getTime", "59", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this.ivResultSet.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getTime", "60", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this.ivResultSet.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getTimestamp", "61", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this.ivResultSet.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getTimestamp", "62", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this.ivResultSet.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getTimestamp", "63", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this.ivResultSet.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getTimestamp", "64", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getType() throws SQLException {
        try {
            return this.ivResultSet.getType();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getType", "65", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final InputStream getUnicodeStream(int n) throws SQLException {
        try {
            return this.ivResultSet.getUnicodeStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getUnicodeStream", "66", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final InputStream getUnicodeStream(String string) throws SQLException {
        try {
            return this.ivResultSet.getUnicodeStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getUnicodeStream", "67", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        try {
            return this.ivResultSet.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getWarnings", "68", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "insertRow", this);
            }
            try {
                if (this.ivPMI == null) {
                    this.ivResultSet.insertRow();
                    break block8;
                }
                try {
                    this.ivPMI.jdbcOperationStarted();
                    this.ivResultSet.insertRow();
                }
                finally {
                    this.ivPMI.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".insertRow", "69", this);
                throw WSRdbUtil.mapException(this.ivConn, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public final boolean isAfterLast() throws SQLException {
        try {
            return this.ivResultSet.isAfterLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".isAfterLast", "70", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean isBeforeFirst() throws SQLException {
        try {
            return this.ivResultSet.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".isBeforeFirst", "71", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean isClosed() {
        return this.ivResultSet == null;
    }

    public final boolean isFirst() throws SQLException {
        try {
            return this.ivResultSet.isFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".isFirst", "72", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean isLast() throws SQLException {
        try {
            return this.ivResultSet.isLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".isLast", "73", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean last() throws SQLException {
        try {
            return this.ivResultSet.last();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".last", "74", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void moveToCurrentRow() throws SQLException {
        try {
            this.ivResultSet.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".moveToCurrentRow", "75", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void moveToInsertRow() throws SQLException {
        try {
            this.ivResultSet.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".moveToInsertRow", "76", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean next() throws SQLException {
        try {
            return this.ivResultSet.next();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".next", "77", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean previous() throws SQLException {
        try {
            return this.ivResultSet.previous();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".previous", "78", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final WSRdbResultSetImpl recycle(java.sql.ResultSet resultSet) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "recycle", new Object[]{this, AdapterUtil.toString(resultSet)});
        }
        this.ivResultSet = resultSet;
        return this;
    }

    public final WSRdbResultSetImpl recycle(java.sql.ResultSet resultSet, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "recycle", new Object[]{this, AdapterUtil.toString(resultSet), AdapterUtil.toString(object)});
        }
        this.ivResultSet = resultSet;
        this.ivsqljIterator = object;
        return this;
    }

    public final WSRdbResultSetImpl recycle(java.sql.ResultSet resultSet, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "recycle", new Object[]{this, AdapterUtil.toString(resultSet), new Boolean(bl)});
        }
        this.ivResultSet = resultSet;
        this.isStatementCallable = bl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "refreshRow", this);
            }
            try {
                if (this.ivPMI == null) {
                    this.ivResultSet.refreshRow();
                    break block8;
                }
                try {
                    this.ivPMI.jdbcOperationStarted();
                    this.ivResultSet.refreshRow();
                }
                finally {
                    this.ivPMI.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".refreshRow", "79", this);
                throw WSRdbUtil.mapException(this.ivConn, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public final boolean relative(int n) throws SQLException {
        try {
            return this.ivResultSet.relative(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".relative", "80", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean rowDeleted() throws SQLException {
        try {
            return this.ivResultSet.rowDeleted();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".rowDeleted", "81", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean rowInserted() throws SQLException {
        try {
            return this.ivResultSet.rowInserted();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".rowInserted", "82", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean rowUpdated() throws SQLException {
        try {
            return this.ivResultSet.rowUpdated();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".rowUpdated", "83", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setFetchDirection(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFetchDirection", new Object[]{this, new Integer(n)});
        }
        try {
            this.ivResultSet.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".setFetchDirection", "84", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setFetchSize(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFetchSize", new Object[]{this, new Integer(n)});
        }
        try {
            this.ivResultSet.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".setFetchSize", "85", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.ivResultSet.updateAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateAsciiStream", "86", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.ivResultSet.updateAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateAsciiStream", "87", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.ivResultSet.updateBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBigDecimal", "88", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            this.ivResultSet.updateBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBigDecimal", "89", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.ivResultSet.updateBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBinaryStream", "90", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.ivResultSet.updateBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBinaryStream", "91", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            this.ivResultSet.updateBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBoolean", "92", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            this.ivResultSet.updateBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBoolean", "93", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateByte(int n, byte by) throws SQLException {
        try {
            this.ivResultSet.updateByte(n, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateByte", "94", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateByte(String string, byte by) throws SQLException {
        try {
            this.ivResultSet.updateByte(string, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateByte", "95", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.ivResultSet.updateBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBytes", "96", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            this.ivResultSet.updateBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBytes", "97", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.ivResultSet.updateCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateCharacterStream", "98", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        try {
            this.ivResultSet.updateCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateCharacterStream", "99", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateDate(int n, Date date) throws SQLException {
        try {
            this.ivResultSet.updateDate(n, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateDate", "100", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateDate(String string, Date date) throws SQLException {
        try {
            this.ivResultSet.updateDate(string, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateDate", "101", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateDouble(int n, double d) throws SQLException {
        try {
            this.ivResultSet.updateDouble(n, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateDouble", "102", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateDouble(String string, double d) throws SQLException {
        try {
            this.ivResultSet.updateDouble(string, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateDouble", "103", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateFloat(int n, float f) throws SQLException {
        try {
            this.ivResultSet.updateFloat(n, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateFloat", "104", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateFloat(String string, float f) throws SQLException {
        try {
            this.ivResultSet.updateFloat(string, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateFloat", "105", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateInt(int n, int n2) throws SQLException {
        try {
            this.ivResultSet.updateInt(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateInt", "106", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateInt(String string, int n) throws SQLException {
        try {
            this.ivResultSet.updateInt(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateInt", "107", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateLong(int n, long l) throws SQLException {
        try {
            this.ivResultSet.updateLong(n, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateLong", "108", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateLong(String string, long l) throws SQLException {
        try {
            this.ivResultSet.updateLong(string, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateLong", "109", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateNull(int n) throws SQLException {
        try {
            this.ivResultSet.updateNull(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateNull", "110", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateNull(String string) throws SQLException {
        try {
            this.ivResultSet.updateNull(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateNull", "111", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateObject(int n, Object object) throws SQLException {
        try {
            this.ivResultSet.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateObject", "112", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            this.ivResultSet.updateObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateObject", "113", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateObject(String string, Object object) throws SQLException {
        try {
            this.ivResultSet.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateObject", "114", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateObject(String string, Object object, int n) throws SQLException {
        try {
            this.ivResultSet.updateObject(string, object, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateObject", "115", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateRow", this);
            }
            try {
                if (this.ivPMI == null) {
                    this.ivResultSet.updateRow();
                    break block8;
                }
                try {
                    this.ivPMI.jdbcOperationStarted();
                    this.ivResultSet.updateRow();
                }
                finally {
                    this.ivPMI.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".UpdateRow", "116", this);
                throw WSRdbUtil.mapException(this.ivConn, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public final void updateShort(int n, short s) throws SQLException {
        try {
            this.ivResultSet.updateShort(n, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateShort", "117", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateShort(String string, short s) throws SQLException {
        try {
            this.ivResultSet.updateShort(string, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateShort", "118", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateString(int n, String string) throws SQLException {
        try {
            this.ivResultSet.updateString(n, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateString", "119", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateString(String string, String string2) throws SQLException {
        try {
            this.ivResultSet.updateString(string, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateString", "120", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateTime(int n, Time time) throws SQLException {
        try {
            this.ivResultSet.updateTime(n, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateTime", "121", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateTime(String string, Time time) throws SQLException {
        try {
            this.ivResultSet.updateTime(string, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateTime", "122", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.ivResultSet.updateTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateTimestamp", "123", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            this.ivResultSet.updateTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateTimestamp", "124", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean wasNull() throws SQLException {
        try {
            return this.ivResultSet.wasNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".wasNull", "125", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(int n) throws SQLException {
        try {
            return this.ivResultSet.getURL(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getURL", "4565", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            return this.ivResultSet.getURL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getURL", "4594", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        try {
            this.ivResultSet.updateArray(n, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateArray", "4622", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateArray(String string, Array array) throws SQLException {
        try {
            this.ivResultSet.updateArray(string, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateArray", "4651", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            this.ivResultSet.updateBlob(n, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBlob", "4679", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            this.ivResultSet.updateBlob(string, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateBlob", "4706", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            this.ivResultSet.updateClob(n, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateClob", "4733", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            this.ivResultSet.updateClob(string, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateClob", "4761", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        try {
            this.ivResultSet.updateRef(n, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateRef", "4789", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            this.ivResultSet.updateRef(string, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".updateRef", "4816", this);
            throw WSRdbUtil.mapException(this.ivConn, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }
}

