/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import java.sql.SQLException;

public class WSRdbUtil {
    private static final TraceComponent tc = Tr.register(WSRdbUtil.class, "RRA", "IBMDataStoreAdapterNLS");

    static final DataStoreAdapterException mapException(WSRdbConnectionImpl wSRdbConnectionImpl, DataStoreAdapterException dataStoreAdapterException) {
        dataStoreAdapterException = wSRdbConnectionImpl.mcf.getInternalDataStoreHelper().mapException(dataStoreAdapterException);
        Exception exception = (Exception)dataStoreAdapterException.getCause();
        if (exception instanceof StaleStatementException) {
            dataStoreAdapterException.setLinkedException(wSRdbConnectionImpl.handleStaleStatement((SQLException)exception));
        } else if (dataStoreAdapterException.isConnectionError()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Encountered a Stale Connection: ", wSRdbConnectionImpl);
            }
            wSRdbConnectionImpl.fireConnectionErrorEvent((Exception)((Object)dataStoreAdapterException));
        }
        return dataStoreAdapterException;
    }

    static final SQLException mapException(WSRdbConnectionImpl wSRdbConnectionImpl, SQLException sQLException) {
        return (SQLException)AdapterUtil.mapException(sQLException, wSRdbConnectionImpl, wSRdbConnectionImpl.managedConn, true);
    }

    static final DataStoreAdapterException mapToResourceException(WSRdbConnectionImpl wSRdbConnectionImpl, SQLException sQLException) {
        return WSRdbUtil.mapException(wSRdbConnectionImpl, AdapterUtil.createDataStoreAdapterException("DSA_ERROR", sQLException, sQLException, wSRdbConnectionImpl.getClass()));
    }
}

