/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.cci.WSInteractionImpl;
import com.ibm.ws.rsadapter.cci.WSInteractionSpecImpl;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionFactoryImpl;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionSpecImpl;
import com.ibm.ws.rsadapter.cci.WSRecordFactoryImpl;
import com.ibm.ws.rsadapter.jdbc.WSProxyDSHelper;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.wsspi.ejbpersistence.WSEJBToRAAdapter;
import com.ibm.wsspi.rsadapter.NoDataSourceJNDINameException;
import com.ibm.wsspi.rsadapter.WSProxyDSJNDINameAccessor;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;

public final class WSRelationalRAAdapter
extends WSEJBToRAAdapter {
    private static final TraceComponent tc = Tr.register(WSRelationalRAAdapter.class, "RRA", "IBMDataStoreAdapterNLS");
    private static WSRelationalRAAdapter singleton;
    private static WSRecordFactoryImpl recFactory;
    private boolean hasConnectionBeenCalled = false;
    public static WSThreadLocal EJB_DEPLOY_PROPS;

    public boolean checkBackendId(ConnectionFactory connectionFactory, String string) throws ResourceException {
        CharSequence charSequence;
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "checkBackendId", new Object[]{this, connectionFactory, string});
        }
        WSRdbConnectionFactoryImpl wSRdbConnectionFactoryImpl = (WSRdbConnectionFactoryImpl)connectionFactory;
        InternalDataStoreHelper internalDataStoreHelper = wSRdbConnectionFactoryImpl.internalHelper;
        if (wSRdbConnectionFactoryImpl.mcf.isBackEndIdCheckingDisabled()) {
            Tr.info(tc, "BACKEND_ID_CHECK_DISABLED");
            return true;
        }
        int n = string.indexOf("_");
        if (n > 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("(").append(string.substring(0, n)).append(")");
            string = ((StringBuffer)charSequence).toString();
        }
        if (bl) {
            Tr.debug(tc, "checkBackendId", "backendId is transformed to " + string);
        }
        if (!this.hasConnectionBeenCalled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "checkBackendId is called, and ready to get a connection...");
            }
            charSequence = null;
            charSequence = wSRdbConnectionFactoryImpl.getDSHelperType() == 20 ? this.switchConnectionFactory(wSRdbConnectionFactoryImpl).getConnection() : wSRdbConnectionFactoryImpl.getConnection();
            charSequence.close();
            this.hasConnectionBeenCalled = true;
        }
        CharSequence charSequence2 = charSequence = internalDataStoreHelper.getDatabaseProductName();
        String string2 = null;
        if (charSequence != null) {
            if (((String)charSequence).startsWith("DB2/")) {
                charSequence2 = "DB2/";
            } else if (((String)charSequence).startsWith("DSN")) {
                charSequence2 = "DSN";
            }
            string2 = DSConfigurationHelper.getBackendIDFromDatabaseProductName((String)charSequence2);
        }
        if (string2 == null) {
            if (DSConfigurationHelper.backendRequiresStrictMatch(string)) {
                if (bl) {
                    Tr.debug(tc, "checkBackendId", "The database product name " + (String)charSequence + " is an unsupported database. It doesn't match the backendId " + string);
                }
                return false;
            }
            Tr.info(tc, "BACKEND_ID_NOT_MATCH", new Object[]{charSequence, string});
            return true;
        }
        if (string2.indexOf(string) != -1) {
            if (bl) {
                Tr.debug(tc, "checkBackendId", "The database product name " + (String)charSequence + " strictly matches the backendId " + string);
            }
            return true;
        }
        if (DSConfigurationHelper.backendRequiresStrictMatch(string) || DSConfigurationHelper.backendRequiresStrictMatch(string2)) {
            if (bl) {
                Tr.debug(tc, "checkBackendId", "The database product name " + (String)charSequence + " does not match the backendId " + string);
            }
            return false;
        }
        Tr.info(tc, "BACKEND_ID_NOT_MATCH", new Object[]{charSequence, string});
        return true;
    }

    public static final WSRelationalRAAdapter createAdapter() {
        return new WSRelationalRAAdapter();
    }

    public Interaction createInteraction(Connection connection, AccessIntent accessIntent, HashMap hashMap) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && this.getTracer().isDebugEnabled()) {
            Tr.debug(this.getTracer(), "createInteraction(cciConnection, intent)", new Object[]{connection, accessIntent});
        }
        Interaction interaction = connection.createInteraction();
        ((WSInteractionImpl)interaction).acIntent = accessIntent;
        if (TraceComponent.isAnyTracingEnabled() && this.getTracer().isDebugEnabled()) {
            Tr.debug(this.getTracer(), "createInteraction(cciConnection)", interaction);
        }
        return interaction;
    }

    public Record executeCreate(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord indexedRecord) throws CreateException, ResourceException {
        Record record;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCreate(Interaction, InteractionSpec, inputRecord)", new Object[]{interaction, interactionSpec, indexedRecord});
        }
        try {
            record = interaction.execute(interactionSpec, (Record)indexedRecord);
            recFactory.returnIndexedRecord(indexedRecord);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSRelationalRAAdapter.executeCreate", "185", this);
            if (resourceException.getCause() != null && resourceException.getCause() instanceof com.ibm.websphere.ce.cm.DuplicateKeyException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "executeCreate(Interaction, InteractionSpec, inputRecord)", "received ResourceException, throwing javax.ejb.DuplicateKeyException");
                }
                throw new DuplicateKeyException();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "executeCreate(Interaction, InteractionSpec, inputRecord)", "re-throwing ResourceExeption from interaction.execute()");
            }
            throw resourceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCreate(Interaction, InteractionSpec, inputRecord)", record);
        }
        return record;
    }

    public final Record executeFinder(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord indexedRecord) throws FinderException, ResourceException {
        Record record = super.executeFinder(interaction, interactionSpec, indexedRecord);
        recFactory.returnIndexedRecord(indexedRecord);
        return record;
    }

    public boolean[] executeReadReadChecking(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord[] indexedRecordArray) throws EJBException, ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "executeReadReadChecking(Interaction, InteractionSpec, inputRecord)", new Object[]{interaction, interactionSpec, indexedRecordArray});
        }
        boolean[] blArray = ((WSInteractionImpl)interaction).executeBatchRead(interactionSpec, indexedRecordArray);
        recFactory.returnIndexedRecord(indexedRecordArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "executeReadReadChecking(Interaction, InteractionSpec, inputRecord)", blArray);
        }
        return blArray;
    }

    public Record executeRemove(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord indexedRecord, IndexedRecord indexedRecord2) throws RemoveException, ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "executeRemove(Interaction, InteractionSpec, inputRecord, predicates)", new Object[]{interaction, interactionSpec, indexedRecord, indexedRecord2});
        }
        WSInteractionSpecImpl wSInteractionSpecImpl = (WSInteractionSpecImpl)interactionSpec;
        wSInteractionSpecImpl.setOldRecord(indexedRecord2);
        Record record = interaction.execute((InteractionSpec)wSInteractionSpecImpl, (Record)indexedRecord);
        recFactory.returnIndexedRecord(indexedRecord);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "executeRemove(Interaction, InteractionSpec, inputRecord, predicates)", record);
        }
        return record;
    }

    public Record executeUpdate(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord indexedRecord, IndexedRecord indexedRecord2, boolean[] blArray, String string) throws EJBException, ResourceException {
        WSInteractionImpl wSInteractionImpl = (WSInteractionImpl)interaction;
        wSInteractionImpl.ivPredicates = indexedRecord2;
        wSInteractionImpl.ivChangeFieldsIndexes = blArray;
        Record record = interaction.execute(interactionSpec, (Record)indexedRecord);
        recFactory.returnIndexedRecord(indexedRecord2 == null ? indexedRecord : indexedRecord2);
        return record;
    }

    public final Record executeOther(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord indexedRecord) throws ResourceException {
        Record record = super.executeOther(interaction, interactionSpec, indexedRecord);
        recFactory.returnIndexedRecord(indexedRecord);
        return record;
    }

    public Connection getConnection(ConnectionFactory connectionFactory, AccessIntent accessIntent) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnection(ConnectionFactory, AccessIntent)", new Object[]{connectionFactory, accessIntent});
        }
        WSRdbConnectionSpecImpl wSRdbConnectionSpecImpl = new WSRdbConnectionSpecImpl();
        wSRdbConnectionSpecImpl.ivAccessIntent = accessIntent;
        WSRdbConnectionFactoryImpl wSRdbConnectionFactoryImpl = (WSRdbConnectionFactoryImpl)connectionFactory;
        Connection connection = null;
        connection = wSRdbConnectionFactoryImpl.getDSHelperType() == 20 ? this.switchConnectionFactory(wSRdbConnectionFactoryImpl).getConnection((ConnectionSpec)wSRdbConnectionSpecImpl) : connectionFactory.getConnection((ConnectionSpec)wSRdbConnectionSpecImpl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnection(ConnectionFactory, AccessIntent)", connection);
        }
        return connection;
    }

    public final int getLockType(ConnectionFactory connectionFactory, AccessIntent accessIntent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLockType", new Object[]{connectionFactory, accessIntent});
        }
        DataStoreHelper dataStoreHelper = ((WSRdbConnectionFactoryImpl)connectionFactory).helper;
        int n = dataStoreHelper.getLockType(accessIntent);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLockType", AdapterUtil.getLockTypeAsString(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLockType(ConnectionFactory connectionFactory, AccessIntent accessIntent, HashMap hashMap) {
        int n;
        boolean bl = TraceComponent.isAnyTracingEnabled();
        if (bl && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLockType", new Object[]{connectionFactory, accessIntent, hashMap});
        }
        try {
            EJB_DEPLOY_PROPS.set(hashMap);
            n = this.getLockType(connectionFactory, accessIntent);
        }
        finally {
            EJB_DEPLOY_PROPS.set((Object)null);
        }
        if (bl && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLockType", AdapterUtil.getLockTypeAsString(n));
        }
        return n;
    }

    public final RecordFactory getRecordFactory(ConnectionFactory connectionFactory) throws ResourceException {
        return recFactory;
    }

    public Record executeCreate(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord[] indexedRecordArray) throws CreateException, ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCreateB(Interaction interaction, InteractionSpec ispec, IndexedRecord[] inputRecord) ", new Object[]{interaction, interactionSpec, indexedRecordArray});
        }
        ((WSInteractionImpl)interaction).executeBatch(interactionSpec, indexedRecordArray, null, null);
        recFactory.returnIndexedRecord(indexedRecordArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCreateB(Interaction interaction, InteractionSpec ispec, IndexedRecord[] inputRecord)");
        }
        return null;
    }

    public Record executeRemove(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord[] indexedRecordArray, IndexedRecord[] indexedRecordArray2) throws RemoveException, ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "executeRemoveB(Interaction, InteractionSpec, IndexedRecord[] inputRecord, IndexedRecord[] predicates)", new Object[]{interaction, interactionSpec, indexedRecordArray, indexedRecordArray2});
        }
        ((WSInteractionImpl)interaction).executeBatch(interactionSpec, indexedRecordArray, indexedRecordArray2, null);
        recFactory.returnIndexedRecord(indexedRecordArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "executeRemoveB(Interaction, InteractionSpec, IndexedRecord[] inputRecord, IndexedRecord[] predicates)");
        }
        return null;
    }

    public Record executeUpdate(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord[] indexedRecordArray, IndexedRecord[] indexedRecordArray2, boolean[][] blArray, String string) throws EJBException, ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "executeUpdateB(Interaction, InteractionSpec, IndexedRecord[] inputRecord, IndexedRecord[] predicates, boolean[][] dirtyBits, cursorName)", new Object[]{interaction, interactionSpec, indexedRecordArray, indexedRecordArray2, blArray, string});
        }
        ((WSInteractionImpl)interaction).executeBatch(interactionSpec, indexedRecordArray, indexedRecordArray2, blArray);
        recFactory.returnIndexedRecord(indexedRecordArray2 == null ? indexedRecordArray : indexedRecordArray2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "executeUpdateB(Interaction, InteractionSpec, inputRecord, predicates, dirtyBits)");
        }
        return null;
    }

    public Record executeOther(Interaction interaction, InteractionSpec interactionSpec, IndexedRecord[] indexedRecordArray) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "executeOtherB(Interaction, InteractionSpec, inputRecord[])", new Object[]{interaction, interactionSpec, indexedRecordArray});
        }
        ((WSInteractionImpl)interaction).executeBatch(interactionSpec, indexedRecordArray, null, null);
        recFactory.returnIndexedRecord(indexedRecordArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "executeOtherB(Interaction, InteractionSpec, inputRecord[])");
        }
        return null;
    }

    public boolean isBatchSupported(ConnectionFactory connectionFactory, AccessIntent accessIntent) {
        return ((WSRdbConnectionFactoryImpl)connectionFactory).helper.isBatchUpdateSupportedWithAccessIntent(accessIntent);
    }

    protected TraceComponent getTracer() {
        return tc;
    }

    private ConnectionFactory switchConnectionFactory(WSRdbConnectionFactoryImpl wSRdbConnectionFactoryImpl) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "switchConnectionFactory", new Object[]{this, wSRdbConnectionFactoryImpl});
        }
        String string = wSRdbConnectionFactoryImpl.getJndiName();
        String string2 = null;
        try {
            string2 = WSProxyDSJNDINameAccessor.getCurrentDataSourceJndiName(string);
            if (!wSRdbConnectionFactoryImpl.proxyDataSource.isJndiNameFound(string2)) {
                String string3 = AdapterUtil.getNLSMessage("DELEGATE_JNDI_NAME_NOT_FOUND", new Object[]{string2, string});
                Tr.error(tc, string3);
                throw new ResourceException(string3);
            }
        }
        catch (NoDataSourceJNDINameException noDataSourceJNDINameException) {
            FFDCFilter.processException((Throwable)noDataSourceJNDINameException, this.getClass().getName() + ".switchConnectionFactory", "893", this);
            ResourceException resourceException = new ResourceException();
            resourceException.initCause((Throwable)noDataSourceJNDINameException);
            Tr.error(tc, noDataSourceJNDINameException.getMessage());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "switchConnectionFactory", "Exception " + (Object)((Object)resourceException));
            }
            throw resourceException;
        }
        WSRdbConnectionFactoryImpl wSRdbConnectionFactoryImpl2 = null;
        if (string2 != null && string2.trim().length() != 0) {
            wSRdbConnectionFactoryImpl2 = WSProxyDSHelper.getConnectionFactory(string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "switchConnectionFactory", wSRdbConnectionFactoryImpl2);
        }
        return wSRdbConnectionFactoryImpl2;
    }

    static {
        recFactory = WSRecordFactoryImpl.createRecordFactory();
        EJB_DEPLOY_PROPS = new WSThreadLocal();
    }
}

