/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.cci;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSRdbCallableStatement;
import com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl;
import com.ibm.ws.rsadapter.cci.WSRdbPreparedStatement;
import com.ibm.ws.rsadapter.cci.WSRdbRecordImpl;
import com.ibm.ws.rsadapter.cci.WSRdbResultSetImpl;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Record;

public class WSResourceAdapterBase {
    private static final TraceComponent tc = Tr.register(WSResourceAdapterBase.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final Class currClass = WSResourceAdapterBase.class;
    private static final TraceComponent clientInfoTc = Tr.register("WAS.clientinfopluslogging", "WAS.clientinfopluslogging", "IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;
    private static final String[] PMI_PSTMT_EXECUTE_QUERY;
    private static final String[] PMI_PSTMT_EXECUTE_UPDATE;
    static boolean _supportsBatchRead;

    public Record createCCIRecord(Object object, Object object2) {
        if (object2 == null) {
            block8: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ReadRead case, will return null");
                }
                try {
                    this.returnPreparedStatement(object, null);
                }
                catch (SQLException sQLException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "return, preparedStatement threw the following sqlException", sQLException);
                }
            }
            return null;
        }
        try {
            WSRdbConnectionImpl wSRdbConnectionImpl = (WSRdbConnectionImpl)object;
            WSRdbResultSetImpl wSRdbResultSetImpl = new WSRdbResultSetImpl((ResultSet)object2);
            wSRdbResultSetImpl.initialize(wSRdbConnectionImpl);
            return wSRdbResultSetImpl;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof WSRdbConnectionImpl) {
                FFDCFilter.processException((Throwable)classCastException, this.getClass().getName() + ".createCCIRecord", "68", this);
                throw classCastException;
            }
            if (object2 instanceof Record) {
                return (Record)object2;
            }
            return new WSRdbResultSetImpl((ResultSet)object2, null);
        }
    }

    public Record createCCIRecord(Object object, CallableStatement callableStatement) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createCCIRecord", new Object[]{AdapterUtil.toString(object), AdapterUtil.toString(callableStatement)});
        }
        WSRdbConnectionImpl wSRdbConnectionImpl = null;
        if (object == null) {
            throw new DataStoreAdapterException("NO_NULL_CONNECTION", "The passed-in Connection object cannot be set to null", currClass);
        }
        if (callableStatement == null) {
            throw new DataStoreAdapterException("NO_NULL_STATEMENT", "The passed-in Statement object cannot be set to null", currClass);
        }
        try {
            wSRdbConnectionImpl = (WSRdbConnectionImpl)object;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.rsadapter.cci.WSResourceAdapterBase.createCCIRecord", "189", this);
            throw new DataStoreAdapterException("CAST_EXCEPTION", new Object[]{object.getClass().getName(), "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl"}, classCastException, classCastException.getMessage(), currClass);
        }
        WSRdbRecordImpl wSRdbRecordImpl = null;
        try {
            WSRdbCallableStatement wSRdbCallableStatement = (WSRdbCallableStatement)callableStatement;
            StatementCacheKey statementCacheKey = wSRdbCallableStatement.statementCacheKey;
            CallableStatement callableStatement2 = wSRdbCallableStatement.cstmt;
            wSRdbRecordImpl = new WSRdbRecordImpl(callableStatement2, wSRdbConnectionImpl, statementCacheKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createCCIRecord", wSRdbRecordImpl);
            }
            return wSRdbRecordImpl;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.rsadapter.cci.WSResourceAdapterBase.createCCIRecord", "199", this);
            throw new DataStoreAdapterException("CAST_EXCEPTION", new Object[]{callableStatement.getClass().getName(), "com.ibm.ws.rsadapter.cci.WSRdbCallableStatement"}, classCastException, classCastException.getMessage(), currClass);
        }
    }

    public final ResultSet executeQuery(Object object, PreparedStatement preparedStatement) throws SQLException {
        return this.executeQuery(object, preparedStatement, null);
    }

    public final ResultSet executeQuery(Object object, PreparedStatement preparedStatement, String string) throws SQLException {
        ResultSet resultSet;
        WSRdbConnectionImpl wSRdbConnectionImpl;
        TraceComponent traceComponent;
        block8: {
            TraceComponent traceComponent2 = traceComponent = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            if (TraceComponent.isAnyTracingEnabled() && traceComponent.isEntryEnabled()) {
                Tr.entry(traceComponent, "executeQuery", new Object[]{object, AdapterUtil.toString(preparedStatement), string});
            }
            wSRdbConnectionImpl = (WSRdbConnectionImpl)object;
            J2EEName j2EEName = null;
            boolean bl = false;
            try {
                WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl = wSRdbConnectionImpl.managedConn.getManagedConnectionFactory();
                if (wSManagedConnectionFactoryImpl != null && wSManagedConnectionFactoryImpl.isEndToEndMonitoringFeatureEnabled()) {
                    bl = wSManagedConnectionFactoryImpl.shouldDataBeCollectedAndPshedDownToCMX();
                    j2EEName = wSRdbConnectionImpl.managedConn.getJ2EEName();
                    AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbConnectionImpl.managedConn.getManagedConnectionFactory().appServerName, wSRdbConnectionImpl.managedConn.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(0, j2EEName, null, this, null, null, null) : null, preparedStatement);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
            }
        }
        try {
            resultSet = wSRdbConnectionImpl.metrics.isInteractionMetricsEnabled() || wSRdbConnectionImpl.pmi != null ? this.pmiExecuteQuery(wSRdbConnectionImpl, preparedStatement, string) : preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".executeQuery", "390", this);
            if (TraceComponent.isAnyTracingEnabled() && traceComponent.isEntryEnabled()) {
                Tr.exit(traceComponent, "executeQuery", sQLException);
            }
            throw sQLException;
        }
        if (TraceComponent.isAnyTracingEnabled() && traceComponent.isEntryEnabled()) {
            Tr.exit(traceComponent, "executeQuery", AdapterUtil.toString(resultSet));
        }
        return resultSet;
    }

    public final int executeUpdate(Object object, PreparedStatement preparedStatement) throws SQLException {
        return this.executeUpdate(object, preparedStatement, null);
    }

    public int executeUpdate(Object object, PreparedStatement preparedStatement, String string) throws SQLException {
        int n;
        WSRdbConnectionImpl wSRdbConnectionImpl;
        TraceComponent traceComponent;
        block8: {
            TraceComponent traceComponent2 = traceComponent = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            if (TraceComponent.isAnyTracingEnabled() && traceComponent.isEntryEnabled()) {
                Tr.entry(traceComponent, "executeUpdate", new Object[]{object, AdapterUtil.toString(preparedStatement), string});
            }
            wSRdbConnectionImpl = (WSRdbConnectionImpl)object;
            J2EEName j2EEName = null;
            boolean bl = false;
            try {
                WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl = wSRdbConnectionImpl.managedConn.getManagedConnectionFactory();
                if (wSManagedConnectionFactoryImpl != null && wSManagedConnectionFactoryImpl.isEndToEndMonitoringFeatureEnabled()) {
                    bl = wSManagedConnectionFactoryImpl.shouldDataBeCollectedAndPshedDownToCMX();
                    j2EEName = wSRdbConnectionImpl.managedConn.getJ2EEName();
                    AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbConnectionImpl.managedConn.getManagedConnectionFactory().appServerName, wSRdbConnectionImpl.managedConn.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(0, j2EEName, null, this, null, null, null) : null, preparedStatement);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
            }
        }
        try {
            n = wSRdbConnectionImpl.metrics.isInteractionMetricsEnabled() || wSRdbConnectionImpl.pmi != null ? this.pmiExecuteUpdate(wSRdbConnectionImpl, preparedStatement, string) : preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".executeUpdate", "452", this);
            if (TraceComponent.isAnyTracingEnabled() && traceComponent.isEntryEnabled()) {
                Tr.exit(traceComponent, "executeUpdate", sQLException);
            }
            throw sQLException;
        }
        if (TraceComponent.isAnyTracingEnabled() && traceComponent.isEntryEnabled()) {
            Tr.exit(traceComponent, "executeUpdate", n + " rows updated.");
        }
        return n;
    }

    private ResultSet pmiExecuteQuery(WSRdbConnectionImpl wSRdbConnectionImpl, PreparedStatement preparedStatement, String string) throws SQLException {
        ResultSet resultSet = null;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (wSRdbConnectionImpl.metrics.isInteractionMetricsEnabled()) {
            object = wSRdbConnectionImpl.metrics.preInteraction(PMI_PSTMT_EXECUTE_QUERY);
        }
        if (wSRdbConnectionImpl.pmi != null) {
            wSRdbConnectionImpl.pmi.jdbcOperationStarted();
        }
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteQuery", "483", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteQuery", "490", this);
            exception = runtimeException;
            n = 2;
        }
        if (wSRdbConnectionImpl.pmi != null) {
            wSRdbConnectionImpl.pmi.jdbcOperationCompleted();
        }
        switch (wSRdbConnectionImpl.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", wSRdbConnectionImpl.mcf.getJndiName());
            }
            case 1: {
                wSRdbConnectionImpl.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return resultSet;
        }
        if (exception instanceof SQLException) {
            throw (SQLException)exception;
        }
        throw (RuntimeException)exception;
    }

    private int pmiExecuteUpdate(WSRdbConnectionImpl wSRdbConnectionImpl, PreparedStatement preparedStatement, String string) throws SQLException {
        int n = 0;
        Object object = null;
        int n2 = 0;
        Exception exception = null;
        Properties properties = null;
        if (wSRdbConnectionImpl.metrics.isInteractionMetricsEnabled()) {
            object = wSRdbConnectionImpl.metrics.preInteraction(PMI_PSTMT_EXECUTE_UPDATE);
        }
        if (wSRdbConnectionImpl.pmi != null) {
            wSRdbConnectionImpl.pmi.jdbcOperationStarted();
        }
        try {
            n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteUpdate", "561", this);
            exception = sQLException;
            n2 = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteUpdate", "568", this);
            exception = runtimeException;
            n2 = 2;
        }
        if (wSRdbConnectionImpl.pmi != null) {
            wSRdbConnectionImpl.pmi.jdbcOperationCompleted();
        }
        switch (wSRdbConnectionImpl.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", wSRdbConnectionImpl.mcf.getJndiName());
            }
            case 1: {
                wSRdbConnectionImpl.metrics.postInteraction(object, n2, properties);
            }
        }
        if (exception == null) {
            return n;
        }
        if (exception instanceof SQLException) {
            throw (SQLException)exception;
        }
        throw (RuntimeException)exception;
    }

    public CallableStatement prepareCall(Object object, String string) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prepareCall", new Object[]{AdapterUtil.toString(object), string});
        }
        return this.prepareCall(object, string, 1003, 1007);
    }

    public CallableStatement prepareCall(Object object, String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement;
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareCall", new Object[]{AdapterUtil.toString(object), string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            callableStatement = ((WSRdbConnectionImpl)object).getCallableStatement(string, n, n2);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.rsadapter.cci.WSResourceAdapterBase.prepareCall", "333", this);
            Tr.error(tc, "CAST_EXCEPTION", new Object[]{object.getClass().getName(), "com.ibm.ws.rsadapter.cci.WSRdbConnectionImpl"});
            throw classCastException;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSResourceAdapterBase.prepareCall", "274", this);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareCall", sQLException);
            }
            throw sQLException;
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareCall", AdapterUtil.toString(callableStatement));
        }
        return callableStatement;
    }

    public PreparedStatement prepareStatement(Object object, String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareStatement(Object connection, String stmt)", new Object[]{AdapterUtil.toString(object), string});
        }
        try {
            WSRdbConnectionImpl wSRdbConnectionImpl = (WSRdbConnectionImpl)object;
            if (wSRdbConnectionImpl.batchOperation) {
                if (wSRdbConnectionImpl.bPstmt == null) {
                    WSRdbPreparedStatement wSRdbPreparedStatement;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "wrapperedPreparedStatement in conn handle is null, creating one");
                    }
                    wSRdbConnectionImpl.bPstmt = wSRdbPreparedStatement = new WSRdbPreparedStatement(wSRdbConnectionImpl.getPreparedStatement(string));
                    wSRdbPreparedStatement.setNumBatchRecords(wSRdbConnectionImpl.numBatchRecords);
                    wSRdbPreparedStatement.supportsBatchRead = _supportsBatchRead;
                    if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                        tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                        Tr.exit(tempTc, "prepareStatement", AdapterUtil.toString(wSRdbPreparedStatement));
                    }
                    return wSRdbPreparedStatement;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "found batchPreparedStatement in conn handle, just returning it");
                }
                if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "prepareStatement", AdapterUtil.toString(wSRdbConnectionImpl.bPstmt));
                }
                return wSRdbConnectionImpl.bPstmt;
            }
            preparedStatement = wSRdbConnectionImpl.getPreparedStatement(string);
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "got a classCastexception, can't use ReadRead or batchUpdate");
            }
            if (object instanceof WSRdbConnectionImpl) {
                FFDCFilter.processException((Throwable)classCastException, this.getClass().getName() + ".prepareStatement", "448", this);
                throw classCastException;
            }
            java.sql.Connection connection = (java.sql.Connection)object;
            preparedStatement = connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.cci.WSResourceAdapterBase.prepareStatement", "586", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareStatement", "Exception");
            }
            throw sQLException;
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareStatement", AdapterUtil.toString(preparedStatement));
        }
        return preparedStatement;
    }

    public void returnPreparedStatement(Object object, PreparedStatement preparedStatement) throws SQLException {
        try {
            StatementCacheKey statementCacheKey;
            WSRdbPreparedStatement wSRdbPreparedStatement = null;
            WSRdbConnectionImpl wSRdbConnectionImpl = (WSRdbConnectionImpl)object;
            if (wSRdbConnectionImpl.batchOperation) {
                wSRdbPreparedStatement = preparedStatement == null ? wSRdbConnectionImpl.bPstmt : (WSRdbPreparedStatement)preparedStatement;
                int n = wSRdbPreparedStatement.currentBatchValue;
                if (n > wSRdbConnectionImpl.numBatchRecords || n == -1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "remove batchPreparedStatement from the conn handle and return pstmt to cache");
                    }
                } else {
                    return;
                }
                preparedStatement = wSRdbPreparedStatement.getContainedStatement();
                wSRdbPreparedStatement.removeContainedStatement();
                wSRdbConnectionImpl.bPstmt = null;
                if (!wSRdbConnectionImpl.batchRead) {
                    wSRdbConnectionImpl.batchUpdateCount = wSRdbPreparedStatement.getBatchUpdateCount();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ReadRead booleanArray returned is:", wSRdbPreparedStatement.getBooleanArray());
                    }
                    wSRdbConnectionImpl.batchReadBooleanArray = wSRdbPreparedStatement.getBooleanArray();
                }
            }
            if ((statementCacheKey = wSRdbConnectionImpl.statementCacheKey) == null) {
                preparedStatement.close();
            } else {
                try {
                    ResultSet resultSet = null;
                    while (preparedStatement.getMoreResults() | preparedStatement.getUpdateCount() != -1) {
                        resultSet = preparedStatement.getResultSet();
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                    wSRdbConnectionImpl.managedConn.cacheStatement(preparedStatement, statementCacheKey);
                }
                catch (SQLException sQLException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Errors while caching. Statement cannot be cached.");
                    }
                    preparedStatement.close();
                }
            }
        }
        catch (ClassCastException classCastException) {
            if (object instanceof WSRdbConnectionImpl) {
                FFDCFilter.processException((Throwable)classCastException, this.getClass().getName() + ".returnPreparedStatement", "611", this);
                throw classCastException;
            }
            preparedStatement.close();
        }
    }

    public Statement createStatement(Object object) throws SQLException {
        Statement statement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatement", new Object[]{object});
        }
        try {
            WSRdbConnectionImpl wSRdbConnectionImpl = (WSRdbConnectionImpl)object;
            wSRdbConnectionImpl.enlistIfNecessary();
            wSRdbConnectionImpl.stmtImpl = statement = wSRdbConnectionImpl.jdbcConn.createStatement();
        }
        catch (ClassCastException classCastException) {
            if (object instanceof WSRdbConnectionImpl) {
                FFDCFilter.processException((Throwable)classCastException, this.getClass().getName() + ".createStatement", "656", this);
                throw classCastException;
            }
            java.sql.Connection connection = (java.sql.Connection)object;
            statement = connection.createStatement();
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.cci.WSResourceAdapterBase.createStatement", "265", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatement", "Exception");
            }
            throw AdapterUtil.toSQLException(resourceException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatement", statement);
        }
        return statement;
    }

    public final Object getNativeConnection(Connection connection) {
        return ((WSRdbConnectionImpl)connection).jdbcConn;
    }

    public final Object getNativeConnection(WSJdbcConnection wSJdbcConnection) {
        return WSJdbcUtil.getNativeConnection(wSJdbcConnection);
    }

    public final DataStoreHelper getDataStoreHelper(Connection connection) {
        return ((WSRdbConnectionImpl)connection).mcf.getDataStoreHelper();
    }

    public final void enlistIfNecessary(WSJdbcConnection wSJdbcConnection) throws SQLException {
        WSJdbcUtil.enlistIfNecessary(wSJdbcConnection);
    }

    public ResourceException createResourceException(Throwable throwable, Class clazz) {
        return new DataStoreAdapterException("DSA_ERROR", throwable, clazz);
    }

    static {
        PMI_PSTMT_EXECUTE_QUERY = new String[]{PreparedStatement.class.getName(), "executeQuery()"};
        PMI_PSTMT_EXECUTE_UPDATE = new String[]{PreparedStatement.class.getName(), "executeUpdate()"};
        _supportsBatchRead = false;
        _supportsBatchRead = new Boolean(System.getProperty("com.ibm.ws.rsadapter.cci.batchReadSupported"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Property com.ibm.ws.rsadapter.cci.batchReadSupported:" + _supportsBatchRead);
        }
    }
}

