/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.exceptions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.exception.WsNestedException;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Locale;
import javax.resource.ResourceException;

public class DataStoreAdapterException
extends ResourceException
implements WsNestedException {
    private static final long serialVersionUID = -1282552127378991160L;
    private static final String DEFAULTTEXT = "Error in a data store adapter";
    private WsException ivException = null;
    static final String resBundle = "IBMDataStoreAdapterNLS";
    private static final TraceComponent tcLocal = Tr.register(DataStoreAdapterException.class, "RRA", "IBMDataStoreAdapterNLS");
    private boolean connectionError = false;
    private boolean containsSqlException = false;
    private boolean beenMapped = false;
    private boolean authorizationException = false;
    private Object[] formatArgs;

    public DataStoreAdapterException(String string, String string2, Class clazz) {
        this(string, null, null, string2, clazz);
    }

    public DataStoreAdapterException(String string, Throwable throwable, String string2, Class clazz) {
        this(string, new Object[]{throwable.getMessage()}, throwable, string2, clazz);
    }

    public DataStoreAdapterException(String string, Throwable throwable, Class clazz) {
        this(string, new Object[]{throwable.getMessage()}, throwable, DEFAULTTEXT, clazz);
    }

    public DataStoreAdapterException(String string, Object[] objectArray, String string2, Class clazz) {
        this(string, objectArray, null, string2, clazz);
    }

    public DataStoreAdapterException(String string, Object[] objectArray, Throwable throwable, String string2, Class clazz) {
        this(TraceNLS.getFormattedMessage(resBundle, string, Locale.US, objectArray, string2), string, objectArray, throwable, clazz);
    }

    private DataStoreAdapterException(String string, String string2, Object[] objectArray, Throwable throwable, Class clazz) {
        super(string);
        this.formatArgs = objectArray;
        TraceComponent traceComponent = Tr.register(clazz, "RRA", resBundle);
        if (throwable == null) {
            this.ivException = new WsException(string);
            this.ivException.fillInStackTrace();
            if (traceComponent.isDebugEnabled()) {
                Tr.debug(tcLocal, "DSA_ERROR", this);
            }
        } else {
            if (throwable instanceof SQLException) {
                this.containsSqlException = true;
                SQLException sQLException = (SQLException)throwable;
                SQLException sQLException2 = sQLException.getNextException();
                Throwable throwable2 = sQLException.getCause();
                String string3 = sQLException.getSQLState();
                int n = sQLException.getErrorCode();
                StringBuffer stringBuffer = new StringBuffer(150);
                stringBuffer.append(string).append(" with SQL State : ").append(string3).append(" SQL Code : ").append(n);
                string = stringBuffer.toString();
                String string4 = AdapterUtil.getNLSMessage("SQL_STATE_ERROR_CODE", new Object[]{string3, new Integer(n)});
                throwable = throwable instanceof DuplicateKeyException ? new DuplicateKeyException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof StaleConnectionException ? new StaleConnectionException(sQLException.getMessage() + string4, string3, n) : (throwable instanceof StaleStatementException ? new StaleStatementException(sQLException.getMessage() + string4, string3, n) : new SQLException(sQLException.getMessage() + string4, string3, n)));
                if (throwable2 != null) {
                    throwable.initCause(throwable2);
                }
                if (sQLException2 != null) {
                    ((SQLException)throwable).setNextException(sQLException2);
                }
                throwable.setStackTrace(sQLException.getStackTrace());
            }
            this.ivException = new WsException(string, throwable);
            this.ivException.setStackTrace(throwable.getStackTrace());
            if (traceComponent.isDebugEnabled()) {
                Tr.debug(traceComponent, "Exception", throwable);
            }
        }
    }

    public void printStackTrace() {
        this.ivException.printStackTrace();
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.ivException.printStackTrace(printWriter);
    }

    public void printStackTrace(PrintStream printStream) {
        this.ivException.printStackTrace(printStream);
    }

    public void printSuperStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }

    public boolean beenMapped() {
        return this.beenMapped;
    }

    public void setBeenMapped() {
        this.beenMapped = true;
    }

    public boolean isConnectionError() {
        return this.connectionError;
    }

    public boolean containsSqlException() {
        return this.containsSqlException;
    }

    public void setConnectionError(boolean bl) {
        this.connectionError = bl;
    }

    public Exception getLinkedException() {
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof Exception)) continue;
            return (Exception)throwable;
        }
        return null;
    }

    public void setLinkedException(Exception exception) {
        String string = this.ivException.getMessage();
        this.ivException = new WsException(string, exception);
        this.containsSqlException = exception instanceof SQLException;
    }

    public Throwable getCause() {
        return this.ivException.getCause();
    }

    public Throwable initCause(Throwable throwable) throws IllegalArgumentException, IllegalStateException {
        return this.ivException.initCause(throwable);
    }

    public final String translate(Locale locale) {
        String string = this.getErrorCode();
        return TraceNLS.getFormattedMessage(resBundle, string, locale, this.formatArgs, string);
    }

    public boolean isAuthorizationException() {
        return this.authorizationException;
    }

    public void setAuthorizationException(boolean bl) {
        this.authorizationException = bl;
    }
}

