/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class WSJdbcCallableStatement
extends WSJdbcPreparedStatement
implements CallableStatement {
    private static final TraceComponent tc = Tr.register(WSJdbcCallableStatement.class, "RRA", "IBMDataStoreAdapterNLS");
    protected CallableStatement cstmtImpl;

    protected WSJdbcCallableStatement() {
    }

    protected WSJdbcCallableStatement(CallableStatement callableStatement, WSJdbcConnection wSJdbcConnection, int n, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(callableStatement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n)});
        }
        this.cstmtImpl = callableStatement;
        this.pstmtImpl = this.cstmtImpl;
        this.stmtImpl = this.cstmtImpl;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.metrics = this.parentWrapper.metrics;
        this.sql = string;
        this.holdability = n;
        try {
            this.__mcf = ((WSJdbcConnection)this.parentWrapper).managedConn.getManagedConnectionFactory();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught something, we will just log and ignore.  This will only disable usage of mcf later (this, t)", new Object[]{this, throwable});
            }
            Tr.warning(tc, "WS_INTERNAL_WARNING", new Object[]{throwable, "", ""});
        }
        try {
            this.currentFetchSize = this.cstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.<init>", "66", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current fetchSize is " + this.currentFetchSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    protected WSJdbcCallableStatement(CallableStatement callableStatement, WSJdbcConnection wSJdbcConnection, int n, String string, StatementCacheKey statementCacheKey) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(callableStatement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n), statementCacheKey});
        }
        this.cstmtImpl = callableStatement;
        this.pstmtImpl = this.cstmtImpl;
        this.stmtImpl = this.cstmtImpl;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.metrics = this.parentWrapper.metrics;
        this.sql = string;
        this.key = statementCacheKey;
        this.holdability = n;
        try {
            this.__mcf = ((WSJdbcConnection)this.parentWrapper).managedConn.getManagedConnectionFactory();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught something, we will just log and ignore.  This will only disable usage of mcf later (this, t)", new Object[]{this, throwable});
            }
            Tr.warning(tc, "WS_INTERNAL_WARNING", new Object[]{throwable, "", ""});
        }
        try {
            this.currentFetchSize = this.cstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.<init>", "111", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current fetchSize is " + this.currentFetchSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    protected SQLException closeWrapper(boolean bl) {
        this.cstmtImpl = null;
        return super.closeWrapper(bl);
    }

    public Array getArray(int n) throws SQLException {
        try {
            return this.cstmtImpl.getArray(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getArray", "86", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return this.cstmtImpl.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBigDecimal", "106", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return this.cstmtImpl.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBigDecimal", "126", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            return this.cstmtImpl.getBlob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBlob", "146", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            return this.cstmtImpl.getBoolean(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBoolean", "166", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            return this.cstmtImpl.getByte(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getByte", "186", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            return this.cstmtImpl.getBytes(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBytes", "206", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(int n) throws SQLException {
        try {
            return this.cstmtImpl.getClob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getClob", "226", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            return this.cstmtImpl.getDate(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDate", "246", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDate", "266", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            return this.cstmtImpl.getDouble(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDouble", "286", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            return this.cstmtImpl.getFloat(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getFloat", "306", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            return this.cstmtImpl.getInt(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getInt", "326", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            return this.cstmtImpl.getLong(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getLong", "346", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(int n) throws SQLException {
        try {
            return this.cstmtImpl.getObject(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getObject", "366", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            return this.cstmtImpl.getObject(n, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getObject", "386", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            return this.cstmtImpl.getRef(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getRef", "406", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            return this.cstmtImpl.getShort(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getShort", "426", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getString(int n) throws SQLException {
        try {
            return this.cstmtImpl.getString(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getString", "446", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            return this.cstmtImpl.getTime(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTime", "466", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTime", "486", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this.cstmtImpl.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTimestamp", "506", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTimestamp", "526", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final TraceComponent getTracer() {
        return tc;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2)});
        }
        try {
            this.cstmtImpl.registerOutParameter(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter", "555", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2), new Integer(n3)});
        }
        try {
            this.cstmtImpl.registerOutParameter(n, n2, n3);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter", "576", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{this, new Integer(n), AdapterUtil.getSQLTypeString(n2), string});
        }
        try {
            this.cstmtImpl.registerOutParameter(n, n2, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter", "597", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            return this.cstmtImpl.wasNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.wasNull", "617", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{string, AdapterUtil.getSQLTypeString(n)});
        }
        try {
            this.cstmtImpl.registerOutParameter(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter(String, int)", "721", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{string, AdapterUtil.getSQLTypeString(n), new Integer(n2)});
        }
        try {
            this.cstmtImpl.registerOutParameter(string, n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter(String, int, int)", "744", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerOutParameter", new Object[]{string, AdapterUtil.getSQLTypeString(n), string2});
        }
        try {
            this.cstmtImpl.registerOutParameter(string, n, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.registerOutParameter(String, int, String)", "766", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setURL(String string, URL uRL) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setURL #" + string);
        }
        try {
            this.cstmtImpl.setURL(string, uRL);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setURL(String, URL)", "783", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNull #" + string, AdapterUtil.getSQLTypeString(n));
        }
        try {
            this.cstmtImpl.setNull(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setNull(String, int)", "804", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBoolean #" + string);
        }
        try {
            this.cstmtImpl.setBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setBoolean(String, boolean)", "823", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setByte(String string, byte by) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setByte #" + string);
        }
        try {
            this.cstmtImpl.setByte(string, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setByte(String, byte)", "841", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setShort(String string, short s) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setShort #" + string);
        }
        try {
            this.cstmtImpl.setShort(string, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setShort(String, short)", "859", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setInt(String string, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setInt #" + string);
        }
        try {
            this.cstmtImpl.setInt(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setint(String, int)", "877", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setLong(String string, long l) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setLong #" + string);
        }
        try {
            this.cstmtImpl.setLong(string, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setLong(String, long)", "895", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFloat(String string, float f) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFloat #" + string);
        }
        try {
            this.cstmtImpl.setFloat(string, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setFloat(String, float)", "913", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDouble(String string, double d) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDouble #" + string);
        }
        try {
            this.cstmtImpl.setDouble(string, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setDouble(String, x)", "931", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBigDecimal #" + string);
        }
        try {
            this.cstmtImpl.setBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setBigDecimal(String, BigDecimal)", "950", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setString(String string, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setString #" + string);
        }
        try {
            this.cstmtImpl.setString(string, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setString(String, String)", "967", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBytes #" + string, byArray == null ? null : "length = " + byArray.length);
        }
        try {
            this.cstmtImpl.setBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setBytes(String, byte[])", "986", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(String string, Date date) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDate #" + string);
        }
        try {
            this.cstmtImpl.setDate(string, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setDate(String, Date)", "1005", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(String string, Time time) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTime #" + string);
        }
        try {
            this.cstmtImpl.setTime(string, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setTime(String, Time)", "1024", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimestamp #" + string);
        }
        try {
            this.cstmtImpl.setTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setTimestamp(String, x)", "1043", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setAsciiStream #" + string, "length = " + n);
        }
        try {
            this.cstmtImpl.setAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setAsciiStream(String, InputStream, int)", "1065", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBinaryStream #" + string, "length = " + n);
        }
        try {
            this.cstmtImpl.setBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setBinaryStream(String, InputDtream, int)", "1087", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject #" + string, new Object[]{AdapterUtil.getSQLTypeString(n), new Integer(n2)});
        }
        try {
            this.cstmtImpl.setObject(string, object, n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setObject(String, Object, int, int)", "1110", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject #" + string, AdapterUtil.getSQLTypeString(n));
        }
        try {
            this.cstmtImpl.setObject(string, object, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setObject(parameterName, x, targetSqlType)", "1129", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(String string, Object object) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject #" + string);
        }
        try {
            this.cstmtImpl.setObject(string, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setObject(String, Object)", "1147", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCharacterStream #" + string, "length = " + n);
        }
        try {
            this.cstmtImpl.setCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setCharacterStream(String, Reader, int)", "1169", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDate with Calendar #" + string);
        }
        try {
            this.cstmtImpl.setDate(string, date, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setDate(String, Date, calendar)", "1191", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTime with Calendar #" + string);
        }
        try {
            this.cstmtImpl.setTime(string, time, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setTime(String, Time, Calendar)", "1213", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimestamp with Calendar #" + string);
        }
        try {
            this.cstmtImpl.setTimestamp(string, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setTimestamp(String, Timestamp, Calendar)", "1235", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNull #" + string, new Object[]{AdapterUtil.getSQLTypeString(n), string2});
        }
        try {
            this.cstmtImpl.setNull(string, n, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.setNull(String, int, String)", "1254", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            return this.cstmtImpl.getArray(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getArray(String)", "1273", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this.cstmtImpl.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBigDecimal(String)", "1293", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            return this.cstmtImpl.getBlob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBlob(String)", "1312", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            return this.cstmtImpl.getBoolean(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBoolean(String)", "1327", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            return this.cstmtImpl.getByte(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getByte(String)", "1346", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            return this.cstmtImpl.getBytes(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getBytes(String)", "1363", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            return this.cstmtImpl.getClob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getClob", "1381", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(String string) throws SQLException {
        try {
            return this.cstmtImpl.getDate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDate(String)", "1400", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDate(String, Calendar)", "1418", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            return this.cstmtImpl.getDouble(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getDouble(String)", "1436", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            return this.cstmtImpl.getFloat(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getFloat(String)", "1454", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            return this.cstmtImpl.getInt(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getInt(String)", "1472", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            return this.cstmtImpl.getLong(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getLong(String)", "1489", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(String string) throws SQLException {
        try {
            return this.cstmtImpl.getObject(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getObject(String)", "1506", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        try {
            return this.cstmtImpl.getObject(string, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getObject(String, Map)", "1524", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(String string) throws SQLException {
        try {
            return this.cstmtImpl.getRef(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getRef(String)", "1542", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            return this.cstmtImpl.getShort(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getShort(String)", "1561", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getString(String string) throws SQLException {
        try {
            return this.cstmtImpl.getString(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getString(String)", "1578", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(String string) throws SQLException {
        try {
            return this.cstmtImpl.getTime(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTime(String)", "1597", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTime(String, Calendar)", "1618", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this.cstmtImpl.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTimestamp(String)", "1637", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this.cstmtImpl.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getTimestamp(String, Calendar)", "1656", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(int n) throws SQLException {
        try {
            return this.cstmtImpl.getURL(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getURL(int)", "1674", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            return this.cstmtImpl.getURL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement.getURL(String)", "1692", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }
}

