/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.websphere.rsadapter.WSConnection;
import com.ibm.websphere.rsadapter.WSSystemMonitor;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.DataStoreHelperKeeper;
import com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.CSCacheKey;
import com.ibm.ws.rsadapter.spi.PSCacheKey;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SharingViolationException;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;

public class WSJdbcConnection
extends WSJdbcObject
implements Reassociateable,
DataStoreHelperKeeper,
WSConnection {
    private static final long INTERNAL_KEY = 29497789L;
    private static final TraceComponent tc = Tr.register(WSJdbcConnection.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final String[] PMI_ROLLBACK_SAVEPOINT = new String[]{Connection.class.getName(), "rollback(Savepoint)"};
    private static final TraceComponent clientInfoTc = Tr.register("WAS.clientinfopluslogging", "WAS.clientinfopluslogging", "IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;
    private static boolean warnedAboutIsolationLevelMatching;
    private static boolean warnedAboutReadOnlyMatching;
    private String[] currentClientInfo;
    private boolean clientInfoSetExplicitly;
    private Properties clientProps;
    protected Connection connImpl;
    public DataStoreHelper helper;
    public WSRdbManagedConnectionImpl managedConn;
    protected WSManagedConnectionFactoryImpl mcf;
    private ConnectionManager cm;
    private LazyEnlistableConnectionManager lazyEnlistableCM;
    private LazyAssociatableConnectionManager lazyAssociatableCM;
    private boolean isReserved;
    protected Object managedConnKey;
    private Subject subject;
    private ConnectionRequestInfo connRequestInfo;
    protected boolean autoCommit;
    private boolean rrsTransactional;
    protected boolean detectMultithreadedAccess;
    protected Object threadID;
    protected boolean isResultSetClosedAtCommit;
    protected int currentTransactionIsolation = 2;
    protected boolean supportIsolvlSwitching = false;

    protected WSJdbcConnection() {
    }

    public WSJdbcConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, Connection connection, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{wSRdbManagedConnectionImpl, AdapterUtil.toString(connection)});
        }
        this.managedConn = wSRdbManagedConnectionImpl;
        this.connImpl = connection;
        this.managedConnKey = object;
        this.threadID = object2;
        this.detectMultithreadedAccess = this.threadID != null;
        this.mcf = this.managedConn.getManagedConnectionFactory();
        this.helper = this.mcf.getDataStoreHelper();
        this.supportIsolvlSwitching = this.mcf.getInternalDataStoreHelper().isIsolationLevelSwitchingSupport();
        this.pmi = this.mcf.getPMI();
        this.metrics = this.managedConn.getInteractionMetrics();
        this.rrsTransactional = this.mcf.getRRSTransactional();
        this.autoCommit = this.managedConn.getTransactionState() == 1 && !this.managedConn.inGlobalTransaction() ? false : this.managedConn.getDefaultAutoCommit();
        this.childWrappers = new ArrayList(8);
        this.currentTransactionIsolation = this.managedConn.getTransactionIsolation();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    protected final Connection initialize(ConnectionManager connectionManager) throws SQLException {
        this.cm = connectionManager;
        if (this.state != 1) {
            this.connImpl.clearWarnings();
        }
        return this;
    }

    public Connection initialize(ConnectionManager connectionManager, Object object) throws ResourceException, SQLException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        return this.initialize(connectionManager);
    }

    private void beginLocalTransactionIfNecessary() throws SQLException {
        if (this.managedConn.isMCStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale", this.managedConn);
            }
            throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
        }
        if (this.autoCommit) {
            return;
        }
        try {
            this.managedConn.processLocalTransactionStartedEvent(this);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, WSJdbcConnection.class.getName() + ".beginLocalTransactionIfNecessary", "343", this);
            throw AdapterUtil.toSQLException(resourceException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Local transaction started for " + this);
        }
    }

    protected void beginTransactionIfNecessary() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.managedConn.isMCStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale", this.managedConn);
            }
            throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
        }
        if (this.detectMultithreadedAccess) {
            this.detectMultithreadedAccess();
        }
        if (this.supportIsolvlSwitching) {
            this.managedConn.setTransactionIsolation(this.currentTransactionIsolation);
        }
        if (this.managedConn.isEnlistmentDisabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beginTransactionIfNecessary: no-op enlistment is disabled");
            }
            return;
        }
        switch (this.managedConn.getTransactionState()) {
            case 2: {
                bl = true;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "Global Transaction is active.");
                break;
            }
            case 7: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "RRS_GLOBAL_TRANSACTION_ACTIVE but marking the internal flag of rrsGlobalTransactionReallyActive since we know we are enlisting.");
                }
                bl = true;
                this.managedConn.setRrsGlobalTransactionReallyActive(true);
                break;
            }
            case 1: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Local Transaction is active.");
                break;
            }
            case 0: {
                if (WSManagedConnectionFactoryImpl.locationRestrictedFunction.inGlobalTransaction()) {
                    try {
                        this.managedConn.lazyEnlist(this.lazyEnlistableCM == null ? (this.lazyEnlistableCM = (LazyEnlistableConnectionManager)this.cm) : this.lazyEnlistableCM);
                        bl = this.managedConn.getTransactionState() == 2;
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        bl2 = true;
                        this.beginLocalTransactionIfNecessary();
                        break;
                    }
                    catch (ResourceException resourceException) {
                        SystemException systemException;
                        FFDCFilter.processException((Throwable)resourceException, WSJdbcConnection.class.getName() + ".beginTransactionIfNecessary", "324", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error during lazy enlistment.", (Object)resourceException);
                        }
                        if (resourceException.getCause() instanceof SystemException && (systemException = (SystemException)resourceException.getCause()).getCause() != null && systemException.getCause() instanceof XAException) {
                            XAException xAException = (XAException)systemException.getCause();
                            if (xAException.errorCode == -7) {
                                StaleConnectionException staleConnectionException = new StaleConnectionException(resourceException.getMessage());
                                staleConnectionException.initCause(xAException);
                                throw staleConnectionException;
                            }
                        }
                        throw AdapterUtil.toSQLException(resourceException);
                    }
                }
                bl2 = true;
                this.beginLocalTransactionIfNecessary();
                break;
            }
            default: {
                throw new SQLException(AdapterUtil.getNLSMessage("INVALID_TRAN_STATE", this.managedConn.getTransactionStateAsString()));
            }
        }
        if (bl2) {
            this.managedConn.enforceAutoCommit(this.autoCommit);
        }
    }

    public final void clearWarnings() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            this.connImpl.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.clearWarnings", "395", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected SQLException closeWrapper(boolean bl) {
        SQLException sQLException;
        block15: {
            block14: {
                sQLException = null;
                if (this.managedConn != null && this.managedConn.getNumberOfInUseHandles() == 1) {
                    try {
                        boolean bl2 = this.mcf.getDataStoreHelper().doConnectionCleanupPerCloseConnection(this.connImpl, false, null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "doConnectionCleanupPerCloseConnection on [helper, mc, sqlCon, returned value]", new Object[]{this.mcf.getDataStoreHelper(), this.managedConn, this.connImpl, new Boolean(bl2)});
                        }
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "doConnectionCleanupPerCloseConnection method caught an exception", throwable);
                        }
                        if (throwable instanceof SQLException) {
                            sQLException = WSJdbcUtil.mapException(this, (SQLException)throwable);
                            break block14;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "initializing a new sqlexception based on the non-sql thrown by doConnectionCleanupPerCloseConnection", throwable);
                        }
                        sQLException = new SQLException(throwable.getMessage(), null, 999999);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doConnectionCleanupPerCloseConnection is not called on mc because number of handles is not 1  or MC is null(i.e. get=>use=>close is not followed", new Object[]{this.managedConn, this.managedConn == null ? new Integer(0) : new Integer(this.managedConn.getNumberOfInUseHandles())});
                }
            }
            if (this.managedConn != null) {
                try {
                    this.managedConn.processConnectionClosedEvent(this);
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.close", "495", this);
                    if (sQLException == null) {
                        sQLException = AdapterUtil.toSQLException(resourceException);
                        break block15;
                    }
                    Tr.warning(tc, "DSA_INTERNAL_ERR_WARNING", new Object[]{"An unexpected error occurred sending a connectionClosed event" + System.getProperty("line.separator"), resourceException});
                }
            } else {
                WSManagedConnectionFactoryImpl.locationRestrictedFunction.inactiveConnectionClosed(this, this.cm);
            }
        }
        this.connImpl = null;
        this.childWrappers = null;
        this.managedConn = null;
        this.managedConnKey = null;
        this.connRequestInfo = null;
        this.subject = null;
        this.mcf = null;
        this.cm = null;
        this.pmi = null;
        this.helper = null;
        this.threadID = null;
        this.clientProps = null;
        return sQLException;
    }

    public void commit() throws SQLException {
        int n;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "commit", this);
        }
        if (this.managedConn != null && this.managedConn.isMCStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale", this.managedConn);
            }
            throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
        }
        if (this.detectMultithreadedAccess) {
            this.detectMultithreadedAccess();
        }
        if (this.state == 1) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "commit", "no-op; state is INACTIVE");
            }
            return;
        }
        if (this.mcf != null && this.mcf.isEndToEndMonitoringFeatureEnabled()) {
            n = this.mcf.shouldDataBeCollectedAndPshedDownToCMX();
            AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, n != 0, this.managedConn.getJ2EEName(), this.mcf.appServerName, this.mcf.getInternalDataStoreHelper(), 120, n != 0 ? AdapterUtil.getcmxArgsObject(4, null, null, this, null, null, null) : null, this.connImpl);
        }
        try {
            if (this.managedConn.isEnlistmentDisabled()) {
                if (this.metrics.isInteractionMetricsEnabled()) {
                    this.managedConn.pmiCommit();
                } else {
                    this.connImpl.commit();
                }
                if (this.isResultSetClosedAtCommit) {
                    for (n = this.childWrappers.size() - 1; n > -1; --n) {
                        ((WSJdbcStatement)this.childWrappers.get(n)).closeResultSetsIfNecessary();
                    }
                }
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "commit", "Enlistment is disabled");
                }
                return;
            }
            if (this.managedConn.inGlobalTransaction()) {
                SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "Connection.commit"));
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "commit", sQLException);
                }
                throw sQLException;
            }
            if (this.managedConn.getTransactionState() == 1) {
                this.managedConn.processLocalTransactionCommittedEvent(this);
                if (this.isResultSetClosedAtCommit) {
                    for (n = this.childWrappers.size() - 1; n > -1; --n) {
                        ((WSJdbcStatement)this.childWrappers.get(n)).closeResultSetsIfNecessary();
                    }
                }
            } else if (this.metrics.isInteractionMetricsEnabled()) {
                this.managedConn.pmiCommit();
            } else {
                this.connImpl.commit();
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.commit", "776", this);
            SQLException sQLException = AdapterUtil.toSQLException(resourceException);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "commit", "Exception");
            }
            throw sQLException;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".commit", "587", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "commit", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "commit", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "commit");
        }
    }

    protected CallableStatement createCallableStatementWrapper(CallableStatement callableStatement, int n, String string) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        WSJdbcCallableStatement wSJdbcCallableStatement = new WSJdbcCallableStatement(callableStatement, this, n, string);
        wSJdbcCallableStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcCallableStatement;
    }

    protected CallableStatement createCallableStatementWrapper(CallableStatement callableStatement, int n, String string, StatementCacheKey statementCacheKey) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        WSJdbcCallableStatement wSJdbcCallableStatement = new WSJdbcCallableStatement(callableStatement, this, n, string, statementCacheKey);
        wSJdbcCallableStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcCallableStatement;
    }

    protected PreparedStatement createPreparedStatementWrapper(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        WSJdbcPreparedStatement wSJdbcPreparedStatement = new WSJdbcPreparedStatement(preparedStatement, this, n, string);
        wSJdbcPreparedStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcPreparedStatement;
    }

    protected PreparedStatement createPreparedStatementWrapper(PreparedStatement preparedStatement, int n, String string, StatementCacheKey statementCacheKey) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        WSJdbcPreparedStatement wSJdbcPreparedStatement = new WSJdbcPreparedStatement(preparedStatement, this, n, string, statementCacheKey);
        wSJdbcPreparedStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcPreparedStatement;
    }

    protected WSJdbcResultSet createResultSetWrapper(ResultSet resultSet, WSJdbcObject wSJdbcObject) {
        return new WSJdbcResultSet(resultSet, wSJdbcObject);
    }

    protected SQLException createSharingException(String string) {
        String string2 = AdapterUtil.getNLSMessage("OP_NOT_SHAREABLE", string);
        SQLException sQLException = new SQLException(string2);
        sQLException.initCause(new SharingViolationException(string2));
        return sQLException;
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        Statement statement;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatement", new Object[]{this, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            statement = this.connImpl.createStatement(n, n2);
            statement = this.createStatementWrapper(statement, this.managedConn.getCurrentHoldability());
            this.childWrappers.add(statement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.createStatement", "865", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatement", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatement", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatement", statement);
        }
        return statement;
    }

    protected Statement createStatementWrapper(Statement statement, int n) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        return new WSJdbcStatement(statement, this, n);
    }

    protected final void detectMultithreadedAccess() {
        Thread thread = Thread.currentThread();
        if (thread != this.threadID) {
            this.mcf.detectedMultithreadedAccess = true;
            StringWriter stringWriter = new StringWriter();
            new Error().printStackTrace(new PrintWriter(stringWriter));
            Tr.warning(tc, "MULTITHREADED_ACCESS_DETECTED", new Object[]{this, Integer.toHexString(this.threadID.hashCode()) + ' ' + this.threadID, Integer.toHexString(thread.hashCode()) + ' ' + thread, stringWriter.getBuffer().delete(0, "java.lang.Error".length())});
        }
    }

    public void dissociate() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dissociate", this);
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isReserved) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unreserving handle for dissociation", this);
                    }
                    this.isReserved = false;
                    break;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "dissociate", "Already dissociated.");
                }
                return;
            }
            case 2: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "dissociate", "Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
            }
        }
        this.closeChildWrappers();
        this.connRequestInfo = this.managedConn.createConnectionRequestInfo();
        this.subject = this.managedConn.getSubject();
        if (this.managedConn.clientInfoExplicitlySet || this.managedConn.clientInfoImplicitlySet) {
            this.currentClientInfo = this.managedConn.getCurrentClientInfo();
            this.clientInfoSetExplicitly = this.managedConn.clientInfoExplicitlySet;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clientProps saved from mc is:", this.currentClientInfo);
            }
        }
        this.managedConn.dissociateHandle(this);
        this.connImpl = null;
        this.managedConn = null;
        this.state = 1;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "state --> INACTIVE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dissociate");
        }
    }

    public void fireConnectionErrorEvent(Exception exception) {
        switch (this.state) {
            case 0: {
                try {
                    this.managedConn.processConnectionErrorOccurredEvent(this, exception);
                }
                catch (NullPointerException nullPointerException) {
                    if (!tc.isEventEnabled()) break;
                    Tr.event(tc, "Handle CLOSED or INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", this);
                }
                break;
            }
            case 1: {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Handle is INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", this);
                    }
                    this.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.FireConnectionErrorEvent", "965", this);
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Error closing connection:", sQLException);
                }
                break;
            }
            case 2: {
                if (!tc.isEventEnabled()) break;
                Tr.event(tc, "Connection already closed. Not sending CONNECTION_ERROR_OCCURRED.", this);
            }
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        if (this.rrsTransactional) {
            UOWCoordinator uOWCoordinator;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MCF is rrsTransactional - check for Global");
            }
            if ((uOWCoordinator = TransactionManagerFactory.getUOWCurrent().getUOWCoord()) != null && uOWCoordinator.isGlobal()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RRSGlobalTran active - return autoCommit=false");
                }
                return false;
            }
        }
        return this.autoCommit;
    }

    public ManagedConnection getManagedConnection(Object object) throws ResourceException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        return this.managedConn;
    }

    public final String getCatalog() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getCatalog();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getCatalog", "917", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final WSJdbcObject getConnectionWrapper() {
        return this;
    }

    public final DataStoreHelper getHelper() {
        return this.helper;
    }

    protected final Object getJDBCImplObject() {
        return this.connImpl;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetaData", this);
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            this.childWrapper = this.childWrapper == null ? new WSJdbcDatabaseMetaData(this.connImpl.getMetaData(), this) : this.childWrapper;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getMetaData", "922", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetaData", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetaData", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetaData", this.childWrapper);
        }
        return (WSJdbcDatabaseMetaData)this.childWrapper;
    }

    protected TraceComponent getTracer() {
        return tc;
    }

    public final int getTransactionIsolation() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getTransactionIsolation();
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Map getTypeMap() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getTypeMap", "927", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.connImpl.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getWarnings", "991", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        this.introspectAll(fFDCLogger);
        fFDCLogger.eoln();
        fFDCLogger.introspect("ConnectionRequestInfo:", this.connRequestInfo);
        fFDCLogger.introspect("ManagedConnectionFactory:", this.mcf);
        fFDCLogger.introspect("ManagedConnection:", this.managedConn);
        return fFDCLogger.toStringArray();
    }

    protected void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        fFDCLogger.append("Transaction Manager global transaction status is", AdapterUtil.getGlobalTranStatusAsString());
        fFDCLogger.append("Underlying Connection: " + AdapterUtil.toString(this.connImpl), this.connImpl);
        fFDCLogger.append("Key Object:", this.managedConnKey);
        fFDCLogger.append("DataStoreHelper:", this.helper);
        fFDCLogger.introspect("Connection Manager:", this.cm);
        fFDCLogger.append("ConnectionManager supports lazy association?", this.cm instanceof LazyAssociatableConnectionManager ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("ConnectionManager supports lazy enlistment?", this.cm instanceof LazyEnlistableConnectionManager ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("Handle is reserved? " + this.isReserved);
        fFDCLogger.append("AutoCommit value tracked by handle: " + this.autoCommit);
        fFDCLogger.append("Detection of multithreaded access is:", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
        fFDCLogger.append("Thread id:", this.threadID);
    }

    public final boolean isClosed() {
        return this.state == 2;
    }

    public final boolean isReadOnly() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.isReadOnly", "996", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean isReserved() {
        return this.isReserved;
    }

    public boolean isShareable() throws SQLException {
        try {
            CMConfigData cMConfigData = WSManagedConnectionFactoryImpl.locationRestrictedFunction.getCMConfigData(this.cm);
            return cMConfigData != null && cMConfigData.isShareable();
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final String nativeSQL(String string) throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.connImpl.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.nativeSQL", "1079", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallableStatement pmiPrepareCall(String string, int n, int n2) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            CallableStatement callableStatement = this.connImpl.prepareCall(string, n, n2);
            return callableStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int n, int n2) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, n, n2);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    private void pmiRollback(Savepoint savepoint) throws SQLException {
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        Object object = this.metrics.preInteraction(PMI_ROLLBACK_SAVEPOINT);
        try {
            this.connImpl.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiRollback", "1815", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiRollback", "1822", this);
            exception = runtimeException;
            n = 2;
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception != null) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw (RuntimeException)exception;
        }
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareCall", new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                CSCacheKey cSCacheKey = new CSCacheKey(string, n, n2, this.managedConn.getCurrentHoldability(), this.helper.getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(cSCacheKey);
                callableStatement = object == null ? (callableStatement = this.pmi == null ? this.connImpl.prepareCall(string, n, n2) : this.pmiPrepareCall(string, n, n2)) : (CallableStatement)object;
                callableStatement = this.createCallableStatementWrapper(callableStatement, this.managedConn.getCurrentHoldability(), string, cSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                callableStatement = this.pmi == null ? this.connImpl.prepareCall(string, n, n2) : this.pmiPrepareCall(string, n, n2);
                callableStatement = this.createCallableStatementWrapper(callableStatement, this.managedConn.getCurrentHoldability(), string);
            }
            this.childWrappers.add(callableStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareCall", "1523", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareCall", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareCall", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareCall", callableStatement);
        }
        return callableStatement;
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareStatement", new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey pSCacheKey = new PSCacheKey(string, n, n2, this.managedConn.getCurrentHoldability(), 0, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(pSCacheKey);
                preparedStatement = object == null ? (this.pmi == null ? this.connImpl.prepareStatement(string, n, n2) : this.pmiPrepareStatement(string, n, n2)) : this.resetStatement((PreparedStatement)object);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability(), string, pSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, n, n2) : this.pmiPrepareStatement(string, n, n2);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability(), string);
            }
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement", "1584", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    protected final void reactivate() throws SQLException {
        if (this.state != 1) {
            return;
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Requesting implicit reactivation.");
        }
        try {
            this.lazyAssociatableCM = this.lazyAssociatableCM == null ? (LazyAssociatableConnectionManager)this.cm : this.lazyAssociatableCM;
            this.lazyAssociatableCM.associateConnection((Object)this, (ManagedConnectionFactory)this.mcf, this.connRequestInfo);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.reactivate", "1625", this);
            Tr.warning(tc, "REASSOCIATION_ERR", (Object)resourceException);
            throw AdapterUtil.toSQLException(resourceException);
        }
    }

    public void reassociate(ManagedConnection managedConnection, Connection connection, Object object) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reassociate", new Object[]{this, managedConnection, AdapterUtil.toString(connection)});
        }
        if (this.managedConnKey == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (object != this.managedConnKey) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        if (this.isReserved) {
            if (managedConnection != this.managedConn) {
                String string = "Connection handle is reserved for reassociation with a specific ManagedConnection, which does not match the ManagedConnection provided.";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string, new Object[]{this, this.managedConn, managedConnection});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "reassociate", "Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{string, " See trace for more details."}, null, WSJdbcConnection.class);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Handle is reserved, reassociating back to original ManagedConnection.");
            }
            this.isReserved = false;
            this.state = 0;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "state --> ACTIVE");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate");
            }
            return;
        }
        if (this.state != 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CANNOT_REASSOCIATE", this.getStateString(), null, WSJdbcConnection.class);
        }
        if (this.childWrapper != null || this.childWrappers != null && this.childWrappers.size() > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "reassociate", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CHILDREN_STILL_OPEN", null, null, WSJdbcConnection.class);
        }
        this.managedConn = (WSRdbManagedConnectionImpl)managedConnection;
        this.connImpl = connection;
        this.connRequestInfo = null;
        this.subject = null;
        if (this.currentClientInfo != null) {
            try {
                this.mcf.getInternalDataStoreHelper().setClientInformationArray(this.currentClientInfo, this.managedConn, this.clientInfoSetExplicitly);
                this.currentClientInfo = null;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, WSJdbcConnection.class.getName() + ".reassociate()", "1781", this);
                throw new DataStoreAdapterException("DSA_ERROR", sQLException, WSJdbcConnection.class);
            }
        }
        if (PmiReqMetrics.isPassCorrelatorToDB() && this.managedConn.getStateManager().getState() == 0) {
            this.mcf.getInternalDataStoreHelper().setEwlmCorrelator(this.metrics.getCorrelator(), this.managedConn);
        }
        this.state = 0;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "state --> ACTIVE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reassociate");
        }
    }

    public void reserve(Object object) throws ResourceException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        this.isReserved = true;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Reserving handle", this);
        }
        this.state = 1;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "state --> INACTIVE");
        }
    }

    protected final CallableStatement resetStatement(CallableStatement callableStatement) throws SQLException {
        callableStatement.clearParameters();
        return callableStatement;
    }

    protected final PreparedStatement resetStatement(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.clearParameters();
        return preparedStatement;
    }

    public void rollback() throws SQLException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "rollback", this);
        }
        try {
            int n;
            if (this.managedConn != null && this.managedConn.isMCStale()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MC is stale", this.managedConn);
                }
                throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
            }
            if (this.detectMultithreadedAccess) {
                this.detectMultithreadedAccess();
            }
            if (this.state == 1) {
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "rollback", "no-op; state is INACTIVE");
                }
                return;
            }
            if (this.mcf.isEndToEndMonitoringFeatureEnabled()) {
                n = this.mcf.shouldDataBeCollectedAndPshedDownToCMX();
                AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, n != 0, this.managedConn.getJ2EEName(), this.mcf.appServerName, this.mcf.getInternalDataStoreHelper(), 120, n != 0 ? AdapterUtil.getcmxArgsObject(4, null, null, this, null, null, null) : null, this.connImpl);
            }
            if (this.managedConn.isEnlistmentDisabled()) {
                if (this.metrics.isInteractionMetricsEnabled()) {
                    this.managedConn.pmiRollback();
                } else {
                    this.connImpl.rollback();
                }
                for (n = this.childWrappers.size() - 1; n > -1; --n) {
                    ((WSJdbcStatement)this.childWrappers.get(n)).closeChildWrappers();
                }
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "rollback", "Enlistment is disabled");
                }
                return;
            }
            if (this.managedConn.inGlobalTransaction()) {
                SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "Connection.rollback"));
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "rollback", sQLException);
                }
                throw sQLException;
            }
            if (this.managedConn.getTransactionState() == 1) {
                this.managedConn.processLocalTransactionRolledbackEvent(this);
                for (n = this.childWrappers.size() - 1; n > -1; --n) {
                    ((WSJdbcStatement)this.childWrappers.get(n)).closeChildWrappers();
                }
            } else if (this.metrics.isInteractionMetricsEnabled()) {
                this.managedConn.pmiRollback();
            } else {
                this.connImpl.rollback();
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.rollback", "2001", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "rollback", "Exception");
            }
            throw AdapterUtil.toSQLException(resourceException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".rollback", "1860", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "rollback", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "rollback", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "rollback");
        }
    }

    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        switch (this.state) {
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Connection dissociated on another thread while performing an operation. Closing the Connection handle.");
                }
                this.close();
            }
            case 2: {
                throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
            }
        }
        return runtimeException;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setAutoCommit(" + bl + ") requested by application.");
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && bl != this.managedConn.getAutoCommit()) {
                throw this.createSharingException("setAutoCommit");
            }
            if (this.managedConn.getTransactionState() == 0) {
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            } else if (this.managedConn.inGlobalTransaction()) {
                if (bl) {
                    throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setAutoCommit"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setAutoCommit(false) requested during a global transaction.");
                }
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            } else {
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setAutoCommit(true) requested during local transaction; implicitly committing the transaction.");
                    }
                    this.commit();
                }
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setAutoCommit", "2006", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setCatalog(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCatalog", new Object[]{this, string});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && !AdapterUtil.match(string, this.managedConn.getCatalog())) {
                throw this.createSharingException("setCatalog");
            }
            this.managedConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setCatalog", "2011", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setReadOnly", new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        if (!warnedAboutReadOnlyMatching) {
            Tr.info(tc, "WebSphere Application Server v6.1.0.15 contains changes to the default behavior for matching the ReadOnly connection property when sharing connections. Prior to v6.1.0.15, connections were matched based on the originally requested ReadOnly. In v6.1.0.15, the default behavior is to match based on the currentReadOnly value of the connection, not the originally requested value. In v6.1.0.17+, the behavior is to use the originally requested value. You may use the data source custom property, connectionSharing, to change this behavior.");
            warnedAboutReadOnlyMatching = true;
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && bl != this.managedConn.isReadOnly()) {
                throw this.createSharingException("setReadOnly");
            }
            this.mcf.getInternalDataStoreHelper().setReadOnly(this.managedConn, bl, true);
            if ((this.mcf.connectionSharing & 2) > 0) {
                if (!this.managedConn.getCRI().isCRIChangable()) {
                    this.managedConn.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.managedConn.getCRI()), 29497789L);
                }
                this.managedConn.getCRI().setReadOnly(bl, 29497789L);
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setReadOnly", "2016", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransactionIsolation requested by application.");
        }
        if (!warnedAboutIsolationLevelMatching) {
            Tr.info(tc, "WebSphere Application Server v6.1.0.15 contains changes to the default behavior for matching the transaction isolation level when sharing connections. Prior to v6.1.0.15, connections were matched based on the originally requested transaction isolation level. In v6.1.0.15+, the default behavior is to match based on the current transaction isolation level of a connection, not the originally requested value. In v6.1.0.17+, you may use the data source custom property, connectionSharing, to configure the behavior.");
            warnedAboutIsolationLevelMatching = true;
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && n != this.managedConn.getTransactionIsolation()) {
                throw this.createSharingException("setTransactionIsolation");
            }
            this.managedConn.setTransactionIsolation(n);
            this.currentTransactionIsolation = n;
            if (!this.supportIsolvlSwitching && (this.mcf.connectionSharing & 1) > 0) {
                if (!this.managedConn.getCRI().isCRIChangable()) {
                    this.managedConn.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.managedConn.getCRI()), 29497789L);
                }
                this.managedConn.getCRI().setTransactionIsolationLevel(n, 29497789L);
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setTransactionIsolation", "2021", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTypeMap", new Object[]{this, map});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1) {
                throw this.createSharingException("setTypeMap");
            }
            this.managedConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setTypeMap", "2026", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsImplicitReactivation() {
        return true;
    }

    public ConnectionRequestInfo getCRI() {
        return this.connRequestInfo;
    }

    public void setHoldability(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setHoldability requested by application.");
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && n != this.managedConn.getHoldability()) {
                throw this.createSharingException("setHoldability");
            }
            this.managedConn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setHoldability", "2031", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getHoldability() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getHoldability();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getHoldability", "2055", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSavepoint", this);
        }
        if (this.state == 1) {
            this.reactivate();
        }
        Savepoint savepoint = null;
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error(tc, "OP_NOT_VALID_IN_GT", "setSavepoint");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setSavepoint", "Exception");
                }
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setSavepoint"));
            }
            savepoint = this.connImpl.setSavepoint();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setSavepoint", "2082", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSavepoint", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSavepoint", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSavepoint", savepoint);
        }
        return savepoint;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSavepoint", new Object[]{this, string});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        Savepoint savepoint = null;
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error(tc, "OP_NOT_VALID_IN_GT", "setSavepoint");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setSavepoint", "Exception");
                }
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setSavepoint"));
            }
            savepoint = this.connImpl.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setSavepoint(String)", "2116", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSavepoint", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSavepoint", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSavepoint", savepoint);
        }
        return savepoint;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        int n;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "rollback", new Object[]{this, savepoint});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        if (this.mcf.isEndToEndMonitoringFeatureEnabled()) {
            n = this.mcf.shouldDataBeCollectedAndPshedDownToCMX();
            AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, n != 0, this.managedConn.getJ2EEName(), this.mcf.appServerName, this.mcf.getInternalDataStoreHelper(), 120, n != 0 ? AdapterUtil.getcmxArgsObject(4, null, null, this, null, null, null) : null, this.connImpl);
        }
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error(tc, "OP_NOT_VALID_IN_GT", "rollback");
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "rollback", "Exception");
                }
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "rollback"));
            }
            if (this.metrics.isInteractionMetricsEnabled()) {
                this.pmiRollback(savepoint);
            } else {
                this.connImpl.rollback(savepoint);
            }
            for (n = this.childWrappers.size() - 1; n > -1; --n) {
                ((WSJdbcStatement)this.childWrappers.get(n)).closeChildWrappers();
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.rollback(Savepoint)", "2141", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "rollback", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "rollback", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "rollback");
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseSavepoint", new Object[]{this, savepoint});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error(tc, "OP_NOT_VALID_IN_GT", "releaseSavepoint");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "releaseSavepoint", "Exception");
                }
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "releaseSavepoint"));
            }
            this.connImpl.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.releaseSavepoint", "2169", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseSavepoint", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseSavepoint", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseSavepoint");
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Statement statement;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatement", new Object[]{this, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2), AdapterUtil.getCursorHoldabilityString(n3)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            statement = this.connImpl.createStatement(n, n2, n3);
            statement = this.createStatementWrapper(statement, n3);
            this.childWrappers.add(statement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.createStatement(int, int, int)", "2268", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatement", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatement", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatement", statement);
        }
        return statement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareStatement", new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2), AdapterUtil.getCursorHoldabilityString(n3)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey pSCacheKey = new PSCacheKey(string, n, n2, n3, 0, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(pSCacheKey);
                preparedStatement = object == null ? (this.pmi == null ? this.connImpl.prepareStatement(string, n, n2, n3) : this.pmiPrepareStatement(string, n, n2, n3)) : this.resetStatement((PreparedStatement)object);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, n3, string, pSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, n, n2, n3) : this.pmiPrepareStatement(string, n, n2, n3);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, n3, string);
            }
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement(String, int, int, int)", "2380", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareCall", new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2), AdapterUtil.getCursorHoldabilityString(n3)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                CSCacheKey cSCacheKey = new CSCacheKey(string, n, n2, n3, this.helper.getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(cSCacheKey);
                callableStatement = object == null ? (this.pmi == null ? this.connImpl.prepareCall(string, n, n2, n3) : this.pmiPrepareCall(string, n, n2, n3)) : this.resetStatement((CallableStatement)object);
                callableStatement = this.createCallableStatementWrapper(callableStatement, n3, string, cSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                callableStatement = this.pmi == null ? this.connImpl.prepareCall(string, n, n2, n3) : this.pmiPrepareCall(string, n, n2, n3);
                callableStatement = this.createCallableStatementWrapper(callableStatement, n3, string);
            }
            this.childWrappers.add(callableStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareCall(String, int, int, int)", "2492", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareCall", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareCall", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareCall", callableStatement);
        }
        return callableStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareStatement", new Object[]{this, string, AdapterUtil.getAutoGeneratedKeyString(n)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey pSCacheKey = new PSCacheKey(string, 1003, 1007, this.managedConn.getCurrentHoldability(), n, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(pSCacheKey);
                preparedStatement = object == null ? (this.pmi == null ? this.connImpl.prepareStatement(string, n) : this.pmiPrepareStatement(string, n)) : this.resetStatement((PreparedStatement)object);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability(), string, pSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, n) : this.pmiPrepareStatement(string, n);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability(), string);
            }
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement(String, int)", "2604", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareStatement", AdapterUtil.populateArrayForTrace(new Object[]{this, string, nArray}));
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, nArray) : this.pmiPrepareStatement(string, nArray);
            preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability(), string);
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement(String, int[])", "2717", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "prepareStatement", AdapterUtil.populateArrayForTrace(new Object[]{this, string, stringArray}));
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, stringArray) : this.pmiPrepareStatement(string, stringArray);
            preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability(), string);
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement(String, String[])", "2827", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "prepareStatement", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepareStatement", preparedStatement);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallableStatement pmiPrepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            CallableStatement callableStatement = this.connImpl.prepareCall(string, n, n2, n3);
            return callableStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, n, n2, n3);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int n) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, n);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int[] nArray) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, nArray);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, stringArray);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    public void setClientInformation(Properties properties) throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        if (properties != null) {
            this.clientProps = (Properties)properties.clone();
            this.mcf.getInternalDataStoreHelper().setClientInformation(properties, this.managedConn, true);
        } else {
            this.mcf.getInternalDataStoreHelper().resetClientInformation(this.managedConn);
        }
    }

    public Properties getClientInformation() {
        return this.clientProps;
    }

    public WSSystemMonitor getSystemMonitor() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        return this.mcf.getInternalDataStoreHelper().getSystemMonitor(this.managedConn);
    }

    public final void clearStatementCache() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearStatementCache on MC : ", this.managedConn);
        }
        this.managedConn.clearStatementCache();
    }

    public void setThreadID(Object object, Object object2) throws DataStoreAdapterException {
        if (object2 != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        this.threadID = object;
    }

    public Connection getNativeConnection(long l) throws SQLException {
        if (l != 29497789L) {
            throw new SQLException(AdapterUtil.getNLSMessage("NOT_A_JDBC_METHOD"));
        }
        return this.connImpl;
    }
}

