/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.JDBCConnectionSpec;
import com.ibm.websphere.rsadapter.WSCciConnectionSpec;
import com.ibm.websphere.rsadapter.WSDataSource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.rsadapter.WSOptimizedDataSource;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;

public class WSJdbcDataSource
implements WSDataSource,
Referenceable,
Serializable,
FFDCSelfIntrospectable,
WSOptimizedDataSource {
    private static final long serialVersionUID = 3264355765813798026L;
    private static final TraceComponent tc = Tr.register(WSJdbcDataSource.class, "RRA", "IBMDataStoreAdapterNLS");
    WSManagedConnectionFactoryImpl managedConnFactory;
    private ConnectionManager cm;
    private CMConfigData cmConfigData;
    private int defaultIsolationLevel;
    private Reference reference;
    private transient DataStoreHelper dSHelper;
    private transient InternalDataStoreHelper internalHelper;
    private transient boolean supportIsolvlSwitching = false;
    private transient Properties extendedDSProps;
    private int extendedDSPropsKey;
    private transient J2EEName _j2eeNameObj = null;
    int configID;
    private static final long PASSKEY = 262144L;
    private static final WSConnectionRequestInfoImpl[] defaultCRIs;
    private static final WSConnectionRequestInfoImpl[] defaultCRIsWithSwitch;
    static /* synthetic */ Class class$java$io$PrintWriter;

    public WSJdbcDataSource(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl, ConnectionManager connectionManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{wSManagedConnectionFactoryImpl, connectionManager});
        }
        this.managedConnFactory = wSManagedConnectionFactoryImpl;
        this.cm = connectionManager;
        this.dSHelper = this.managedConnFactory.getDataStoreHelper();
        this.cmConfigData = WSManagedConnectionFactoryImpl.locationRestrictedFunction.getCMConfigData(this.cm);
        this.internalHelper = wSManagedConnectionFactoryImpl.getInternalDataStoreHelper();
        this.supportIsolvlSwitching = this.internalHelper.isIsolationLevelSwitchingSupport();
        try {
            if (this.cmConfigData != null) {
                String string;
                this.defaultIsolationLevel = this.cmConfigData.getIsolationLevel();
                if (this.defaultIsolationLevel == 0) {
                    this.defaultIsolationLevel = this.dSHelper.getIsolationLevel(null);
                }
                if ((string = this.cmConfigData.getPurgePolicy()) != null) {
                    wSManagedConnectionFactoryImpl.setPurgePolicyInternal(string);
                } else {
                    wSManagedConnectionFactoryImpl.setPurgePolicyInternal("FailingConnectionOnly");
                }
                this.extendedDSProps = this.cmConfigData.getHPproperties();
                this._j2eeNameObj = this.cmConfigData.getJ2EEName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Res-Ref connection prop (i.e. Heterogenous pooling properties) are set to : ", this.extendedDSProps);
                }
                if (this.extendedDSProps != null) {
                    this.extendedDSPropsKey = this.cmConfigData.getPrimeID();
                    Properties properties = (Properties)wSManagedConnectionFactoryImpl.getDBDSProperties().clone();
                    properties.putAll((Map<?, ?>)this.extendedDSProps);
                    this.extendedDSProps = properties;
                    this.extendedDSProps = DSConfigurationHelper.validateAndAdjustHPProps(wSManagedConnectionFactoryImpl.getDataSourceClassName(), this.extendedDSProps);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Combined DS and Res-Ref connection prop is : ", this.extendedDSProps);
                    }
                }
            } else {
                this.defaultIsolationLevel = this.dSHelper.getIsolationLevel(null);
                wSManagedConnectionFactoryImpl.setPurgePolicyInternal("FailingConnectionOnly");
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.<init>", "100", this);
            String string = System.getProperty("line.separator");
            Tr.warning(tc, "DSA_ERROR", new Object[]{"Unable to determine the WebSphere default isolation level from the DataStoreHelper" + string + "Defaulting to READ COMMITTED." + string + this.dSHelper + string + AdapterUtil.stackTraceToString(resourceException)});
            this.defaultIsolationLevel = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{this, object});
        }
        try {
            WSJdbcDataSource wSJdbcDataSource = (WSJdbcDataSource)object;
            bl = this.cm.equals(wSJdbcDataSource.cm) && this.managedConnFactory.equals(wSJdbcDataSource.managedConnFactory, this.configID, wSJdbcDataSource.configID);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    public final Connection getConnection() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnection");
        }
        if (this.managedConnFactory.jmsOnePhaseOptimization) {
            throw new SQLException(AdapterUtil.getNLSMessage("INVALID_OPERATION1"));
        }
        int n = this.cmConfigData != null && this.cmConfigData.isCMP1_x() ? WSManagedConnectionFactoryImpl.locationRestrictedFunction.getIsolationLevelFromContainer(this.defaultIsolationLevel) : this.defaultIsolationLevel;
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = null;
        if (this.configID == 0) {
            if (!(this.managedConnFactory.ispropagateClientIdentityUsingTrustedContextEnabled() || this.extendedDSProps != null || this.managedConnFactory.getOptimizedForGetUseClose() || this.managedConnFactory.shouldDataBeCollectedAndPshedDownToCMX())) {
                wSConnectionRequestInfoImpl = !this.supportIsolvlSwitching ? (n < defaultCRIs.length ? defaultCRIs[n] : new WSConnectionRequestInfoImpl(n, true)) : (n < defaultCRIsWithSwitch.length ? defaultCRIsWithSwitch[n] : new WSConnectionRequestInfoImpl(n, true, true, false));
            } else {
                wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(null, null, n, this.configID, false, this.supportIsolvlSwitching, false);
                wSConnectionRequestInfoImpl.markAsChangable();
                wSConnectionRequestInfoImpl.setHeterogeneousProperties(this.extendedDSProps, this.extendedDSPropsKey);
                wSConnectionRequestInfoImpl.setOptimizeForGetUseClose(this.managedConnFactory.getOptimizedForGetUseClose());
                wSConnectionRequestInfoImpl.setJ2EEName(this._j2eeNameObj);
            }
        } else {
            wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(null, null, n, this.configID, false, this.supportIsolvlSwitching, false);
            if (this.managedConnFactory.ispropagateClientIdentityUsingTrustedContextEnabled() || this.extendedDSProps != null || this.managedConnFactory.getOptimizedForGetUseClose() || this.managedConnFactory.shouldDataBeCollectedAndPshedDownToCMX()) {
                wSConnectionRequestInfoImpl.markAsChangable();
                wSConnectionRequestInfoImpl.setHeterogeneousProperties(this.extendedDSProps, this.extendedDSPropsKey);
                wSConnectionRequestInfoImpl.setOptimizeForGetUseClose(this.managedConnFactory.getOptimizedForGetUseClose());
                wSConnectionRequestInfoImpl.setJ2EEName(this._j2eeNameObj);
            }
        }
        return this.getConnection(wSConnectionRequestInfoImpl);
    }

    private WSJdbcConnection getConnection(ConnectionRequestInfo connectionRequestInfo) throws SQLException {
        WSJdbcConnection wSJdbcConnection;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnection", new Object[]{this, AdapterUtil.toString(connectionRequestInfo)});
        }
        try {
            wSJdbcConnection = (WSJdbcConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.managedConnFactory, connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getConnection", "299", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnection", "Exception");
            }
            throw AdapterUtil.toSQLException(resourceException);
        }
        try {
            wSJdbcConnection.initialize(this.cm);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getConnection", "280", this);
            SQLException sQLException2 = WSJdbcUtil.mapException(wSJdbcConnection, sQLException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnection", sQLException2);
            }
            throw sQLException2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnection", wSJdbcConnection);
        }
        return wSJdbcConnection;
    }

    public Connection getConnection(JDBCConnectionSpec jDBCConnectionSpec) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnection", jDBCConnectionSpec);
        }
        if (this.managedConnFactory.jmsOnePhaseOptimization) {
            throw new SQLException(AdapterUtil.getNLSMessage("INVALID_OPERATION1"));
        }
        int n = jDBCConnectionSpec.getTransactionIsolation();
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(jDBCConnectionSpec.getUserName(), jDBCConnectionSpec.getPassword(), n == 0 ? this.defaultIsolationLevel : n, jDBCConnectionSpec.getCatalog(), jDBCConnectionSpec.isReadOnly(), jDBCConnectionSpec.getTypeMap(), jDBCConnectionSpec.getHoldability(), this.configID, true, this.supportIsolvlSwitching, false, false);
        if (this.managedConnFactory.ispropagateClientIdentityUsingTrustedContextEnabled() || this.extendedDSProps != null || this.managedConnFactory.getOptimizedForGetUseClose() || this.managedConnFactory.shouldDataBeCollectedAndPshedDownToCMX()) {
            wSConnectionRequestInfoImpl.markAsChangable();
            wSConnectionRequestInfoImpl.setHeterogeneousProperties(this.extendedDSProps, this.extendedDSPropsKey);
            wSConnectionRequestInfoImpl.setOptimizeForGetUseClose(this.managedConnFactory.getOptimizedForGetUseClose());
            wSConnectionRequestInfoImpl.setJ2EEName(this._j2eeNameObj);
        }
        return this.getConnection(wSConnectionRequestInfoImpl);
    }

    public final Connection getConnection(long l, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnection(passkey,shareWithCMPOnly )", new Object[]{"******", new Boolean(bl)});
        }
        if (bl && !this.managedConnFactory.jmsOnePhaseOptimization) {
            throw new SQLException(AdapterUtil.getNLSMessage("INVALID_OPERATION2"));
        }
        if (l == 262144L) {
            int n = this.cmConfigData != null && this.cmConfigData.isCMP1_x() ? WSManagedConnectionFactoryImpl.locationRestrictedFunction.getIsolationLevelFromContainer(this.defaultIsolationLevel) : this.defaultIsolationLevel;
            WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(null, null, n, this.configID, !bl, this.supportIsolvlSwitching, bl);
            if (this.managedConnFactory.ispropagateClientIdentityUsingTrustedContextEnabled() || this.extendedDSProps != null || this.managedConnFactory.getOptimizedForGetUseClose() || this.managedConnFactory.shouldDataBeCollectedAndPshedDownToCMX()) {
                wSConnectionRequestInfoImpl.markAsChangable();
                wSConnectionRequestInfoImpl.setHeterogeneousProperties(this.extendedDSProps, this.extendedDSPropsKey);
                wSConnectionRequestInfoImpl.setOptimizeForGetUseClose(this.managedConnFactory.getOptimizedForGetUseClose());
                wSConnectionRequestInfoImpl.setJ2EEName(this._j2eeNameObj);
            }
            return this.getConnection(wSConnectionRequestInfoImpl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "passkey not valid");
        }
        throw new SQLException(AdapterUtil.getNLSMessage("INVALID_OPERATION"));
    }

    public final Connection getConnection(String string, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnection", new Object[]{string, string2 == null ? string2 : "******"});
        }
        if (this.managedConnFactory.jmsOnePhaseOptimization) {
            throw new SQLException(AdapterUtil.getNLSMessage("INVALID_OPERATION1"));
        }
        int n = this.cmConfigData != null && this.cmConfigData.isCMP1_x() ? WSManagedConnectionFactoryImpl.locationRestrictedFunction.getIsolationLevelFromContainer(this.defaultIsolationLevel) : this.defaultIsolationLevel;
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(string, string2, n, this.configID, false, this.supportIsolvlSwitching, false);
        if (this.managedConnFactory.ispropagateClientIdentityUsingTrustedContextEnabled() || this.extendedDSProps != null || this.managedConnFactory.getOptimizedForGetUseClose() || this.managedConnFactory.shouldDataBeCollectedAndPshedDownToCMX()) {
            wSConnectionRequestInfoImpl.markAsChangable();
            wSConnectionRequestInfoImpl.setHeterogeneousProperties(this.extendedDSProps, this.extendedDSPropsKey);
            wSConnectionRequestInfoImpl.setOptimizeForGetUseClose(this.managedConnFactory.getOptimizedForGetUseClose());
            wSConnectionRequestInfoImpl.setJ2EEName(this._j2eeNameObj);
        }
        return this.getConnection(wSConnectionRequestInfoImpl);
    }

    public Connection getConnection(WSCciConnectionSpec wSCciConnectionSpec) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getConnection(" + WSCciConnectionSpec.class.getName() + ")", DataSource.class.getName()}));
    }

    public final DataStoreHelper getDataStoreHelper() {
        return this.dSHelper;
    }

    public final InternalDataStoreHelper getInternalDataStoreHelper() {
        return this.internalHelper;
    }

    public final int getLoginTimeout() throws SQLException {
        return this.managedConnFactory.getLoginTimeout(this.configID);
    }

    public final PrintWriter getLogWriter() throws SQLException {
        return this.managedConnFactory.getLogWriter(this.configID);
    }

    public final Reference getReference() {
        return this.reference;
    }

    public final int hashCode() {
        return this.managedConnFactory.hashCode() + this.cm.hashCode() + this.configID;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("Connection Manager Configuration Data:", this.cmConfigData);
        fFDCLogger.append("Isolation Level:", AdapterUtil.getIsolationLevelString(this.defaultIsolationLevel));
        fFDCLogger.append("Current Configuration ID: " + this.configID);
        fFDCLogger.append("Reference:", this.reference);
        fFDCLogger.introspect("Connection Manager:", this.cm);
        fFDCLogger.introspect("ManagedConnectionFactory:", this.managedConnFactory);
        return fFDCLogger.toStringArray();
    }

    public final boolean isXADataSource() {
        return this.managedConnFactory.isJTAEnabled();
    }

    public void setLoginTimeout(int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLoginTimeout", new Integer(n));
        }
        try {
            this.configID = this.managedConnFactory.configureDataSource("setLoginTimeout", new Object[]{new Integer(n)}, new Class[]{Integer.TYPE}, this.configID);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".setLoginTimeout", "491", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setLoginTimeout", sQLException);
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLoginTimeout");
        }
    }

    public void setLogWriter(final PrintWriter printWriter) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLogWriter", AdapterUtil.toString(printWriter));
        }
        try {
            this.configID = (Integer)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Integer(WSJdbcDataSource.this.managedConnFactory.configureDataSource("setLogWriter", new Object[]{printWriter}, new Class[]{class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = WSJdbcDataSource.class$("java.io.PrintWriter")) : class$java$io$PrintWriter}, WSJdbcDataSource.this.configID));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), this.getClass().getName() + ".setLogWriter", "522", this);
            SQLException sQLException = AdapterUtil.toSQLException(privilegedActionException.getException());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setLogWriter", sQLException);
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLogWriter");
        }
    }

    public final void setReference(Reference reference) {
        this.reference = reference;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Referenceable Object set to:", reference);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating default, reusable ConnectionRequestInfo instances.");
        }
        defaultCRIs = new WSConnectionRequestInfoImpl[9];
        WSJdbcDataSource.defaultCRIs[0] = new WSConnectionRequestInfoImpl(0, true);
        WSJdbcDataSource.defaultCRIs[1] = new WSConnectionRequestInfoImpl(1, true);
        WSJdbcDataSource.defaultCRIs[2] = new WSConnectionRequestInfoImpl(2, true);
        WSJdbcDataSource.defaultCRIs[4] = new WSConnectionRequestInfoImpl(4, true);
        WSJdbcDataSource.defaultCRIs[8] = new WSConnectionRequestInfoImpl(8, true);
        defaultCRIsWithSwitch = new WSConnectionRequestInfoImpl[9];
        WSJdbcDataSource.defaultCRIsWithSwitch[0] = new WSConnectionRequestInfoImpl(0, true, true, false);
        WSJdbcDataSource.defaultCRIsWithSwitch[1] = new WSConnectionRequestInfoImpl(1, true, true, false);
        WSJdbcDataSource.defaultCRIsWithSwitch[2] = new WSConnectionRequestInfoImpl(2, true, true, false);
        WSJdbcDataSource.defaultCRIsWithSwitch[4] = new WSConnectionRequestInfoImpl(4, true, true, false);
        WSJdbcDataSource.defaultCRIsWithSwitch[8] = new WSConnectionRequestInfoImpl(8, true, true, false);
    }
}

