/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class WSJdbcDatabaseMetaData
extends WSJdbcObject
implements DatabaseMetaData {
    private static final TraceComponent tc = Tr.register(WSJdbcDatabaseMetaData.class, "RRA", "IBMDataStoreAdapterNLS");
    private DatabaseMetaData mDataImpl;

    WSJdbcDatabaseMetaData(DatabaseMetaData databaseMetaData, WSJdbcConnection wSJdbcConnection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(databaseMetaData), wSJdbcConnection});
        }
        this.mDataImpl = databaseMetaData;
        this.parentWrapper = wSJdbcConnection;
        this.childWrappers = new ArrayList(8);
        this.pmi = wSJdbcConnection.pmi;
        this.metrics = this.parentWrapper.metrics;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this.mDataImpl.allProceduresAreCallable();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.allProceduresAreCallable", "68", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this.mDataImpl.allTablesAreSelectable();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.allTablesAreSelectable", "88", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final SQLException closeWrapper(boolean bl) {
        this.parentWrapper.childWrapper = null;
        this.mDataImpl = null;
        return null;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this.mDataImpl.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.dataDefinitionCausesTransactionCommit", "167", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this.mDataImpl.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.dataDefinitionIgnoredInTransactions", "187", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        try {
            return this.mDataImpl.deletesAreDetected(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.deletesAreDetected", "207", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this.mDataImpl.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.doesMaxRowSizeIncludeBlobs", "227", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getBestRowIdentifier(string, string2, string3, n, bl);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getBestRowIdentifier(string, string2, string3, n, bl);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getBestRowIdentifier", "254", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCatalogs() throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getCatalogs();
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getCatalogs();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getCatalogs", "280", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public String getCatalogSeparator() throws SQLException {
        try {
            return this.mDataImpl.getCatalogSeparator();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getCatalogSeparator", "300", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getCatalogTerm() throws SQLException {
        try {
            return this.mDataImpl.getCatalogTerm();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getCatalogTerm", "320", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getColumnPrivileges(string, string2, string3, string4);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getColumnPrivileges(string, string2, string3, string4);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getColumnPrivileges", "347", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getColumns(string, string2, string3, string4);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getColumns(string, string2, string3, string4);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getColumns", "374", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = (Connection)((Object)this.parentWrapper);
        if (this.state == 2 || connection == null) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
        }
        return connection;
    }

    protected final WSJdbcObject getConnectionWrapper() {
        return this.parentWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getCrossReference(string, string2, string3, string4, string5, string6);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getCrossReference(string, string2, string3, string4, string5, string6);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getCrossReference", "411", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public String getDatabaseProductName() throws SQLException {
        try {
            return this.mDataImpl.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDatabaseProductName", "431", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this.mDataImpl.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDatabaseProductVersion", "451", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this.mDataImpl.getDefaultTransactionIsolation();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDefaultTransactionIsolation", "471", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getDriverMajorVersion() {
        try {
            return this.mDataImpl.getDriverMajorVersion();
        }
        catch (NullPointerException nullPointerException) {
            if (this.state == 2) {
                throw new RuntimeException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
            }
            throw nullPointerException;
        }
    }

    public int getDriverMinorVersion() {
        try {
            return this.mDataImpl.getDriverMinorVersion();
        }
        catch (NullPointerException nullPointerException) {
            if (this.state == 2) {
                throw new RuntimeException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
            }
            throw nullPointerException;
        }
    }

    public String getDriverName() throws SQLException {
        try {
            return this.mDataImpl.getDriverName();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDriverName", "513", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getDriverVersion() throws SQLException {
        try {
            return this.mDataImpl.getDriverVersion();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDriverVersion", "533", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getExportedKeys(string, string2, string3);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getExportedKeys(string, string2, string3);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getExportedKeys", "560", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public String getExtraNameCharacters() throws SQLException {
        try {
            return this.mDataImpl.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getExtraNameCharacters", "580", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getIdentifierQuoteString() throws SQLException {
        try {
            return this.mDataImpl.getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getIdentifierQuoteString", "600", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getImportedKeys(string, string2, string3);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getImportedKeys(string, string2, string3);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getImportedKeys", "627", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getIndexInfo(string, string2, string3, bl, bl2);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getIndexInfo(string, string2, string3, bl, bl2);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getIndexInfo", "654", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    protected final Object getJDBCImplObject() {
        return this.mDataImpl;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxBinaryLiteralLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxBinaryLiteralLength", "674", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxCatalogNameLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxCatalogNameLength", "694", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxCharLiteralLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxCharLiteralLength", "714", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnNameLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnNameLength", "734", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInGroupBy();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInGroupBy", "754", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInIndex();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInIndex", "774", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInOrderBy();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInOrderBy", "794", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInSelect();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInSelect", "814", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this.mDataImpl.getMaxColumnsInTable();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxColumnsInTable", "834", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxConnections() throws SQLException {
        try {
            return this.mDataImpl.getMaxConnections();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxConnections", "854", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxCursorNameLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxCursorNameLength", "874", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxIndexLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxIndexLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxIndexLength", "894", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxProcedureNameLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxProcedureNameLength", "914", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxRowSize() throws SQLException {
        try {
            return this.mDataImpl.getMaxRowSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxRowSize", "934", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxSchemaNameLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxSchemaNameLength", "954", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxStatementLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxStatementLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxStatementLength", "974", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxStatements() throws SQLException {
        try {
            return this.mDataImpl.getMaxStatements();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxStatements", "994", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxTableNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxTableNameLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxTableNameLength", "1014", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this.mDataImpl.getMaxTablesInSelect();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxTablesInSelect", "1034", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxUserNameLength() throws SQLException {
        try {
            return this.mDataImpl.getMaxUserNameLength();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getMaxUserNameLength", "1054", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getNumericFunctions() throws SQLException {
        try {
            return this.mDataImpl.getNumericFunctions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getNumericFunctions", "1088", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getPrimaryKeys(string, string2, string3);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getPrimaryKeys(string, string2, string3);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getPrimaryKeys", "1115", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getProcedureColumns(string, string2, string3, string4);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getProcedureColumns(string, string2, string3, string4);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getProcedureColumns", "1143", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getProcedures(string, string2, string3);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getProcedures(string, string2, string3);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getProcedures", "1170", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public String getProcedureTerm() throws SQLException {
        try {
            return this.mDataImpl.getProcedureTerm();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getProcedureTerm", "1190", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getSchemas() throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getSchemas();
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getSchemas();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSchemas", "1216", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public String getSchemaTerm() throws SQLException {
        try {
            return this.mDataImpl.getSchemaTerm();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSchemaTerm", "1236", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getSearchStringEscape() throws SQLException {
        try {
            return this.mDataImpl.getSearchStringEscape();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSearchStringEscape", "1256", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getSQLKeywords() throws SQLException {
        try {
            return this.mDataImpl.getSQLKeywords();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSQLKeywords", "1276", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getStringFunctions() throws SQLException {
        try {
            return this.mDataImpl.getStringFunctions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getStringFunctions", "1296", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getSystemFunctions() throws SQLException {
        try {
            return this.mDataImpl.getSystemFunctions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSystemFunctions", "1316", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getTablePrivileges(string, string2, string3);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getTablePrivileges(string, string2, string3);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTablePrivileges", "1343", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getTables(string, string2, string3, stringArray);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getTables(string, string2, string3, stringArray);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTables", "1370", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTableTypes() throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getTableTypes();
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getTableTypes();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTableTypes", "1396", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public String getTimeDateFunctions() throws SQLException {
        try {
            return this.mDataImpl.getTimeDateFunctions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTimeDateFunctions", "1415", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final TraceComponent getTracer() {
        return tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTypeInfo() throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getTypeInfo();
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getTypeInfo();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getTypeInfo", "1450", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getUDTs(string, string2, string3, nArray);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getUDTs(string, string2, string3, nArray);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getUDTs", "1477", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public String getURL() throws SQLException {
        try {
            return this.mDataImpl.getURL();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getURL", "1497", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getUserName() throws SQLException {
        try {
            return this.mDataImpl.getUserName();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getUserName", "1517", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            try {
                if (this.pmi == null) {
                    resultSet = this.mDataImpl.getVersionColumns(string, string2, string3);
                    break block7;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    resultSet = this.mDataImpl.getVersionColumns(string, string2, string3);
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getVersionColumns", "1544", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        resultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(resultSet, this);
        this.childWrappers.add(resultSet);
        return resultSet;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        try {
            return this.mDataImpl.insertsAreDetected(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.insertsAreDetected", "1564", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        fFDCLogger.append("Underlying DatabaseMetaData: " + AdapterUtil.toString(this.mDataImpl), this.mDataImpl);
    }

    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this.mDataImpl.isCatalogAtStart();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.isCatalogAtStart", "1584", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.mDataImpl.isReadOnly();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.isReadOnly", "1604", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this.mDataImpl.nullPlusNonNullIsNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullPlusNonNullIsNull", "1624", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this.mDataImpl.nullsAreSortedAtEnd();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullsAreSortedAtEnd", "1644", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this.mDataImpl.nullsAreSortedAtStart();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullsAreSortedAtStart", "1664", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this.mDataImpl.nullsAreSortedHigh();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullsAreSortedHigh", "1684", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this.mDataImpl.nullsAreSortedLow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.nullsAreSortedLow", "1704", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        try {
            return this.mDataImpl.othersDeletesAreVisible(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.othersDeletesAreVisible", "1724", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        try {
            return this.mDataImpl.othersInsertsAreVisible(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.othersInsertsAreVisible", "1744", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        try {
            return this.mDataImpl.othersUpdatesAreVisible(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.othersUpdatesAreVisible", "1764", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        try {
            return this.mDataImpl.ownDeletesAreVisible(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.ownDeletesAreVisible", "1784", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        try {
            return this.mDataImpl.ownInsertsAreVisible(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.ownInsertsAreVisible", "1804", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        try {
            return this.mDataImpl.ownUpdatesAreVisible(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.ownUpdatesAreVisible", "1824", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesLowerCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesLowerCaseIdentifiers", "1844", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        if (this.state == 2) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
        }
        return runtimeException;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesLowerCaseQuotedIdentifiers", "1864", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesMixedCaseIdentifiers", "1885", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesMixedCaseQuotedIdentifiers", "1905", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesUpperCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesUpperCaseIdentifiers", "1925", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.storesUpperCaseQuotedIdentifiers", "1945", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this.mDataImpl.supportsAlterTableWithAddColumn();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsAlterTableWithAddColumn", "1965", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this.mDataImpl.supportsAlterTableWithDropColumn();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsAlterTableWithDropColumn", "1985", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this.mDataImpl.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsANSI92EntryLevelSQL", "2005", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this.mDataImpl.supportsANSI92FullSQL();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsANSI92FullSQL", "2025", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this.mDataImpl.supportsANSI92IntermediateSQL();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsANSI92IntermediateSQL", "2045", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this.mDataImpl.supportsBatchUpdates();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsBatchUpdates", "2065", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInDataManipulation();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInDataManipulation", "2085", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInIndexDefinitions", "2105", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInPrivilegeDefinitions", "2125", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInProcedureCalls", "2145", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCatalogsInTableDefinitions", "2165", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this.mDataImpl.supportsColumnAliasing();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsColumnAliasing", "2185", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsConvert() throws SQLException {
        try {
            return this.mDataImpl.supportsConvert();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsConvert", "2205", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        try {
            return this.mDataImpl.supportsConvert(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsConvert", "2225", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this.mDataImpl.supportsCoreSQLGrammar();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCoreSQLGrammar", "2245", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this.mDataImpl.supportsCorrelatedSubqueries();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsCorrelatedSubqueries", "2265", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this.mDataImpl.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions", "2286", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this.mDataImpl.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsDataManipulationTransactionsOnly", "2306", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this.mDataImpl.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsDifferentTableCorrelationNames", "2326", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this.mDataImpl.supportsExpressionsInOrderBy();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsExpressionsInOrderBy", "2346", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this.mDataImpl.supportsExtendedSQLGrammar();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsExtendedSQLGrammar", "2366", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this.mDataImpl.supportsFullOuterJoins();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsFullOuterJoins", "2386", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsGroupBy() throws SQLException {
        try {
            return this.mDataImpl.supportsGroupBy();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsGroupBy", "2406", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this.mDataImpl.supportsGroupByBeyondSelect();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsGroupByBeyondSelect", "2426", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this.mDataImpl.supportsGroupByUnrelated();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsGroupByUnrelated", "2446", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this.mDataImpl.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsIntegrityEnhancementFacility", "2466", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this.mDataImpl.supportsLikeEscapeClause();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsLikeEscapeClause", "2486", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this.mDataImpl.supportsLimitedOuterJoins();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsLimitedOuterJoins", "2506", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this.mDataImpl.supportsMinimumSQLGrammar();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMinimumSQLGrammar", "2526", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.supportsMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMixedCaseIdentifiers", "2546", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this.mDataImpl.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMixedCaseQuotedIdentifiers", "2566", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this.mDataImpl.supportsMultipleResultSets();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMultipleResultSets", "2586", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this.mDataImpl.supportsMultipleTransactions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMultipleTransactions", "2606", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this.mDataImpl.supportsNonNullableColumns();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsNonNullableColumns", "2626", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this.mDataImpl.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOpenCursorsAcrossCommit", "2646", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this.mDataImpl.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOpenCursorsAcrossRollback", "2666", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this.mDataImpl.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOpenStatementsAcrossCommit", "2686", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this.mDataImpl.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOpenStatementsAcrossRollback", "2706", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this.mDataImpl.supportsOrderByUnrelated();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOrderByUnrelated", "2726", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this.mDataImpl.supportsOuterJoins();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsOuterJoins", "2746", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this.mDataImpl.supportsPositionedDelete();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsPositionedDelete", "2766", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this.mDataImpl.supportsPositionedUpdate();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsPositionedUpdate", "2786", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        try {
            return this.mDataImpl.supportsResultSetConcurrency(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsResultSetConcurrency", "2807", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        try {
            return this.mDataImpl.supportsResultSetType(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsResultSetType", "2827", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInDataManipulation();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInDataManipulation", "2847", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInIndexDefinitions", "2867", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInPrivilegeDefinitions", "2887", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInProcedureCalls();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInProcedureCalls", "2907", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this.mDataImpl.supportsSchemasInTableDefinitions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSchemasInTableDefinitions", "2927", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this.mDataImpl.supportsSelectForUpdate();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSelectForUpdate", "2947", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this.mDataImpl.supportsStoredProcedures();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsStoredProcedures", "2967", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this.mDataImpl.supportsSubqueriesInComparisons();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSubqueriesInComparisons", "2987", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this.mDataImpl.supportsSubqueriesInExists();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSubqueriesInExists", "3007", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this.mDataImpl.supportsSubqueriesInIns();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSubqueriesInIns", "3027", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this.mDataImpl.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSubqueriesInQuantifieds", "3047", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this.mDataImpl.supportsTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsTableCorrelationNames", "3067", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        try {
            return this.mDataImpl.supportsTransactionIsolationLevel(n);
        }
        catch (SQLException sQLException) {
            if (n == 0 || n == 1 || n == 2 || n == 4 || n == 8) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsTransactionIsolationLevel", "3088", this);
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsTransactions() throws SQLException {
        try {
            return this.mDataImpl.supportsTransactions();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsTransactions", "3108", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsUnion() throws SQLException {
        try {
            return this.mDataImpl.supportsUnion();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsUnion", "3128", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsUnionAll() throws SQLException {
        try {
            return this.mDataImpl.supportsUnionAll();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsUnionAll", "3148", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        try {
            return this.mDataImpl.updatesAreDetected(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.updatesAreDetected", "3168", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this.mDataImpl.usesLocalFilePerTable();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.usesLocalFilePerTable", "3188", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean usesLocalFiles() throws SQLException {
        try {
            return this.mDataImpl.usesLocalFiles();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.usesLocalFiles", "3208", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        try {
            WSJdbcResultSet wSJdbcResultSet = null;
            wSJdbcResultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(this.mDataImpl.getAttributes(string, string2, string3, string4), this);
            this.childWrappers.add(wSJdbcResultSet);
            return wSJdbcResultSet;
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getAttributes"});
            SQLException sQLException = new SQLException("Unsupported Method: getAttributes");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getAttributes", "3279", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this.mDataImpl.getDatabaseMajorVersion();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getDatabaseMajorVersion"});
            SQLException sQLException = new SQLException("Unsupported Method: getDatabaseMajorVersion");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDatabaseMajorVersion", "3292", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this.mDataImpl.getDatabaseMinorVersion();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getDatabaseMinorVersion"});
            SQLException sQLException = new SQLException("Unsupported Method: getDatabaseMinorVersion");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getDatabaseMinorVersion", "3310", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getJDBCMajorVersion() throws SQLException {
        try {
            return this.mDataImpl.getJDBCMajorVersion();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getJDBCMajorVersion"});
            SQLException sQLException = new SQLException("Unsupported Method: getJDBCMajorVersion");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getJDBCMajorVersion", "3325", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getJDBCMinorVersion() throws SQLException {
        try {
            return this.mDataImpl.getJDBCMinorVersion();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getJDBCMinorVersion"});
            SQLException sQLException = new SQLException("Unsupported Method: getJDBCMinorVersion");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getJDBCMinorVersion", "3340", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.mDataImpl.getResultSetHoldability();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getResultSetHoldability"});
            SQLException sQLException = new SQLException("Unsupported Method: getResultSetHoldability");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getResultSetHoldability", "3355", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getSQLStateType() throws SQLException {
        try {
            return this.mDataImpl.getSQLStateType();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getSQLStateType"});
            SQLException sQLException = new SQLException("Unsupported Method: getSQLStateType");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSQLStateType", "3370", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        try {
            WSJdbcResultSet wSJdbcResultSet = null;
            wSJdbcResultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(this.mDataImpl.getSuperTables(string, string2, string3), this);
            this.childWrappers.add(wSJdbcResultSet);
            return wSJdbcResultSet;
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getSuperTables"});
            SQLException sQLException = new SQLException("Unsupported Method: getSuperTables");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSuperTables", "3385", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        try {
            WSJdbcResultSet wSJdbcResultSet = null;
            wSJdbcResultSet = ((WSJdbcConnection)this.parentWrapper).createResultSetWrapper(this.mDataImpl.getSuperTypes(string, string2, string3), this);
            this.childWrappers.add(wSJdbcResultSet);
            return wSJdbcResultSet;
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"getSuperTypes"});
            SQLException sQLException = new SQLException("Unsupported Method: getSuperTypes");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.getSuperTypes", "3399", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this.mDataImpl.locatorsUpdateCopy();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"locatorsUpdateCopy"});
            SQLException sQLException = new SQLException("Unsupported Method: locatorsUpdateCopy");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.locatorsUpdateCopy", "3414", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this.mDataImpl.supportsGetGeneratedKeys();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"supportsGetGeneratedKeys"});
            SQLException sQLException = new SQLException("Unsupported Method: supportsGetGeneratedKeys");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsGetGeneratedKeys", "3429", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this.mDataImpl.supportsNamedParameters();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"supportsNamedParameters"});
            SQLException sQLException = new SQLException("Unsupported Method: supportsNamedParameters");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsNamedParameters", "3444", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        try {
            return this.mDataImpl.supportsResultSetHoldability(n);
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"supportsResultSetHoldability"});
            SQLException sQLException = new SQLException("Unsupported Method: supportsResultSetHoldability");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsResultSetHoldability", "3460", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsSavepoints() throws SQLException {
        try {
            return this.mDataImpl.supportsSavepoints();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"supportsSavepoints"});
            SQLException sQLException = new SQLException("Unsupported Method: supportsSavepoints");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsSavepoints", "3475", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsStatementPooling() throws SQLException {
        try {
            return this.mDataImpl.supportsStatementPooling();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"supportsStatementPooling"});
            SQLException sQLException = new SQLException("Unsupported Method: supportsStatementPooling");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsStatementPooling", "3490", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this.mDataImpl.supportsMultipleOpenResults();
        }
        catch (AbstractMethodError abstractMethodError) {
            Tr.warning(tc, "UNSUPPORTED_JDBC30_METHOD", new Object[]{"supportsMultipleOpenResults"});
            SQLException sQLException = new SQLException("Unsupported Method: supportsMultipleOpenResults");
            sQLException.initCause(abstractMethodError);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData.supportsMultipleOpenResults", "3505", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }
}

