/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.j2c.InteractionMetrics;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.rsadapter.HandleStates;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class WSJdbcObject
implements HandleStates,
FFDCSelfIntrospectable {
    protected int state = 0;
    protected WSJdbcObject parentWrapper;
    protected WSJdbcObject childWrapper;
    protected ArrayList childWrappers;
    public J2CPerf pmi;
    public InteractionMetrics metrics;
    protected transient WSManagedConnectionFactoryImpl __mcf;

    protected void beginTransactionIfNecessary() throws SQLException {
        this.getConnectionWrapper().beginTransactionIfNecessary();
    }

    public void close() throws SQLException {
        this.close(false);
    }

    protected void close(boolean bl) throws SQLException {
        TraceComponent traceComponent = this.getTracer();
        if (traceComponent.isEntryEnabled()) {
            Tr.entry(traceComponent, "close", this);
        }
        if (this.state == 2) {
            if (traceComponent.isEventEnabled()) {
                Tr.event(traceComponent, "Already closed.");
            }
            if (traceComponent.isEntryEnabled()) {
                Tr.exit(traceComponent, "close");
            }
            return;
        }
        this.state = 2;
        if (traceComponent.isEventEnabled()) {
            Tr.event(traceComponent, "state --> " + this.getStateString());
        }
        this.closeChildWrappers();
        SQLException sQLException = this.closeWrapper(bl);
        this.parentWrapper = null;
        this.childWrappers = null;
        this.pmi = null;
        this.metrics = null;
        if (sQLException == null) {
            if (traceComponent.isEntryEnabled()) {
                Tr.exit(traceComponent, "close");
            }
        } else {
            if (traceComponent.isEntryEnabled()) {
                Tr.exit(traceComponent, "close", sQLException);
            }
            throw sQLException;
        }
    }

    protected final void closeChildWrappers() {
        TraceComponent traceComponent = this.getTracer();
        if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
            WSJdbcObject wSJdbcObject = null;
            int n = this.childWrappers.size();
            while (n > 0) {
                try {
                    wSJdbcObject = (WSJdbcObject)this.childWrappers.get(--n);
                    wSJdbcObject.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcObject.closeChildWrappers", "554", this);
                    Tr.warning(this.getTracer(), "ERR_CLOSING_CHILD", new Object[]{wSJdbcObject, sQLException});
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (traceComponent.isDebugEnabled()) {
                        Tr.debug(traceComponent, "ArrayIndexOutOfBoundsException is caught during closeChildWrappers() of the WSJdbcObject ", this);
                        Tr.debug(traceComponent, "Possible causes:");
                        Tr.debug(traceComponent, "multithreaded access of JDBC objects by the Application");
                        Tr.debug(traceComponent, "Application is closing JDBC objects in a finalize()");
                        Tr.debug(traceComponent, "Exception is: ", arrayIndexOutOfBoundsException);
                    }
                    throw arrayIndexOutOfBoundsException;
                }
            }
        }
        if (this.childWrapper != null) {
            try {
                this.childWrapper.close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcObject.closeChildWrappers", "573", this);
                Tr.warning(this.getTracer(), "ERR_CLOSING_CHILD", new Object[]{this.childWrapper, sQLException});
            }
        }
    }

    protected abstract SQLException closeWrapper(boolean var1);

    protected abstract WSJdbcObject getConnectionWrapper();

    protected abstract Object getJDBCImplObject();

    public final String getJNDIName() {
        return ((WSJdbcConnection)this.getConnectionWrapper()).mcf.getJndiName();
    }

    public final int getState() {
        return this.state;
    }

    public final String getStateString() {
        return STATE_STRINGS[this.state];
    }

    protected abstract TraceComponent getTracer();

    protected void introspectAll(FFDCLogger fFDCLogger) {
        fFDCLogger.append(this.toString());
        this.introspectWrapperSpecificInfo(fFDCLogger);
        fFDCLogger.append("Wrapper State: ", this.getStateString());
        fFDCLogger.append("Parent wrapper:", this.parentWrapper);
        fFDCLogger.append("Child wrapper:");
        fFDCLogger.indent(this.childWrapper);
        if (this.childWrappers != null) {
            try {
                fFDCLogger.append("# of Child Wrappers " + this.childWrappers.size());
                fFDCLogger.append("Child wrappers:");
                for (int i = 0; i < this.childWrappers.size(); ++i) {
                    fFDCLogger.indent(this.childWrappers.get(i));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        fFDCLogger.eoln();
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        WSJdbcObject wSJdbcObject = null;
        try {
            wSJdbcObject = this.getConnectionWrapper();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (wSJdbcObject == null || wSJdbcObject == this) {
            this.introspectAll(fFDCLogger);
        } else {
            fFDCLogger.append("Displaying FFDC information for wrapper hierarchy,");
            fFDCLogger.append("beginning from the Connection...");
            fFDCLogger.append(wSJdbcObject.introspectSelf());
        }
        return fFDCLogger.toStringArray();
    }

    protected void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
    }

    protected abstract RuntimeException runtimeXIfNotClosed(RuntimeException var1) throws SQLException;
}

