/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;

public class WSJdbcPreparedStatement
extends WSJdbcStatement
implements PreparedStatement {
    private static final TraceComponent tc = Tr.register(WSJdbcPreparedStatement.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final String[] PMI_EXECUTE = new String[]{PreparedStatement.class.getName(), "execute()"};
    private static final String[] PMI_EXECUTE_BATCH = new String[]{Statement.class.getName(), "executeBatch()"};
    private static final String[] PMI_EXECUTE_QUERY = new String[]{PreparedStatement.class.getName(), "executeQuery()"};
    private static final String[] PMI_EXECUTE_UPDATE = new String[]{PreparedStatement.class.getName(), "executeUpdate()"};
    protected PreparedStatement pstmtImpl;
    protected StatementCacheKey key;
    protected String sql;
    InternalDataStoreHelper internalHelper;

    protected WSJdbcPreparedStatement() {
    }

    protected WSJdbcPreparedStatement(PreparedStatement preparedStatement, WSJdbcConnection wSJdbcConnection, int n, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(preparedStatement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n)});
        }
        this.pstmtImpl = preparedStatement;
        this.stmtImpl = this.pstmtImpl;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.metrics = this.parentWrapper.metrics;
        this.sql = string;
        this.holdability = n;
        try {
            this.__mcf = ((WSJdbcConnection)this.parentWrapper).managedConn.getManagedConnectionFactory();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught something, we will just log and ignore.  This will only disable usage of mcf later (this, t)", new Object[]{this, throwable});
            }
            Tr.warning(tc, "WS_INTERNAL_WARNING", new Object[]{throwable, "", ""});
        }
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.<init>", "94", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current fetchSize is " + this.currentFetchSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    protected WSJdbcPreparedStatement(PreparedStatement preparedStatement, WSJdbcConnection wSJdbcConnection, int n, String string, StatementCacheKey statementCacheKey) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(preparedStatement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n), statementCacheKey});
        }
        this.pstmtImpl = preparedStatement;
        this.stmtImpl = this.pstmtImpl;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.metrics = this.parentWrapper.metrics;
        this.sql = string;
        this.key = statementCacheKey;
        this.holdability = n;
        try {
            this.__mcf = ((WSJdbcConnection)this.parentWrapper).managedConn.getManagedConnectionFactory();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught something, we will just log and ignore.  This will only disable usage of mcf later (this, t)", new Object[]{this, throwable});
            }
            Tr.warning(tc, "WS_INTERNAL_WARNING", new Object[]{throwable, "", ""});
        }
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.<init>", "184", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current fetchSize is " + this.currentFetchSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void setInternalHelper(InternalDataStoreHelper internalDataStoreHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInternalHelper");
        }
        this.internalHelper = internalDataStoreHelper;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInternalHelper");
        }
    }

    public void addBatch() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addBatch");
        }
        try {
            this.pstmtImpl.addBatch();
            this.hasBatchParameters = true;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.addBatch", "65", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void clearParameters() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearParameters");
        }
        try {
            this.pstmtImpl.clearParameters();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.clearParameters", "87", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected SQLException closeWrapper(boolean bl) {
        SQLException sQLException;
        block20: {
            sQLException = null;
            try {
                this.parentWrapper.childWrappers.remove(this);
            }
            catch (RuntimeException runtimeException) {
                if (this.parentWrapper.state == 2) break block20;
                throw runtimeException;
            }
        }
        if (this.key == null) {
            try {
                this.pstmtImpl.close();
            }
            catch (SQLException sQLException2) {
                FFDCFilter.processException((Throwable)sQLException2, this.getClass().getName() + ".closeWrapper", "264", this);
                Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{this.pstmtImpl, sQLException2});
                sQLException = sQLException2;
            }
        } else {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.parentWrapper;
            WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = wSJdbcConnection.managedConn;
            if (wSRdbManagedConnectionImpl == null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not associated with a ManagedConnection. Statement cannot be cached.");
                    }
                    this.pstmtImpl.close();
                }
                catch (SQLException sQLException3) {
                    FFDCFilter.processException((Throwable)sQLException3, this.getClass().getName() + ".closeWrapper", "281", this);
                    Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{this.pstmtImpl, sQLException3});
                    sQLException = sQLException3;
                }
            } else {
                try {
                    ResultSet resultSet = null;
                    while (this.pstmtImpl.getMoreResults() | this.pstmtImpl.getUpdateCount() != -1) {
                        resultSet = this.pstmtImpl.getResultSet();
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                    if (this.haveStatementPropertiesChanged) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cleaning up Statement");
                        }
                        wSJdbcConnection.helper.doStatementCleanup(this.pstmtImpl);
                        this.haveStatementPropertiesChanged = false;
                    }
                    if (this.hasBatchParameters) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Clearing batch parameters");
                        }
                        this.pstmtImpl.clearBatch();
                    }
                    wSRdbManagedConnectionImpl.cacheStatement(this.pstmtImpl, this.key);
                }
                catch (SQLException sQLException4) {
                    FFDCFilter.processException((Throwable)sQLException4, this.getClass().getName() + ".closeWrapper", "310", this);
                    sQLException = sQLException4;
                    try {
                        this.pstmtImpl.close();
                    }
                    catch (SQLException sQLException5) {
                        FFDCFilter.processException((Throwable)sQLException5, this.getClass().getName() + ".closeWrapper", "321", this);
                        Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{this.pstmtImpl, sQLException5});
                    }
                }
            }
        }
        this.stmtImpl = null;
        this.pstmtImpl = null;
        this.key = null;
        this.sql = null;
        return sQLException == null ? null : WSJdbcUtil.mapException(this, sQLException);
    }

    protected final void enforceStatementProperties() throws SQLException {
        if (this.requestedFetchSize != this.currentFetchSize) {
            this.stmtImpl.setFetchSize(this.requestedFetchSize);
            this.currentFetchSize = this.requestedFetchSize;
        }
    }

    public boolean execute() throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", this);
        }
        try {
            block14: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl2 = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl2, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl2 ? AdapterUtil.getcmxArgsObject(2, j2EEName, null, this, null, null, null) : null, this.pstmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            bl = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.pstmtImpl.execute() : this.pmiExecute();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.execute", "286", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", "SQLException");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", "NullPointerException");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        catch (RuntimeException runtimeException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Object[]{"RuntimeException", runtimeException});
            }
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", bl ? "QUERY" : "UPDATE");
        }
        return bl;
    }

    public ResultSet executeQuery() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeQuery", this);
        }
        WSJdbcResultSet wSJdbcResultSet = null;
        try {
            block14: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(2, j2EEName, null, this, null, null, null) : null, this.pstmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            wSJdbcResultSet = this.createResultSetWrapper(this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.pstmtImpl.executeQuery() : this.pmiExecuteQuery());
            this.childWrapper = wSJdbcResultSet;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.executeQuery", "371", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeQuery", "SQLException");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeQuery", "NullPointerException");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        catch (RuntimeException runtimeException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeQuery", new Object[]{"RuntimeException", runtimeException});
            }
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeQuery", this.childWrapper);
        }
        return wSJdbcResultSet;
    }

    public int executeUpdate() throws SQLException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeUpdate", this);
        }
        try {
            block14: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(2, j2EEName, null, this, null, null, null) : null, this.pstmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            n = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.pstmtImpl.executeUpdate() : this.pmiExecuteUpdate();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.executeUpdate", "449", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeUpdate", "SQLException");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeUpdate", "NullPpointerException");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        catch (RuntimeException runtimeException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeUpdate", new Object[]{"RuntimeException", runtimeException});
            }
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeUpdate", new Integer(n));
        }
        return n;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetaData", this);
        }
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSetMetaData = this.pstmtImpl.getMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.getMetaData", "621", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetaData", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetaData", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetaData", resultSetMetaData);
        }
        return resultSetMetaData;
    }

    protected TraceComponent getTracer() {
        return tc;
    }

    protected void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        super.introspectWrapperSpecificInfo(fFDCLogger);
        fFDCLogger.append("key:", this.key);
        fFDCLogger.append("sql:", this.sql);
    }

    private boolean pmiExecute() throws SQLException {
        boolean bl = false;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            bl = this.pstmtImpl.execute();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecute", "669", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecute", "676", this);
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", this.sql);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return bl;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    int[] pmiExecuteBatch() throws SQLException {
        int[] nArray = null;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_BATCH);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            nArray = this.stmtImpl.executeBatch();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteBatch", "749", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteBatch", "756", this);
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", this.sql);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return nArray;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private ResultSet pmiExecuteQuery() throws SQLException {
        ResultSet resultSet = null;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_QUERY);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            resultSet = this.pstmtImpl.executeQuery();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteQuery", "738", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteQuery", "745", this);
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", this.sql);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return resultSet;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private int pmiExecuteUpdate() throws SQLException {
        int n = 0;
        Object object = null;
        int n2 = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_UPDATE);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            n = this.pstmtImpl.executeUpdate();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteUpdate", "807", this);
            exception = sQLException;
            n2 = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteUpdate", "814", this);
            exception = runtimeException;
            n2 = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", this.sql);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n2, properties);
            }
        }
        if (exception == null) {
            return n;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    public void setArray(int n, Array array) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setArray #" + n);
        }
        try {
            this.pstmtImpl.setArray(n, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setArray", "500", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setAsciiStream #" + n, new Integer(n2));
        }
        try {
            this.pstmtImpl.setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setAsciiStream", "522", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBigDecimal #" + n);
        }
        try {
            this.pstmtImpl.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBigDecimal", "544", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBinaryStream #" + n, new Integer(n2));
        }
        try {
            this.pstmtImpl.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBinaryStream", "566", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBlob #" + n);
        }
        try {
            this.pstmtImpl.setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBlob", "588", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBoolean #" + n);
        }
        try {
            this.pstmtImpl.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBoolean", "610", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setByte #" + n);
        }
        try {
            this.pstmtImpl.setByte(n, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setByte", "632", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBytes #" + n);
        }
        try {
            this.internalHelper.psSetBytes(this.pstmtImpl, n, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBytes", "654", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBytes", "949", this);
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCharacterStream #" + n, new Integer(n2));
        }
        try {
            this.pstmtImpl.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setCharacterStream", "677", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setClob #" + n);
        }
        try {
            this.pstmtImpl.setClob(n, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setClob", "699", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDate #" + n);
        }
        try {
            this.pstmtImpl.setDate(n, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDate", "721", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDate with Calendar #" + n);
        }
        try {
            this.pstmtImpl.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDate", "743", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDouble #" + n);
        }
        try {
            this.pstmtImpl.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDouble", "765", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFloat #" + n);
        }
        try {
            this.pstmtImpl.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setFloat", "787", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setInt #" + n);
        }
        try {
            this.pstmtImpl.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setInt", "809", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setLong #" + n);
        }
        try {
            this.pstmtImpl.setLong(n, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setLong", "831", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNull #" + n, AdapterUtil.getSQLTypeString(n2));
        }
        try {
            this.pstmtImpl.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setNull", "854", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setNull #" + n, new Object[]{AdapterUtil.getSQLTypeString(n2), string});
        }
        try {
            this.pstmtImpl.setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setNull", "877", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject #" + n);
        }
        try {
            this.pstmtImpl.setObject(n, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", "899", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject #" + n, new Integer(n2));
        }
        try {
            this.pstmtImpl.setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", "921", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject #" + n, new Object[]{new Integer(n2), new Integer(n3)});
        }
        try {
            this.pstmtImpl.setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", "944", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRef #" + n);
        }
        try {
            this.pstmtImpl.setRef(n, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setRef", "966", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setShort #" + n);
        }
        try {
            this.pstmtImpl.setShort(n, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setShort", "988", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setString(int n, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setString #" + n);
        }
        try {
            this.internalHelper.psSetString(this.pstmtImpl, n, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setString", "1010", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setString", "1307", this);
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTime #" + n);
        }
        try {
            this.pstmtImpl.setTime(n, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTime", "1032", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTime with Calendar #" + n);
        }
        try {
            this.pstmtImpl.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTime", "1054", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimestamp #" + n);
        }
        try {
            this.pstmtImpl.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTimestamp", "1076", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setTimestamp with Calendar #" + n);
        }
        try {
            this.pstmtImpl.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTimestamp", "1098", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setUnicodeStream #" + n, new Integer(n2));
        }
        try {
            this.pstmtImpl.setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setUnicodeStream", "1120", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setURL", new Integer(n));
        }
        try {
            this.pstmtImpl.setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setURL", "1140", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParameterMetaData", this);
        }
        ParameterMetaData parameterMetaData = null;
        try {
            parameterMetaData = this.pstmtImpl.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.getParameterMetaData", "1442", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParameterMetaData", "Exception, details in FFDC");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getParameterMetaData", "Exception, details in FFDC");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParameterMetaData", parameterMetaData);
        }
        return parameterMetaData;
    }
}

