/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class WSJdbcResultSet
extends WSJdbcObject
implements ResultSet {
    private static final TraceComponent tc = Tr.register(WSJdbcResultSet.class, "RRA", "IBMDataStoreAdapterNLS");
    protected ResultSet rsetImpl;

    protected WSJdbcResultSet() {
    }

    protected WSJdbcResultSet(ResultSet resultSet, WSJdbcObject wSJdbcObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(resultSet), wSJdbcObject});
        }
        this.rsetImpl = resultSet;
        this.parentWrapper = wSJdbcObject;
        this.pmi = this.parentWrapper.pmi;
        this.metrics = this.parentWrapper.metrics;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean absolute(int n) throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            return this.rsetImpl.absolute(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.absolute", "93", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void afterLast() throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            this.rsetImpl.afterLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.afterLast", "118", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            this.rsetImpl.beforeFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.beforeFirst", "144", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelRowUpdates", this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.cancelRowUpdates();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.cancelRowUpdates();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.cancelRowUpdates", "183", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.rsetImpl.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.clearWarnings", "208", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected SQLException closeWrapper(boolean bl) {
        if (this.parentWrapper.childWrapper == this) {
            this.parentWrapper.childWrapper = null;
        } else {
            this.parentWrapper.childWrappers.remove(this);
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "closeWrapper skipping close of ResultSet implementation object");
            }
        } else {
            try {
                this.rsetImpl.close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.closeWrapper", "246", this);
                this.rsetImpl = null;
                return WSJdbcUtil.mapException(this, sQLException);
            }
        }
        this.rsetImpl = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleteRow", this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.deleteRow();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.deleteRow();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.deleteRow", "355", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public int findColumn(String string) throws SQLException {
        try {
            return this.rsetImpl.findColumn(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.findColumn", "384", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean first() throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            return this.rsetImpl.first();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.first", "411", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            return this.rsetImpl.getArray(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getArray", "438", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            return this.rsetImpl.getArray(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getArray", "465", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            return this.rsetImpl.getAsciiStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getAsciiStream", "501", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            return this.rsetImpl.getAsciiStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getAsciiStream", "537", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", "566", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", "596", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", "625", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", "656", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            return this.rsetImpl.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBinaryStream", "691", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            return this.rsetImpl.getBinaryStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBinaryStream", "727", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            return this.rsetImpl.getBlob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBlob", "754", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            return this.rsetImpl.getBoolean(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBoolean", "784", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            return this.rsetImpl.getBoolean(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBoolean", "813", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            return this.rsetImpl.getByte(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getByte", "842", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            return this.rsetImpl.getByte(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getByte", "871", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            return this.rsetImpl.getBytes(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBytes", "901", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            return this.rsetImpl.getBytes(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBytes", "931", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            return this.rsetImpl.getBlob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBlob", "958", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        try {
            return this.rsetImpl.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCharacterStream", "983", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        try {
            return this.rsetImpl.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCharacterStream", "1010", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(int n) throws SQLException {
        try {
            return this.rsetImpl.getClob(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getClob", "1037", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            return this.rsetImpl.getClob(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getClob", "1064", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            return this.rsetImpl.getConcurrency();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getConcurrency", "1092", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final WSJdbcObject getConnectionWrapper() {
        return this.parentWrapper.parentWrapper;
    }

    public String getCursorName() throws SQLException {
        try {
            return this.rsetImpl.getCursorName();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCursorName", "1129", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            return this.rsetImpl.getDate(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", "1158", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", "1190", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(String string) throws SQLException {
        try {
            return this.rsetImpl.getDate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", "1219", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", "1251", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            return this.rsetImpl.getDouble(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDouble", "1280", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            return this.rsetImpl.getDouble(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDouble", "1309", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.rsetImpl.getFetchDirection();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFetchDirection", "1336", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.rsetImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFetchSize", "1363", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            return this.rsetImpl.getFloat(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFloat", "1392", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            return this.rsetImpl.getFloat(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFloat", "1422", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            return this.rsetImpl.getInt(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getInt", "1451", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            return this.rsetImpl.getInt(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getInt", "1480", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final Object getJDBCImplObject() {
        return this.rsetImpl;
    }

    public long getLong(int n) throws SQLException {
        try {
            return this.rsetImpl.getLong(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getLong", "1509", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            return this.rsetImpl.getLong(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getLong", "1538", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetaData", this);
        }
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSetMetaData = this.rsetImpl.getMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getMetaData", "1579", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetaData", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMetaData", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetaData", resultSetMetaData);
        }
        return resultSetMetaData;
    }

    public Object getObject(int n) throws SQLException {
        try {
            return this.rsetImpl.getObject(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", "1617", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            return this.rsetImpl.getObject(n, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", "1646", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(String string) throws SQLException {
        try {
            return this.rsetImpl.getObject(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", "1684", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        try {
            return this.rsetImpl.getObject(string, map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", "1713", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            return this.rsetImpl.getRef(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRef", "1740", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Ref getRef(String string) throws SQLException {
        try {
            return this.rsetImpl.getRef(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRef", "1767", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getRow() throws SQLException {
        try {
            return this.rsetImpl.getRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRow", "1808", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            return this.rsetImpl.getShort(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getShort", "1837", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            return this.rsetImpl.getShort(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getShort", "1866", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Statement getStatement() throws SQLException {
        if (this.parentWrapper instanceof WSJdbcDatabaseMetaData) {
            return null;
        }
        Statement statement = (Statement)((Object)this.parentWrapper);
        if (this.state == 2 || statement == null) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "ResultSet"));
        }
        return statement;
    }

    public String getString(int n) throws SQLException {
        try {
            return this.rsetImpl.getString(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getString", "1926", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String getString(String string) throws SQLException {
        try {
            return this.rsetImpl.getString(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getString", "1955", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            return this.rsetImpl.getTime(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", "1984", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", "2016", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(String string) throws SQLException {
        try {
            return this.rsetImpl.getTime(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", "2045", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", "2077", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", "2106", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", "2138", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", "2167", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", "2199", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final TraceComponent getTracer() {
        return tc;
    }

    public int getType() throws SQLException {
        try {
            return this.rsetImpl.getType();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getType", "2235", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        try {
            return this.rsetImpl.getUnicodeStream(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getUnicodeStream", "2273", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            return this.rsetImpl.getUnicodeStream(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getUnicodeStream", "2312", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.rsetImpl.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getWarnings", "2345", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "insertRow", this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.insertRow();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.insertRow();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.insertRow", "2398", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    protected void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        fFDCLogger.append("Underlying ResultSet: " + AdapterUtil.toString(this.rsetImpl), this.rsetImpl);
    }

    public boolean isAfterLast() throws SQLException {
        try {
            return this.rsetImpl.isAfterLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isAfterLast", "2425", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.rsetImpl.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isBeforeFirst", "2452", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            return this.rsetImpl.isFirst();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isFirst", "2479", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean isLast() throws SQLException {
        try {
            return this.rsetImpl.isLast();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isLast", "2508", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean last() throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            return this.rsetImpl.last();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.last", "2535", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            this.rsetImpl.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.moveToCurrentRow", "2561", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            this.rsetImpl.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.moveToInsertRow", "2592", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean next() throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            return this.rsetImpl.next();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.next", "2624", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean previous() throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            return this.rsetImpl.previous();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.previous", "2654", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "refreshRow", this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.refreshRow();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.refreshRow();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.refreshRow", "2714", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public boolean relative(int n) throws SQLException {
        try {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.getConnectionWrapper();
            if (wSJdbcConnection.mcf.beginTranForResultSetScrollingAPIs) {
                wSJdbcConnection.beginTransactionIfNecessary();
            }
            return this.rsetImpl.relative(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.relative", "2748", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            return this.rsetImpl.rowDeleted();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowDeleted", "2777", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            return this.rsetImpl.rowInserted();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowInserted", "2805", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            return this.rsetImpl.rowUpdated();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowUpdated", "2833", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        if (this.state == 2) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "ResultSet"));
        }
        return runtimeException;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFetchDirection", new Object[]{this, AdapterUtil.getFetchDirectionString(n)});
        }
        try {
            this.rsetImpl.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.setFetchDirection", "2860", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFetchSize(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFetchSize", new Object[]{this, new Integer(n)});
        }
        try {
            this.rsetImpl.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.setFetchSize", "2891", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateAsciiStream", "2922", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateAsciiStream", "2953", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.rsetImpl.updateBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBigDecimal", "2983", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            this.rsetImpl.updateBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBigDecimal", "3013", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBinaryStream", "3044", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBinaryStream", "3075", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            this.rsetImpl.updateBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBoolean", "3105", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            this.rsetImpl.updateBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBoolean", "3135", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        try {
            this.rsetImpl.updateByte(n, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateByte", "3165", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        try {
            this.rsetImpl.updateByte(string, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateByte", "3195", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.rsetImpl.updateBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBytes", "3225", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            this.rsetImpl.updateBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBytes", "3255", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateCharacterStream", "3286", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateCharacterStream", "3317", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        try {
            this.rsetImpl.updateDate(n, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDate", "3347", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        try {
            this.rsetImpl.updateDate(string, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDate", "3377", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        try {
            this.rsetImpl.updateDouble(n, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDouble", "3407", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateDouble(String string, double d) throws SQLException {
        try {
            this.rsetImpl.updateDouble(string, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDouble", "3437", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        try {
            this.rsetImpl.updateFloat(n, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateFloat", "3467", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateFloat(String string, float f) throws SQLException {
        try {
            this.rsetImpl.updateFloat(string, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateFloat", "3497", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        try {
            this.rsetImpl.updateInt(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateInt", "3527", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateInt(String string, int n) throws SQLException {
        try {
            this.rsetImpl.updateInt(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateInt", "3557", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        try {
            this.rsetImpl.updateLong(n, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateLong", "3587", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateLong(String string, long l) throws SQLException {
        try {
            this.rsetImpl.updateLong(string, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateLong", "3617", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateNull(int n) throws SQLException {
        try {
            this.rsetImpl.updateNull(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateNull", "3646", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateNull(String string) throws SQLException {
        try {
            this.rsetImpl.updateNull(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateNull", "3675", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        try {
            this.rsetImpl.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", "3705", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            this.rsetImpl.updateObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", "3737", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        try {
            this.rsetImpl.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", "3767", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        try {
            this.rsetImpl.updateObject(string, object, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", "3799", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateRow", this);
            }
            try {
                this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
                if (this.pmi == null) {
                    this.rsetImpl.updateRow();
                    break block8;
                }
                try {
                    this.pmi.jdbcOperationStarted();
                    this.rsetImpl.updateRow();
                }
                finally {
                    this.pmi.jdbcOperationCompleted();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRow", "3851", this);
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        try {
            this.rsetImpl.updateShort(n, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateShort", "3881", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        try {
            this.rsetImpl.updateShort(string, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateShort", "3911", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateString(int n, String string) throws SQLException {
        try {
            this.rsetImpl.updateString(n, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateString", "3941", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        try {
            this.rsetImpl.updateString(string, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateString", "3971", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        try {
            this.rsetImpl.updateTime(n, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTime", "4001", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        try {
            this.rsetImpl.updateTime(string, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTime", "4031", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.rsetImpl.updateTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTimestamp", "4061", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            this.rsetImpl.updateTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTimestamp", "4091", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            return this.rsetImpl.wasNull();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.wasNull", "4119", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(int n) throws SQLException {
        try {
            return this.rsetImpl.getURL(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getURL", "3935", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            return this.rsetImpl.getURL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getURL", "3964", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        try {
            this.rsetImpl.updateArray(n, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateArray", "3993", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateArray(String string, Array array) throws SQLException {
        try {
            this.rsetImpl.updateArray(string, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateArray", "4009", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            this.rsetImpl.updateBlob(n, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBlob", "4038", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            this.rsetImpl.updateBlob(string, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBlob", "4066", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            this.rsetImpl.updateClob(n, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateClob", "4094", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            this.rsetImpl.updateClob(string, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateClob", "4123", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        try {
            this.rsetImpl.updateRef(n, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRef", "4152", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            this.rsetImpl.updateRef(string, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRef", "4180", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }
}

