/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

public class WSJdbcStatement
extends WSJdbcObject
implements Statement {
    private static final TraceComponent tc = Tr.register(WSJdbcStatement.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final String[] PMI_EXECUTE = new String[]{Statement.class.getName(), "execute(String)"};
    private static final String[] PMI_EXECUTE_KEYS = new String[]{Statement.class.getName(), "execute(String, int)"};
    private static final String[] PMI_EXECUTE_COL_INDICES = new String[]{Statement.class.getName(), "execute(String, int[])"};
    private static final String[] PMI_EXECUTE_COL_NAMES = new String[]{Statement.class.getName(), "execute(String, String[])"};
    private static final String[] PMI_EXECUTE_BATCH = new String[]{Statement.class.getName(), "executeBatch()"};
    private static final String[] PMI_EXECUTE_QUERY = new String[]{Statement.class.getName(), "executeQuery(String)"};
    private static final String[] PMI_EXECUTE_UPDATE = new String[]{Statement.class.getName(), "executeUpdate(String)"};
    private static final String[] PMI_EXECUTE_UPDATE_KEYS = new String[]{Statement.class.getName(), "executeUpdate(String, int)"};
    private static final String[] PMI_EXECUTE_UPDATE_COL_INDICES = new String[]{Statement.class.getName(), "executeUpdate(String, int[])"};
    private static final String[] PMI_EXECUTE_UPDATE_COL_NAMES = new String[]{Statement.class.getName(), "executeUpdate(String, String[])"};
    private static final TraceComponent clientInfoTc = Tr.register("WAS.clientinfopluslogging", "WAS.clientinfopluslogging", "IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;
    protected Statement stmtImpl;
    protected int currentFetchSize;
    int requestedFetchSize;
    boolean haveStatementPropertiesChanged;
    protected int holdability;
    boolean hasBatchParameters;

    protected WSJdbcStatement() {
    }

    protected WSJdbcStatement(Statement statement, WSJdbcConnection wSJdbcConnection, int n) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(statement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n)});
            }
            this.stmtImpl = statement;
            this.parentWrapper = wSJdbcConnection;
            this.pmi = wSJdbcConnection.pmi;
            this.metrics = this.parentWrapper.metrics;
            try {
                this.__mcf = ((WSJdbcConnection)this.parentWrapper).managedConn.getManagedConnectionFactory();
            }
            catch (ClassCastException classCastException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught a ClassCastException while trying to get mcf to store for this object: (this, cce)", new Object[]{this, classCastException});
                }
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught a NPE while trying to get mcf to store for this object: (this, npe)", new Object[]{this, nullPointerException});
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Caught something, we will just log and ignore.  This will only disable usage of mcf later (this, t)", new Object[]{this, throwable});
            }
        }
        this.holdability = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void addBatch(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addBatch", new Object[]{this, string});
        }
        try {
            this.stmtImpl.addBatch(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.addBatch", "70", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void cancel() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancel", this);
        }
        try {
            this.stmtImpl.cancel();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.cancel", "94", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cancel", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cancel", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
    }

    public void clearBatch() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearBatch", this);
        }
        try {
            this.stmtImpl.clearBatch();
            this.hasBatchParameters = false;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.clearBatch", "116", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.stmtImpl.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.clearWarnings", "136", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected final void closeAndRemoveResultSet() {
        this.closeAndRemoveResultSet(false);
    }

    protected final void closeAndRemoveResultSet(boolean bl) {
        try {
            this.childWrapper.close(bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.closeAndRemoveResultSet", "275", this);
            Tr.warning(tc, "ERR_CLOSING_OBJECT", new Object[]{this.childWrapper, sQLException});
        }
        this.childWrapper = null;
    }

    protected final void closeAndRemoveResultSets() {
        this.closeAndRemoveResultSets(false);
    }

    protected final void closeAndRemoveResultSets(boolean bl) {
        for (int i = this.childWrappers.size() - 1; i > -1; --i) {
            try {
                ((WSJdbcObject)this.childWrappers.get(i)).close(bl);
                continue;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.closeAndRemoveResultSets", "277", this);
                Tr.warning(tc, "ERR_CLOSING_OBJECT", sQLException);
            }
        }
    }

    protected SQLException closeWrapper(boolean bl) {
        block4: {
            try {
                this.parentWrapper.childWrappers.remove(this);
            }
            catch (RuntimeException runtimeException) {
                if (this.parentWrapper.state == 2) break block4;
                throw runtimeException;
            }
        }
        try {
            this.stmtImpl.close();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.closeWrapper", "314", this);
            this.stmtImpl = null;
            return WSJdbcUtil.mapException(this, sQLException);
        }
        this.stmtImpl = null;
        return null;
    }

    protected WSJdbcResultSet createResultSetWrapper(ResultSet resultSet) {
        return new WSJdbcResultSet(resultSet, this);
    }

    protected void enforceStatementProperties() throws SQLException {
        if (this.requestedFetchSize != this.currentFetchSize) {
            this.stmtImpl.setFetchSize(this.requestedFetchSize);
            this.currentFetchSize = this.requestedFetchSize;
        }
    }

    public boolean execute(String string) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "execute", new Object[]{this, string});
        }
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl2 = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl2, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl2 ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            bl = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.execute(string) : this.pmiExecute(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.execute", "296", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "execute", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "execute", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "execute", bl ? "QUERY" : "UPDATE");
        }
        return bl;
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray;
        Object object;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "executeBatch", this);
        }
        try {
            block21: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                object = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        object = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = ((WSRdbManagedConnectionImpl)object).getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, ((WSRdbManagedConnectionImpl)object).getManagedConnectionFactory().appServerName, ((WSRdbManagedConnectionImpl)object).getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            nArray = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.executeBatch() : this.pmiExecuteBatch();
            this.hasBatchParameters = false;
        }
        catch (BatchUpdateException batchUpdateException) {
            FFDCFilter.processException((Throwable)batchUpdateException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeBatch", "357", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Check for Connection Error", new Object[]{AdapterUtil.getStackTraceWithState(batchUpdateException)});
            }
            try {
                WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.parentWrapper;
                if (wSJdbcConnection.helper.isConnectionError(batchUpdateException)) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Encountered a Stale Connection: ", wSJdbcConnection);
                    }
                    wSJdbcConnection.fireConnectionErrorEvent(batchUpdateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "executeBatch", "Exception");
                }
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeBatch", "Exception");
            }
            throw batchUpdateException;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeBatch", "384", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeBatch", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeBatch", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            object = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                ((StringBuffer)object).append(i).append(' ');
            }
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "executeBatch", new String((StringBuffer)object));
        }
        return nArray;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "executeQuery", new Object[]{this, string});
        }
        WSJdbcResultSet wSJdbcResultSet = null;
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            wSJdbcResultSet = this.createResultSetWrapper(this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.executeQuery(string) : this.pmiExecuteQuery(string));
            this.childWrapper = wSJdbcResultSet;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeQuery", "459", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeQuery", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeQuery", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "executeQuery", this.childWrapper);
        }
        return wSJdbcResultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        int n;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "executeUpdate", new Object[]{this, string});
        }
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            n = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.executeUpdate(string) : this.pmiExecuteUpdate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeUpdate", "522", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeUpdate", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeUpdate", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "executeUpdate", new Integer(n));
        }
        return n;
    }

    public final Connection getConnection() throws SQLException {
        Connection connection = (Connection)((Object)this.parentWrapper);
        if (this.state == 2 || connection == null) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement"));
        }
        return connection;
    }

    protected final WSJdbcObject getConnectionWrapper() {
        return this.parentWrapper;
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.stmtImpl.getFetchDirection();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getFetchDirection", "551", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getFetchSize() throws SQLException {
        if (this.state == 2) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement"));
        }
        return this.requestedFetchSize;
    }

    protected final Object getJDBCImplObject() {
        return this.stmtImpl;
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.stmtImpl.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMaxFieldSize", "591", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.stmtImpl.getMaxRows();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMaxRows", "611", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getMoreResults() throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMoreResults", this);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet(true);
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets(true);
            }
            bl = this.stmtImpl.getMoreResults();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMoreResults", "655", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMoreResults", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMoreResults", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMoreResults", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.stmtImpl.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getQueryTimeout", "675", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        WSJdbcResultSet wSJdbcResultSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResultSet", this);
        }
        try {
            ResultSet resultSet = this.stmtImpl.getResultSet();
            if (resultSet == null) {
                wSJdbcResultSet = null;
            } else if (this.childWrapper == null && (this.childWrappers == null || this.childWrappers.isEmpty())) {
                wSJdbcResultSet = this.createResultSetWrapper(resultSet);
                this.childWrapper = wSJdbcResultSet;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Set the result set to child wrapper");
                }
            } else {
                if (this.childWrappers == null) {
                    this.childWrappers = new ArrayList(5);
                }
                wSJdbcResultSet = this.createResultSetWrapper(resultSet);
                this.childWrappers.add(wSJdbcResultSet);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Add the result set to child wrappers list.");
                }
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSet", "717", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResultSet", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResultSet", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResultSet", wSJdbcResultSet);
        }
        return wSJdbcResultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.stmtImpl.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSetConcurrency", "737", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.stmtImpl.getResultSetType();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSetType", "757", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected TraceComponent getTracer() {
        return tc;
    }

    public int getUpdateCount() throws SQLException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUpdateCount", this);
        }
        try {
            n = this.stmtImpl.getUpdateCount();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getUpdateCount", "800", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUpdateCount", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUpdateCount", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUpdateCount", new Integer(n));
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.stmtImpl.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getWarnings", "820", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    protected void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        fFDCLogger.append("Underlying Statement: " + AdapterUtil.toString(this.stmtImpl), this.stmtImpl);
        fFDCLogger.append("Statement properties have changed? " + this.haveStatementPropertiesChanged);
    }

    private boolean pmiExecute(String string) throws SQLException {
        boolean bl = false;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            bl = this.stmtImpl.execute(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecute", "1192", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecute", "1199", this);
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return bl;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    int[] pmiExecuteBatch() throws SQLException {
        int[] nArray = null;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_BATCH);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            nArray = this.stmtImpl.executeBatch();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteBatch", "1260", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteBatch", "1267", this);
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return nArray;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private ResultSet pmiExecuteQuery(String string) throws SQLException {
        ResultSet resultSet = null;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_QUERY);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            resultSet = this.stmtImpl.executeQuery(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteQuery", "1315", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteQuery", "1322", this);
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return resultSet;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private int pmiExecuteUpdate(String string) throws SQLException {
        int n = 0;
        Object object = null;
        int n2 = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_UPDATE);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            n = this.stmtImpl.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteUpdate", "1384", this);
            exception = sQLException;
            n2 = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteUpdate", "1391", this);
            exception = runtimeException;
            n2 = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n2, properties);
            }
        }
        if (exception == null) {
            return n;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        if (this.state == 2) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement"));
        }
        return runtimeException;
    }

    public void setCursorName(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCursorName", new Object[]{this, string});
        }
        try {
            this.stmtImpl.setCursorName(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setCursorName", "840", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setEscapeProcessing", new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        try {
            this.stmtImpl.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setEscapeProcessing", "860", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFetchDirection", new Object[]{this, AdapterUtil.getFetchDirectionString(n)});
        }
        try {
            this.stmtImpl.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setFetchDirection", "880", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public final void setFetchSize(int n) throws SQLException {
        if (this.state == 2 || n < 0) {
            if (this.state == 2) {
                throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement"));
            }
            if (n < 0) {
                throw new SQLException(AdapterUtil.getNLSMessage("NO_NEGATIVE_FETCH_SIZES"));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "requested fetchSize --> " + n, this);
        }
        this.requestedFetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMaxFieldSize", new Object[]{this, new Integer(n)});
        }
        try {
            this.stmtImpl.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setMaxFieldSize", "920", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public void setMaxRows(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMaxRows", new Object[]{this, new Integer(n)});
        }
        try {
            this.stmtImpl.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setMaxRows", "940", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setQueryTimeout", new Object[]{this, new Integer(n)});
        }
        try {
            this.stmtImpl.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setQueryTimeout", "960", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public void closeResultSetsIfNecessary() {
        if (this.holdability == 2) {
            this.closeChildWrappers();
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMoreResults", new Object[]{this, AdapterUtil.getResultSetCloseString(n)});
        }
        boolean bl = false;
        try {
            switch (n) {
                case 3: {
                    if (this.childWrapper != null) {
                        this.closeAndRemoveResultSet(true);
                    }
                    if (this.childWrappers == null || this.childWrappers.isEmpty()) break;
                    this.closeAndRemoveResultSets(true);
                    break;
                }
                case 1: {
                    if (this.childWrappers == null || this.childWrappers.isEmpty()) {
                        if (this.childWrapper == null) break;
                        this.closeAndRemoveResultSet(true);
                        break;
                    }
                    ((WSJdbcResultSet)this.childWrappers.get(this.childWrappers.size() - 1)).close(true);
                    break;
                }
            }
            bl = this.stmtImpl.getMoreResults(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMoreResults(int)", "1280", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMoreResults", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMoreResults", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMoreResults", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGeneratedKeys", this);
        }
        ResultSet resultSet = null;
        WSJdbcResultSet wSJdbcResultSet = null;
        try {
            resultSet = this.stmtImpl.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGeneratedKeys", "Exception");
            }
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getGeneratedKeys", "1138", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGeneratedKeys", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (this.childWrapper == null && (this.childWrappers == null || this.childWrappers.isEmpty())) {
            wSJdbcResultSet = this.createResultSetWrapper(resultSet);
            this.childWrapper = wSJdbcResultSet;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set the result set to child wrapper");
            }
        } else {
            if (this.childWrappers == null) {
                this.childWrappers = new ArrayList(5);
            }
            wSJdbcResultSet = this.createResultSetWrapper(resultSet);
            this.childWrappers.add(wSJdbcResultSet);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add the result set to child wrappers list.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGeneratedKeys", wSJdbcResultSet);
        }
        return wSJdbcResultSet;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        int n2;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "executeUpdate", new Object[]{this, string, AdapterUtil.getAutoGeneratedKeyString(n)});
        }
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            n2 = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.executeUpdate(string, n) : this.pmiExecuteUpdate(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeUpdate", "1363", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeUpdate", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeUpdate", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "executeUpdate", new Integer(n2));
        }
        return n2;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        int n;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "executeUpdate", AdapterUtil.populateArrayForTrace(new Object[]{this, string, nArray}));
        }
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            n = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.executeUpdate(string, nArray) : this.pmiExecuteUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeUpdate", "1426", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeUpdate", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeUpdate", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "executeUpdate", new Integer(n));
        }
        return n;
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        int n;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "executeUpdate", AdapterUtil.populateArrayForTrace(new Object[]{this, string, stringArray}));
        }
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            n = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.executeUpdate(string, stringArray) : this.pmiExecuteUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeUpdate", "1488", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeUpdate", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "executeUpdate", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "executeUpdate", new Integer(n));
        }
        return n;
    }

    public boolean execute(String string, int n) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "execute", new Object[]{this, string, AdapterUtil.getAutoGeneratedKeyString(n)});
        }
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl2 = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl2, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl2 ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            bl = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.execute(string, n) : this.pmiExecute(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.execute", "1559", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "execute", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "execute", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "execute", bl ? "QUERY" : "UPDATE");
        }
        return bl;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "execute", AdapterUtil.populateArrayForTrace(new Object[]{this, string, nArray}));
        }
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl2 = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl2, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl2 ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            bl = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.execute(string, nArray) : this.pmiExecute(string, nArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.execute", "1631", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "execute", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "execute", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "execute", bl ? "QUERY" : "UPDATE");
        }
        return bl;
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "execute", AdapterUtil.populateArrayForTrace(new Object[]{this, string, stringArray}));
        }
        try {
            block12: {
                if (this.childWrapper != null) {
                    this.closeAndRemoveResultSet();
                }
                if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                    this.closeAndRemoveResultSets();
                }
                this.parentWrapper.beginTransactionIfNecessary();
                this.enforceStatementProperties();
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
                J2EEName j2EEName = null;
                try {
                    if (this.__mcf != null && this.__mcf.isEndToEndMonitoringFeatureEnabled()) {
                        boolean bl2 = this.__mcf.shouldDataBeCollectedAndPshedDownToCMX();
                        wSRdbManagedConnectionImpl = ((WSJdbcConnection)this.parentWrapper).managedConn;
                        j2EEName = wSRdbManagedConnectionImpl.getJ2EEName();
                        AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl2, j2EEName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().appServerName, wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper(), 130, bl2 ? AdapterUtil.getcmxArgsObject(1, j2EEName, null, this, null, null, null) : null, this.stmtImpl);
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "error happened while preparing to push cmx data, no cmx data is pushed down", throwable);
                }
            }
            bl = this.pmi == null && !this.metrics.isInteractionMetricsEnabled() ? this.stmtImpl.execute(string, stringArray) : this.pmiExecute(string, stringArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.execute", "1703", this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "execute", "Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "execute", "Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "execute", bl ? "QUERY" : "UPDATE");
        }
        return bl;
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.stmtImpl.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSetHoldability", "1770", this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    private boolean pmiExecute(String string, int n) throws SQLException {
        boolean bl = false;
        Object object = null;
        int n2 = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_KEYS);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            bl = this.stmtImpl.execute(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecute", "2404", this);
            exception = sQLException;
            n2 = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecute", "2411", this);
            exception = runtimeException;
            n2 = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n2, properties);
            }
        }
        if (exception == null) {
            return bl;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private boolean pmiExecute(String string, int[] nArray) throws SQLException {
        boolean bl = false;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_COL_INDICES);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            bl = this.stmtImpl.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecute", "2477", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecute", "2484", this);
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return bl;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private boolean pmiExecute(String string, String[] stringArray) throws SQLException {
        boolean bl = false;
        Object object = null;
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_COL_NAMES);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            bl = this.stmtImpl.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecute", "2550", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecute", "2557", this);
            exception = runtimeException;
            n = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception == null) {
            return bl;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private int pmiExecuteUpdate(String string, int n) throws SQLException {
        int n2 = 0;
        Object object = null;
        int n3 = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_UPDATE_KEYS);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            n2 = this.stmtImpl.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteUpdate", "2623", this);
            exception = sQLException;
            n3 = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteUpdate", "2630", this);
            exception = runtimeException;
            n3 = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n3, properties);
            }
        }
        if (exception == null) {
            return n2;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private int pmiExecuteUpdate(String string, int[] nArray) throws SQLException {
        int n = 0;
        Object object = null;
        int n2 = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_UPDATE_COL_INDICES);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            n = this.stmtImpl.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteUpdate", "2696", this);
            exception = sQLException;
            n2 = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteUpdate", "2703", this);
            exception = runtimeException;
            n2 = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n2, properties);
            }
        }
        if (exception == null) {
            return n;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }

    private int pmiExecuteUpdate(String string, String[] stringArray) throws SQLException {
        int n = 0;
        Object object = null;
        int n2 = 0;
        Exception exception = null;
        Properties properties = null;
        if (this.metrics.isInteractionMetricsEnabled()) {
            object = this.metrics.preInteraction(PMI_EXECUTE_UPDATE_COL_NAMES);
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationStarted();
        }
        try {
            n = this.stmtImpl.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiExecuteUpdate", "2769", this);
            exception = sQLException;
            n2 = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiExecuteUpdate", "2776", this);
            exception = runtimeException;
            n2 = 2;
        }
        if (this.pmi != null) {
            this.pmi.jdbcOperationCompleted();
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("SQLString", string);
                properties.setProperty("DataSourceJNDIName", this.getJNDIName());
            }
            case 1: {
                this.metrics.postInteraction(object, n2, properties);
            }
        }
        if (exception == null) {
            return n;
        }
        if (exception instanceof SQLException) {
            throw exception;
        }
        throw (RuntimeException)exception;
    }
}

