/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.TraceComponent;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public class WSJdbcTracer
implements InvocationHandler {
    static final Set METHODS_TO_SKIP = new HashSet();
    static final Set TRACEABLE_TYPES;
    TraceComponent tracer;
    PrintWriter writer;
    Object impl;
    String traceID;

    public WSJdbcTracer(TraceComponent traceComponent, PrintWriter printWriter, Object object, Class clazz, boolean bl) {
        this.tracer = traceComponent;
        this.writer = printWriter;
        this.impl = object;
        this.traceID = clazz.getSimpleName() + Integer.toHexString(System.identityHashCode(object));
        if (bl) {
            this.traceConfig();
        }
    }

    public static final Object getImpl(Object object) {
        InvocationHandler invocationHandler;
        return Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof WSJdbcTracer ? ((WSJdbcTracer)invocationHandler).impl : object;
    }

    public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
        Object object2;
        Serializable serializable;
        boolean bl;
        String string = method2.getName();
        if (METHODS_TO_SKIP.contains(string)) {
            try {
                return method2.invoke(this.impl, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
        Object object3 = null;
        WSJdbcTracer wSJdbcTracer = this;
        if (wSJdbcTracer.tracer.isAnyTracingEnabled() && this.tracer.isDebugEnabled()) {
            bl = string.equals("getPooledConnection") || string.equals("getXAConnection");
            serializable = new StringBuffer(120);
            ((StringBuffer)serializable).append("==> ").append(this.traceID).append('.').append(string).append('(');
            if (this.tracer.getLevel() <= 1 && objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i != 0) {
                        ((StringBuffer)serializable).append(", ");
                    }
                    ((StringBuffer)serializable).append(bl && i == 1 ? "***" : this.toString(objectArray[i]));
                }
            }
            ((StringBuffer)serializable).append(");");
            this.writer.println(new String((StringBuffer)serializable));
        }
        try {
            object2 = method2.invoke(this.impl, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            WSJdbcTracer wSJdbcTracer2 = this;
            if (wSJdbcTracer2.tracer.isAnyTracingEnabled() && this.tracer.isDebugEnabled()) {
                serializable = new StringBuffer(800);
                ((StringBuffer)serializable).append("<== ").append(this.toString(invocationTargetException.getCause()));
                this.writer.println(new String((StringBuffer)serializable));
            }
            throw invocationTargetException.getCause();
        }
        bl = string.equals("unwrap");
        if (object2 != null && (bl || TRACEABLE_TYPES.contains(method2.getReturnType()))) {
            serializable = bl ? (Class)objectArray[0] : method2.getReturnType();
            object3 = Proxy.newProxyInstance(((Class)serializable).getClassLoader(), new Class[]{serializable}, (InvocationHandler)new WSJdbcTracer(this.tracer, this.writer, object2, (Class)serializable, false));
        }
        WSJdbcTracer wSJdbcTracer3 = this;
        if (wSJdbcTracer3.tracer.isAnyTracingEnabled() && this.tracer.isDebugEnabled()) {
            serializable = new StringBuffer(40);
            ((StringBuffer)serializable).append("<== ");
            if (Void.TYPE.equals(method2.getReturnType())) {
                ((StringBuffer)serializable).append(string);
            } else if (object3 != null) {
                ((StringBuffer)serializable).append(method2.getReturnType().getSimpleName()).append(Integer.toHexString(System.identityHashCode(object2)));
            } else if (this.tracer.getLevel() <= 1) {
                ((StringBuffer)serializable).append(this.toString(object2));
            }
            this.writer.println(new String((StringBuffer)serializable));
        }
        return object3 == null ? object2 : object3;
    }

    private String toString(Object object) {
        if (object instanceof String) {
            byte[] byArray;
            String string = (String)object;
            StringBuffer stringBuffer = new StringBuffer(string.length()).append('\"');
            try {
                byArray = string.getBytes("UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(stringBuffer.append(string).append('\"'));
            }
            for (int i = 0; i < byArray.length; i += 2) {
                if (byArray[i] == 0 && (byArray[i + 1] & 0x80) == 0) {
                    stringBuffer.append((char)byArray[i + 1]);
                    continue;
                }
                stringBuffer.append("\\u").append(Integer.toHexString(byArray[i] >> 4 & 0xF)).append(Integer.toHexString(byArray[i] & 0xF)).append(Integer.toHexString(byArray[i + 1] >> 4 & 0xF)).append(Integer.toHexString(byArray[i + 1] & 0xF));
            }
            return new String(stringBuffer.append('\"'));
        }
        if (object instanceof Throwable) {
            StringWriter stringWriter = new StringWriter();
            ((Throwable)object).printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString();
        }
        if (object != null && object.getClass().isArray()) {
            int n = Array.getLength(object);
            StringBuffer stringBuffer = new StringBuffer(120);
            stringBuffer.append(object.getClass().getComponentType().getSimpleName());
            stringBuffer.append('[').append(n).append("] {");
            if (n < 20) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(i == 0 ? " " : ", ").append(Array.get(object, i));
                }
            } else {
                stringBuffer.append(" ...");
            }
            stringBuffer.append(" }");
            return new String(stringBuffer);
        }
        return object == null ? null : object.toString();
    }

    private void traceConfig() {
        this.writer.println(new String(new StringBuffer(180).append(this.impl.getClass().getName()).append(' ').append(this.traceID).append(" = new ").append(this.impl.getClass().getName()).append("();")));
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(this.impl.getClass()).getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Method method2;
                Method method3 = propertyDescriptorArray[i].getReadMethod();
                if (method3 == null || (method2 = propertyDescriptorArray[i].getWriteMethod()) == null) continue;
                StringBuffer stringBuffer = new StringBuffer(60);
                stringBuffer.append(this.traceID).append('.').append(method2.getName()).append('(');
                if (!"password".equals(propertyDescriptorArray[i].getName())) {
                    try {
                        stringBuffer.append(this.toString(method3.invoke(this.impl, null)));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                stringBuffer.append(");");
                this.writer.println(new String(stringBuffer));
            }
        }
        catch (IntrospectionException introspectionException) {
            this.writer.println("Unable to read the configuration for " + this.traceID);
            introspectionException.printStackTrace(this.writer);
        }
    }

    static {
        METHODS_TO_SKIP.add("equals");
        METHODS_TO_SKIP.add("hashCode");
        METHODS_TO_SKIP.add("toString");
        TRACEABLE_TYPES = new HashSet();
        TRACEABLE_TYPES.add(CallableStatement.class);
        TRACEABLE_TYPES.add(Connection.class);
        TRACEABLE_TYPES.add(ConnectionPoolDataSource.class);
        TRACEABLE_TYPES.add(DatabaseMetaData.class);
        TRACEABLE_TYPES.add(DataSource.class);
        TRACEABLE_TYPES.add(PooledConnection.class);
        TRACEABLE_TYPES.add(PreparedStatement.class);
        TRACEABLE_TYPES.add(ResultSet.class);
        TRACEABLE_TYPES.add(Statement.class);
        TRACEABLE_TYPES.add(XAConnection.class);
        TRACEABLE_TYPES.add(XADataSource.class);
        TRACEABLE_TYPES.add(XAResource.class);
    }
}

