/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbcproviderutils.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.DatasourceResourcePropertyView;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.DatasourceView;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.JDBCConfigHelper;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.VersionHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateDatasourceCommand
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateDatasourceCommand.class, JDBCConfigHelper.TRACE_GROUP, JDBCConfigHelper.BUNDLE_FILE);
    private String taskName = null;
    private ObjectName cmpConnectorFactory = null;

    public CreateDatasourceCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.taskName = taskCommandMetadata.getName();
    }

    public CreateDatasourceCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.taskName = commandData.getName();
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetObject(jdbcProvider)", objectName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Validating targetObject");
        }
        try {
            configService.queryConfigObjects(session, null, objectName, null);
        }
        catch (ConfigServiceException configServiceException) {
            FFDCFilter.processException(configServiceException, "com.ibm.ws.management.commands.jdbcProvider.validate", "116");
            String string = JDBCConfigHelper.getFormattedMessage("DSRA3600E", new Object[]{this.getName(), configServiceException.toString()});
            throw new CommandValidationException(string);
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException(connectorException, "com.ibm.ws.management.commands.jdbcProvider.validate", "123");
            String string = JDBCConfigHelper.getFormattedMessage("DSRA3600E", new Object[]{this.getName(), connectorException.toString()});
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "result was not successful");
            }
            return;
        }
        try {
            taskCommandResultImpl.setResult(this.createDatasource());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.jdbcProvider.beforeStepsExecuted", "140");
            String string = JDBCConfigHelper.getFormattedMessage("DSRA3601E", new Object[]{"createDatasource", throwable.toString()});
            taskCommandResultImpl.setException(new CommandException(throwable, string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task result was not successful");
            }
        } else {
            CommandResultImpl commandResultImpl = (CommandResultImpl)taskCommandResultImpl.getStepResult("configureResourceProperties");
            if (!commandResultImpl.isSuccessful()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Step result was not successful");
                }
                taskCommandResultImpl.setException(commandResultImpl.getException());
                Collection collection = commandResultImpl.getMessages();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    taskCommandResultImpl.addWarnings(string);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Warning:" + string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    protected void taskCommandExecuted(boolean bl) {
        block16: {
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Task result was not successful.  Cleaning up");
                }
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
                ObjectName objectName = null;
                try {
                    objectName = (ObjectName)taskCommandResultImpl.getResult();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (this.cmpConnectorFactory != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cmpConnectorFactory", this.cmpConnectorFactory);
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deleting cmpConnectorFactory configuration");
                        }
                        configService.deleteConfigData(session, this.cmpConnectorFactory);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cmpConnectorFactory configuration deleted");
                        }
                    }
                    catch (Throwable throwable) {
                        Tr.debug(tc, "cmpConnectorFactory delete exception: " + throwable);
                    }
                }
                if (objectName != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "datasource", objectName);
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deleting datasource configuration");
                        }
                        configService.deleteConfigData(session, objectName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Datasource configuration deleted");
                        }
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Datasource delete exception: " + throwable);
                    }
                }
            }
        }
    }

    public Object[] getChoices(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", string);
        }
        ObjectName objectName = (ObjectName)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetObject(jdbcProvider)", objectName);
        }
        Object[] objectArray = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jdbcProvider", ConfigServiceHelper.getDisplayName(objectName));
            }
            DatasourceView datasourceView = JDBCConfigHelper.getDatasourceTemplate(configService, session, objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template", datasourceView.getDisplayName());
            }
            if (string.equals("dataStoreHelperClassName")) {
                objectArray = new Object[1];
                String string2 = datasourceView.getDatasourceHelperClassname();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "helper", string2);
                }
                objectArray[0] = string2;
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception in getChoices", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.jdbcProvider.getChoices", "196");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices");
        }
        return objectArray;
    }

    private ObjectName createDatasource() throws Throwable {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDatasource");
        }
        CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = this.getConfigSession();
        this.cmpConnectorFactory = null;
        ObjectName objectName = (ObjectName)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetObject(jdbcProvider)", objectName);
        }
        String string = (String)this.getParameter("name");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "name", string);
        }
        String string2 = (String)this.getParameter("jndiName");
        String string3 = (String)this.getParameter("description");
        String string4 = (String)this.getParameter("category");
        String string5 = (String)this.getParameter("dataStoreHelperClassName");
        String string6 = (String)this.getParameter("componentManagedAuthenticationAlias");
        Boolean bl = (Boolean)this.getParameter("containerManagedPersistence");
        String string7 = (String)this.getParameter("xaRecoveryAuthAlias");
        DatasourceView datasourceView = JDBCConfigHelper.getDatasourceTemplate(configService, session, objectName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "template", datasourceView.getDisplayName());
        }
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name", string);
            }
            datasourceView.setAttributeValue("name", string.trim());
        }
        if (string2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jndiName", string2);
            }
            datasourceView.setAttributeValue("jndiName", string2);
        }
        if (string3 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "description", string3);
            }
            datasourceView.setAttributeValue("description", string3);
        }
        if (string4 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "category", string4);
            }
            datasourceView.setAttributeValue("category", string4);
        }
        if (string5 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dataStoreHelperClassName", string5);
            }
            datasourceView.setAttributeValue("datasourceHelperClassname", string5);
        }
        if (string6 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "componentManagedAuthenticationAlias", string6);
            }
            datasourceView.setAttributeValue("authDataAlias", string6);
        }
        if (VersionHelper.getProductVersion(objectName, session).startsWith("6") && string7 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "componentManagedAuthenticationAlias", string7);
            }
            datasourceView.setAttributeValue("xaRecoveryAuthAlias", string7);
        }
        if (VersionHelper.getProductVersion(objectName, session).startsWith("5")) {
            ConfigServiceHelper.removeAttribute(datasourceView.getAttributeList(), "xaRecoveryAuthAlias");
            ConfigServiceHelper.removeAttribute(datasourceView.getAttributeList(), "providerType");
            ConfigServiceHelper.removeAttribute(datasourceView.getAttributeList(), "manageCachedHandles");
            ConfigServiceHelper.removeAttribute(datasourceView.getAttributeList(), "logMissingTransactionContext");
            ConfigServiceHelper.removeAttribute(datasourceView.getAttributeList(), "diagnoseConnectionUsage");
            ConfigServiceHelper.removeAttribute(datasourceView.getAttributeList(), "preTestConfig");
            serializable = (AttributeList)datasourceView.getAttributeValue("connectionPool");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "numberOfSharedPoolPartitions");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "numberOfUnsharedPoolPartitions");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "numberOfFreePoolPartitions");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "freePoolDistributionTableSize");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "surgeThreshold");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "surgeCreationInterval");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "testConnection");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "testConnectionInterval");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "stuckTimerTime");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "stuckTime");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "stuckThreshold");
            ConfigServiceHelper.removeAttribute((AttributeList)serializable, "properties");
        } else {
            ConfigServiceHelper.setAttributeValue(datasourceView.getAttributeList(), "providerType", JDBCConfigHelper.getProviderTypeAlias(objectName, session, (String)ConfigServiceHelper.getAttributeValue(datasourceView.getAttributeList(), "providerType")));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating new datasource...");
        }
        serializable = configService.createConfigDataByTemplate(session, objectName, "DataSource", datasourceView.getAttributeList(), datasourceView.getTemplate());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "datasource", serializable);
        }
        if (bl.booleanValue()) {
            Object object;
            ObjectName objectName2 = (ObjectName)configService.getAttribute(session, (ObjectName)serializable, "relationalResourceAdapter");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rra", objectName2);
            }
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "connectionDefTemplateProps");
            ObjectName objectName3 = null;
            if (arrayList.size() > 0) {
                object = (AttributeList)arrayList.get(0);
                objectName3 = (ObjectName)ConfigServiceHelper.getAttributeValue((AttributeList)object, "ConnectionDefinition");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connectionDef", objectName3);
            }
            object = string + "_CF";
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "name", object);
            if (string6 != null && !string6.equals(null)) {
                ConfigServiceHelper.setAttributeValue(attributeList, "authDataAlias", string6);
            }
            ConfigServiceHelper.setAttributeValue(attributeList, "cmpDatasource", serializable);
            ConfigServiceHelper.setAttributeValue(attributeList, "connectionDefinition", objectName3);
            if (VersionHelper.getProductVersion(objectName, session).startsWith("6") && string7 != null && !string7.equals(null)) {
                ConfigServiceHelper.setAttributeValue(attributeList, "xaRecoveryAuthAlias", string7);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cmpAttr", attributeList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating CMP connector factory...");
            }
            this.cmpConnectorFactory = configService.createConfigData(session, objectName2, "CMPConnectorFactory", "CMPConnectorFactory", attributeList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cmpConnectorFactory created: " + this.cmpConnectorFactory);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDatasource", serializable);
        }
        return serializable;
    }

    public class ConfigureResourcePropertiesStep
    extends AbstractCommandStep {
        private String stepName;

        public ConfigureResourcePropertiesStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.stepName = commandStepMetadata.getName();
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            commandResultImpl.reset();
            this.setCommandResult(commandResultImpl);
        }

        public ConfigureResourcePropertiesStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.stepName = commandStepData.getName();
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            commandResultImpl.reset();
            this.setCommandResult(commandResultImpl);
        }

        protected void initializeStep() throws CommandException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeStep");
            }
            CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
            commandResultImpl.reset();
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.taskCmd.getConfigSession();
            ObjectName objectName = (ObjectName)this.taskCmd.getTargetObject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jdbcProvider", objectName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jdbcProvider", ConfigServiceHelper.getDisplayName(objectName));
            }
            try {
                DatasourceView datasourceView = JDBCConfigHelper.getDatasourceTemplate(configService, session, objectName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "template", datasourceView.getDisplayName());
                }
                ArrayList arrayList = JDBCConfigHelper.getDatasourceResourceProperties(configService, session, datasourceView.getTemplate(), true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting up rows");
                }
                AttributeList attributeList = new AttributeList();
                int n = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    DatasourceResourcePropertyView datasourceResourcePropertyView = (DatasourceResourcePropertyView)iterator.next();
                    attributeList.add(new Attribute("name", datasourceResourcePropertyView.getName()));
                    attributeList.add(new Attribute("type", datasourceResourcePropertyView.getType()));
                    attributeList.add(new Attribute("value", datasourceResourcePropertyView.getValue()));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added row: " + attributeList.toString());
                        Tr.debug(tc, "name: " + datasourceResourcePropertyView.getName() + " - " + "type: " + datasourceResourcePropertyView.getType() + " - " + "value: " + datasourceResourcePropertyView.getValue());
                    }
                    this.initializeRow(attributeList, n);
                    attributeList.clear();
                    ++n;
                }
            }
            catch (Throwable throwable) {
                String string = JDBCConfigHelper.getFormattedMessage("DSRA3605E", new Object[]{this.stepName, CreateDatasourceCommand.this.taskName, throwable.toString()});
                throw new CommandException(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeStep");
            }
        }

        public void validateProperty(String string, String string2, String string3, ArrayList arrayList) throws CommandValidationException {
            Object object;
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateProperty", new Object[]{string, string2, string3});
            }
            if (string3 == null || string3.equals("")) {
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    object = (DatasourceResourcePropertyView)object2.next();
                    if (!((DatasourceResourcePropertyView)object).getName().trim().equals(string)) continue;
                    if (((DatasourceResourcePropertyView)object).getRequired().booleanValue()) {
                        String string4 = JDBCConfigHelper.getFormattedMessage("DSRA3607E", new Object[]{this.stepName, CreateDatasourceCommand.this.taskName, string, string2});
                        throw new CommandValidationException(string4);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property " + string + " not required; No validation performed");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateProperty");
                    }
                    return;
                }
            }
            if (string2.equals("java.lang.String")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type is " + string2 + ".  No validation performed");
                }
            } else if (string2.equals("java.lang.Integer")) {
                try {
                    Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    object = JDBCConfigHelper.getFormattedMessage("DSRA3608E", new Object[]{string3, string, string2, this.stepName, CreateDatasourceCommand.this.taskName});
                    throw new CommandValidationException((String)object);
                }
            } else if (string2.equals("java.lang.Long")) {
                try {
                    Long.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    object = JDBCConfigHelper.getFormattedMessage("DSRA3608E", new Object[]{string3, string, string2, this.stepName, CreateDatasourceCommand.this.taskName});
                    throw new CommandValidationException((String)object);
                }
            } else if (string2.equals("java.lang.Boolean")) {
                if (!string3.equalsIgnoreCase("true") && !string3.equalsIgnoreCase("false")) {
                    object2 = JDBCConfigHelper.getFormattedMessage("DSRA3608E", new Object[]{string3, string, string2, this.stepName, CreateDatasourceCommand.this.taskName});
                    throw new CommandValidationException((String)object2);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Type is " + string2 + ".  No validation performed");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateProperty");
            }
        }

        protected void executeStep() {
            block6: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "executeStep");
                }
                CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
                TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getTaskCommandResult();
                ObjectName objectName = (ObjectName)taskCommandResultImpl.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "datasource", objectName);
                }
                CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
                ConfigService configService = commandProviderHelper.getConfigService();
                Session session = this.taskCmd.getConfigSession();
                try {
                    ObjectName objectName2 = (ObjectName)this.taskCmd.getTargetObject();
                    DatasourceView datasourceView = JDBCConfigHelper.getDatasourceTemplate(configService, session, objectName2);
                    ArrayList arrayList = JDBCConfigHelper.getDatasourceResourceProperties(configService, session, datasourceView.getTemplate(), true);
                    for (int i = 0; i < this.getNumberOfRows(); ++i) {
                        String string = (String)this.getParameter("name", i);
                        String string2 = (String)this.getParameter("type", i);
                        String string3 = (String)this.getParameter("value", i);
                        string = string.trim();
                        string2 = string2.trim();
                        string3 = string3.trim();
                        this.validateProperty(string, string2, string3, arrayList);
                        JDBCConfigHelper.updateDatasourceResourceProperty(configService, session, objectName, string, string2, string3);
                    }
                }
                catch (Throwable throwable) {
                    String string = JDBCConfigHelper.getFormattedMessage("DSRA3605E", new Object[]{this.stepName, CreateDatasourceCommand.this.taskName, throwable.toString()});
                    commandResultImpl.setException(throwable);
                    commandResultImpl.addWarnings(string);
                    commandResultImpl.setResult(string);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Set commandResult exception to: + ", throwable);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeStep");
            }
        }
    }
}

