/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbcproviderutils.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.JDBCConfigHelper;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.JDBCProviderView;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.VersionHelper;
import java.util.Vector;
import javax.management.ObjectName;

public class CreateJDBCProviderCommand
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateJDBCProviderCommand.class, JDBCConfigHelper.TRACE_GROUP, JDBCConfigHelper.BUNDLE_FILE);
    private String providerName;

    public CreateJDBCProviderCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateJDBCProviderCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        String string = (String)this.getParameter("scope");
        String string2 = (String)this.getParameter("databaseType");
        String string3 = (String)this.getParameter("providerType");
        String string4 = (String)this.getParameter("implementationType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "types", new Object[]{string2, string3, string4});
        }
        try {
            this.providerName = JDBCConfigHelper.getJDBCProviderName(configService, session, string, string2, string3, string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerName", this.providerName);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.jdbcProvider.validate", "73");
            String string5 = JDBCConfigHelper.getFormattedMessage("DSRA3600E", new Object[]{"createJDBCProvider", throwable.toString()});
            throw new CommandValidationException(throwable, string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            taskCommandResultImpl.setResult(this.createJDBCProvider());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.jdbcProvider.beforeStepsExecuted", "140");
            String string = JDBCConfigHelper.getFormattedMessage("DSRA3601E", new Object[]{"createJDBCProvider", throwable.toString()});
            taskCommandResultImpl.setException(new CommandException(throwable, string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public Object[] getChoices(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", string);
        }
        Object[] objectArray = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            String string2 = (String)this.getParameter("scope");
            if (string.equals("databaseType")) {
                objectArray = JDBCConfigHelper.getDatabaseTypeList(configService, session, string2);
            } else if (string.equals("providerType")) {
                String string3 = (String)this.getParameter("databaseType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "selectedDBType", string3);
                }
                objectArray = JDBCConfigHelper.getDriverTypeList(configService, session, string2, string3);
            } else if (string.equals("implementationType")) {
                String string4 = (String)this.getParameter("databaseType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "selectedDBType", string4);
                }
                String string5 = (String)this.getParameter("providerType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "selectedProviderType", string5);
                }
                objectArray = JDBCConfigHelper.getTranTypeList(configService, session, string2, string4, string5);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.jdbcProvider.getChoices", "194");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices");
        }
        return objectArray;
    }

    private ObjectName createJDBCProvider() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJDBCProvider");
        }
        CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = this.getConfigSession();
        String string = (String)this.getParameter("scope");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scope", string);
        }
        ObjectName objectName = null;
        try {
            objectName = JDBCConfigHelper.resolveScope(configService, session, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeObject", objectName);
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            throw new InvalidParameterValueException(this.getName(), "scope", string);
        }
        String string2 = (String)this.getParameter("name");
        String string3 = (String)this.getParameter("description");
        String string4 = (String)this.getParameter("implementationClassName");
        String[] stringArray = (String[])this.getParameter("classpath");
        String[] stringArray2 = (String[])this.getParameter("nativePath");
        JDBCProviderView jDBCProviderView = JDBCConfigHelper.getJDBCProviderTemplate(configService, session, this.providerName, string);
        if (string2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name", string2);
            }
            jDBCProviderView.setAttributeValue("name", string2);
        }
        if (string3 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "description", string3);
            }
            jDBCProviderView.setAttributeValue("description", string3);
        }
        if (string4 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "implementationClassName", string4);
            }
            jDBCProviderView.setAttributeValue("implementationClassName", string4);
        }
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Classpath element " + i + ": ", stringArray[i]);
                }
                vector.add(stringArray[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "classpath", vector);
            }
            jDBCProviderView.setAttributeValue("classpath", vector);
        }
        Vector<String> vector2 = new Vector<String>();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nativepath element " + i + ": ", stringArray2[i]);
                }
                vector2.add(stringArray2[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nativepath", vector2);
            }
            jDBCProviderView.setAttributeValue("nativepath", vector2);
        }
        if (VersionHelper.getProductVersion(objectName, session).startsWith("5")) {
            ConfigServiceHelper.removeAttribute(jDBCProviderView.getAttributeList(), "providerType");
        } else {
            ConfigServiceHelper.setAttributeValue(jDBCProviderView.getAttributeList(), "providerType", JDBCConfigHelper.getProviderTypeAlias(configService, session, string, (String)ConfigServiceHelper.getAttributeValue(jDBCProviderView.getAttributeList(), "providerType")));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating new provider");
        }
        ObjectName objectName2 = configService.createConfigData(session, objectName, "JDBCProvider", "JDBCProvider", jDBCProviderView.getAttributeList());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJDBCProvider", objectName2);
        }
        return objectName2;
    }
}

