/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbcproviderutils.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.AdminCommandHelper;
import com.ibm.ws.rsadapter.jdbcproviderutils.commands.CreateDatasourceCommand;
import com.ibm.ws.rsadapter.jdbcproviderutils.commands.CreateJDBCProviderCommand;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.JDBCConfigHelper;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;

public class JDBCConfigCommandProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(JDBCConfigCommandProvider.class, JDBCConfigHelper.TRACE_GROUP, JDBCConfigHelper.BUNDLE_FILE);

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand", new Object[]{commandMetadata});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, commandMetadata.toString());
        }
        String string = commandMetadata.getName();
        AbstractAdminCommand abstractAdminCommand = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Trying to create new " + string + " task command.");
        }
        abstractAdminCommand = string.equals("createJDBCProvider") ? new CreateJDBCProviderCommand((TaskCommandMetadata)commandMetadata) : (string.equals("createDatasource") ? new CreateDatasourceCommand((TaskCommandMetadata)commandMetadata) : super.createCommand(commandMetadata));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommand", abstractAdminCommand);
        }
        return abstractAdminCommand;
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommand", new Object[]{commandData});
        }
        String string = commandData.getName();
        AbstractAdminCommand abstractAdminCommand = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Trying to load new " + string + " task command.");
        }
        abstractAdminCommand = string.equals("createJDBCProvider") ? new CreateJDBCProviderCommand(commandData) : (string.equals("createDatasource") ? new CreateDatasourceCommand(commandData) : super.loadCommand(commandData));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCommand", abstractAdminCommand);
        }
        return abstractAdminCommand;
    }

    public AbstractCommandStep createCommandStep(AbstractTaskCommand abstractTaskCommand, String string) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommandStep", new Object[]{abstractTaskCommand, string});
        }
        String string2 = abstractTaskCommand.getName();
        CreateDatasourceCommand.ConfigureResourcePropertiesStep configureResourcePropertiesStep = null;
        TaskCommandMetadata taskCommandMetadata = (TaskCommandMetadata)abstractTaskCommand.getCommandMetadata();
        CommandStepMetadata commandStepMetadata = null;
        Iterator iterator = taskCommandMetadata.getSteps().iterator();
        while (iterator.hasNext()) {
            CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)iterator.next();
            if (!commandStepMetadata2.getName().equals(string)) continue;
            commandStepMetadata = commandStepMetadata2;
            break;
        }
        if (commandStepMetadata == null) {
            throw new CommandNotFoundException(string2, string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating " + string + " step for " + string2 + " command");
        }
        if (string2.equals("createDatasource")) {
            if (!string.equals("configureResourceProperties")) {
                throw new CommandNotFoundException(string2, string);
            }
        } else {
            throw new CommandNotFoundException(string2, string);
        }
        CreateDatasourceCommand createDatasourceCommand = (CreateDatasourceCommand)abstractTaskCommand;
        createDatasourceCommand.getClass();
        configureResourcePropertiesStep = createDatasourceCommand.new CreateDatasourceCommand.ConfigureResourcePropertiesStep(abstractTaskCommand, commandStepMetadata);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommandStep", configureResourcePropertiesStep);
        }
        return configureResourcePropertiesStep;
    }

    public AbstractCommandStep loadCommandStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommandStep", new Object[]{abstractTaskCommand, commandStepData});
        }
        String string = abstractTaskCommand.getName();
        String string2 = commandStepData.getName();
        CreateDatasourceCommand.ConfigureResourcePropertiesStep configureResourcePropertiesStep = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating " + string2 + " step for " + string + " command");
        }
        if (string.equals("createDatasource")) {
            if (!string2.equals("configureResourceProperties")) {
                throw new CommandNotFoundException(string, string2);
            }
        } else {
            throw new CommandNotFoundException(string, string2);
        }
        CreateDatasourceCommand createDatasourceCommand = (CreateDatasourceCommand)abstractTaskCommand;
        createDatasourceCommand.getClass();
        configureResourcePropertiesStep = createDatasourceCommand.new CreateDatasourceCommand.ConfigureResourcePropertiesStep(abstractTaskCommand, commandStepData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCommandStep", configureResourcePropertiesStep);
        }
        return configureResourcePropertiesStep;
    }

    public List listJDBCProviders(AbstractAdminCommand abstractAdminCommand) throws Throwable {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listJDBCProviders", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("scope");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scope", string);
        }
        ObjectName objectName = null;
        if (string != null) {
            objectNameArray = null;
            try {
                objectNameArray = AdminCommandHelper.getResources(session, configService, string);
            }
            catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
                FFDCFilter.processException(invalidConfigDataTypeException, "com.ibm.ws.management.commands.jdbcProvider.listJDBCProviders", "83");
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scope", string);
            }
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scope", string);
            }
            objectName = objectNameArray[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeObject", objectName);
        }
        objectNameArray = ConfigServiceHelper.createObjectName(null, "JDBCProvider");
        List list = JDBCConfigHelper.getResources(configService, session, objectName, (ObjectName)objectNameArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listJDBCProviders");
        }
        return list;
    }

    public List listDatasources(AbstractAdminCommand abstractAdminCommand) throws Throwable {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listDatasources", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("scope");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scope", string);
        }
        ObjectName objectName = null;
        if (string != null) {
            objectNameArray = null;
            try {
                objectNameArray = AdminCommandHelper.getResources(session, configService, string);
            }
            catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
                FFDCFilter.processException(invalidConfigDataTypeException, "com.ibm.ws.management.commands.jdbcProvider.listDatasource", "301");
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scope", string);
            }
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scope", string);
            }
            objectName = objectNameArray[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeObject", objectName);
        }
        objectNameArray = ConfigServiceHelper.createObjectName(null, "DataSource");
        List list = JDBCConfigHelper.getResources(configService, session, objectName, (ObjectName)objectNameArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listDatasources");
        }
        return list;
    }
}

