/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbcproviderutils.confighelper;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.AdminCommandHelper;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.DatasourceResourcePropertyView;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.DatasourceView;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.JDBCProviderView;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.TemplateDescriptor;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.VersionHelper;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class JDBCConfigHelper {
    public static String BUNDLE_FILE;
    public static String TRACE_GROUP;
    private static ResourceBundle resBundle;
    private static TraceComponent tc;
    private static String wasHome;
    private static WASProductInfo product;
    private static String currentScope;
    private static ArrayList jdbcProviderDataStructure;
    private static ArrayList dbTypes;
    private static ArrayList driverTypes;
    private static ArrayList tranArray;
    private static Vector dropList;
    public static final String JDBC_PROVIDER_RESOURCE_TYPE = "JDBCProvider";
    public static final String DATASOURCE_RESOURCE_TYPE = "DataSource";
    public static final String J2EE_RESOURCE_PROPERTY_TYPE = "J2EEResourceProperty";
    public static final String DEPRECATED_DESCRIPTION_TAG = "Deprecated";
    public static final String MIN_VERSION_DESCRIPTION_TAG = "minVer";
    public static final String MAX_VERSION_DESCRIPTION_TAG = "maxVer";
    public static final String ADMIN_REQUIRED_DESCRIPTION_TAG = "adminRequired";
    public static final String DBTYPE_PROXY = "Proxy";
    private static final String TEMPLATE_ID = "templates/system|jdbc-resource-provider-templates.xml";
    private static boolean includeDeprecated;
    private static String deprecatedTag;
    private static boolean typesIncludeDeprecated;
    private static HashMap dbAliases;
    private static Object synchLoad;
    private static String onePC_en;
    private static String twoPC_en;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIncludeDeprecated(boolean bl, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIncludeDeprecated", new Object[]{new Boolean(bl), string});
        }
        Object object = synchLoad;
        synchronized (object) {
            includeDeprecated = bl;
            deprecatedTag = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIncludeDeprecated");
        }
    }

    public static boolean typesIncludeDeprecated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "typesIncludeDeprecated");
            Tr.exit(tc, "typesIncludeDeprecated", new Boolean(typesIncludeDeprecated));
        }
        return typesIncludeDeprecated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getDatabaseTypeList(ConfigService configService, Session session, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatabaseTypeList", string);
        }
        Object[] objectArray = null;
        Object object = synchLoad;
        synchronized (object) {
            ArrayList arrayList = JDBCConfigHelper.getDatabaseTypesDataStructure(configService, session, string);
            objectArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                string2 = string2.trim();
                objectArray[i] = string2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatabaseTypeList", driverTypes);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getDriverTypeList(ConfigService configService, Session session, String string, String string2) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDriverTypeList", new Object[]{string, string2});
        }
        String[] stringArray = null;
        Object object = synchLoad;
        synchronized (object) {
            ArrayList arrayList = JDBCConfigHelper.getDatabaseTypesDataStructure(configService, session, string);
            ArrayList arrayList2 = JDBCConfigHelper.getDriverTypesDataStructure(configService, session, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                if (!(string3 = string3.trim()).equalsIgnoreCase(string2.trim())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dbType", string3);
                }
                ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
                stringArray = new String[arrayList3.size()];
                for (int j = 0; j < arrayList3.size(); ++j) {
                    String string4 = (String)arrayList3.get(j);
                    stringArray[j] = string4 = string4.trim();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDriverTypeList", stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getTranTypeList(ConfigService configService, Session session, String string, String string2, String string3) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTranTypeList", new Object[]{string, string2, string3});
        }
        String[] stringArray = null;
        Object object = synchLoad;
        synchronized (object) {
            ArrayList arrayList = JDBCConfigHelper.getDatabaseTypesDataStructure(configService, session, string);
            ArrayList arrayList2 = JDBCConfigHelper.getDriverTypesDataStructure(configService, session, string);
            ArrayList arrayList3 = JDBCConfigHelper.getTranTypesDataStructure(configService, session, string);
            String string4 = JDBCConfigHelper.getFormattedMessage("JDBCProviderTemplate.tranType.connectionpool", null);
            String string5 = JDBCConfigHelper.getFormattedMessage("JDBCProviderTemplate.tranType.xa", null);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string6 = (String)arrayList.get(i);
                if (!(string6 = string6.trim()).equalsIgnoreCase(string2.trim())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dbType", string6);
                }
                ArrayList arrayList4 = (ArrayList)arrayList2.get(i);
                for (int j = 0; j < arrayList4.size(); ++j) {
                    String string7 = (String)arrayList4.get(j);
                    if (!(string7 = string7.trim()).equalsIgnoreCase(string3.trim())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "driver", string7);
                    }
                    ArrayList arrayList5 = (ArrayList)arrayList3.get(i);
                    ArrayList arrayList6 = (ArrayList)arrayList5.get(j);
                    if (i == arrayList.size() - 1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "dbType is user-defined type");
                        }
                        stringArray = new String[]{string6};
                        continue;
                    }
                    if (arrayList6.get(0) != null && arrayList6.get(1) != null) {
                        stringArray = new String[2];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Two tranTypes");
                        }
                        stringArray[0] = string4;
                        stringArray[1] = string5;
                        continue;
                    }
                    stringArray = new String[1];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "One tranType");
                    }
                    if (arrayList6.get(0) != null) {
                        stringArray[0] = string4;
                        continue;
                    }
                    if (arrayList6.get(1) == null) continue;
                    stringArray[0] = string5;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTranTypeList", stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getDatabaseTypesDataStructure(ConfigService configService, Session session, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatabaseTypesDataStructure", string);
        }
        Object object = synchLoad;
        synchronized (object) {
            JDBCConfigHelper.constructJDBCProviderDataStructures(configService, session, string, dbTypes);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatabaseTypesDataStructure", dbTypes);
        }
        return dbTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getDriverTypesDataStructure(ConfigService configService, Session session, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDriverTypesDataStructure", string);
        }
        Object object = synchLoad;
        synchronized (object) {
            JDBCConfigHelper.constructJDBCProviderDataStructures(configService, session, string, driverTypes);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDriverTypesDataStructure", driverTypes);
        }
        return driverTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTranTypesDataStructure(ConfigService configService, Session session, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTranTypesDataStructure", string);
        }
        Object object = synchLoad;
        synchronized (object) {
            JDBCConfigHelper.constructJDBCProviderDataStructures(configService, session, string, tranArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTranTypesDataStructure", tranArray);
        }
        return tranArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getJDBCProviderDataStructure(ConfigService configService, Session session, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJDBCProviderDataStructure", string);
        }
        Object object = synchLoad;
        synchronized (object) {
            JDBCConfigHelper.constructJDBCProviderDataStructures(configService, session, string, jdbcProviderDataStructure);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJDBCProviderDataStructure", jdbcProviderDataStructure);
        }
        return jdbcProviderDataStructure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDropList(ConfigService configService, Session session, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDropList", string);
        }
        Object object = synchLoad;
        synchronized (object) {
            JDBCConfigHelper.constructJDBCProviderDataStructures(configService, session, string, dropList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDropList", dropList);
        }
        return dropList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJDBCProviderName(ConfigService configService, Session session, String string, String string2, String string3, String string4) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJDBCProviderName", new Object[]{string, string2, string3, string4});
        }
        String string5 = null;
        if (string3 != null && string3.equals("Sybase JDBC Driver")) {
            string3 = "Sybase JDBC 2 Driver";
        }
        Object object = synchLoad;
        synchronized (object) {
            ArrayList arrayList = JDBCConfigHelper.getDatabaseTypesDataStructure(configService, session, string);
            ArrayList arrayList2 = JDBCConfigHelper.getDriverTypesDataStructure(configService, session, string);
            ArrayList arrayList3 = JDBCConfigHelper.getTranTypesDataStructure(configService, session, string);
            String string6 = JDBCConfigHelper.getFormattedMessage("JDBCProviderTemplate.tranType.connectionpool", null);
            String string7 = JDBCConfigHelper.getFormattedMessage("JDBCProviderTemplate.tranType.xa", null);
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string8 = (String)arrayList.get(i);
                if (!(string8 = string8.trim()).equalsIgnoreCase(string2.trim())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dbType", string8);
                }
                bl = true;
                ArrayList arrayList4 = (ArrayList)arrayList2.get(i);
                boolean bl2 = false;
                for (int j = 0; j < arrayList4.size(); ++j) {
                    String string9 = (String)arrayList4.get(j);
                    if (!(string9 = string9.trim()).equalsIgnoreCase(string3.trim())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "driver", string9);
                    }
                    bl2 = true;
                    ArrayList arrayList5 = (ArrayList)arrayList3.get(i);
                    ArrayList arrayList6 = (ArrayList)arrayList5.get(j);
                    string4 = string4.trim();
                    String string10 = (String)arrayList6.get(0);
                    String string11 = (String)arrayList6.get(1);
                    if (string8.equalsIgnoreCase(string4)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "User-defined tran type");
                        }
                        string5 = string10;
                    } else if (string6.equalsIgnoreCase(string4) || onePC_en.equalsIgnoreCase(string4) || string4.equalsIgnoreCase(string10)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "1PC tran type");
                        }
                        string5 = string10;
                    } else if (string7.equalsIgnoreCase(string4) || twoPC_en.equalsIgnoreCase(string4) || string4.equalsIgnoreCase(string11)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "2PC tran type");
                        }
                        string5 = string11;
                    }
                    if (string5 != null) continue;
                    String string12 = JDBCConfigHelper.getFormattedMessage("DSRA3602E", new Object[]{"tranType(implementationType)", string4});
                    throw new ConfigServiceException(string12);
                }
                if (bl2) continue;
                String string13 = JDBCConfigHelper.getFormattedMessage("DSRA3602E", new Object[]{"driverType(providerType)", string3});
                throw new ConfigServiceException(string13);
            }
            if (!bl) {
                String string14 = JDBCConfigHelper.getFormattedMessage("DSRA3602E", new Object[]{"databaseType", string2});
                throw new ConfigServiceException(string14);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJDBCProviderName", string5);
        }
        return string5;
    }

    public static JDBCProviderView getJDBCProviderTemplate(ConfigService configService, Session session, String string, String string2) throws Throwable {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJDBCProviderTemplate", new Object[]{string, string2});
        }
        ObjectName[] objectNameArray = configService.queryTemplates(session, JDBC_PROVIDER_RESOURCE_TYPE);
        ObjectName objectName = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing provider template list");
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            string3 = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
            if (!string3.equals(string)) continue;
            objectName = objectNameArray[i];
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "templateName", string3);
            Tr.debug(tc, "template", objectName);
            break;
        }
        if (objectName == null) {
            String string4 = JDBCConfigHelper.getFormattedMessage("DSRA3603E", new Object[]{string});
            throw new ConfigServiceException(string4);
        }
        ObjectName objectName2 = JDBCConfigHelper.resolveScope(configService, session, string2);
        string3 = VersionHelper.getProductVersion(objectName2, session);
        JDBCProviderView jDBCProviderView = new JDBCProviderView(configService, session, objectName, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJDBCProviderTemplate", objectName);
        }
        return jDBCProviderView;
    }

    public static ObjectName getJDBCProvider(ConfigService configService, Session session, String string, String string2) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJDBCProvider", new Object[]{string, string2});
        }
        ObjectName objectName = null;
        ObjectName objectName2 = JDBCConfigHelper.resolveScope(configService, session, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeObject", objectName2);
        }
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, JDBC_PROVIDER_RESOURCE_TYPE);
        List list = JDBCConfigHelper.getResources(configService, session, objectName2, objectName3);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName4 = (ObjectName)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "provider", objectName4);
            }
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName4);
            String string3 = configDataId.getHref();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "href", string3);
            }
            if (string3.indexOf(string) == -1) continue;
            objectName = objectName4;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Found the provider");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJDBCProvider", objectName);
        }
        return objectName;
    }

    public static DatasourceView getDatasourceTemplate(ConfigService configService, Session session, ObjectName objectName) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatasourceTemplate", objectName);
        }
        String string = VersionHelper.getProductVersion(objectName, session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "productVersion", string);
        }
        DatasourceView datasourceView = JDBCConfigHelper.getDatasourceTemplate(configService, session, objectName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatasourceTemplate", datasourceView);
        }
        return datasourceView;
    }

    public static DatasourceView getDatasourceTemplate(ConfigService configService, Session session, JDBCProviderView jDBCProviderView, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatasourceTemplate", new Object[]{jDBCProviderView, string});
        }
        ObjectName objectName = JDBCConfigHelper.resolveScope(configService, session, string);
        String string2 = VersionHelper.getProductVersion(objectName, session);
        ObjectName objectName2 = jDBCProviderView.getTemplate();
        DatasourceView datasourceView = JDBCConfigHelper.getDatasourceTemplate(configService, session, objectName2, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatasourceTemplate", datasourceView);
        }
        return datasourceView;
    }

    public static DatasourceView getDatasourceTemplate(ConfigService configService, Session session, ObjectName objectName, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatasourceTemplate", new Object[]{objectName, string});
        }
        String string2 = null;
        try {
            string2 = (String)configService.getAttribute(session, objectName, "providerType");
            if (string2.equals("Sybase JDBC Driver")) {
                string2 = "Sybase JDBC 2 Driver";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "providerSearchString(providerType)", string2);
        }
        if (string2 == null || string2.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jdbcProviderType is not set.  Attempt to use the provider name instead.");
            }
            string2 = (String)configService.getAttribute(session, objectName, "name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerSearchString(providerName)", string2);
            }
        }
        ObjectName[] objectNameArray = configService.queryTemplates(session, DATASOURCE_RESOURCE_TYPE);
        ObjectName objectName2 = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing datasource template list: " + objectNameArray.length);
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectNameArray[i]);
            String string3 = configDataId.toString();
            if (!string3.startsWith(TEMPLATE_ID)) continue;
            ObjectName objectName3 = (ObjectName)configService.getAttribute(session, objectNameArray[i], "provider");
            String string4 = (String)configService.getAttribute(session, objectName3, "providerType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "templateProviderType", string4);
            }
            String string5 = (String)configService.getAttribute(session, objectNameArray[i], "description");
            TemplateDescriptor templateDescriptor = TemplateDescriptor.parseDescriptor(string5);
            if (!string4.equals(string2) || !JDBCConfigHelper.includeTemplate(templateDescriptor, string)) continue;
            objectName2 = objectNameArray[i];
            String string6 = ConfigServiceHelper.getDisplayName(objectName2);
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Selected templateName[" + i + "]: " + string6);
            Tr.debug(tc, "template", objectName2);
            break;
        }
        if (objectName2 == null) {
            String string7 = JDBCConfigHelper.getFormattedMessage("DSRA3604E", new Object[]{string2});
            throw new ConfigServiceException(string7);
        }
        DatasourceView datasourceView = new DatasourceView(configService, session, objectName2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatasourceTemplate", datasourceView);
        }
        return datasourceView;
    }

    public static ArrayList getDatasourceResourceProperties(ConfigService configService, Session session, ObjectName objectName, boolean bl) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatasourceResourceProperties", new Object[]{objectName, Boolean.toString(bl)});
        }
        AttributeList attributeList = (AttributeList)configService.getAttribute(session, objectName, "propertySet");
        ArrayList arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue(attributeList, "resourceProperties");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceProperties", arrayList);
        }
        ArrayList<DatasourceResourcePropertyView> arrayList2 = null;
        arrayList2 = new ArrayList<DatasourceResourcePropertyView>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AttributeList attributeList2 = (AttributeList)iterator.next();
            if (bl && !JDBCConfigHelper.includeDatabaseResourceProperty(attributeList2)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredProperty", attributeList2);
            }
            DatasourceResourcePropertyView datasourceResourcePropertyView = new DatasourceResourcePropertyView(configService, session, attributeList2);
            arrayList2.add(datasourceResourcePropertyView);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatasourceResourceProperties", arrayList2);
        }
        return arrayList2;
    }

    public static Collection makeList(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeList", new Object[]{string});
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.trim().equals("")) continue;
            vector.add(string2.trim());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Size: " + vector.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeList", vector);
        }
        return vector;
    }

    public static String getFormattedMessage(String string, Object[] objectArray) {
        return JDBCConfigHelper.getFormattedMessage(resBundle, string, objectArray);
    }

    public static String getFormattedMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage", new Object[]{resourceBundle, string, objectArray});
        }
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
            if (string2 == null) {
                string2 = new String("Cannot find message key " + string + "in resource bundle" + resourceBundle.toString());
                Tr.event(tc, string2);
            }
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = new String("Cannot find message key " + string + "in resource bundle " + resourceBundle.toString());
            Tr.event(tc, string2);
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            string2 = new String("Null pointer exception caught trying to find message key " + string + " in resource bundle " + resourceBundle.toString());
            Tr.event(tc, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFormattedMessage", string2);
        }
        return string2;
    }

    public static ObjectName resolveScope(ConfigService configService, Session session, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveScope", string);
        }
        ObjectName objectName = null;
        if (string != null && !string.equals("")) {
            ObjectName[] objectNameArray = AdminCommandHelper.getResources(session, configService, string);
            if (objectNameArray.length != 1) {
                throw new InvalidConfigDataTypeException(string);
            }
            objectName = objectNameArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveScope", objectName);
        }
        return objectName;
    }

    private static void constructJDBCProviderDataStructures(ConfigService configService, Session session, String string, Object object) throws Throwable {
        String[] stringArray;
        String[] stringArray2;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        int n;
        HashMap hashMap;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructJDBCProviderDataStructures", string);
        }
        ObjectName objectName = JDBCConfigHelper.resolveScope(configService, session, string);
        ObjectName objectName2 = null;
        try {
            objectName2 = JDBCConfigHelper.resolveScope(configService, session, currentScope);
        }
        catch (ConfigServiceException configServiceException) {
            FFDCFilter.processException(configServiceException, "com.ibm.ws.rsadapter.jdbcproviderutils.confighelper", "1420");
        }
        String string2 = null;
        if (objectName2 != null) {
            string2 = VersionHelper.getProductVersion(objectName2, session);
        }
        String string3 = VersionHelper.getProductVersion(objectName, session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "requested data", object);
            Tr.debug(tc, "current Version", string2);
            Tr.debug(tc, "new Version", string3);
            Tr.debug(tc, "current scope", currentScope);
            Tr.debug(tc, "new scope", string);
            Tr.debug(tc, "types include deprecated", new Boolean(typesIncludeDeprecated));
            Tr.debug(tc, "include deprecated", new Boolean(includeDeprecated));
        }
        if (object != null && string3.equals(string2) && currentScope.equals(string) && includeDeprecated == typesIncludeDeprecated) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "constructJDBCProviderDataStructures", "Exited early!");
            }
            return;
        }
        currentScope = string;
        typesIncludeDeprecated = includeDeprecated;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray3 = DSConfigurationHelper.getAdminSupportedDatabases();
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            Tr.debug(tc, "adding supported db: " + stringArray3[n2]);
            arrayList.add(stringArray3[n2]);
        }
        if (JDBCConfigHelper.isXD()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isXD: true");
            }
            n2 = stringArray3.length - 1;
            Tr.debug(tc, "adding Proxy type to index: " + n2);
            arrayList.add(n2, DBTYPE_PROXY);
        }
        Tr.debug(tc, "tempDBTypes", arrayList);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dbtypes structure constructed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Constructing tempValues data structure");
        }
        ArrayList arrayList2 = new ArrayList();
        Vector<String[]> vector = new Vector<String[]>();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding hashmaps to tempvalues arraylist...");
        }
        ObjectName[] objectNameArray = arrayList.iterator();
        while (objectNameArray.hasNext()) {
            String string4 = (String)objectNameArray.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dbType: ", string4);
            }
            hashMap = new HashMap();
            arrayList2.add(hashMap);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Hashmaps added.");
            Tr.debug(tc, "tempDBTypes size: " + arrayList.size());
            Tr.debug(tc, "tempvalues size: " + arrayList2.size());
            Tr.debug(tc, "Querying provider templates and populating data structures...");
        }
        objectNameArray = configService.queryTemplates(session, JDBC_PROVIDER_RESOURCE_TYPE);
        for (n = 0; n < objectNameArray.length; ++n) {
            hashMap = objectNameArray[n];
            object4 = (String)configService.getAttribute(session, (ObjectName)((Object)hashMap), "description");
            object3 = (String[])configService.getAttribute(session, (ObjectName)((Object)hashMap), "name");
            serializable = ConfigServiceHelper.getConfigDataId(hashMap);
            String string5 = ((ConfigDataId)serializable).toString();
            object2 = TemplateDescriptor.parseDescriptor((String)object4);
            if (!string5.startsWith(TEMPLATE_ID) || !JDBCConfigHelper.includeTemplate((TemplateDescriptor)object2, string3)) continue;
            stringArray2 = object3;
            stringArray = null;
            int n3 = 0;
            vector.addElement((String[])object3);
            Boolean bl = (Boolean)configService.getAttribute(session, (ObjectName)((Object)hashMap), "xa");
            if (bl.booleanValue()) {
                object3 = ((String)object3).replaceFirst("\\(XA\\)", "").trim();
                object3 = ((String)object3).replaceFirst("\\(Native XA\\)", "(Native)").trim();
                object3 = ((String)object3).replaceFirst("\\(Toolbox XA\\)", "(Toolbox)").trim();
                object3 = ((String)object3).replaceFirst("\\(Native XA\\ ", "(Native ").trim();
                n3 = 1;
            } else {
                object3 = ((String)object3).trim();
                n3 = 0;
            }
            if (((TemplateDescriptor)object2).deprecated) {
                object3 = (String)object3 + " " + deprecatedTag;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                HashMap hashMap2;
                String string6 = (String)arrayList.get(i);
                string6 = string6.trim();
                String string7 = (String)dbAliases.get(string6);
                if (((String)object3).indexOf(string6) < 0 && (null == string7 || ((String)object3).indexOf(string7) < 0) || (stringArray = (String[])(hashMap2 = (HashMap)arrayList2.get(i)).get(object3)) != null) continue;
                stringArray = new String[2];
                hashMap2.put(object3, stringArray);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added tempvalues[" + i + "] - tranlist for name: " + (String)object3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding tranlist value: " + (String)stringArray2);
            }
            if (stringArray != null) {
                stringArray[n3] = stringArray2;
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Template error: DB Type for provider does not exist; Ignore providerName in TranList:" + (String)stringArray2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Data structure populated");
        }
        dropList = vector;
        dbTypes = new ArrayList();
        jdbcProviderDataStructure = new ArrayList();
        driverTypes = new ArrayList();
        tranArray = new ArrayList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Constructing driverTypes and tranArray data structures");
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            hashMap = (HashMap)arrayList2.get(n);
            object4 = hashMap.entrySet().iterator();
            object3 = new ArrayList(hashMap.size());
            serializable = new ArrayList(hashMap.size());
            int n4 = 0;
            while (object4.hasNext()) {
                object2 = (Map.Entry)object4.next();
                ((ArrayList)object3).add(n4, object2.getKey());
                stringArray2 = (String[])object2.getValue();
                stringArray = new ArrayList(2);
                stringArray.add(0, stringArray2[0]);
                stringArray.add(1, stringArray2[1]);
                ((ArrayList)serializable).add(n4, stringArray);
                ++n4;
            }
            if (hashMap.isEmpty()) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Hashmap for tempvalues[" + n + "] is not empty.");
                Tr.debug(tc, "Adding dbType: " + arrayList.get(n));
            }
            dbTypes.add(arrayList.get(n));
            jdbcProviderDataStructure.add(hashMap);
            driverTypes.add(object3);
            tranArray.add(serializable);
        }
        if (tc.isDebugEnabled()) {
            JDBCConfigHelper.dumpJDBCProviderDataStructure(configService, session, string);
            Tr.debug(tc, "driverTypes and tranArray data structures constructed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructJDBCProviderDataStructures");
        }
    }

    private static boolean includeTemplate(TemplateDescriptor templateDescriptor, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "includeTemplate", new Object[]{templateDescriptor, string});
        }
        boolean bl = true;
        string = VersionHelper.truncateVersion(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "truncatedProductVersion", string);
        }
        if (templateDescriptor.deprecated && includeDeprecated) {
            bl = true;
        } else if (templateDescriptor.deprecated && templateDescriptor.minVersion == null && templateDescriptor.maxVersion == null) {
            bl = false;
        } else {
            int n = templateDescriptor.minVersion == null || templateDescriptor.minVersion.equals("null") ? -1 : VersionHelper.compareVersions(VersionHelper.truncateVersion(templateDescriptor.minVersion), string);
            int n2 = templateDescriptor.maxVersion == null || templateDescriptor.maxVersion.equals("null") ? 1 : VersionHelper.compareVersions(VersionHelper.truncateVersion(templateDescriptor.maxVersion), string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "minCompare", n);
                Tr.debug(tc, "maxCompare", n2);
            }
            boolean bl2 = bl = !(n != -1 && n != 0 || n2 != 1 && n2 != 0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "includeTemplate", bl);
        }
        return bl;
    }

    private static boolean includeDatabaseResourceProperty(AttributeList attributeList) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "includeDatabaseResourceProperty", attributeList);
        }
        boolean bl = false;
        String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
        String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "description");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "name", string);
            Tr.debug(tc, "description", string2);
        }
        String[] stringArray = string2.split(" - ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.startsWith(ADMIN_REQUIRED_DESCRIPTION_TAG)) continue;
            int n = string3.indexOf(61) + 1;
            String string4 = string3.substring(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminRequiredString", string4);
            }
            bl = Boolean.parseBoolean(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "includeDatabaseResourceProperty", bl);
        }
        return bl;
    }

    private static void dumpJDBCProviderDataStructure(ConfigService configService, Session session, String string) throws Throwable {
        String[] stringArray;
        String string2;
        Collection<Object> collection;
        Object object;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dumpJDBCProviderDataStructure", string);
        }
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug(tc, "Data structure sizes:");
        Tr.debug(tc, "dbTypes: " + dbTypes.size());
        Tr.debug(tc, "jdbcProviderDataStructure: " + jdbcProviderDataStructure.size());
        Tr.debug(tc, "driverTypes: " + driverTypes.size());
        Tr.debug(tc, "tranArray: " + tranArray.size());
        Tr.debug(tc, "dropList: " + dropList.size());
        ArrayList arrayList = JDBCConfigHelper.getDatabaseTypesDataStructure(configService, session, string);
        ArrayList arrayList2 = JDBCConfigHelper.getDriverTypesDataStructure(configService, session, string);
        ArrayList arrayList3 = JDBCConfigHelper.getTranTypesDataStructure(configService, session, string);
        Tr.debug(tc, "DatabaseTypes, DriverTypes, and TranTypes Data Structures:");
        for (n = 0; n < arrayList.size(); ++n) {
            object = (String)arrayList.get(n);
            object = ((String)object).trim();
            Tr.debug(tc, "*** dbType[" + n + "] - " + (String)object);
            collection = (ArrayList)arrayList2.get(n);
            for (int i = 0; i < ((ArrayList)collection).size(); ++i) {
                string2 = (String)((ArrayList)collection).get(i);
                string2 = string2.trim();
                Tr.debug(tc, "   ** driver[" + i + "] - " + string2);
                stringArray = (String[])arrayList3.get(n);
                ArrayList arrayList4 = (ArrayList)stringArray.get(i);
                Tr.debug(tc, "       * tran[0] - " + (String)arrayList4.get(0));
                Tr.debug(tc, "       * tran[1] - " + (String)arrayList4.get(1));
            }
        }
        Tr.debug(tc, "jdbcProviderDataStructure", jdbcProviderDataStructure);
        Tr.debug(tc, "jdbcProviderDataStructure:");
        for (n = 0; n < jdbcProviderDataStructure.size(); ++n) {
            Tr.debug(tc, "*** dbType[" + n + "] - " + arrayList.get(n));
            object = (HashMap)jdbcProviderDataStructure.get(n);
            collection = ((HashMap)object).keySet();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                Tr.debug(tc, "   ** driver: " + string2);
                stringArray = (String[])((HashMap)object).get(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    Tr.debug(tc, "       * tran[" + i + "]: " + stringArray[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dumpJDBCProviderDataStructure");
        }
    }

    private static boolean isXD() {
        return product != null;
    }

    public static void updateDatasourceResourceProperty(ConfigService configService, Session session, ObjectName objectName, String string, String string2, String string3) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDatasourceResourceProperty", new Object[]{objectName, string, string2, string3});
        }
        string = string.trim();
        string2 = string2.trim();
        string3 = string3.trim();
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, J2EE_RESOURCE_PROPERTY_TYPE);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing J2EEResourceProperty set results: " + objectNameArray.length);
        }
        boolean bl = false;
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName3 = objectNameArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "property", objectName3);
            }
            String string4 = (String)configService.getAttribute(session, objectName3, "name");
            String string5 = (String)configService.getAttribute(session, objectName3, "type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "property[" + i + "]: " + string4 + " - " + string5);
            }
            if (!string.equals(string4) || !string2.equals(string5)) continue;
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting value: " + string3);
            }
            attributeList.clear();
            attributeList.add(new Attribute("value", string3));
            DatasourceResourcePropertyView datasourceResourcePropertyView = new DatasourceResourcePropertyView(configService, session, objectName3);
            String string6 = datasourceResourcePropertyView.getDescription();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting description: " + string6);
            }
            attributeList.add(new Attribute("description", string6));
            configService.setAttributes(session, objectName3, attributeList);
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Property value set");
            break;
        }
        if (!bl) {
            String string7 = JDBCConfigHelper.getFormattedMessage("DSRA3606E", new Object[]{string, string2, string3});
            throw new ConfigServiceException(string7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateDatasourceResourceProperty");
        }
    }

    public static List getResources(ConfigService configService, Session session, ObjectName objectName, ObjectName objectName2) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResources", new Object[]{objectName, objectName2});
        }
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ConfigDataId configDataId = null;
        String string = null;
        if (objectName != null) {
            configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            string = configDataId.getContextUri();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeContext", string);
            }
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (objectName != null) {
                ConfigDataId configDataId2 = ConfigServiceHelper.getConfigDataId(objectNameArray[i]);
                String string2 = configDataId2.getContextUri();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matchContext", string2);
                }
                if (!string2.equals(string)) continue;
            }
            arrayList.add(objectNameArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResources", arrayList);
        }
        return arrayList;
    }

    public static String getProviderTypeAlias(ConfigService configService, Session session, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProviderTypeAlias", new Object[]{configService, session, string, string2});
        }
        String string3 = string2;
        if (string2 != null && string2.startsWith("Sybase")) {
            try {
                ObjectName objectName = JDBCConfigHelper.resolveScope(configService, session, string);
                string3 = JDBCConfigHelper.getProviderTypeAlias(objectName, session, string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProviderTypeAlias", new Object[]{string3});
        }
        return string3;
    }

    public static String getProviderTypeAlias(ObjectName objectName, Session session, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProviderTypeAlias", new Object[]{objectName, session, string});
        }
        String string2 = string;
        if (string != null && string.startsWith("Sybase")) {
            try {
                String string3 = VersionHelper.getProductVersion(objectName, session);
                if (string3.startsWith("6.0")) {
                    if (string.equals("Sybase JDBC 2 Driver")) {
                        string2 = "Sybase JDBC Driver";
                    } else if (string.equals("Sybase JDBC 2 Driver (XA)")) {
                        string2 = "Sybase JDBC Driver (XA)";
                    }
                } else if (string3.startsWith("6.1") || string3.startsWith("7")) {
                    if (string.equals("Sybase JDBC Driver")) {
                        string2 = "Sybase JDBC 2 Driver";
                    } else if (string.equals("Sybase JDBC Driver (XA)")) {
                        string2 = "Sybase JDBC 2 Driver (XA)";
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProviderTypeAlias", new Object[]{string2});
        }
        return string2;
    }

    static {
        block2: {
            BUNDLE_FILE = "IBMDataStoreAdapterNLS";
            TRACE_GROUP = "WAS.jdbcprovidercommands";
            resBundle = ResourceBundle.getBundle(BUNDLE_FILE, Locale.getDefault());
            tc = Tr.register(JDBCConfigHelper.class, TRACE_GROUP, BUNDLE_FILE);
            wasHome = System.getProperty("was.install.root");
            product = new WASDirectory(wasHome).getWASProductInfo("XD");
            currentScope = "";
            jdbcProviderDataStructure = null;
            dbTypes = null;
            driverTypes = null;
            tranArray = null;
            dropList = null;
            includeDeprecated = false;
            deprecatedTag = DEPRECATED_DESCRIPTION_TAG;
            typesIncludeDeprecated = false;
            dbAliases = new HashMap();
            dbAliases.put("SQL Server", "SQLServer");
            synchLoad = new Object();
            onePC_en = "";
            twoPC_en = "";
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_FILE, Locale.US);
                onePC_en = JDBCConfigHelper.getFormattedMessage(resourceBundle, "JDBCProviderTemplate.tranType.connectionpool", null).trim();
                twoPC_en = JDBCConfigHelper.getFormattedMessage(resourceBundle, "JDBCProviderTemplate.tranType.xa", null).trim();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.rsadapter.jdbcproviderutils.confighelper", "705");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "An exception occurred obtaining Locale.US parameter values for onePC_en=" + onePC_en + ", twoPC_en=" + twoPC_en + "; see FFDC logs for e=:  + ", exception);
            }
        }
    }
}

