/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbcproviderutils.confighelper;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.JDBCConfigHelper;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.TemplateView;
import java.util.Collection;
import javax.management.ObjectName;

public class JDBCProviderView
extends TemplateView {
    private static final String DERBY_NETWORK_UNIVERSAL_PROVIDER = "Derby Network Server Using Universal JDBC Driver";
    private static final String DERBY_JDBC_PROVIDER = "Derby JDBC Provider";
    private static final String CLASSPATH_DERBY_NETWORK_UNIVERSAL_602 = "${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc.jar;${CLOUDSCAPE_JDBC_DRIVER_PATH}/otherJars/db2jcc.jar;${UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc_license_cu.jar";
    private static final String CLASSPATH_DERBY_JDBC_PROVIDER_602 = "${WAS_INSTALL_ROOT}/derby/lib/derby.jar";
    protected TraceComponent tc = Tr.register(JDBCProviderView.class, JDBCConfigHelper.TRACE_GROUP, JDBCConfigHelper.BUNDLE_FILE);
    private String productVersion;

    public JDBCProviderView(ConfigService configService, Session session, ObjectName objectName, String string) throws Throwable {
        super(configService, session, objectName, false);
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "constructor", new Object[]{objectName, string});
        }
        this.productVersion = string;
        this.cleanupClasspath();
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "constructor");
        }
    }

    public String getProviderType() {
        String string = (String)this.getAttributeValue("providerType");
        return string;
    }

    public String getName() {
        String string = (String)this.getAttributeValue("name");
        return string;
    }

    public String getDescription() {
        return super.getDescription();
    }

    public String getImplementationClassName() {
        String string = (String)this.getAttributeValue("implementationClassName");
        return string;
    }

    public Boolean isXA() {
        Boolean bl = (Boolean)this.getAttributeValue("xa");
        return bl;
    }

    public Collection getClasspath() {
        Collection collection = (Collection)this.getAttributeValue("classpath");
        return collection;
    }

    public Collection getNativepath() {
        Collection collection = (Collection)this.getAttributeValue("nativepath");
        return collection;
    }

    private void cleanupClasspath() throws Throwable {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "cleanupClasspath");
        }
        Collection collection = this.getClasspath();
        String string = this.getProviderType();
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "providerType", string);
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "productVersion", this.productVersion);
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "originalClasspath", collection);
        }
        Collection collection2 = collection;
        collection2 = string.equals(DERBY_NETWORK_UNIVERSAL_PROVIDER) && this.productVersion.startsWith("6.0.2") ? JDBCConfigHelper.makeList(CLASSPATH_DERBY_NETWORK_UNIVERSAL_602) : (string.startsWith(DERBY_JDBC_PROVIDER) && this.productVersion.startsWith("6.0.2") ? JDBCConfigHelper.makeList(CLASSPATH_DERBY_JDBC_PROVIDER_602) : collection);
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "newClasspath", collection2);
        }
        this.setAttributeValue("classpath", collection2);
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "cleanupClasspath");
        }
    }
}

