/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbcproviderutils.confighelper;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.JDBCConfigHelper;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

class TemplateView {
    protected TraceComponent tc = Tr.register(TemplateView.class, JDBCConfigHelper.TRACE_GROUP, JDBCConfigHelper.BUNDLE_FILE);
    private ObjectName template;
    private AttributeList attrList;

    public TemplateView(ConfigService configService, Session session, ObjectName objectName, boolean bl) throws Throwable {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "constructor", new Object[]{objectName, bl});
        }
        this.template = objectName;
        this.attrList = configService.getAttributes(session, objectName, null, bl);
        this.cleanupDescription();
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "constructor");
        }
    }

    public TemplateView(ConfigService configService, Session session, AttributeList attributeList) throws Throwable {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "constructor", attributeList);
        }
        this.template = null;
        this.attrList = attributeList;
        this.cleanupDescription();
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "constructor");
        }
    }

    public String getDescription() {
        String string = (String)this.getAttributeValue("description");
        return string;
    }

    public String getDisplayName() {
        String string = ConfigServiceHelper.getDisplayName(this.template);
        return string;
    }

    public ObjectName getTemplate() {
        return this.template;
    }

    public AttributeList getAttributeList() {
        return this.attrList;
    }

    public Object getAttributeValue(String string) {
        Object object;
        block4: {
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "getAttributeValue", string);
            }
            object = null;
            try {
                object = ConfigServiceHelper.getAttributeValue(this.attrList, string);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (!this.tc.isDebugEnabled()) break block4;
                Tr.debug(this.tc, "Exception", attributeNotFoundException);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "getAttributeValue", object);
        }
        return object;
    }

    public void setAttributeValue(String string, Object object) {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "setAttributeValue", new Object[]{string, object});
        }
        ConfigServiceHelper.setAttributeValue(this.attrList, string, object);
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "setAttributeValue");
        }
    }

    protected void cleanupDescription() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "cleanupDescription");
        }
        String string = this.getDescription();
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "originalDescription", string);
        }
        String[] stringArray = string.split(" - ");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "token", string2);
            }
            if (string2.equals("Deprecated")) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "Contains deprecated tag");
                }
                stringBuffer.append(string2);
                stringBuffer.append(" - ");
                continue;
            }
            if (string2.startsWith("minVer") || string2.startsWith("maxVer") || string2.startsWith("adminRequired")) continue;
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "minVer, maxVer, or adminRequired tag found - removed");
            }
            stringBuffer.append(string2);
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "newDescription", stringBuffer.toString());
        }
        this.setAttributeValue("description", stringBuffer.toString());
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "cleanupDescription");
        }
    }
}

