/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbcproviderutils.confighelper;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.rsadapter.jdbcproviderutils.confighelper.JDBCConfigHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class VersionHelper {
    private static TraceComponent tc = Tr.register(VersionHelper.class, JDBCConfigHelper.TRACE_GROUP, JDBCConfigHelper.BUNDLE_FILE);
    public static final int VERSION_EARLIER = -1;
    public static final int VERSION_LATER = 1;
    public static final int VERSION_EQUAL = 0;

    public static int compareVersions(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareVersion", new Object[]{string, string2});
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        short s = 0;
        short s2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            s = Short.parseShort(stringTokenizer.nextToken());
            if (!stringTokenizer2.hasMoreTokens()) {
                while (s == 0) {
                    if (stringTokenizer.hasMoreTokens()) {
                        s = Short.parseShort(stringTokenizer.nextToken());
                        continue;
                    }
                    return 0;
                }
                return 1;
            }
            s2 = Short.parseShort(stringTokenizer2.nextToken());
            if (s < s2) {
                return -1;
            }
            if (s <= s2) continue;
            return 1;
        }
        if (stringTokenizer2.hasMoreTokens()) {
            s2 = Short.parseShort(stringTokenizer2.nextToken());
            while (s2 == 0) {
                if (stringTokenizer2.hasMoreTokens()) {
                    s2 = Short.parseShort(stringTokenizer2.nextToken());
                    continue;
                }
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public static String truncateVersion(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "truncateVersion", string);
        }
        String[] stringArray = string.split("\\.");
        String string2 = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version tokens: " + stringArray.length);
        }
        if (stringArray.length > 3) {
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < 3; ++i) {
                stringBuffer.append(".");
                stringBuffer.append(stringArray[i]);
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "truncateVersion", string2);
        }
        return string2;
    }

    public static String getProductVersion(ObjectName objectName, Session session) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProductVersion", objectName);
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "location", properties);
        }
        String string = properties.getProperty("cluster");
        String string2 = properties.getProperty("cell");
        String string3 = properties.getProperty("node");
        String string4 = properties.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cluster", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell", string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node", string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", string4);
        }
        String string5 = null;
        string5 = string != null && !string.equals("") ? VersionHelper.getClusterVersion(string, string3, session) : VersionHelper.getNodeVersion(string3, session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProductVersion", string5);
        }
        return string5;
    }

    private static String getClusterVersion(String string, String string2, Session session) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterVersion", new Object[]{string, string2});
        }
        String string3 = null;
        if (string2 != null && !string2.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName specified, using it to obtain version");
            }
            string3 = VersionHelper.getNodeVersion(string2, session);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName=null, look at all cluster nodes");
            }
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            String string4 = "cluster=" + string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scope", string4);
            }
            ObjectName objectName = JDBCConfigHelper.resolveScope(configService, session, string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster", objectName);
            }
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "members");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList = (AttributeList)iterator.next();
                String string5 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "memberName", string5);
                }
                string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeName", string2);
                }
                String string6 = VersionHelper.getNodeVersion(string2, session);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "version", string6);
                }
                if (string3 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "result is null so set with current version");
                    }
                    string3 = string6;
                    continue;
                }
                int n = VersionHelper.compareVersions(string6, string3);
                if (n != 1) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "version is later than current result");
                }
                string3 = string6;
            }
        }
        if (string3 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cluster contains no nodes or members.  Use default node for cell");
            }
            string3 = VersionHelper.getNodeVersion(null, session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterVersion", string3);
        }
        return string3;
    }

    private static String getNodeVersion(String string, Session session) throws Throwable {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeVersion", string);
        }
        String string2 = null;
        if (string == null || string.equals("")) {
            object = AdminServiceFactory.getAdminService();
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Running in WAS scripting environment");
                }
                string = System.getProperty("local.node");
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Running in WAS server runtime environment");
                    Tr.debug(tc, "cellName", object.getCellName());
                    Tr.debug(tc, "processName", object.getProcessName());
                    Tr.debug(tc, "processType", object.getProcessType());
                }
                string = object.getNodeName();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Default node for cell: " + string);
            }
        }
        object = CommandMgr.getCommandMgr().createCommand("getNodeBaseProductVersion");
        object.setParameter("nodeName", string);
        object.setConfigSession(session);
        object.execute();
        CommandResult commandResult = object.getCommandResult();
        if (!commandResult.isSuccessful()) {
            Throwable throwable = commandResult.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while executing getNodeBaseProductVersion command", throwable);
            }
            throw throwable;
        }
        string2 = (String)commandResult.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeVersion", string2);
        }
        return string2;
    }
}

