/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.spi.ParameterList;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DynamicDSConfigManager
implements FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(DynamicDSConfigManager.class, "RRA", "IBMDataStoreAdapterNLS");
    private HashMap configMethodsToConfigID;
    private HashMap configIDToConfigMethods;
    private HashMap configIDToDataSource;
    private HashMap configIDToCMXDataSourceProxy;

    DynamicDSConfigManager(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", AdapterUtil.toString(object));
        }
        this.configMethodsToConfigID = new HashMap();
        this.configIDToConfigMethods = new HashMap();
        this.configIDToDataSource = new HashMap();
        this.add(0, new HashMap(), object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    DynamicDSConfigManager(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init2>", new Object[]{AdapterUtil.toString(object), object2});
        }
        this.configMethodsToConfigID = new HashMap();
        this.configIDToConfigMethods = new HashMap();
        this.configIDToDataSource = new HashMap();
        this.configIDToCMXDataSourceProxy = new HashMap();
        this.add(0, new HashMap(), object, object2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init2>", this);
        }
    }

    void add(int n, HashMap hashMap, Object object, Object object2) {
        Integer n2 = new Integer(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "add: proxy", new Object[]{n2, AdapterUtil.toString(object), hashMap, object2});
        }
        this.configMethodsToConfigID.put(hashMap, n2);
        this.configIDToConfigMethods.put(n2, hashMap);
        this.configIDToDataSource.put(n2, object);
        this.configIDToCMXDataSourceProxy.put(n2, object2);
    }

    void add(int n, HashMap hashMap, Object object) {
        Integer n2 = new Integer(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "add", new Object[]{n2, AdapterUtil.toString(object), hashMap});
        }
        this.configMethodsToConfigID.put(hashMap, n2);
        this.configIDToConfigMethods.put(n2, hashMap);
        this.configIDToDataSource.put(n2, object);
    }

    static void applyConfiguration(Object object, HashMap hashMap) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applyConfiguration", new Object[]{AdapterUtil.toString(object), DynamicDSConfigManager.hidePassword(hashMap)});
        }
        Class<?> clazz = object.getClass();
        try {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ParameterList parameterList = (ParameterList)entry.getValue();
                clazz.getMethod((String)entry.getKey(), parameterList.paramTypes).invoke(object, parameterList.paramValues);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException(invocationTargetException.getTargetException(), DynamicDSConfigManager.class.getName() + ".applyConfiguration", "137");
            Throwable throwable = invocationTargetException.getTargetException();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "applyConfiguration", throwable);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw AdapterUtil.toSQLException(throwable);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException(runtimeException, DynamicDSConfigManager.class.getName() + ".applyConfiguration", "154");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "applyConfiguration", runtimeException);
            }
            throw runtimeException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, DynamicDSConfigManager.class.getName() + ".applyConfiguration", "161");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "applyConfiguration", exception);
            }
            throw AdapterUtil.toSQLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applyConfiguration");
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{this, object});
        }
        try {
            bl = AdapterUtil.match(this.configIDToConfigMethods, ((DynamicDSConfigManager)object).configIDToConfigMethods);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    int getConfigID(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigID", DynamicDSConfigManager.hidePassword(hashMap));
        }
        Integer n = (Integer)this.configMethodsToConfigID.get(hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigID", n);
        }
        return n == null ? -1 : n;
    }

    Map getConfigMethods(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigMethods", new Integer(n));
        }
        Map map = (Map)this.configIDToConfigMethods.get(new Integer(n));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigMethods", map);
        }
        return map;
    }

    Object getDataSource(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataSource", new Integer(n));
        }
        Object v = this.configIDToDataSource.get(new Integer(n));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataSource", AdapterUtil.toString(v));
        }
        return v;
    }

    Object getCMXDataSourceProxy(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCMXDataSourceProxy", new Integer(n));
        }
        Object v = this.configIDToCMXDataSourceProxy.get(new Integer(n));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCMXDataSourceProxy", v);
        }
        return v;
    }

    private static Map hidePassword(HashMap hashMap) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>(hashMap);
        Object v = hashMap2.remove("setPassword");
        if (v != null) {
            hashMap2.put("setPassword", "******");
        }
        return hashMap2;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(500, this);
        DecimalFormat decimalFormat = new DecimalFormat("'  '000");
        fFDCLogger.append("CONFIG ID  DATA SOURCE  MODIFIED PROPERTIES");
        HashMap hashMap = new HashMap(this.configIDToDataSource);
        HashMap hashMap2 = new HashMap(this.configIDToConfigMethods);
        Iterator iterator = this.configMethodsToConfigID.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                HashMap hashMap3 = (HashMap)entry.getKey();
                Object v = entry.getValue();
                Object v2 = hashMap.remove(v);
                hashMap2.remove(v);
                fFDCLogger.append(decimalFormat.format(((Integer)v).intValue()) + "      " + Integer.toHexString(v2.hashCode()) + "     " + DynamicDSConfigManager.hidePassword(hashMap3));
            }
            catch (Exception exception) {}
        }
        if (!hashMap.isEmpty()) {
            fFDCLogger.append("Error! Configuration-ID-to-DataSource map has extra entries:", hashMap);
        }
        if (!hashMap2.isEmpty()) {
            fFDCLogger.append("Error! Configuration-ID-to-Config-methods map has extra entries:", hashMap2);
        }
        return fFDCLogger.toStringArray();
    }
}

