/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.DB2AS400NativeUtility;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.resource.ResourceException;

public class InternalDB2AS400NativeDataStoreHelper
extends InternalDB2DataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalDB2AS400NativeDataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    boolean isolationLevelSwitchingSupport = false;
    boolean switchingSupportDetermined = false;
    protected static String os400Version_;
    protected static int os400VersionNum_;
    private DB2AS400NativeUtility UTILITY = (DB2AS400NativeUtility)AdapterUtil.createDBUtility("com.ibm.ws.rsadapter.dbutils.impl.DB2AS400NativeUtilityImpl");

    public void setProperties(Properties properties) throws ResourceException {
        if (properties != null) {
            super.setProperties(properties);
            String string = properties.getProperty("isolationLevelSwitchingSupport");
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "internalDB2AS400NativeDataStoreHelper.setProperties():  isolationSwitchingSupported property = " + string);
                }
                this.isolationLevelSwitchingSupport = new Boolean(string);
                this.switchingSupportDetermined = true;
            }
        }
    }

    public String getCorrelator(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        try {
            return this.UTILITY.getServerJobName(wSRdbManagedConnectionImpl.sqlConn);
        }
        catch (SQLException sQLException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getServerJobName()", sQLException, "method may not be supported on DB2 driver being used"});
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getServerJobName()", nullPointerException, "method not supported on DB2 driver being used"});
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getServerJobName()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        return null;
    }

    public void setEwlmCorrelator(byte[] byArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        try {
            if (byArray != null) {
                this.UTILITY.setDB2eWLMCorrelator(wSRdbManagedConnectionImpl.sqlConn, byArray);
            }
        }
        catch (SQLException sQLException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", sQLException, "method not be supported on DB2 driver being used"});
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", nullPointerException, "method not supported on DB2 driver being used"});
        }
    }

    protected static final int generateVersionNumber(String string) {
        int n = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "VRM", false);
        if (stringTokenizer.countTokens() == 3) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2 + stringTokenizer.nextToken();
            string2 = string2 + stringTokenizer.nextToken();
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public boolean isIsolationLevelSwitchingSupport() {
        if (!this.switchingSupportDetermined) {
            os400Version_ = System.getProperty("os.version");
            os400VersionNum_ = InternalDB2AS400NativeDataStoreHelper.generateVersionNumber(os400Version_);
            if (os400VersionNum_ >= 530) {
                this.isolationLevelSwitchingSupport = true;
            }
            this.switchingSupportDetermined = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "internalDB2AS400NativeDataStoreHelper.isIsolationLevelSwitchingSupport():  isolationSwitchingSupported has a value of " + this.isolationLevelSwitchingSupport);
        }
        return this.isolationLevelSwitchingSupport;
    }
}

