/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.DB2AS400ToolBoxUtility;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;

public class InternalDB2AS400ToolboxDataStoreHelper
extends InternalDB2DataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalDB2AS400ToolboxDataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    private DB2AS400ToolBoxUtility UTILITY = null;
    boolean isolationLevelSwitchingSupport = false;

    public InternalDB2AS400ToolboxDataStoreHelper() throws Exception {
        this.localZOS = false;
        this.isRRSTransaction = false;
        this.threadIdentitySupport = "NOTALLOWED";
        this.threadSecurity = false;
        this.UTILITY = (DB2AS400ToolBoxUtility)AdapterUtil.createDBUtility("com.ibm.ws.rsadapter.dbutils.impl.DB2AS400ToolBoxUtilityImpl");
    }

    public void setProperties(Properties properties) throws ResourceException {
        if (properties != null) {
            super.setProperties(properties);
            String string = properties.getProperty("isolationLevelSwitchingSupport");
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "internalDB2AS400ToolboxDataStoreHelper.setProperties():  isolationSwitchingSupported property = " + string);
                }
                this.isolationLevelSwitchingSupport = new Boolean(string);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "internalDB2AS400ToolboxDataStoreHelper.setProperties():  isolationSwitchingSupported property not set for this datasource");
            }
        }
    }

    public String getCorrelator(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        try {
            return this.UTILITY.getServerJobIdentifier(wSRdbManagedConnectionImpl.sqlConn);
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getServerJobIdentifier()", nullPointerException, "method not supported on DB2 driver being used"});
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getServerJobIdentifier()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        catch (IllegalAccessError illegalAccessError) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getServerJobIdentifier()", illegalAccessError, ": AS400JDBCConnectionHandle is not a public class in the version of the Toolbox driver being used."});
        }
        catch (SQLException sQLException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getServerJobIdentifier()", sQLException, "method may not be supported on DB2 driver being used"});
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
        return null;
    }

    public void setEwlmCorrelator(byte[] byArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        try {
            if (byArray != null) {
                this.UTILITY.setDB2eWLMCorrelator(wSRdbManagedConnectionImpl.sqlConn, byArray);
            }
        }
        catch (SQLException sQLException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", sQLException, "method may not be supported on DB2 driver being used"});
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", nullPointerException, "method not supported on DB2 driver being used"});
        }
    }

    public boolean isIsolationLevelSwitchingSupport() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "internalDB2AS400ToolboxDataStoreHelper.isIsolationLevelSwitchingSupport():  isolationSwitchingSupported has a value of " + this.isolationLevelSwitchingSupport);
        }
        return this.isolationLevelSwitchingSupport;
    }
}

