/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.db2.jcc.DB2Wrapper;
import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.DB2UniversalUtility;
import com.ibm.ws.rsadapter.jdbc.WSDB2WrapperConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.resource.ResourceException;

public class InternalDB2DataStoreHelper
extends InternalGenericDataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalDB2DataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    private DB2UniversalUtility UTILITY = (DB2UniversalUtility)AdapterUtil.createDBUtility("com.ibm.ws.rsadapter.dbutils.impl.DB2UniversalUtilityImpl");
    protected static final TraceComponent db2Tc = Tr.register("com.ibm.ws.db2.logwriter", "WAS.database", null);
    String osType;
    boolean isRRSTransaction = false;
    String threadIdentitySupport = "NOTALLOWED";
    boolean threadSecurity = false;
    boolean localZOS = false;
    protected static boolean private_disableResetUOW;
    private static Field mTransactionStateField;
    String productName = null;
    static int JDBC;
    static int SQLJ;
    int connType = 0;
    private transient PrintWriter db2Pw;

    public InternalDB2DataStoreHelper() throws Exception {
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            this.localZOS = true;
        }
        if (this.localZOS) {
            this.isRRSTransaction = true;
            this.threadIdentitySupport = "ALLOWED";
            this.threadSecurity = true;
        }
    }

    public Reassociateable createJDBCConnectionWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJDBCConnectionWrapper", wSRdbManagedConnectionImpl);
        }
        WSJdbcConnection wSJdbcConnection = null;
        Object object = wSRdbManagedConnectionImpl.threadID;
        if (object == null && wSRdbManagedConnectionImpl.mcf.detectMultithreadedAccess) {
            object = Thread.currentThread();
        }
        wSJdbcConnection = this.localZOS ? new WSDB2WrapperConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, object) : new WSJdbcConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJDBCConnectionWrapper", wSJdbcConnection);
        }
        return wSJdbcConnection;
    }

    public Boolean getRRSTransactional() {
        return new Boolean(this.isRRSTransaction);
    }

    public String getThreadIdentitySupport() {
        return this.threadIdentitySupport;
    }

    public Boolean getThreadSecurity() {
        return new Boolean(this.threadSecurity);
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.db2Pw == null) {
            this.db2Pw = this.externalHelper.getPrintWriter();
            if (this.db2Pw != null) {
                Tr.debug(db2Tc, "user supplied own printWriter in the datastore helper, will use provided one", this.db2Pw);
            } else {
                this.db2Pw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
            }
        }
        Tr.debug(tc, "returning", this.db2Pw);
        return this.db2Pw;
    }

    public Object getDefaultContext(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultContext", this);
        }
        Object object = null;
        try {
            object = this.UTILITY.createSQLJDefaultContext(connection);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper.getDefaultContext", "549", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultContext - failed trying to create Default ConnectionContext, throwing exception");
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultContext", object);
        }
        return object;
    }

    public void processLastHandleClosed(Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (this.localZOS && bl && !bl2) {
            this.resetUOWBoundary(connection);
        }
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (this.localZOS) {
            this.resetUOWBoundary(wSRdbManagedConnectionImpl.sqlConn);
        }
    }

    private void resetUOWBoundary(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetUOWBoundary");
        }
        if (!private_disableResetUOW) {
            boolean bl = true;
            if (this.localZOS && this.externalHelper.getMetaData().supportsUOWDetection()) {
                try {
                    int n;
                    DB2Wrapper dB2Wrapper = (DB2Wrapper)((Object)connection);
                    Object object = dB2Wrapper.getDB2Object();
                    if (mTransactionStateField == null) {
                        Class<?> clazz = object.getClass();
                        mTransactionStateField = clazz.getField("mTransactionState");
                    }
                    if ((n = mTransactionStateField.getInt(object)) == 0) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    Tr.event(tc, "JDBC Driver does not support UOW detection because of: ", exception);
                }
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Issuing rollback to reset UOW boundary");
                }
                connection.rollback();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Connection already on UOW boundary; skip rollback");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetUOWBoundary");
        }
    }

    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) {
        return db2Tc.isDebugEnabled() && !wSManagedConnectionFactoryImpl.loggingEnabled;
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return this.shouldTraceBeEnabled(wSRdbManagedConnectionImpl.mcf);
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !db2Tc.isDebugEnabled() && wSRdbManagedConnectionImpl.mcf.loggingEnabled;
    }

    public boolean isInDatabaseUnitOfWork(Connection connection) throws SQLException {
        return this.UTILITY.isInDB2UnitOfWork(connection);
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block8: {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            String string2 = databaseMetaData.getDriverName();
            this.setDatabaseProductName(string);
            Tr.info(tc, "DB_PRODUCT_NAME", string);
            Tr.info(tc, "DB_PRODUCT_VERSION", databaseMetaData.getDatabaseProductVersion());
            Tr.info(tc, "JDBC_DRIVER_NAME", string2);
            Tr.info(tc, "JDBC_DRIVER_VERSION", databaseMetaData.getDriverVersion());
            if (string2.equalsIgnoreCase("DSNAJDBC")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "application using <DB2 for zOS Local JDBC Provider (RRS)> which is not supported anymore in WAS6.1");
                }
                Tr.warning(tc, "PROVIDER_NOT_SUPPORTED", new Object[]{"DB2 for zOS Local JDBC Provider (RRS)", "DB2 Universal JDBC Driver Provider Type 2"});
                throw new SQLException(AdapterUtil.getNLSMessage("PROVIDER_NOT_SUPPORTED", new Object[]{"DB2 for zOS Local JDBC Provider (RRS)", "DB2 Universal JDBC Driver Provider Type 2"}));
            }
            try {
                if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdabiliy is supported");
                    }
                    this.holdabilitySupported = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", throwable);
            }
        }
    }

    static {
        mTransactionStateField = null;
        JDBC = 1;
        SQLJ = 2;
        private_disableResetUOW = new Boolean(System.getProperty("private_disableResetUOW"));
        if (tc.isDebugEnabled() && private_disableResetUOW) {
            Tr.debug(tc, "resetUOW is disabled");
        }
    }
}

