/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.websphere.rsadapter.WSSystemMonitor;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.dbutils.DB2UniversalUtility;
import com.ibm.ws.rsadapter.dbutils.WSJccUtility;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJccConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.PooledConnection;

public class InternalDB2UniversalDataStoreHelper
extends InternalDB2DataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalDB2UniversalDataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    private DB2UniversalUtility UTILITY = null;
    private WSJccUtility JCC_UTILITY = null;
    private static TraceComponent clientInfoTc = Tr.register("WAS.clientinfo", "WAS.clientinfo", "IBMDataStoreAdapterNLS");
    private static TraceComponent clientInfoPlusTc = Tr.register("WAS.clientinfopluslogging", "WAS.clientinfopluslogging", "IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;
    private int driverType = 0;
    private transient PrintWriter db2UPw;
    private transient String traceFile;
    private transient int configuredTraceLevel;
    private transient Class currClass = InternalDB2UniversalDataStoreHelper.class;
    private transient boolean ConnResetSupported = true;
    private transient boolean _workStationSetFlag = true;
    private transient String _workStationValue = " ";
    private transient Object _workStationLockObject = new Object();
    private transient boolean _dataSourceSetFlag = false;
    private transient boolean _foundDatasourceClientInfoValue = false;
    private transient String _applicationName = " ";
    private transient String _accountInfo = " ";
    private transient String _workStation = " ";
    private transient String _clientId = " ";
    private transient Object _dataSourceLockObject = new Object();

    public InternalDB2UniversalDataStoreHelper() throws Exception {
        this.UTILITY = (DB2UniversalUtility)AdapterUtil.createDBUtility("com.ibm.ws.rsadapter.dbutils.impl.DB2UniversalUtilityImpl");
        this.JCC_UTILITY = (WSJccUtility)AdapterUtil.createDBUtility("com.ibm.ws.rsadapter.dbutils.impl.WSJccUtilityImpl");
        this.configuredTraceLevel = this.getDefaultTraceLevel();
    }

    private int getDefaultTraceLevel() {
        return this.UTILITY.getDefaultTraceLevel();
    }

    public void setProperties(Properties properties) throws ResourceException {
        String string;
        super.setProperties(properties);
        this.isRRSTransaction = false;
        this.threadIdentitySupport = "NOTALLOWED";
        this.threadSecurity = false;
        String string2 = null;
        boolean bl = false;
        if (properties != null) {
            string2 = properties.getProperty("driverType");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "internalDB2UniversalDataStoreHelper.setProperties():  driverType property = " + string2);
            }
            if (string2 != null) {
                this.driverType = new Integer(string2);
                if (this.driverType == 2 || this.driverType == 4) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new ResourceException("Required driverType property was not specifed or is invalid. The driverType property is " + string2);
        }
        if (this.localZOS && this.driverType == 2) {
            string = properties.getProperty("dataSourceClass");
            if (string.equals("com.ibm.db2.jcc.DB2XADataSource")) {
                throw new ResourceException("DB2ZOS_TYPE2_ERROR");
            }
            if (string.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource")) {
                this.isRRSTransaction = true;
                this.threadIdentitySupport = "ALLOWED";
                this.threadSecurity = true;
                Tr.info(tc, "DB2ZOS_CONFIG_INFO");
            }
        }
        if (properties != null) {
            string = properties.getProperty("traceLevel");
            if (string != null && !string.equals("")) {
                this.configuredTraceLevel = Integer.parseInt(string);
                if (TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled()) {
                    Tr.debug(db2Tc, "traceLevel is set to ", new Integer(this.configuredTraceLevel));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled()) {
                Tr.debug(db2Tc, "traceLevel is not set, using WAS default: TRACE_CONNECTION_CALLS | TRACE_DRIVER_CONFIGURATION | TRACE_CONNECTS");
            }
            this.traceFile = properties.getProperty("traceFile");
        }
        if (this.traceFile != null && !this.traceFile.equals("")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "DB2 JDBC trace was configured to go to a file, Thus no integration with WAS trace.  File name is: ", this.traceFile);
            }
            try {
                this.db2UPw = new PrintWriter(new FileOutputStream(this.traceFile), true);
            }
            catch (IOException iOException) {
                Tr.error(tc, "DB2_FILE_OUTSTREAM_ERROR", this.traceFile);
            }
        } else {
            this.db2UPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
        }
    }

    public void closeDefaultContext(Object object) throws ResourceException {
        try {
            this.UTILITY.closeSQLJDefaultContext(object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".closeDefaultContext", "233", this);
            throw AdapterUtil.translateSQLException(this.externalHelper.mapException(sQLException), null, false, this.getClass());
        }
    }

    public String getCorrelator(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        try {
            return this.UTILITY.getDB2Correlator(wSRdbManagedConnectionImpl.sqlConn);
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getDB2Correlator()", nullPointerException, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getDB2Correlator()", noSuchMethodError, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (SQLException sQLException) {
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"getDB2Correlator()", sQLException, "method not supported on DB2 driver being used"});
            return null;
        }
    }

    public void setEwlmCorrelator(byte[] byArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        try {
            if (byArray != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setEwlmCorrelator: ", byArray);
                }
                this.UTILITY.setDB2eWLMCorrelator(wSRdbManagedConnectionImpl.sqlConn, byArray);
            }
        }
        catch (SQLException sQLException) {
            AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", sQLException, "method not supported on DB2 driver being used"});
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"setDB2eWLMCorrelator()", nullPointerException, "method not supported on DB2 driver being used"});
        }
    }

    public Reassociateable createJDBCConnectionWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        return this.JCC_UTILITY.createSQLJConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, wSRdbManagedConnectionImpl.threadID);
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled() && !wSRdbManagedConnectionImpl.loggingEnabled;
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !db2Tc.isDebugEnabled() && wSRdbManagedConnectionImpl.loggingEnabled;
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        Tr.debug(db2Tc, "Disabling logging on connection: ", wSRdbManagedConnectionImpl.sqlConn);
        try {
            this.UTILITY.setJCCLogWriter(wSRdbManagedConnectionImpl.sqlConn, null);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.disableJdbcLogging", "402", this);
            throw AdapterUtil.translateSQLException(sQLException, wSRdbManagedConnectionImpl, true, this.currClass);
        }
        wSRdbManagedConnectionImpl.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        PrintWriter printWriter = this.getPrintWriter();
        Tr.debug(db2Tc, "Setting printWriter on connection and with level: ", new Object[]{printWriter, wSRdbManagedConnectionImpl.sqlConn, new Integer(this.configuredTraceLevel)});
        try {
            this.UTILITY.setJCCLogWriter(wSRdbManagedConnectionImpl.sqlConn, printWriter, this.configuredTraceLevel);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.enableJdbcLogging", "419", this);
            throw AdapterUtil.translateSQLException(sQLException, wSRdbManagedConnectionImpl, true, this.currClass);
        }
        wSRdbManagedConnectionImpl.loggingEnabled = true;
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.db2UPw == null) {
            this.db2UPw = this.externalHelper.getPrintWriter();
            if (this.db2UPw != null) {
                Tr.debug(db2Tc, "user supplied own printWriter in the datastore helper, will use provided one", this.db2UPw);
            } else {
                this.db2UPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
            }
        }
        Tr.debug(db2Tc, "returning", this.db2UPw);
        return this.db2UPw;
    }

    public void setClientInformation(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        String string = " ";
        String string2 = " ";
        String string3 = " ";
        String string4 = " ";
        if (TraceComponent.isAnyTracingEnabled() && (tc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled())) {
            tempTc = clientInfoPlusTc.isDebugEnabled() ? clientInfoPlusTc : tc;
            Tr.debug(tempTc, "setClientInformation(Properties props,WSRdbManagedConnectionImpl mc, boolean explicitCall) with sqlConn", new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl), wSRdbManagedConnectionImpl.sqlConn});
        }
        if (bl) {
            string2 = properties.getProperty("CLIENT_ACCOUNTING_INFO");
            if (string2 == null || string2.equals("")) {
                string2 = " ";
            }
            if ((string3 = properties.getProperty("CLIENT_LOCATION")) == null || string3.equals("")) {
                string3 = " ";
            }
            if ((string4 = properties.getProperty("CLIENT_ID")) == null || string4.equals("")) {
                string4 = " ";
            }
            if ((string = properties.getProperty("CLIENT_APPLICATION_NAME")) == null || string.equals("")) {
                string = " ";
            }
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        }
        if (wSRdbManagedConnectionImpl.mcf.shouldDataBeCollectedAndPshedDownToCMX() || TraceComponent.isAnyTracingEnabled() && (clientInfoTc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled())) {
            if (string.equals(" ")) {
                try {
                    J2EEName j2EEName = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName();
                    string = j2EEName == null ? "NON-J2EE application" : j2EEName.getApplication();
                }
                catch (NullPointerException nullPointerException) {
                    string = "NON-J2EE application";
                }
            }
            if (WSSecurityHelper.isServerSecurityEnabled()) {
                if (string4.equals(" ")) {
                    string4 = WSSecurityHelper.getFirstCaller();
                }
                if (string3.equals(" ")) {
                    string3 = WSSecurityHelper.getFirstServer();
                }
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(RasHelper.getThreadId());
            stringBuffer.append('_');
            stringBuffer.append(wSRdbManagedConnectionImpl.toString());
            if (!string2.equals(" ")) {
                stringBuffer.append('_');
                stringBuffer.append(string2);
            }
            string2 = stringBuffer.toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The accountInfo new String is:", string2);
            }
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        if (wSRdbManagedConnectionImpl.clientInfoExplicitlySet || wSRdbManagedConnectionImpl.clientInfoImplicitlySet) {
            wSRdbManagedConnectionImpl.holdCurrentClientInfo(string4, string3, string, string2);
            try {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                }
                this.UTILITY.setDB2ClientInfo(wSRdbManagedConnectionImpl.sqlConn, string4, string3, string, string2);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.setClientInformation", "567", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setClientInformation - Exception", sQLException);
                }
                throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            }
            finally {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformationEndToEndMonitoring(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientInformationEndToEndMonitoring");
        }
        String string = " ";
        String string2 = " ";
        String string3 = " ";
        String string4 = " ";
        if (TraceComponent.isAnyTracingEnabled() && (tc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled())) {
            tempTc = clientInfoPlusTc.isDebugEnabled() ? clientInfoPlusTc : tc;
            Tr.debug(tempTc, "setClientInformationEndToEndMonitoring(Properties props,WSRdbManagedConnectionImpl mc, boolean explicitCall) with sqlConn", new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl), wSRdbManagedConnectionImpl.sqlConn});
        }
        if (bl) {
            string2 = properties.getProperty("CLIENT_ACCOUNTING_INFO");
            if (string2 == null || string2.equals("")) {
                string2 = this._accountInfo;
            }
            if ((string3 = properties.getProperty("CLIENT_LOCATION")) == null || string3.equals("")) {
                string3 = this._workStation;
            }
            if ((string4 = properties.getProperty("CLIENT_ID")) == null || string4.equals("")) {
                string4 = this._clientId;
            }
            if ((string = properties.getProperty("CLIENT_APPLICATION_NAME")) == null || string.equals("")) {
                string = this._applicationName;
            }
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        } else if (properties != null) {
            if (!this._dataSourceSetFlag) {
                object = this._dataSourceLockObject;
                synchronized (object) {
                    if (!this._dataSourceSetFlag) {
                        this._accountInfo = properties.getProperty("clientAccountingInformation");
                        if (this._accountInfo == null || this._accountInfo.equals("")) {
                            this._accountInfo = " ";
                        } else {
                            this._foundDatasourceClientInfoValue = true;
                        }
                        this._workStation = properties.getProperty("clientWorkstation");
                        if (this._workStation == null || this._workStation.equals("")) {
                            this._workStation = " ";
                        } else {
                            this._foundDatasourceClientInfoValue = true;
                        }
                        this._clientId = properties.getProperty("clientUser");
                        if (this._clientId == null || this._clientId.equals("")) {
                            this._clientId = " ";
                        } else {
                            this._foundDatasourceClientInfoValue = true;
                        }
                        this._applicationName = properties.getProperty("clientApplicationInformation");
                        if (this._applicationName == null || this._applicationName.equals("")) {
                            this._applicationName = " ";
                        } else {
                            this._foundDatasourceClientInfoValue = true;
                        }
                        this._dataSourceSetFlag = true;
                    }
                }
            }
            if (this._foundDatasourceClientInfoValue) {
                string2 = this._accountInfo;
                string3 = this._workStation;
                string4 = this._clientId;
                string = this._applicationName;
                wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
            }
        }
        if (string.equals(" ")) {
            try {
                object = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName();
                string = object == null ? "NON-J2EE application" : object.getApplication();
            }
            catch (NullPointerException nullPointerException) {
                string = "NON-J2EE application";
            }
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        if (WSSecurityHelper.isServerSecurityEnabled()) {
            if (string4.equals(" ")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling security code for clientID");
                }
                string4 = WSSecurityHelper.getFirstCaller();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The clientID is " + string4);
                }
                wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using clientID " + string4);
            }
            if (string3.equals(" ")) {
                block61: {
                    try {
                        if (this._workStationSetFlag) {
                            object = this._workStationLockObject;
                            synchronized (object) {
                                if (this._workStationValue.equals(" ")) {
                                    this._workStationValue = InetAddress.getLocalHost().getHostName();
                                }
                                this._workStationSetFlag = false;
                                string3 = this._workStationValue;
                                break block61;
                            }
                        }
                        string3 = this._workStationValue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        string3 = "Unknown host name";
                    }
                }
                wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(RasHelper.getThreadId());
        stringBuffer.append('_');
        stringBuffer.append(wSRdbManagedConnectionImpl.toString());
        if (!string2.equals(" ")) {
            stringBuffer.append('_');
            stringBuffer.append(string2);
        }
        string2 = stringBuffer.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setClientInformationEndToEndMonitoring - The accountInfo new String is:", string2);
        }
        wSRdbManagedConnectionImpl.holdCurrentClientInfo(string4, string3, string, string2);
        try {
            if (wSRdbManagedConnectionImpl.pmi != null) {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setClientInfo values  mc.sqlConn " + wSRdbManagedConnectionImpl.sqlConn + " _clientId " + string4 + " _workStation " + string3 + " _applicationName " + string + " _accountInfo " + string2);
            }
            this.UTILITY.setDB2ClientInfo(wSRdbManagedConnectionImpl.sqlConn, string4, string3, string, string2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.setClientInformation", "567", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setClientInformation - Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
        finally {
            if (wSRdbManagedConnectionImpl.pmi != null) {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            }
        }
        if (wSRdbManagedConnectionImpl.clientInfoExplicitlySet || wSRdbManagedConnectionImpl.clientInfoImplicitlySet) {
            wSRdbManagedConnectionImpl.holdCurrentClientInfo(string4, string3, string, string2);
            try {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                }
                this.UTILITY.setDB2ClientInfo(wSRdbManagedConnectionImpl.sqlConn, string4, string3, string, string2);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.setClientInformation", "567", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setClientInformation - Exception", sQLException);
                }
                throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            }
            finally {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClientInformationEndToEndMonitoring");
        }
    }

    public void setClientInformationArray(String[] stringArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setClientInformationArray (String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall)", new Object[]{stringArray, wSRdbManagedConnectionImpl, new Boolean(bl)});
        }
        if (bl) {
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        } else {
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        try {
            if (wSRdbManagedConnectionImpl.pmi != null) {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
            }
            this.UTILITY.setDB2ClientInfo(wSRdbManagedConnectionImpl.sqlConn, stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.setClientInformationArray", "611", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setClientInformationArray - Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
        finally {
            if (wSRdbManagedConnectionImpl.pmi != null) {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            }
        }
    }

    public void resetClientInformation(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (wSRdbManagedConnectionImpl.clientInfoExplicitlySet || wSRdbManagedConnectionImpl.clientInfoImplicitlySet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "resetClientInformation is called on: ", wSRdbManagedConnectionImpl);
            }
            try {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                }
                this.UTILITY.setDB2ClientInfo(wSRdbManagedConnectionImpl.sqlConn, " ", " ", " ", " ");
                wSRdbManagedConnectionImpl.clientInfoExplicitlySet = false;
                wSRdbManagedConnectionImpl.clientInfoImplicitlySet = false;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.resetClientInformation", "677", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "resetClientInformation -- Exception", sQLException);
                }
                throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
            }
            finally {
                if (wSRdbManagedConnectionImpl.pmi != null) {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
                }
            }
        }
    }

    public boolean resetConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resetConnection:", wSRdbManagedConnectionImpl.sqlConn);
        }
        boolean bl = this.ConnResetSupported;
        if (this.ConnResetSupported) {
            try {
                this.UTILITY.resetDB2Connection(wSRdbManagedConnectionImpl.sqlConn);
            }
            catch (Throwable throwable) {
                bl = false;
                if (throwable instanceof SQLException) {
                    SQLException sQLException = AdapterUtil.mapSQLException((SQLException)throwable, wSRdbManagedConnectionImpl);
                    if (sQLException instanceof StaleConnectionException) {
                        Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"resetDB2Connection()", sQLException, " a stale connection exception was encountered on an attempt to reset a connection"});
                    } else {
                        Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"resetDB2Connection()", sQLException, "method not supported on DB2 driver being used"});
                        this.ConnResetSupported = false;
                    }
                }
                Tr.warning(tc, "DSA_GENERIC_MSG", new Object[]{"resetDB2Connection()", throwable, "method not supported on DB2 driver being used"});
                this.ConnResetSupported = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resetConnection: ", new Boolean(bl));
        }
        return bl;
    }

    public PooledConnection getPooledConnection(final Object object, WSRdbDataSource wSRdbDataSource, int n, int n2) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPooledConnection (GSSCredential)", new Integer(n2));
        }
        PooledConnection pooledConnection = null;
        if (wSRdbDataSource.isJTAEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "XADatasource is used which doesn't support kerberos getPooledConnection(GSSCredential)");
            }
            return null;
        }
        final Object object2 = n == 0 ? wSRdbDataSource.getDataSource(n2) : wSRdbDataSource.dcm.getDataSource(n);
        final boolean bl = wSRdbDataSource.mcf.useRunAsSystemOnGetPooledConnection;
        try {
            pooledConnection = (PooledConnection)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (bl) {
                        try {
                            return SecurityContext.runAsSystem(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return InternalDB2UniversalDataStoreHelper.this.UTILITY.getPooledConnection(object2, object);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw (Exception)privilegedActionException.getCause();
                        }
                    }
                    return InternalDB2UniversalDataStoreHelper.this.UTILITY.getPooledConnection(object2, object);
                }
            });
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledConnection() returning: ", AdapterUtil.toString(pooledConnection));
            }
            return pooledConnection;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.rsadapter.InternalDB2UniversalDataStoreHelper.getPooledConnection", "628");
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", "PooledConnection", privilegedActionException.getException(), InternalDB2UniversalDataStoreHelper.class);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledConnection", "Exception");
            }
            throw dataStoreAdapterException;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.info(tc, "KERBEROS_METHOD_NOT_SUPPORTED_INFO");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledConnection() returning: ", null);
            }
            return null;
        }
    }

    public WSSystemMonitor getSystemMonitor(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        try {
            Object object = this.UTILITY.getDB2SystemMonitor(wSRdbManagedConnectionImpl.sqlConn);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getSystemMonitor: returning: ", object);
            }
            if (object == null) {
                return null;
            }
            return new WSSystemMonitor(object, this, wSRdbManagedConnectionImpl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSystemMonitor", "674", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getSystemMonitor -Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public void enableSystemMonitor(Object object, boolean bl, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "enableSystemMonitor");
        }
        try {
            this.UTILITY.enableSystemMonitor(object, bl);
        }
        catch (SQLException sQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "enableSystemMonitor -Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public void startSystemMonitor(Object object, int n, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "startSystemMonitor", new Integer(n));
        }
        try {
            this.UTILITY.startSystemMonitor(object, n);
        }
        catch (SQLException sQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "startSystemMonitor -Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public void stopSystemMonitor(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "stopSystemMonitor");
        }
        try {
            this.UTILITY.stopSystemMonitor(object);
        }
        catch (SQLException sQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "stopSystemMonitor -Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public long getServerTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerTimeMicros");
        }
        try {
            return this.UTILITY.getServerTimeMicros(object);
        }
        catch (SQLException sQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerTimeMicros -Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public long getNetworkIOTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getNetworkIOTimeMicros");
        }
        try {
            return this.UTILITY.getNetworkIOTimesMicros(object);
        }
        catch (SQLException sQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getNetworkIOTimeMicros -Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public long getCoreDriverTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCoreDriverTimeMicros");
        }
        try {
            return this.UTILITY.getCoreDriverTimeMicros(object);
        }
        catch (SQLException sQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getCoreDriverTimeMicros -Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public long getApplicationTimeMillis(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getApplicationTimeMillis");
        }
        try {
            return this.UTILITY.getApplicationTimeMillis(object);
        }
        catch (SQLException sQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getApplicationTimeMillis -Exception", sQLException);
            }
            throw AdapterUtil.mapSQLException(sQLException, wSRdbManagedConnectionImpl);
        }
    }

    public boolean isIsolationLevelSwitchingSupport() {
        return true;
    }

    public Object getSQLJContext(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSQLJContext", this);
        }
        Object object = null;
        try {
            if (wSRdbManagedConnectionImpl.cachedConnection == null) {
                wSRdbManagedConnectionImpl.cachedConnection = (Connection)((Object)this.createJDBCConnectionWrapper(wSRdbManagedConnectionImpl));
                ((WSJdbcConnection)wSRdbManagedConnectionImpl.cachedConnection).initialize(wSRdbManagedConnectionImpl.mcf.connMgr, WSRdbManagedConnectionImpl.key);
                this.UTILITY.setCurrentAutoCommit(wSRdbManagedConnectionImpl.cachedConnection, wSRdbManagedConnectionImpl.currentAutoCommit);
            } else {
                ((WSJccConnection)wSRdbManagedConnectionImpl.cachedConnection).setThreadID(wSRdbManagedConnectionImpl.threadID, WSRdbManagedConnectionImpl.key);
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", "550", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSQLJContext - failed trying to create SQLJ ConnectionContext, throwing exception");
            }
            throw AdapterUtil.toSQLException(resourceException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", "1009", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSQLJContext - failed trying to create SQLJ ConnectionContext, throwing exception");
            }
            throw WSJdbcUtil.mapException((WSJdbcObject)((Object)wSRdbManagedConnectionImpl.cachedConnection), sQLException);
        }
        try {
            object = this.UTILITY.createSQLJDefaultContext(wSRdbManagedConnectionImpl.cachedConnection);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", "549", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSQLJContext - failed trying to create SQLJ ConnectionContext, throwing exception");
            }
            throw WSJdbcUtil.mapException((WSJdbcObject)((Object)wSRdbManagedConnectionImpl.cachedConnection), sQLException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSQLJContext", object);
        }
        return object;
    }

    public Object getDefaultContext(Connection connection) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultContext", this);
        }
        Object object = null;
        try {
            object = this.UTILITY.createSQLJDefaultContext(connection);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getDefaultContext", "549", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDefaultContext - failed trying to create Default ConnectionContext, throwing exception");
            }
            throw sQLException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultContext", object);
        }
        return object;
    }

    public void setCurrentAutoCommit(Connection connection, boolean bl) {
        this.UTILITY.setCurrentAutoCommit(connection, bl);
    }

    public void setCurrentTransactionIsolation(Connection connection, int n) {
        this.UTILITY.setCurrentTransactionIsolation(connection, n);
    }

    public void processLastHandleClosed(Connection connection, boolean bl, boolean bl2) throws SQLException {
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
    }

    private void resetUOWBoundary(Connection connection) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resetUOWBoundary");
        }
        if (!private_disableResetUOW) {
            boolean bl;
            block11: {
                bl = true;
                if (this.localZOS && this.driverType == 2 && this.externalHelper.getMetaData().supportsUOWDetection()) {
                    try {
                        if (!this.UTILITY.isInDB2UnitOfWork(connection)) {
                            bl = false;
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "JCC Driver version does not support isInUnitOfWork method");
                    }
                }
            }
            if (bl) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Issuing rollback to reset UOW boundary");
                }
                connection.rollback();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Connection already on UOW boundary; skip rollback");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resetUOWBoundary");
        }
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block10: {
            DatabaseMetaData databaseMetaData;
            block9: {
                databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                this.setDatabaseProductName(string);
                Tr.info(tc, "DB_PRODUCT_NAME", string);
                Tr.info(tc, "DB_PRODUCT_VERSION", databaseMetaData.getDatabaseProductVersion());
                Tr.info(tc, "JDBC_DRIVER_NAME", databaseMetaData.getDriverName());
                Tr.info(tc, "JDBC_DRIVER_VERSION", databaseMetaData.getDriverVersion());
                Tr.info(tc, "DATA_STORE_HELPER_NAME", wSRdbDataSource.dataStoreHelper);
                try {
                    this.UTILITY.isInDB2UnitOfWork(connection);
                    wSRdbDataSource.dataStoreHelper.getMetaData().setSupportsUOWDetection(true);
                }
                catch (Throwable throwable) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "JCC Driver version does not support isInDB2UnitOfWork method");
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "JCC Driver version supports isInDB2UnitOfWork method");
            }
            try {
                if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdabiliy is supported");
                    }
                    this.holdabilitySupported = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", throwable);
            }
        }
    }

    public boolean isInDatabaseUnitOfWork(Connection connection) throws SQLException {
        boolean bl = this.UTILITY.isInDB2UnitOfWork(connection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isInDatabaseUnitOfWork returning: ", new Boolean(bl));
        }
        return bl;
    }

    public Object[] getPooledConnection(WSRdbDataSource wSRdbDataSource, String string, String string2, final boolean bl, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, final Properties properties, int n) throws ResourceException {
        Object object;
        Object object2 = object = wSConnectionRequestInfoImpl.ivConfigID == 0 ? wSRdbDataSource.getDataSource(n) : wSRdbDataSource.dcm.getDataSource(wSConnectionRequestInfoImpl.ivConfigID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPooledCon", new Object[]{AdapterUtil.toString(object), string, "******", bl ? "two-phase" : "one-phase", new Integer(n)});
        }
        if (!wSRdbDataSource.mcf.propagateClientIdentityUsingTrustedContext || !wSConnectionRequestInfoImpl.trustedContextIdentityAttributesAreSet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "propagateClientIdentityUsingTrustedContext is not enabled, so calling the getPooledCon that doesn't do trusted");
            }
            return super.getPooledConnection(wSRdbDataSource, string, string2, bl, wSConnectionRequestInfoImpl, properties, n);
        }
        final String string3 = string == null ? null : string.trim();
        final String string4 = string2 == null ? null : string2.trim();
        final PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return bl ? (string3 == null ? InternalDB2UniversalDataStoreHelper.this.UTILITY.getDB2TrustedXAConnection(object, properties) : InternalDB2UniversalDataStoreHelper.this.UTILITY.getDB2TrustedXAConnection(object, string3, string4, properties)) : (string3 == null ? InternalDB2UniversalDataStoreHelper.this.UTILITY.getDB2TrustedPooledConnection(object, properties) : InternalDB2UniversalDataStoreHelper.this.UTILITY.getDB2TrustedPooledConnection(object, string3, string4, properties));
            }
        };
        PrivilegedExceptionAction privilegedExceptionAction2 = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    return SecurityContext.runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (Exception)privilegedActionException.getCause();
                }
            }
        };
        try {
            Object[] objectArray = wSRdbDataSource.mcf.useRunAsSystemOnGetPooledConnection ? (Object[])AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction2) : (Object[])AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledCon returnes Object[pcon, cookie]", objectArray);
            }
            return objectArray;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getPooledCon", "1301");
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", bl ? "TrustedXAConnection" : "TrustedPooledConnection", privilegedActionException.getException(), InternalDB2UniversalDataStoreHelper.class);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledCon", "Exception");
            }
            throw dataStoreAdapterException;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getPooledCon", "1312");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught ClassCastException", classCastException);
            }
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException(bl ? "NOT_A_2_PHASE_DS" : "NOT_A_1_PHASE_DS", classCastException.getMessage(), null, InternalDB2UniversalDataStoreHelper.class);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledCon", "Exception");
            }
            throw dataStoreAdapterException;
        }
    }

    public Connection getTrustedConnection(PooledConnection pooledConnection, String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrustedConnection", new Object[]{pooledConnection, string, string2, string3, byArray});
        }
        return this.UTILITY.getDB2Connection(pooledConnection, string, string2, string3, byArray, byArray2);
    }

    public void reuseTrustedConnection(Connection connection, byte[] byArray, String string, String string2, String string3, byte[] byArray2, String string4, Properties properties) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "reuseConnection (conn, cookie, user, password, userRegistry, userSecToken, originalUser,properties)", new Object[]{connection, "cookie", string, null, string3, byArray2, string4, properties});
        }
        this.UTILITY.reuseDB2Connection(connection, byArray, string, string2, string3, byArray2, string4, properties);
    }

    public Properties validateConfiguration(Properties properties, String string) {
        String string2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateConfiguration", properties);
        }
        if (string.equals("com.ibm.db2.jcc.DB2XADataSource") && (string2 = (String)properties.setProperty("retrieveMessagesFromServerOnGetMessage", "false")) != null && Boolean.valueOf(string2).booleanValue()) {
            Tr.info(tc, "DB2_GETMSG_CONFIG_INFO_DSRA7021");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateConfiguration", properties);
        }
        return properties;
    }

    public void reuseOrReconfigureConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, Properties properties) throws SQLException {
        boolean bl = this.UTILITY.isInDB2UnitOfWork(wSRdbManagedConnectionImpl.sqlConn);
        Object var4_4 = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reuseOrReconfigureConnection (mc, Heterogenous Properties, sqlConn, inDB2UOW)", new Object[]{wSRdbManagedConnectionImpl, properties, wSRdbManagedConnectionImpl.sqlConn, new Boolean(bl)});
        }
        if (bl) {
            this.UTILITY.reconfigureDB2Connection(wSRdbManagedConnectionImpl.sqlConn, properties);
        } else {
            this.UTILITY.reuseDB2Connection(wSRdbManagedConnectionImpl.sqlConn, properties);
        }
        wSRdbManagedConnectionImpl.clearStatementCache();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reuseOrReconfigureConnection");
        }
    }

    public Connection getHetrogenousConnection(PooledConnection pooledConnection, Properties properties) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getHetrogenousConnection with (pcon, props)", new Object[]{pooledConnection, properties});
        }
        Connection connection = null;
        connection = this.UTILITY.getDB2Connection(pooledConnection, properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getHetrogenousConnection returns ", connection);
        }
        return connection;
    }

    public void closeSQLjIterator(Object object) throws SQLException {
        this.UTILITY.closeSQLJIterator(object);
    }

    public boolean isAnAuthorizationException(SQLException sQLException) {
        boolean bl = false;
        SQLException sQLException2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnAuthorizationException: ", sQLException);
        }
        if (DSConfigurationHelper._disableCheckingForAuthorizationException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CheckingForAuthorizationException is disabled so returning false for isAnAuthorizationException");
            }
            return bl;
        }
        if (sQLException != null) {
            if (sQLException.getErrorCode() == -4214) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Main Exception is an Authorization Exception");
                }
                bl = true;
            } else {
                for (sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
                    if (sQLException2.getErrorCode() != -4214) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "next Exception is an Authorization Exception");
                    }
                    bl = true;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAnAuthorizationException: " + new Boolean(bl));
        }
        return bl;
    }

    public void postCMXMessage(int n, Object[] objectArray, Object object, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "postCMXMessage: (int cmxMessageType, Object[] cmxArgs, Object DBObject )", new Object[]{new Integer(n), objectArray, object});
        }
        try {
            this.UTILITY.pushDataToCMX(n, objectArray, object, bl);
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "CMX_DATA_POSTING_PROBLEM", throwable);
        }
    }

    public boolean isMonitoringEnabled(Object object) {
        boolean bl;
        block3: {
            bl = false;
            try {
                bl = this.UTILITY.isCMXMonitoringEnabled(object);
            }
            catch (ClassCastException classCastException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "isMonitoringEnabled caught a Class cast exception isMonitoringEnabled:", new Boolean(bl) + " exception " + classCastException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isMonitoringEnabled:", new Boolean(bl));
        }
        return bl;
    }

    public Object getCMXDataSourceProxy(Object object, boolean bl) {
        Object object2 = this.UTILITY.getCMXDataSourceProxy(object, bl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCMXDataSourceProxy returning:", object2);
        }
        return object2;
    }
}

