/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.websphere.rsadapter.WSSystemMonitor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import org.ietf.jgss.GSSCredential;

public class InternalGenericDataStoreHelper
implements InternalDataStoreHelper {
    private static final TraceComponent databaseTc = Tr.register("com.ibm.ws.database.logwriter", "WAS.database", null);
    private static final TraceComponent tc = Tr.register(InternalGenericDataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    private static TraceComponent clientInfoPlusTc = Tr.register("WAS.clientinfopluslogging", "WAS.clientinfopluslogging", "IBMDataStoreAdapterNLS");
    private transient PrintWriter genPw = null;
    protected transient DataStoreHelper externalHelper = null;
    private String databaseProductName = null;
    protected boolean holdabilitySupported = true;

    public boolean alwaysSetAutoCommit() {
        return false;
    }

    public void clearWarnings(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
    }

    public void closeDefaultContext(Object object) throws ResourceException {
    }

    public Reassociateable createJDBCConnectionWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        return new WSJdbcConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, wSRdbManagedConnectionImpl.threadID);
    }

    public Boolean getRRSTransactional() {
        return Boolean.FALSE;
    }

    public String getThreadIdentitySupport() {
        return "NOTALLOWED";
    }

    public Boolean getThreadSecurity() {
        return Boolean.FALSE;
    }

    public TraceComponent getTracer() {
        return null;
    }

    public String getCorrelator(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        return null;
    }

    public void setEwlmCorrelator(byte[] byArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
    }

    public void setProperties(Properties properties) throws ResourceException {
    }

    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) {
        return databaseTc.isDebugEnabled() && !wSManagedConnectionFactoryImpl.loggingEnabled;
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return this.shouldTraceBeEnabled(wSRdbManagedConnectionImpl.mcf);
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !databaseTc.isDebugEnabled() && wSRdbManagedConnectionImpl.mcf.loggingEnabled;
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        wSRdbManagedConnectionImpl.mcf.reallySetLogWriter(null);
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) throws ResourceException {
        PrintWriter printWriter = this.getPrintWriter();
        Tr.debug(databaseTc, "enabling logging {mcf, pw}: ", new Object[]{wSManagedConnectionFactoryImpl, printWriter});
        wSManagedConnectionFactoryImpl.reallySetLogWriter(printWriter);
        wSManagedConnectionFactoryImpl.loggingEnabled = true;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        this.enableJdbcLogging(wSRdbManagedConnectionImpl.mcf);
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.genPw == null) {
            PrintWriter printWriter = this.externalHelper.getPrintWriter();
            if (printWriter != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user supplied own printWriter in the DataStoreHelper, will use provided one", printWriter);
                }
                this.genPw = printWriter;
            } else {
                this.genPw = new PrintWriter((Writer)new TraceWriter(databaseTc), true);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning", this.genPw);
        }
        return this.genPw;
    }

    public String processSQL(String string, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = null;
        if (bl) {
            stringBuffer = new StringBuffer(250);
            stringBuffer.append(string).append(" FOR UPDATE");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modified sqlString is: " + stringBuffer);
            }
            return new String(stringBuffer);
        }
        return string;
    }

    public void setReadOnly(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl, boolean bl2) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setReadOnly ", new Object[]{this, wSRdbManagedConnectionImpl, Boolean.toString(bl), Boolean.toString(bl2)});
        }
        wSRdbManagedConnectionImpl.setReadOnly(bl);
    }

    public int getHoldability(Connection connection) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHoldability", AdapterUtil.toString(connection));
        }
        int n = 0;
        try {
            if (this.holdabilitySupported) {
                n = connection.getHoldability();
                return n;
            }
            return 0;
        }
        catch (AbstractMethodError abstractMethodError) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHoldability", "getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError");
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHoldability", "getHoldability is not supported in this JDBC driver. Encounter a java.lang.UnsupportedOperationException");
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = this.externalHelper.mapException(sQLException);
            if (sQLException2 instanceof StaleConnectionException) {
                throw sQLException2;
            }
            this.holdabilitySupported = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException", sQLException2);
            }
            return 0;
        }
    }

    public Properties validateConfiguration(Properties properties, String string) {
        return properties;
    }

    public boolean isIsolationLevelSwitchingSupport() {
        return false;
    }

    public void psSetBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        preparedStatement.setBytes(n, byArray);
    }

    public void psSetString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        preparedStatement.setString(n, string);
    }

    public DataStoreAdapterException mapException(DataStoreAdapterException dataStoreAdapterException) {
        if (dataStoreAdapterException.containsSqlException()) {
            dataStoreAdapterException.setLinkedException(this.externalHelper.mapException((SQLException)dataStoreAdapterException.getCause()));
        }
        return (DataStoreAdapterException)((Object)AdapterUtil.mapException((Exception)((Object)dataStoreAdapterException), null, null, false));
    }

    public void setExternalHelper(DataStoreHelper dataStoreHelper) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setExternalHelper", dataStoreHelper);
        }
        this.externalHelper = dataStoreHelper;
    }

    public void setDatabaseProductName(String string) {
        this.databaseProductName = string;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setClientInformationEndToEndMonitoring(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (properties == null) {
            return;
        }
        if (clientInfoPlusTc.isDebugEnabled()) {
            Tr.debug(clientInfoPlusTc, "setClientInformation(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall)", new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl)});
        }
    }

    public void setClientInformation(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (properties == null) {
            return;
        }
        if (clientInfoPlusTc.isDebugEnabled()) {
            Tr.debug(clientInfoPlusTc, "setClientInformation(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall)", new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl)});
        }
    }

    public void setClientInformationArray(String[] stringArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
    }

    public void resetClientInformation(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
    }

    public boolean resetConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        return false;
    }

    public PooledConnection getPooledConnection(GSSCredential gSSCredential, WSRdbDataSource wSRdbDataSource, int n, int n2) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPooledConnection() returning null");
        }
        return null;
    }

    public WSSystemMonitor getSystemMonitor(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSystemMonitor() returning null");
        }
        return null;
    }

    public void enableSystemMonitor(Object object, boolean bl, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no-op");
        }
    }

    public void startSystemMonitor(Object object, int n, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no-op");
        }
    }

    public void stopSystemMonitor(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no-op");
        }
    }

    public long getServerTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no-op");
        }
        return -1L;
    }

    public long getNetworkIOTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no-op");
        }
        return -1L;
    }

    public long getCoreDriverTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no-op");
        }
        return -1L;
    }

    public long getApplicationTimeMillis(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no-op");
        }
        return -1L;
    }

    public Object getSQLJContext(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        return null;
    }

    public Object getDefaultContext(Connection connection) throws SQLException {
        return null;
    }

    public void setCurrentAutoCommit(Connection connection, boolean bl) {
    }

    public void setCurrentTransactionIsolation(Connection connection, int n) {
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
    }

    public void processLastHandleClosed(Connection connection, boolean bl, boolean bl2) throws SQLException {
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block9: {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            this.setDatabaseProductName(string);
            Tr.info(tc, "DB_PRODUCT_NAME", string);
            Tr.info(tc, "DB_PRODUCT_VERSION", databaseMetaData.getDatabaseProductVersion());
            Tr.info(tc, "JDBC_DRIVER_NAME", databaseMetaData.getDriverName());
            Tr.info(tc, "JDBC_DRIVER_VERSION", databaseMetaData.getDriverVersion());
            try {
                if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdabiliy is supported");
                    }
                    this.holdabilitySupported = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = this.externalHelper.mapException(sQLException);
                if (sQLException2 instanceof StaleConnectionException) {
                    throw sQLException2;
                }
                this.holdabilitySupported = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException", sQLException2);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", throwable);
            }
        }
    }

    public boolean isInDatabaseUnitOfWork(Connection connection) throws SQLException {
        Tr.info(tc, "UNSUPPORTED_METHOD", "isInDatabaseUnitOfWork");
        throw new SQLException("method not supported for this backend database");
    }

    public Object[] getPooledConnection(WSRdbDataSource wSRdbDataSource, String string, String string2, final boolean bl, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, Properties properties, int n) throws ResourceException {
        Object object;
        Object object2 = object = wSConnectionRequestInfoImpl.ivConfigID == 0 ? wSRdbDataSource.getDataSource(n) : wSRdbDataSource.dcm.getDataSource(wSConnectionRequestInfoImpl.ivConfigID);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPooledCon", new Object[]{AdapterUtil.toString(object), string, "******", bl ? "two-phase" : "one-phase", new Integer(n)});
        }
        final String string3 = string == null ? null : string.trim();
        final String string4 = string2 == null ? null : string2.trim();
        final PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return bl ? (string3 == null ? ((XADataSource)object).getXAConnection() : ((XADataSource)object).getXAConnection(string3, string4)) : (string3 == null ? ((ConnectionPoolDataSource)object).getPooledConnection() : ((ConnectionPoolDataSource)object).getPooledConnection(string3, string4));
            }
        };
        PrivilegedExceptionAction privilegedExceptionAction2 = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    return SecurityContext.runAsSystem(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (Exception)privilegedActionException.getCause();
                }
            }
        };
        try {
            PooledConnection pooledConnection = wSRdbDataSource.mcf.useRunAsSystemOnGetPooledConnection ? (PooledConnection)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction2) : (PooledConnection)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledCon", AdapterUtil.toString(pooledConnection));
            }
            return new Object[]{pooledConnection, null};
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper.getPooledCon", "1298");
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", bl ? "XAConnection" : "PooledConnection", privilegedActionException.getException(), InternalGenericDataStoreHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledCon", "Exception");
            }
            throw dataStoreAdapterException;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, "com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper.getPooledCon", "1312");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught ClassCastException", classCastException);
            }
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException(bl ? "NOT_A_2_PHASE_DS" : "NOT_A_1_PHASE_DS", classCastException.getMessage(), null, InternalGenericDataStoreHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPooledCon", "Exception");
            }
            throw dataStoreAdapterException;
        }
    }

    public Connection getTrustedConnection(PooledConnection pooledConnection, String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws SQLException {
        throw new SQLException("The JDBC Driver that is configured with the DataSource for the Application Server does not support Trusted Connection");
    }

    public void reuseTrustedConnection(Connection connection, byte[] byArray, String string, String string2, String string3, byte[] byArray2, String string4, Properties properties) throws SQLException {
    }

    public void reuseOrReconfigureConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, Properties properties) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no-op");
        }
    }

    public Connection getHetrogenousConnection(PooledConnection pooledConnection, Properties properties) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Heterogenous properties are set but backend doesn't support heterogenous.  returning normal pc.getConnection.");
        }
        return pooledConnection.getConnection();
    }

    public void closeSQLjIterator(Object object) throws SQLException {
    }

    public boolean isAnAuthorizationException(SQLException sQLException) {
        return false;
    }

    public boolean dBConnectionCacheExists(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dBConnectionCacheExists: no-op returning false");
        }
        return false;
    }

    public void removeDBConnectionCache(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDBConnectionCache: no-op");
        }
    }

    public void postCMXMessage(int n, Object[] objectArray, Object object, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "postCMXMessage: no-op");
        }
    }

    public boolean isMonitoringEnabled(Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isMonitoringEnabled: false");
        }
        return false;
    }

    public Object getCMXDataSourceProxy(Object object, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCMXDataSourceProxy (Generic Helper) : returning null");
        }
        return null;
    }
}

