/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import javax.resource.ResourceException;

public class InternalOracle10gDataStoreHelper
extends InternalOracleDataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalOracle10gDataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    private String[] matrix;

    public InternalOracle10gDataStoreHelper() throws Exception {
        try {
            this.matrix = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    return new String[InternalOracle10gDataStoreHelper.this.UTILITY.getEndToEndStateIndexMax()];
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.rsadapter.spi.InternalOracle10gDataStoreHelper", "95");
            throw privilegedActionException.getException();
        }
    }

    public boolean alwaysSetAutoCommit() {
        return false;
    }

    public void setProperties(Properties properties) throws ResourceException {
        super.setProperties(properties);
        int n = 0;
        int n2 = 1;
        String string = null;
        Logger logger = null;
        Formatter formatter = null;
        FileHandler fileHandler = null;
        String string2 = "oracle.jdbc.driver";
        String string3 = "INFO";
        String string4 = "SimpleFormat";
        String string5 = null;
        if (properties != null) {
            string5 = properties.getProperty("oracleLogPackageName");
            if (string5 != null && !string5.equals("")) {
                string2 = string5;
            }
            if ((string5 = properties.getProperty("oracleLogFileName")) != null && !string5.equals("")) {
                string = string5;
            }
            if (oraTc.isDebugEnabled()) {
                Tr.debug(oraTc, "DSConfigurationHelper.ORACLELOG_PACKAGENAME is: ", string2);
                Tr.debug(oraTc, "DSConfigurationHelper.ORACLELOG_FILENAME is:  ", string);
            }
            logger = Logger.getLogger(string2);
            if (string != null && !string.equals("")) {
                string5 = properties.getProperty("oracleLogTraceLevel");
                if (string5 != null && !string5.equals("")) {
                    string3 = string5;
                }
                if ((string5 = properties.getProperty("oracleLogFormat")) != null && !string5.equals("")) {
                    string4 = string5;
                }
                if (string4 != null && (string4.charAt(0) == 'S' || string4.charAt(0) == 's')) {
                    if (oraTc.isDebugEnabled()) {
                        Tr.debug(oraTc, "SimpleFormatter is used");
                    }
                    formatter = new SimpleFormatter();
                } else {
                    if (oraTc.isDebugEnabled()) {
                        Tr.debug(oraTc, "XMLFormatter is used");
                    }
                    formatter = new XMLFormatter();
                }
                string5 = properties.getProperty("oracleLogFileSizeLimit");
                if (string5 != null && !string5.equals("")) {
                    n = Integer.parseInt(string5);
                }
                if ((string5 = properties.getProperty("oracleLogFileCount")) != null && !string5.equals("")) {
                    n2 = Integer.parseInt(string5);
                }
                if (oraTc.isDebugEnabled()) {
                    Tr.debug(oraTc, "DSConfigurationHelper.ORACLELOG_FILE_COUNT is: " + n2);
                    Tr.debug(oraTc, "DSConfigurationHelper.ORACLELOG_FILE_SIZE_LIMIT is: " + n);
                    Tr.debug(oraTc, "DSConfigurationHelper.ORACLELOG_FORMAT is: ", string4);
                    Tr.debug(oraTc, "DSConfigurationHelper.ORACLELOG_TRACELEVEL is: ", string3);
                }
                try {
                    fileHandler = new FileHandler(string + "%g.%u", n, n2);
                    fileHandler.setFormatter(formatter);
                    fileHandler.setLevel(Level.ALL);
                    logger.setLevel(AdapterUtil.getLevelBasedOnName(string3));
                    logger.setUseParentHandlers(false);
                    logger.addHandler(fileHandler);
                }
                catch (IOException iOException) {
                    Tr.warning(oraTc, "ORACLE_TRACE_WARNING", new Object[]{string, iOException});
                }
            } else if (oraTc.isDebugEnabled()) {
                Tr.debug(oraTc, "Oracle trace file is not set, Oracle logging/tracing will be mergned with WAS logging based on WAS logging settings");
            }
        }
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Disabling loggin on Oracle10g and later");
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    InternalOracle10gDataStoreHelper.this.UTILITY.setTrace(false);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper.enableJdbcLogging", "236", this);
            Tr.debug(oraTc, "InternalOracleDataStoreHelper.enableJdbcLogging failed to enable trace in Oracle, execution will continue: ", privilegedActionException.getException());
        }
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) throws ResourceException {
        Tr.debug(oraTc, "Enabling logging on Oracle10g and later");
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    InternalOracle10gDataStoreHelper.this.UTILITY.setTrace(true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper.enableJdbcLogging", "236", this);
            Tr.debug(oraTc, "InternalOracleDataStoreHelper.enableJdbcLogging failed to enable trace in Oracle, execution will continue: ", privilegedActionException.getException());
        }
        wSManagedConnectionFactoryImpl.loggingEnabled = true;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        this.enableJdbcLogging(wSRdbManagedConnectionImpl.mcf);
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        return null;
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformation(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        StringBuffer stringBuffer = null;
        String string = null;
        if (tc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            TraceComponent traceComponent = clientInfoPlusTc.isDebugEnabled() ? clientInfoPlusTc : tc;
            Tr.debug(traceComponent, "setClientInformation(Properties props,WSRdbManagedConnectionImpl mc, boolean explicitCall) with sqlConn", new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl), wSRdbManagedConnectionImpl.sqlConn});
        }
        if (bl) {
            string = properties.getProperty("CLIENT_ID");
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        }
        if (clientInfoTc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            stringBuffer = new StringBuffer(64);
            stringBuffer.append(RasHelper.getThreadId()).append('_').append(wSRdbManagedConnectionImpl.toString());
            if (string != null) {
                stringBuffer.append('_').append(string);
            }
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
            string = stringBuffer.toString();
        }
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The clientInfo string is:", string);
            }
            wSRdbManagedConnectionImpl.holdCurrentClientInfo(string, null, null, null);
            this.matrix[this.UTILITY.getEndToEndClientIdIndex()] = string;
            if (wSRdbManagedConnectionImpl.pmi != null) {
                try {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                    this.UTILITY.setEndToEndMetrics(wSRdbManagedConnectionImpl.sqlConn, this.matrix, (short)0);
                }
                finally {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
                }
            } else {
                this.UTILITY.setEndToEndMetrics(wSRdbManagedConnectionImpl.sqlConn, this.matrix, (short)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformationArray(String[] stringArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (bl) {
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        } else {
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        this.matrix[this.UTILITY.getEndToEndClientIdIndex()] = stringArray[0];
        if (wSRdbManagedConnectionImpl.pmi != null) {
            try {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
            }
            finally {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            }
        } else {
            this.UTILITY.setEndToEndMetrics(wSRdbManagedConnectionImpl.sqlConn, this.matrix, (short)0);
        }
    }

    public void resetClientInformation(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if ((wSRdbManagedConnectionImpl.clientInfoExplicitlySet || wSRdbManagedConnectionImpl.clientInfoImplicitlySet) && !clientInfoTc.isDebugEnabled() && !clientInfoPlusTc.isDebugEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resetClientInformation is called on: ", wSRdbManagedConnectionImpl);
            }
            this.matrix[this.UTILITY.getEndToEndClientIdIndex()] = null;
            this.UTILITY.setEndToEndMetrics(wSRdbManagedConnectionImpl.sqlConn, this.matrix, (short)0);
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = false;
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = false;
        }
    }

    public boolean dBConnectionCacheExists(String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dBConnectionCacheExists(String cacheName)", string);
        }
        boolean bl = false;
        bl = this.UTILITY.dBConnectionCacheExists(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dBConnectionCacheExists: ", new Boolean(bl));
        }
        return bl;
    }

    public void removeDBConnectionCache(String string) throws SQLException {
        this.UTILITY.removeDBConnectionCache(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDBConnectionCache finished for cache:", string);
        }
    }
}

