/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.OracleUtility;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;

public class InternalOracleDataStoreHelper
extends InternalGenericDataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalOracleDataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    protected OracleUtility UTILITY = null;
    protected static TraceComponent oraTc = Tr.register("com.ibm.ws.oracle.logwriter", "WAS.database", null);
    protected static TraceComponent clientInfoTc = Tr.register("WAS.clientinfo", "WAS.clientinfo", "IBMDataStoreAdapterNLS");
    protected static TraceComponent clientInfoPlusTc = Tr.register("WAS.clientinfopluslogging", "WAS.clientinfopluslogging", "IBMDataStoreAdapterNLS");
    private transient PrintWriter oraPw;
    int _logLevel = 2;
    private transient Class currClass = InternalOracleDataStoreHelper.class;

    public InternalOracleDataStoreHelper() throws Exception {
        this.UTILITY = (OracleUtility)AdapterUtil.createDBUtility("com.ibm.ws.rsadapter.dbutils.impl.OracleUtilityImpl");
    }

    public boolean alwaysSetAutoCommit() {
        return true;
    }

    public void setProperties(Properties properties) throws ResourceException {
        String string;
        super.setProperties(properties);
        if (properties != null && (string = properties.getProperty("oracle9iLogTraceLevel")) != null && !string.equals("")) {
            this._logLevel = Integer.parseInt(string);
            if (oraTc.isDebugEnabled()) {
                Tr.debug(oraTc, "the oracle trace level specified is: ", new Integer(this._logLevel));
            }
            this.UTILITY.setLogVolume(this._logLevel);
        }
    }

    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) {
        return oraTc.isDebugEnabled() && !wSManagedConnectionFactoryImpl.loggingEnabled;
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return this.shouldTraceBeEnabled(wSRdbManagedConnectionImpl.mcf);
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !oraTc.isDebugEnabled() && wSRdbManagedConnectionImpl.mcf.loggingEnabled;
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        Tr.debug(oraTc, "Disabling logging on Oracle9i or prior", wSRdbManagedConnectionImpl.sqlConn);
        this.UTILITY.setLogWriter(null);
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) throws ResourceException {
        PrintWriter printWriter = this.getPrintWriter();
        Tr.debug(oraTc, "Enabling logging on Oralce9i or prior to ", printWriter);
        this.UTILITY.setLogWriter(printWriter);
        wSManagedConnectionFactoryImpl.loggingEnabled = true;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        this.enableJdbcLogging(wSRdbManagedConnectionImpl.mcf);
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.oraPw == null) {
            this.oraPw = this.externalHelper.getPrintWriter();
            if (this.oraPw != null) {
                Tr.debug(oraTc, "user supplied own printWriter in the datastore helper, will use provided one", this.oraPw);
            } else {
                this.oraPw = new PrintWriter((Writer)new TraceWriter(oraTc), true);
            }
        }
        Tr.debug(oraTc, "returning", this.oraPw);
        return this.oraPw;
    }

    public void setReadOnly(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl, boolean bl2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setReadOnly", new Object[]{this, wSRdbManagedConnectionImpl, Boolean.toString(bl), Boolean.toString(bl2)});
        }
        if (bl2) {
            if (bl) {
                throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"setReadOnly", Connection.class.getName()}));
            }
            Tr.info(tc, "ORA_READONLY");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setReadOnly ignored for internal call");
        }
    }

    public void psSetBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        int n2;
        int n3 = n2 = byArray == null ? 0 : byArray.length;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "psSetBytes - byteArray length: " + n2);
        }
        if (byArray != null && n2 > 2000) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ORACLE setBytes byte array length > 2000 workaround.");
            }
            preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), n2);
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    public void psSetString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        int n2;
        int n3 = n2 = string == null ? 0 : string.getBytes().length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "string length: " + n2);
        }
        if (n2 > 4000) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Oracle setString length > 4000 bytes workaround.");
            }
            preparedStatement.setCharacterStream(n, (Reader)new StringReader(string), string.length());
        } else {
            preparedStatement.setString(n, string);
        }
    }

    public int getHoldability(Connection connection) throws SQLException {
        int n = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHoldability", AdapterUtil.toString(connection));
        }
        try {
            if (this.holdabilitySupported) {
                n = connection.getHoldability();
                return n;
            }
            return 0;
        }
        catch (AbstractMethodError abstractMethodError) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHoldability", "getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError");
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 17023) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getHoldability", "getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException: " + sQLException.getMessage());
                }
                this.holdabilitySupported = false;
                return 0;
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformation(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        StringBuffer stringBuffer = null;
        String string = null;
        if (tc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            TraceComponent traceComponent = clientInfoPlusTc.isDebugEnabled() ? clientInfoPlusTc : tc;
            Tr.debug(traceComponent, "setClientInformation(Properties props,WSRdbManagedConnectionImpl mc, boolean explicitCall) with sqlConn", new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl), wSRdbManagedConnectionImpl.sqlConn});
        }
        if (bl) {
            string = properties.getProperty("CLIENT_ID");
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        }
        if (clientInfoTc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            stringBuffer = new StringBuffer(64);
            stringBuffer.append(RasHelper.getThreadId()).append('_').append(wSRdbManagedConnectionImpl.toString());
            if (string != null) {
                stringBuffer.append('_').append(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The clientInfo string is:", stringBuffer);
            }
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
            string = stringBuffer.toString();
        }
        if (string != null) {
            wSRdbManagedConnectionImpl.holdCurrentClientInfo(string, null, null, null);
            if (wSRdbManagedConnectionImpl.pmi != null) {
                try {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                    this.UTILITY.setClientIdentifier(wSRdbManagedConnectionImpl.sqlConn, string);
                }
                finally {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
                }
            } else {
                this.UTILITY.setClientIdentifier(wSRdbManagedConnectionImpl.sqlConn, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformationArray(String[] stringArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (bl) {
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        } else {
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        if (wSRdbManagedConnectionImpl.pmi != null) {
            try {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                this.UTILITY.setClientIdentifier(wSRdbManagedConnectionImpl.sqlConn, stringArray[0]);
            }
            finally {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            }
        } else {
            this.UTILITY.setClientIdentifier(wSRdbManagedConnectionImpl.sqlConn, stringArray[0]);
        }
    }

    public void resetClientInformation(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if ((wSRdbManagedConnectionImpl.clientInfoExplicitlySet || wSRdbManagedConnectionImpl.clientInfoImplicitlySet) && !clientInfoTc.isDebugEnabled() && !clientInfoPlusTc.isDebugEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resetClientInformation is called on: ", wSRdbManagedConnectionImpl);
            }
            this.UTILITY.setClientIdentifier(wSRdbManagedConnectionImpl.sqlConn, null);
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = false;
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = false;
        }
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (wSRdbManagedConnectionImpl.is2Phase()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting AC to false to workaround Oracle xa problem");
            }
            wSRdbManagedConnectionImpl.setAutoCommit(false);
        }
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block7: {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            this.setDatabaseProductName(string);
            Tr.info(tc, "DB_PRODUCT_NAME", string);
            Tr.info(tc, "DB_PRODUCT_VERSION", databaseMetaData.getDatabaseProductVersion());
            Tr.info(tc, "JDBC_DRIVER_NAME", databaseMetaData.getDriverName());
            Tr.info(tc, "JDBC_DRIVER_VERSION", databaseMetaData.getDriverVersion());
            Tr.info(tc, "DATA_STORE_HELPER_NAME", wSRdbDataSource.dataStoreHelper);
            if (databaseMetaData.getDriverMajorVersion() >= 10 && !AdapterUtil.isInstance(wSRdbDataSource.dataStoreHelper, "com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper")) {
                Tr.warning(tc, "ORACLE_10G_DATASTORE_HELPER_WARNING");
            }
            try {
                if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdabiliy is supported");
                    }
                    this.holdabilitySupported = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", throwable);
            }
        }
    }
}

