/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class InternalSequeLinkDataStoreHelper
extends InternalDataDirectDataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalSequeLinkDataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");

    public int getHoldability(Connection connection) throws SQLException {
        int n = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHoldability", AdapterUtil.toString(connection));
        }
        try {
            if (this.holdabilitySupported) {
                n = connection.getHoldability();
                return n;
            }
            return 0;
        }
        catch (AbstractMethodError abstractMethodError) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getHoldability", "getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError");
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 6003) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getHoldability", "getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException: " + sQLException.getMessage());
                }
                this.holdabilitySupported = false;
                return 0;
            }
            throw sQLException;
        }
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block8: {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (connection.getClass().getName().indexOf("com.microsoft") >= 0) {
                Tr.info(tc, "JDBC_DRIVER_DEPRECATED", new Object[]{"Microsoft SQL Server 2000", "Connect"});
            }
            if ("SequeLink".equals(databaseMetaData.getDriverName())) {
                Tr.info(tc, "JDBC_DRIVER_DEPRECATED", new Object[]{"SequeLink", "Connect"});
            }
            try {
                if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdabiliy is supported");
                    }
                    this.holdabilitySupported = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", throwable);
            }
        }
    }
}

