/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.resource.ResourceException;

public class InternalSybaseDataStoreHelper
extends InternalGenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register(InternalSybaseDataStoreHelper.class, "RRA", "IBMDataStoreAdapterNLS");
    private transient TraceComponent sybaseTc = Tr.register("com.ibm.ws.sybase.logwriter", "WAS.database", null);
    private transient PrintWriter sybasePw = null;

    public void clearWarnings(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (!DSConfigurationHelper._skipInternalClearWarnings) {
            wSRdbManagedConnectionImpl.sqlConn.clearWarnings();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "clearWarnings: cleanup of warnings done");
            }
        }
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.sybasePw == null) {
            this.sybasePw = this.externalHelper.getPrintWriter();
            if (this.sybasePw != null) {
                Tr.debug(this.sybaseTc, "user supplied own printWriter in datastore helper, will use provided one", this.sybasePw);
            } else {
                this.sybasePw = new PrintWriter((Writer)new TraceWriter(this.sybaseTc), true);
            }
        }
        Tr.debug(this.sybaseTc, "returning", this.sybasePw);
        return this.sybasePw;
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block9: {
            this.setDatabaseProductName("Sybase SQL Server");
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                Tr.info(tc, "DB_PRODUCT_NAME", string);
                Tr.info(tc, "DB_PRODUCT_VERSION", databaseMetaData.getDatabaseProductVersion());
                Tr.info(tc, "JDBC_DRIVER_NAME", databaseMetaData.getDriverName());
                Tr.info(tc, "JDBC_DRIVER_VERSION", databaseMetaData.getDriverVersion());
                try {
                    if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Holdabiliy is supported");
                        }
                        this.holdabilitySupported = true;
                        break block9;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", throwable);
                    }
                }
            }
            catch (SQLException sQLException) {
                if (this.externalHelper.isConnectionError(sQLException)) {
                    throw sQLException;
                }
                Tr.info(tc, "META_DATA_EXCEPTION", sQLException.getMessage());
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "meta data access caused a non SCE, continuing without displaying metadata: " + sQLException);
            }
        }
    }

    public void setReadOnly(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl, boolean bl2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setReadOnly", new Object[]{this, wSRdbManagedConnectionImpl, Boolean.toString(bl), Boolean.toString(bl2)});
        }
        if (!bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setReadOnly ignored for internal call");
            }
        } else if (DSConfigurationHelper._allowSetReadOnlyForSybase) {
            wSRdbManagedConnectionImpl.setReadOnly(bl);
        } else {
            Tr.info(tc, "Method setReadOnly() is ignored by WebSphere. Sybase does not honor the setReadOnly method.");
        }
    }

    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) {
        return this.sybaseTc.isDebugEnabled() && !wSManagedConnectionFactoryImpl.loggingEnabled;
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return this.shouldTraceBeEnabled(wSRdbManagedConnectionImpl.mcf);
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !this.sybaseTc.isDebugEnabled() && wSRdbManagedConnectionImpl.mcf.loggingEnabled;
    }
}

