/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.FFDCLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.ConnectionRequestInfo;

public class WSConnectionRequestInfoImpl
implements ConnectionRequestInfo,
Cloneable,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(WSConnectionRequestInfoImpl.class, "RRA", "IBMDataStoreAdapterNLS");
    private static final int NUM_CRI_PROPERTIES = 8;
    private boolean changable = false;
    String ivUserName;
    String ivPassword;
    int ivIsoLevel;
    String ivCatalog;
    Boolean ivReadOnly;
    Map ivTypeMap;
    int ivHoldability;
    int ivConfigID;
    Boolean defaultReadOnly;
    int extentionDSPropKey;
    Properties extentionDSProps;
    boolean useHetrogeneous = false;
    private boolean optimizeForGetUseCloseUsage = false;
    String tc_name;
    String tc_realm;
    byte[] tc_userSecToken;
    String tc_originalUser;
    boolean trustedContextIdentityAttributesAreSet;
    private transient J2EEName j2eename;
    boolean ivNoEnlist;
    boolean ivShareWithCMPOnly;
    private int hashcode;
    private boolean hasIsolationLevelOnly;
    boolean isJDBC;
    boolean supportIsolvlSwitching;

    WSConnectionRequestInfoImpl() {
        this.ivIsoLevel = 2;
        this.hasIsolationLevelOnly = true;
    }

    public WSConnectionRequestInfoImpl(int n, boolean bl) {
        this.ivIsoLevel = n;
        this.isJDBC = bl;
        this.hasIsolationLevelOnly = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ConnectionRequestInfo created", this);
        }
    }

    public WSConnectionRequestInfoImpl(int n, boolean bl, boolean bl2, boolean bl3) {
        this.ivIsoLevel = n;
        this.isJDBC = bl;
        this.supportIsolvlSwitching = bl2;
        this.ivShareWithCMPOnly = bl3;
        int n2 = this.hashcode = bl3 ? 71 : 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ConnectionRequestInfo created", this);
        }
    }

    public WSConnectionRequestInfoImpl(String string, String string2, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.ivUserName = string;
        this.ivPassword = string2;
        this.ivIsoLevel = n;
        this.ivConfigID = n2;
        this.isJDBC = true;
        this.ivNoEnlist = bl;
        this.supportIsolvlSwitching = bl2;
        this.ivShareWithCMPOnly = bl3;
        this.hashcode = this.ivConfigID + (bl ? 37 : 0) + (bl3 ? 71 : 0) + (this.ivUserName == null ? 0 : this.ivUserName.hashCode() / 8) + (this.ivPassword == null ? 0 : this.ivPassword.hashCode() / 8);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ConnectionRequestInfo created", this);
        }
    }

    public WSConnectionRequestInfoImpl(String string, String string2, int n, String string3, Boolean bl, Map map, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.ivUserName = string;
        this.ivPassword = string2;
        this.ivIsoLevel = n;
        this.ivCatalog = string3;
        this.ivReadOnly = bl;
        this.ivTypeMap = map;
        this.ivHoldability = n2;
        this.ivConfigID = n3;
        this.isJDBC = bl2;
        this.ivNoEnlist = bl4;
        this.ivShareWithCMPOnly = bl5;
        this.supportIsolvlSwitching = bl3;
        this.hashcode = this.ivConfigID + (bl4 ? 37 : 0) + (bl5 ? 71 : 0) + (this.ivUserName == null ? 0 : this.ivUserName.hashCode() / 8) + (this.ivPassword == null ? 0 : this.ivPassword.hashCode() / 8);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ConnectionRequestInfo created", this);
        }
    }

    public final int getConfigID() {
        return this.ivConfigID;
    }

    public final String getUserName() {
        return this.ivUserName;
    }

    public final String getPassword() {
        return this.ivPassword;
    }

    public final int getIsolationLevel() {
        return this.ivIsoLevel;
    }

    public final String getCatalog() {
        return this.ivCatalog;
    }

    public final Map getTypeMap() {
        return this.ivTypeMap;
    }

    public final int getHoldability() {
        return this.ivHoldability;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("extention DS properties     = ", this.extentionDSProps);
        fFDCLogger.append("extention DS properties key = ", new Integer(this.extentionDSPropKey));
        fFDCLogger.append("useHetrogeneous = ", new Boolean(this.useHetrogeneous));
        fFDCLogger.append("changable CRI = ", new Boolean(this.changable));
        fFDCLogger.append("optimizeForGetUseCloseUsage = ", new Boolean(this.optimizeForGetUseCloseUsage));
        fFDCLogger.append("User Name:", this.ivUserName);
        fFDCLogger.append("Password:", this.ivPassword == null ? null : "******");
        fFDCLogger.append("Isolation Level:", AdapterUtil.getIsolationLevelString(this.ivIsoLevel));
        fFDCLogger.append("Catalog:", this.ivCatalog);
        fFDCLogger.append("Is Read Only?", this.ivReadOnly);
        fFDCLogger.append("Type Map:", this.ivTypeMap);
        fFDCLogger.append("Cursor Holdability:", AdapterUtil.getCursorHoldabilityString(this.ivHoldability));
        fFDCLogger.append("Config ID: " + this.ivConfigID);
        fFDCLogger.append("Hash Code:", Integer.toHexString(this.hashcode));
        fFDCLogger.append("Support isolation switching on connection:", new Boolean(this.supportIsolvlSwitching));
        fFDCLogger.append("NoEnlistment: ", new Boolean(this.ivNoEnlist));
        fFDCLogger.append("ShareWithCMPOnly: ", new Boolean(this.ivShareWithCMPOnly));
        fFDCLogger.append("Handle type:", this.isJDBC ? Connection.class.getName() : javax.resource.cci.Connection.class.getName());
        fFDCLogger.append("TrustedContext_name: ").append(this.tc_name);
        fFDCLogger.append("TrustedContext_realm: ").append(this.tc_realm);
        fFDCLogger.append("TrustedContext_userSecToken: ").append(this.tc_userSecToken == null ? null : this.tc_userSecToken.toString());
        fFDCLogger.append("TrustedContext_originalUser: ").append(this.tc_originalUser);
        fFDCLogger.append("trustedContextIdentityAttributesAreSet = ", new Boolean(this.trustedContextIdentityAttributesAreSet));
        fFDCLogger.append("J2EEName = ").append(this.j2eename == null ? null : ((Object)this.j2eename).toString());
        return fFDCLogger.toStringArray();
    }

    public final boolean isJDBCHandle() {
        return this.isJDBC;
    }

    public final Boolean isReadOnly() {
        return this.ivReadOnly;
    }

    public final boolean isReconfigurable(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, boolean bl) {
        if (bl) {
            return this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID && this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly;
        }
        return WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID && this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly;
    }

    public final boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            bl = true;
        } else {
            try {
                WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = (WSConnectionRequestInfoImpl)object;
                bl = this.supportIsolvlSwitching ? (!this.isJDBC && !wSConnectionRequestInfoImpl.isJDBC ? (this.optimizeForGetUseCloseUsage ? this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.matchIDentityAttributes(wSConnectionRequestInfoImpl) : this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || this.extentionDSPropKey == wSConnectionRequestInfoImpl.extentionDSPropKey && WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.matchIDentityAttributes(wSConnectionRequestInfoImpl)) : (this.optimizeForGetUseCloseUsage ? this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly && WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.matchIDentityAttributes(wSConnectionRequestInfoImpl) && this.ivHoldability == wSConnectionRequestInfoImpl.ivHoldability && WSConnectionRequestInfoImpl.match(this.ivCatalog, wSConnectionRequestInfoImpl.ivCatalog) && this.matchReadOnly(wSConnectionRequestInfoImpl) && WSConnectionRequestInfoImpl.match(this.ivTypeMap, wSConnectionRequestInfoImpl.ivTypeMap) && this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID : this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || this.extentionDSPropKey == wSConnectionRequestInfoImpl.extentionDSPropKey && this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly && WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.matchIDentityAttributes(wSConnectionRequestInfoImpl) && this.ivHoldability == wSConnectionRequestInfoImpl.ivHoldability && WSConnectionRequestInfoImpl.match(this.ivCatalog, wSConnectionRequestInfoImpl.ivCatalog) && this.matchReadOnly(wSConnectionRequestInfoImpl) && WSConnectionRequestInfoImpl.match(this.ivTypeMap, wSConnectionRequestInfoImpl.ivTypeMap) && this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID)) : (this.optimizeForGetUseCloseUsage ? this.ivIsoLevel == wSConnectionRequestInfoImpl.ivIsoLevel && (this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || this.hashcode == wSConnectionRequestInfoImpl.hashcode && this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly && WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.matchIDentityAttributes(wSConnectionRequestInfoImpl) && this.ivHoldability == wSConnectionRequestInfoImpl.ivHoldability && WSConnectionRequestInfoImpl.match(this.ivCatalog, wSConnectionRequestInfoImpl.ivCatalog) && this.matchReadOnly(wSConnectionRequestInfoImpl) && WSConnectionRequestInfoImpl.match(this.ivTypeMap, wSConnectionRequestInfoImpl.ivTypeMap) && this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID) : this.ivIsoLevel == wSConnectionRequestInfoImpl.ivIsoLevel && (this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || this.hashcode == wSConnectionRequestInfoImpl.hashcode && this.extentionDSPropKey == wSConnectionRequestInfoImpl.extentionDSPropKey && this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly && WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.matchIDentityAttributes(wSConnectionRequestInfoImpl) && this.ivHoldability == wSConnectionRequestInfoImpl.ivHoldability && WSConnectionRequestInfoImpl.match(this.ivCatalog, wSConnectionRequestInfoImpl.ivCatalog) && this.matchReadOnly(wSConnectionRequestInfoImpl) && WSConnectionRequestInfoImpl.match(this.ivTypeMap, wSConnectionRequestInfoImpl.ivTypeMap) && this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID));
            }
            catch (RuntimeException runtimeException) {
                bl = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "equals?", new Object[]{AdapterUtil.toString(this), AdapterUtil.toString(object), bl ? Boolean.TRUE : Boolean.FALSE});
        }
        return bl;
    }

    private boolean matchIDentityAttributes(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "matchIDentityAttributes ", new Object[]{this, wSConnectionRequestInfoImpl});
        }
        boolean bl = false;
        if (this.trustedContextIdentityAttributesAreSet && wSConnectionRequestInfoImpl.trustedContextIdentityAttributesAreSet) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "both have identity attributes set");
            }
            if (WSConnectionRequestInfoImpl.match(this.tc_name, wSConnectionRequestInfoImpl.tc_name) && WSConnectionRequestInfoImpl.match(this.tc_realm, wSConnectionRequestInfoImpl.tc_realm) && Arrays.equals(this.tc_userSecToken, wSConnectionRequestInfoImpl.tc_userSecToken) && WSConnectionRequestInfoImpl.match(this.tc_originalUser, wSConnectionRequestInfoImpl.tc_originalUser)) {
                bl = true;
            }
        } else if (this.trustedContextIdentityAttributesAreSet || wSConnectionRequestInfoImpl.trustedContextIdentityAttributesAreSet) {
            bl = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "only one has identity attributes set");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "both have identity attributes not set");
            }
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "matchIDentityAttributes returned: ", new Boolean(bl));
        }
        return bl;
    }

    private static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private final boolean matchReadOnly(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) {
        if (DSConfigurationHelper._disablePK54589) {
            return WSConnectionRequestInfoImpl.match(this.ivReadOnly, wSConnectionRequestInfoImpl.ivReadOnly);
        }
        Boolean bl = this.defaultReadOnly == null ? wSConnectionRequestInfoImpl.defaultReadOnly : this.defaultReadOnly;
        return WSConnectionRequestInfoImpl.match(this.ivReadOnly, wSConnectionRequestInfoImpl.ivReadOnly) || this.ivReadOnly == null && WSConnectionRequestInfoImpl.match(bl, wSConnectionRequestInfoImpl.ivReadOnly) || wSConnectionRequestInfoImpl.ivReadOnly == null && WSConnectionRequestInfoImpl.match(this.ivReadOnly, bl);
    }

    void setDefaultValues(String string, Integer n, Boolean bl, Map map) {
        this.defaultReadOnly = bl;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(300).append(AdapterUtil.toString(this)).append(string + "  extention DS properties     = ").append(this.extentionDSProps).append(string + "  extention DS properties key = ").append(this.extentionDSPropKey).append(string + "  useHetrogeneous = ").append(this.useHetrogeneous).append(string + "  optimizeForGetUseCloseUsage = ").append(this.optimizeForGetUseCloseUsage).append(string + "  changable CRI  = ").append(this.changable).append(string + "  UserName       = ").append(this.ivUserName).append(string + "  Password       = ").append(this.ivPassword == null ? "null" : "******").append(string + "  Catalog        = ").append(this.ivCatalog).append(string + "  IsReadOnly     = ").append(this.ivReadOnly).append(string + "  defaultReadOnly= ").append(this.defaultReadOnly).append(string + "  TypeMap        = ").append(this.ivTypeMap).append(string + "  NoEnlist       = ").append(this.ivNoEnlist).append(string + "  ShareWithCMPOnly = ").append(this.ivShareWithCMPOnly).append(string + "  TrustedContext_name = ").append(this.tc_name).append(string + "  TrustedContext_realm = ").append(this.tc_realm).append(string + "  TrustedContext_userSecToken = ").append(this.tc_userSecToken).append(string + "  TrustedContext_originalUser = ").append(this.tc_originalUser).append(string + "  trustedContextIdentityAttributesAreSet = ").append(this.trustedContextIdentityAttributesAreSet).append(string + "  Holdability    = ").append(AdapterUtil.getCursorHoldabilityString(this.ivHoldability)).append(string + "  ConfigID       = ").append(this.ivConfigID).append(string + "  Isolation      = ").append(AdapterUtil.getIsolationLevelString(this.ivIsoLevel)).append(string + "  Support isolation switching  = ").append(this.supportIsolvlSwitching).append(string + "  Handle type    = ").append(this.isJDBC ? Connection.class.getName() : javax.resource.cci.Connection.class.getName());
        return new String(stringBuffer);
    }

    public final int hashCode() {
        return this.hashcode;
    }

    public void setJ2EEName(J2EEName j2EEName) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: J2EEName, cri", j2EEName, this}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setJ2EEName: ", j2EEName);
        }
        this.j2eename = j2EEName;
    }

    public J2EEName getJ2EEName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getJ2EEName returns: ", this.j2eename);
        }
        return this.j2eename;
    }

    public void setHeterogeneousProperties(Properties properties, int n) throws SQLException {
        if (properties != null) {
            if (!this.changable) {
                throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: HeterogeneousProperties, cri", properties, this}));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting the heterogenous properties (CRI, props, propKey)", new Object[]{this, properties, new Integer(n)});
            }
            this.extentionDSProps = properties;
            this.extentionDSPropKey = n;
            this.useHetrogeneous = true;
            this.hasIsolationLevelOnly = false;
        }
    }

    public void setOptimizeForGetUseClose(boolean bl) throws SQLException {
        if (!this.changable && bl) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: OptimizeForGetUseClose, cri", bl ? "true" : "false", this}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting the optimizeForGetUseCloseUsage to: ", new Boolean(bl));
        }
        this.optimizeForGetUseCloseUsage = bl;
    }

    public void setTrustedContextUserName(String string) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: TrustedContextUserName, cri", string, this}));
        }
        this.tc_name = string;
        this.trustedContextIdentityAttributesAreSet = true;
    }

    public void setTrustedContextUserSecToken(byte[] byArray) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: TrustedContextUserSecToken, cri", byArray, this}));
        }
        this.tc_userSecToken = byArray;
        this.trustedContextIdentityAttributesAreSet = true;
    }

    public void setTrustedContextOriginalUser(String string) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: TrustedContextOriginalUser, cri", string, this}));
        }
        this.tc_originalUser = string;
        this.trustedContextIdentityAttributesAreSet = true;
    }

    public void setTrustedContextRealm(String string) throws SQLException {
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: TrustedContextRealm, cri", string, this}));
        }
        this.tc_realm = string;
        this.trustedContextIdentityAttributesAreSet = true;
    }

    public void markAsChangable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "This CRI is marked as changable: ", this);
        }
        this.changable = true;
    }

    public boolean isCRIChangable() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isCRIChangable :", new Boolean(this.changable));
        }
        return this.changable;
    }

    public void setTransactionIsolationLevel(int n, long l) throws SQLException {
        if (l != 29497789L) {
            throw new IllegalArgumentException();
        }
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: iso , cri", new Integer(n), this}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting isolation level on the CRI to:", new Integer(n));
        }
        this.ivIsoLevel = n;
    }

    public void setReadOnly(boolean bl, long l) throws SQLException {
        if (l != 29497789L) {
            throw new IllegalArgumentException();
        }
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: readOnly , cri", new Boolean(bl), this}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting read only on the CRI to:", new Boolean(bl));
        }
        this.ivReadOnly = new Boolean(bl);
    }

    public void setReadOnly(Boolean bl, long l) throws SQLException {
        if (l != 29497789L) {
            throw new IllegalArgumentException();
        }
        if (!this.changable) {
            throw new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be modified, doing so may result in corruption: readOnly , cri", bl, this}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting read only on the CRI to:", bl);
        }
        this.ivReadOnly = bl;
    }

    public final boolean getNoEnlistValue() {
        return this.ivNoEnlist;
    }

    public final boolean getShareWithCMPOnlyValue() {
        return this.ivShareWithCMPOnly;
    }

    public final boolean getSupportIsolvlSwitchingValue() {
        return this.supportIsolvlSwitching;
    }

    public static WSConnectionRequestInfoImpl createChangableCRIFromNon(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) {
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl2 = new WSConnectionRequestInfoImpl(wSConnectionRequestInfoImpl.getUserName(), wSConnectionRequestInfoImpl.getPassword(), wSConnectionRequestInfoImpl.getIsolationLevel(), wSConnectionRequestInfoImpl.getCatalog(), wSConnectionRequestInfoImpl.isReadOnly(), wSConnectionRequestInfoImpl.getTypeMap(), wSConnectionRequestInfoImpl.getHoldability(), wSConnectionRequestInfoImpl.getConfigID(), true, wSConnectionRequestInfoImpl.getSupportIsolvlSwitchingValue(), wSConnectionRequestInfoImpl.getNoEnlistValue(), wSConnectionRequestInfoImpl.getShareWithCMPOnlyValue());
        wSConnectionRequestInfoImpl2.setDefaultValues(null, null, wSConnectionRequestInfoImpl.defaultReadOnly, null);
        wSConnectionRequestInfoImpl2.markAsChangable();
        return wSConnectionRequestInfoImpl2;
    }
}

