/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.DataSourceMBean;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.security.auth.IdentityPrincipal;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.j2c.J2CConfigPropertiesAndStatAccess;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.LocationRestrictedFunction;
import com.ibm.ws.rsadapter.spi.RestrictedClientFunction;
import com.ibm.ws.rsadapter.spi.WSAtomicInteger;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSDefaultConnectionManagerImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactory;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.security.GenericCredential;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.ietf.jgss.GSSCredential;

public class WSManagedConnectionFactoryImpl
implements WSManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable,
DataSourceMBean,
FFDCSelfIntrospectable {
    private static final long serialVersionUID = -56589160441993572L;
    private transient boolean perfEnhancementEnabledNotSet = true;
    private transient boolean perfEnhancementEnabled = false;
    private transient boolean useRRASetEqualsNotSet = true;
    private transient boolean useRRASetEquals = false;
    private transient String description;
    private transient int statementCacheSize;
    boolean newDBConnectionValidationEnabled = false;
    int newDBConnectionValidationRetries = 100;
    long newDBConnectionValidationRetryDuration = 3000L;
    transient WSAtomicInteger failoverCount;
    transient int datasourceFailoverAttempts;
    public int connectionSharing = 1;
    public transient boolean beginTranForResultSetScrollingAPIs;
    transient Properties dbDSProperties;
    boolean optimizedForGetUseClose = false;
    private boolean wasUsedToGetAConnection;
    transient boolean useDataSource;
    boolean propagateClientIdentityUsingTrustedContext;
    private Integer connectionFactoryType;
    private transient Properties dataSourceProperties;
    private ResourceAdapter resourceAdapter;
    private WSDefaultConnectionManagerImpl defaultConnectionManager = new WSDefaultConnectionManagerImpl();
    protected WSRdbDataSource dataSource;
    transient DataStoreHelper dataStoreHelper;
    transient InternalDataStoreHelper internalHelper;
    private transient LinkedList propertyListeners;
    private transient String databaseType;
    transient boolean disableBackendIdchecking;
    boolean resetConnectionByBackendDatabase;
    boolean reauthEnabled;
    transient int hashCode;
    transient PrintWriter logWriter;
    transient J2CPerf pmi;
    public boolean jmsOnePhaseOptimization;
    boolean disableWASConnectionPooling;
    transient boolean detectMultithreadedAccess;
    transient String preTestSQLString = "select 1 from dual";
    public transient boolean detectedMultithreadedAccess;
    private static final Class currClass = WSManagedConnectionFactoryImpl.class;
    private static TraceComponent tc = Tr.register(currClass, "RRA", "IBMDataStoreAdapterNLS");
    boolean loggingEnabled;
    String jndiName = "";
    protected transient ConnectionManager connMgr = null;
    transient boolean transactionBranchesLooselyCoupled;
    transient long fatalErrorCount;
    transient boolean validateAfterConnectionError = true;
    public static LocationRestrictedFunction locationRestrictedFunction;
    private String _purgePolicy = "FailingConnectionOnly";
    private int _commitOrRollbackOnCleanup;
    protected static final int COMMIT_DB_IMPLICITLY_STARTED_TRAN_ON_CLEANUP = 0;
    protected static final int ROLLBACK_DB_IMPLICITLY_STARTED_TRAN_ON_CLEANUP = 1;
    protected static final int DEFAULT_ON_CLEANUP = -1;
    protected boolean loggedDbUowMessage = false;
    protected boolean loggedImmplicitTransactionFound = false;
    transient boolean useRunAsSystemOnGetPooledConnection;
    public transient String appServerName = "";
    transient Integer initialMaxPoolSize;
    transient boolean collectDataAndPushDownToCMX = false;
    private transient boolean checkCMXMonitoring = true;
    transient boolean enableEndToEndMonitoringFeature;
    transient J2CConfigPropertiesAndStatAccess j2cConfigPropOb;
    static /* synthetic */ Class class$java$util$Hashtable;

    public WSManagedConnectionFactoryImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    Tr.info(tc, "SERVICE_NOT_FOUND_DSRA9548I", "AdminService");
                    return "";
                }
                return AdapterUtil.concatWithHash(AdapterUtil.concatWithHash(adminService.getCellName(), adminService.getNodeName()), adminService.getProcessName());
            }
        };
        try {
            this.appServerName = (String)com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), this.getClass().getName() + ".<init>", "765", this);
            Tr.info(tc, "SERVICE_LOOKUP_FAILURE_DSRA9546W", new Object[]{"AdminService", privilegedActionException.getException()});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The appServer identity is: " + this.appServerName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public int configureDataSource(String string, Object[] objectArray, Class[] classArray, int n) throws SQLException {
        return this.dataSource.configure(string, objectArray, classArray, n);
    }

    public boolean isReauthenticationEnabled() {
        return this.reauthEnabled;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new LinkedList();
        }
        this.propertyListeners.add(propertyChangeListener);
    }

    public boolean shouldDataBeCollectedAndPshedDownToCMX() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "collectDataAndPushDownToCMX value is: ", new Boolean(this.collectDataAndPushDownToCMX));
            Tr.debug(tc, "enableEndToEndMonitoringFeature value is: ", new Boolean(this.enableEndToEndMonitoringFeature));
            Tr.debug(tc, "shouldDataBeCollectedAndPshedDownToCMX(): ", new Boolean(this.enableEndToEndMonitoringFeature && this.collectDataAndPushDownToCMX));
        }
        return this.enableEndToEndMonitoringFeature && this.collectDataAndPushDownToCMX;
    }

    public boolean isEndToEndMonitoringFeatureEnabled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isEndToEndMonitoringFeatureEnabled()returns : ", new Boolean(this.enableEndToEndMonitoringFeature));
        }
        return this.enableEndToEndMonitoringFeature;
    }

    public void setJ2CConfigPropertiesAndStatAccess(J2CConfigPropertiesAndStatAccess j2CConfigPropertiesAndStatAccess) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setJ2CConfigPropertiesAndStatAccess(J2CConfigPropertiesAndStatAccess) ", j2CConfigPropertiesAndStatAccess);
        }
        this.j2cConfigPropOb = j2CConfigPropertiesAndStatAccess;
    }

    public void setJ2CInitialConfigProperties(String string, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setJ2CInitialConfigProperties (String jndiName, int maxNumOfConnections) ", new Object[]{string, new Integer(n)});
        }
        this.initialMaxPoolSize = new Integer(n);
        this.jndiName = string;
    }

    final void adjustHashCode(Object object, Object object2) {
        this.hashCode += (object2 == null ? 0 : object2.hashCode()) - (object == null ? 0 : object.hashCode());
    }

    public final Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionFactory", connectionManager);
        }
        this.connMgr = connectionManager;
        Object object = this.connectionFactoryType == null || this.connectionFactoryType.equals(ConnectionFactoryRefBuilder.FACTORY_WSJdbcDataSource) ? new WSJdbcDataSource(this, connectionManager) : locationRestrictedFunction.createCCIConnectionFactory(this, connectionManager);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createConnectionFactory", object);
        }
        return object;
    }

    public final Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(this.defaultConnectionManager);
    }

    public final Object createConnectionFactory(ConnectionManager connectionManager, Integer n) throws ResourceException {
        this.connMgr = connectionManager;
        this.setConnectionFactoryType(n);
        return this.createConnectionFactory(connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        Object[] objectArray;
        Object object2;
        String string;
        String string2;
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl;
        int n;
        PooledConnection pooledConnection;
        boolean bl;
        Object var4_4;
        boolean bl2;
        block61: {
            Object object3;
            Object object4;
            Object object5;
            block62: {
                block60: {
                    bl2 = false;
                    var4_4 = null;
                    boolean bl3 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "createManagedConnection", new Object[]{subject == null ? null : "subject not null", AdapterUtil.toString(connectionRequestInfo)});
                    }
                    pooledConnection = null;
                    n = this.failoverCount == null ? 0 : this.failoverCount.get();
                    wSConnectionRequestInfoImpl = connectionRequestInfo == null ? new WSConnectionRequestInfoImpl() : (WSConnectionRequestInfoImpl)connectionRequestInfo;
                    string2 = null;
                    string = null;
                    if (subject != null) break block60;
                    string = wSConnectionRequestInfoImpl.getPassword();
                    string2 = wSConnectionRequestInfoImpl.getUserName();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block61;
                    if (string2 == null) {
                        Tr.event(tc, "Using DataSource default user/password for authentication");
                    } else {
                        Tr.event(tc, "Using ConnectionRequestInfo for authentication");
                    }
                    break block61;
                }
                if (bl) {
                    Tr.debug(tc, "Subject found.  Will try to use either PasswordCredentials or GenericCredentials ");
                }
                string2 = null;
                string = null;
                object2 = this.getThreadIdentitySupport();
                boolean bl4 = false;
                if (((String)object2).equals("ALLOWED") || ((String)object2).equals("REQUIRED")) {
                    if (bl) {
                        Tr.debug(tc, "The JDBC Provider supports the use of Thread Identity for authentication.");
                    }
                    objectArray = subject;
                    object = null;
                    if (System.getSecurityManager() != null) {
                        object5 = new PrivilegedExceptionAction((Subject)objectArray){
                            private final /* synthetic */ Subject val$subj;
                            {
                                this.val$subj = subject;
                            }

                            public Object run() throws Exception {
                                return this.val$subj.getPrivateCredentials(class$javax$resource$spi$security$GenericCredential == null ? (class$javax$resource$spi$security$GenericCredential = WSManagedConnectionFactoryImpl.class$("javax.resource.spi.security.GenericCredential")) : class$javax$resource$spi$security$GenericCredential);
                            }
                        };
                        try {
                            object = (Set)AccessController.doPrivileged(object5);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl", "826", this);
                            Exception exception = privilegedActionException.getException();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "createManagedConnection with exception", exception);
                            }
                            throw (ResourceException)((Object)exception);
                        }
                    } else {
                        object = objectArray.getPrivateCredentials(GenericCredential.class);
                    }
                    object5 = object.iterator();
                    object4 = new PrivilegedExceptionAction((Iterator)object5){
                        private final /* synthetic */ Iterator val$iterator;
                        {
                            this.val$iterator = iterator;
                        }

                        public Object run() throws Exception {
                            return this.val$iterator.next();
                        }
                    };
                    object3 = null;
                    while (object5.hasNext()) {
                        if (System.getSecurityManager() != null) {
                            try {
                                object3 = (GenericCredential)AccessController.doPrivileged(object4);
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "createManagedConnection", "Exception");
                                }
                                String string3 = "Error validating credentials.";
                                DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{string3, privilegedActionException.getException()}, privilegedActionException.getException(), currClass);
                                FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), "com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl.createManagedConnection", "644", this, new Object[]{string3, " Possible components: Security"});
                                throw dataStoreAdapterException;
                            }
                        } else {
                            object3 = (GenericCredential)object5.next();
                        }
                        if (!object3.getMechType().equals("oid:1.3.18.0.2.30.1")) continue;
                        bl4 = true;
                        break;
                    }
                    if (!bl4 && ((String)object2).equals("REQUIRED")) {
                        String string4 = "createManagedConnection() error: Jdbc Provider requires ThreadIdentitySupport, but no UTOKEN generic credential was found.";
                        DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", string4, null, currClass);
                        throw dataStoreAdapterException;
                    }
                }
                if (!bl4) break block62;
                if (this.propagateClientIdentityUsingTrustedContext) {
                    Tr.warning(tc, "IDENTITY_PROPAGATION_CONFLICT2_WARNING");
                    this.propagateClientIdentityUsingTrustedContext = false;
                }
                string2 = null;
                string = null;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block61;
                Tr.event(tc, "Using thread identity for authentication by the JDBC Provider's DataSource.");
                break block61;
            }
            objectArray = subject.getPrivateCredentials().iterator();
            object = new PrivilegedExceptionAction((Iterator)objectArray){
                private final /* synthetic */ Iterator val$iter;
                {
                    this.val$iter = iterator;
                }

                public Object run() throws Exception {
                    return this.val$iter.next();
                }
            };
            while (objectArray.hasNext()) {
                if (System.getSecurityManager() != null) {
                    try {
                        var4_4 = AccessController.doPrivileged(object);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), this.getClass().getName() + ".createManagedConnection", "335", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "createManagedConnection", "Exception");
                        }
                        object3 = "Error validating credentials.";
                        DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{object3, privilegedActionException.getException()}, privilegedActionException.getException(), currClass);
                        FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), this.getClass().getName() + ".createManagedConnection", "754", this, new Object[]{object3, " Possible components: Security"});
                        throw dataStoreAdapterException;
                    }
                } else {
                    var4_4 = objectArray.next();
                }
                if (var4_4 instanceof PasswordCredential) {
                    object5 = var4_4;
                    if (!object5.getManagedConnectionFactory().equals(this)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Using PasswordCredentials for authentication");
                    }
                    string2 = object5.getUserName();
                    object4 = object5.getPassword();
                    string = object4 == null ? null : new String((char[])object4);
                    break;
                }
                if (!(var4_4 instanceof GSSCredential)) continue;
                bl2 = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Using GenericCredentials for authentication");
                }
                pooledConnection = this.internalHelper.getPooledConnection(var4_4, this.dataSource, wSConnectionRequestInfoImpl.ivConfigID, n);
                break;
            }
        }
        object2 = null;
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
        try {
            objectArray = null;
            if (this.useDataSource) {
                object2 = this.dataSource.getConnectionUsingDS(string2, string, wSConnectionRequestInfoImpl, n);
                objectArray = new Object[]{null, null};
            } else if (pooledConnection == null) {
                objectArray = this.dataSource.getPooledConnection(string2, string, wSConnectionRequestInfoImpl, n);
                pooledConnection = (PooledConnection)objectArray[0];
                if (bl) {
                    Tr.debug(tc, "PooledConnection returned is ", objectArray[0]);
                    Tr.debug(tc, "cookie returned is ", objectArray[1] == null ? null : "not null");
                }
                object2 = this.dataSource.getConnection(pooledConnection, (byte[])objectArray[1], wSConnectionRequestInfoImpl);
            } else {
                objectArray = new Object[]{pooledConnection, null};
                object2 = this.dataSource.getConnection(pooledConnection, null, wSConnectionRequestInfoImpl);
            }
            try {
                if (this.enableEndToEndMonitoringFeature && this.checkCMXMonitoring) {
                    object = wSConnectionRequestInfoImpl.ivConfigID == 0 ? this.dataSource.cmxDataSourceProxy : this.dataSource.dcm.getCMXDataSourceProxy(wSConnectionRequestInfoImpl.ivConfigID);
                    this.collectDataAndPushDownToCMX = object != null && this.internalHelper.isMonitoringEnabled(object);
                }
            }
            catch (Throwable throwable) {
                this.checkCMXMonitoring = false;
                this.enableEndToEndMonitoringFeature = false;
                if (bl) {
                    Tr.debug(tc, "got an exception while checking on monitoring . Disabling the monitoring feature based on that.  Exception is:", throwable);
                }
                Tr.warning(tc, "CMX_MONITORING_CHECKING_PROBLEM", throwable);
            }
            if (this.newDBConnectionValidationEnabled && !this.useDataSource) {
                if (bl) {
                    Tr.debug(tc, "New connection validation is enabled, now validating conn");
                }
                this.validateConnection((Connection)object2);
            }
            wSRdbManagedConnectionImpl = new WSRdbManagedConnectionImpl(this, pooledConnection, (Connection)object2, subject, wSConnectionRequestInfoImpl, this.statementCacheSize, this.databaseType, (byte[])objectArray[1], n);
            if (bl) {
                Tr.debug(tc, "[mc, pconn, isJTAEnabled]", new Object[]{wSRdbManagedConnectionImpl, pooledConnection, new Boolean(this.isJTAEnabled())});
            }
            if (this.enableEndToEndMonitoringFeature) {
                AdapterUtil.displayApplicationInfoAndPostCMXMsg(false, this.collectDataAndPushDownToCMX, wSRdbManagedConnectionImpl.mc_j2eename, this.appServerName, this.internalHelper, 110, this.collectDataAndPushDownToCMX ? AdapterUtil.getcmxArgsObject(3, wSRdbManagedConnectionImpl.mc_j2eename, this.j2cConfigPropOb, wSRdbManagedConnectionImpl, null, this.jndiName, null) : null, wSRdbManagedConnectionImpl.sqlConn);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createManagedConnection", wSRdbManagedConnectionImpl);
            }
            return wSRdbManagedConnectionImpl;
        }
        catch (ResourceException resourceException) {
            if (!this.newDBConnectionValidationEnabled && resourceException instanceof DataStoreAdapterException && ((DataStoreAdapterException)resourceException).isConnectionError() && !((DataStoreAdapterException)resourceException).isAuthorizationException()) {
                this.moveToNextFailoverServer(n);
            }
            if (this.newDBConnectionValidationEnabled && !this.useDataSource) {
                if (((DataStoreAdapterException)resourceException).isAuthorizationException()) {
                    if (bl) {
                        Tr.debug(tc, "Exception is an autherization exception, so no retries will be done.");
                    }
                    throw resourceException;
                }
                if (bl) {
                    Tr.debug(tc, "Exception is a SCE and not an autherization exception, so no retries will continue.");
                }
                object = null;
                if (bl) {
                    Tr.debug(tc, "validating failed closing connection and getting new one to revalidate");
                }
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (pooledConnection != null) {
                        pooledConnection.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bl) {
                    Tr.debug(tc, "done closing, now try to get a good connection");
                }
                object = this.getGoodConnection(pooledConnection, string2, string, wSConnectionRequestInfoImpl, bl2, var4_4, n);
                wSRdbManagedConnectionImpl = new WSRdbManagedConnectionImpl(this, (PooledConnection)object[0], (Connection)object[2], subject, wSConnectionRequestInfoImpl, this.statementCacheSize, this.databaseType, (byte[])object[1], n);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createManagedConnection in retry mode", wSRdbManagedConnectionImpl);
                }
                if (this.enableEndToEndMonitoringFeature) {
                    AdapterUtil.displayApplicationInfoAndPostCMXMsg(false, this.collectDataAndPushDownToCMX, wSRdbManagedConnectionImpl.mc_j2eename, this.appServerName, this.internalHelper, 110, this.collectDataAndPushDownToCMX ? AdapterUtil.getcmxArgsObject(3, wSRdbManagedConnectionImpl.mc_j2eename, this.j2cConfigPropOb, wSRdbManagedConnectionImpl, null, this.jndiName, null) : null, wSRdbManagedConnectionImpl.sqlConn);
                }
                return wSRdbManagedConnectionImpl;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createManagedConnection", (Object)resourceException);
            }
            throw resourceException;
        }
    }

    public final boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object || object != null && this.hashCode == object.hashCode() && this.fullCompare(object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "equals?", new Object[]{this, object, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        return bl;
    }

    public boolean equals(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl, int n, int n2) {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{"Configuration #" + n + " of " + this, "Configuration #" + n2 + " of " + wSManagedConnectionFactoryImpl});
        }
        boolean bl2 = WSManagedConnectionFactoryImpl.match(this.dataSourceProperties, wSManagedConnectionFactoryImpl.dataSourceProperties) && (this.dataSource == null ? wSManagedConnectionFactoryImpl.dataSource == null : this.dataSource.equals(wSManagedConnectionFactoryImpl.dataSource, n, n2)) ? true : (bl = false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    private synchronized void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "ManagedConnectionFactory property changed:", new Object[]{this, string, string.equalsIgnoreCase("password") ? "******" : object, string.equalsIgnoreCase("password") ? "******" : object2});
        }
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        Iterator iterator = this.propertyListeners.iterator();
        while (iterator.hasNext()) {
            ((PropertyChangeListener)iterator.next()).propertyChange(propertyChangeEvent);
        }
    }

    private boolean fullCompare(Object object) {
        try {
            WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl = (WSManagedConnectionFactoryImpl)object;
            return WSManagedConnectionFactoryImpl.match(this.dataSourceProperties, wSManagedConnectionFactoryImpl.dataSourceProperties) && WSManagedConnectionFactoryImpl.match(this.dataSource, wSManagedConnectionFactoryImpl.dataSource);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Set getInvalidConnections(Set set) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvalidConnections", new Object[]{this, set});
        }
        HashSet<WSRdbManagedConnectionImpl> hashSet = new HashSet<WSRdbManagedConnectionImpl>();
        Object var3_3 = null;
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                wSRdbManagedConnectionImpl = (WSRdbManagedConnectionImpl)iterator.next();
                wSRdbManagedConnectionImpl.preTestConnection(false);
            }
            catch (ResourceException resourceException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SQLException sQLException = (SQLException)resourceException.getCause();
                    Tr.debug(tc, "Found a bad connection.", new Object[]{wSRdbManagedConnectionImpl, "SQL State:  " + sQLException.getSQLState(), "Error Code: " + sQLException.getErrorCode(), sQLException.getMessage()});
                }
                hashSet.add(wSRdbManagedConnectionImpl);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvalidConnections", hashSet);
        }
        return hashSet;
    }

    public final ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public final Boolean getRRSTransactional() {
        return this.internalHelper.getRRSTransactional();
    }

    public final String getThreadIdentitySupport() {
        return this.internalHelper.getThreadIdentitySupport();
    }

    public final Boolean getThreadSecurity() {
        return this.internalHelper.getThreadSecurity();
    }

    public Object getUnderlyingDataSource(long l, int n) throws SQLException {
        if (29497789L != l) {
            throw new IllegalArgumentException();
        }
        if (this.dataSource.isFailoverEnabled()) {
            throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"DataSource.*", "datasourceFailoverServers"}));
        }
        return n == 0 ? this.dataSource.getDataSource(0) : this.dataSource.dcm.getDataSource(n);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean isDataSourceFailoverEnabled() {
        return this.dataSource.isFailoverEnabled();
    }

    private static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            object = null;
            object = subject == null ? "null" : "not null";
            Tr.entry(tc, "matchManagedConnections", new Object[]{set == null ? null : new Integer(set.size()), object, connectionRequestInfo});
        }
        if (this.disableWASConnectionPooling) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WAS connection pooling is disabled, throwing a NotSupportedException");
            }
            throw new NotSupportedException();
        }
        if (set == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "matchManagedConnections", null);
            }
            return null;
        }
        try {
            object = (WSConnectionRequestInfoImpl)connectionRequestInfo;
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "matchManagedConnections", null);
            }
            return null;
        }
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "the size of the set should be 1, and it is", new Integer(set.size()));
        }
        Iterator iterator = set.iterator();
        WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl2 = (WSRdbManagedConnectionImpl)iterator.next();
        if (wSRdbManagedConnectionImpl2._claimedVictim && ((WSConnectionRequestInfoImpl)object).isReconfigurable(wSRdbManagedConnectionImpl2.getCRI(), true)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "mc is claimedVictim matched", wSRdbManagedConnectionImpl2);
            }
            wSRdbManagedConnectionImpl = wSRdbManagedConnectionImpl2;
        } else if (subject == null) {
            if (wSRdbManagedConnectionImpl2.getSubject() == null && ((WSConnectionRequestInfoImpl)object).isReconfigurable(wSRdbManagedConnectionImpl2.getCRI(), false)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "mc matched", wSRdbManagedConnectionImpl2);
                }
                wSRdbManagedConnectionImpl = wSRdbManagedConnectionImpl2;
            }
        } else {
            Subject subject2 = wSRdbManagedConnectionImpl2.getSubject();
            if (subject2 != null) {
                Equals equals = new Equals();
                equals.setSubjects(subject, subject2);
                if (((Boolean)com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedAction)equals)).booleanValue() && ((WSConnectionRequestInfoImpl)object).isReconfigurable(wSRdbManagedConnectionImpl2.getCRI(), false)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "mc matched", wSRdbManagedConnectionImpl2);
                    }
                    wSRdbManagedConnectionImpl = wSRdbManagedConnectionImpl2;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "matchManagedConnections", wSRdbManagedConnectionImpl);
        }
        return wSRdbManagedConnectionImpl;
    }

    void moveToNextFailoverServer(int n) {
        boolean bl;
        boolean bl2 = TraceComponent.isAnyTracingEnabled();
        if (bl2 && tc.isEntryEnabled()) {
            Tr.entry(tc, "moveToNextFailoverServer", new Integer(n));
        }
        boolean bl3 = bl = this.failoverCount == null ? false : this.failoverCount.compareAndSet(n, n + 1);
        if (bl2 && tc.isEntryEnabled()) {
            Tr.exit(tc, "moveToNextFailoverServer", bl ? new Integer(n + 1) : null);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(propertyChangeListener);
        }
    }

    private void resetHashCode() {
        this.hashCode = this.dataSourceProperties == null ? 0 : this.dataSourceProperties.hashCode();
    }

    public final void setAgedTimeout(int n) {
        Tr.warning(tc, "METHOD_UNSUPPORTED", new Object[]{"setAgedTimeout", ManagedConnectionFactory.class});
    }

    public final void setConnectionTimeout(int n) {
        Tr.warning(tc, "METHOD_UNSUPPORTED", new Object[]{"setConnectionTimeout", ManagedConnectionFactory.class});
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final void setInactiveConnectionSupport(Boolean bl) {
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setLogWriter on the mcf is a no-op when calling this method");
        }
    }

    final void reallySetLogWriter(final PrintWriter printWriter) throws ResourceException {
        if (this.dataSource != null) {
            final WSRdbDataSource wSRdbDataSource = this.dataSource;
            try {
                com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        wSRdbDataSource.setLogWriter(printWriter);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl.setLogWriter", "593", this);
                throw (ResourceException)((Object)privilegedActionException.getException());
            }
        }
        this.logWriter = printWriter;
    }

    public final void setMaxConnections(int n) {
        Tr.warning(tc, "METHOD_UNSUPPORTED", new Object[]{"setMaxConnections", ManagedConnectionFactory.class});
    }

    public final void setMinConnections(int n) {
        Tr.warning(tc, "METHOD_UNSUPPORTED", new Object[]{"setMinConnections", ManagedConnectionFactory.class});
    }

    public final void setPurgePolicy(String string) {
        Tr.warning(tc, "METHOD_UNSUPPORTED", new Object[]{"setPurgePolicy", ManagedConnectionFactory.class});
    }

    public final void setReapTime(int n) {
        Tr.warning(tc, "METHOD_UNSUPPORTED", new Object[]{"setReapTime", ManagedConnectionFactory.class});
    }

    public final void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        this.resourceAdapter = resourceAdapter;
    }

    public final void setUnusedTimeout(int n) {
        Tr.warning(tc, "METHOD_UNSUPPORTED", new Object[]{"setUnusedTimeout", ManagedConnectionFactory.class});
    }

    public void setDataSourceProperties(Properties properties) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String string = (String)properties.remove("password");
            Tr.entry(tc, "setDataSourceProperties", properties);
            if (string != null) {
                properties.setProperty("password", string);
            }
        }
        this.dataSourceProperties = (Properties)properties.clone();
        this.dataSource = new WSRdbDataSource(this.dataSourceProperties, this);
        this.dataStoreHelper = this.dataSource.dataStoreHelper;
        if (this.internalHelper.shouldTraceBeEnabled(this)) {
            this.internalHelper.enableJdbcLogging(this);
        }
        this.resetHashCode();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setDataSourceProperties");
        }
    }

    public String getDataSourceName() {
        String string = null;
        if (this.dataSourceProperties != null) {
            string = this.dataSourceProperties.getProperty("dataSourceName");
        }
        if (string == null) {
            string = "ManagedConnectionFactory " + Integer.toHexString(super.hashCode());
        }
        return string;
    }

    public void setConnectionFactoryType(Integer n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setConnectionFactoryType", AdapterUtil.getConnectionFactoryInterfaceName(n));
        }
        if (WSManagedConnectionFactoryImpl.match(n, this.connectionFactoryType)) {
            return;
        }
        if (this.propertyListeners == null) {
            this.connectionFactoryType = n;
        } else {
            this.connectionFactoryType = n;
            this.firePropertyChangeEvent("ConnectionFactoryType", this.connectionFactoryType, this.connectionFactoryType);
        }
    }

    final void setStatementCacheSize(int n) {
        this.statementCacheSize = n;
    }

    public final void setTransactionResourceRegistration(String string) {
    }

    public final int getStatementCacheSize() {
        return this.statementCacheSize;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("Detection of multithreaded access is", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
        if (this.detectMultithreadedAccess) {
            fFDCLogger.append("Multithreaded access was detected?", this.detectedMultithreadedAccess ? Boolean.TRUE : Boolean.FALSE);
        }
        fFDCLogger.append("Resource Adapter:", this.resourceAdapter);
        fFDCLogger.append("Hash Code:", this.hashCode + " (0x" + Integer.toHexString(this.hashCode) + ')');
        fFDCLogger.append("DataSource properties:", AdapterUtil.hidePassword(this.dataSourceProperties));
        fFDCLogger.append("Database Type:", this.databaseType);
        fFDCLogger.append("DataStoreHelper:", this.dataStoreHelper);
        fFDCLogger.append("Description:", this.description);
        fFDCLogger.append("InternalDataStoreHelper:", this.internalHelper);
        fFDCLogger.append("Log Writer:", this.logWriter);
        fFDCLogger.append("Performance Monitoring Instrumentation:", this.pmi);
        fFDCLogger.append("Statement Cache Size (maximum):", new Integer(this.statementCacheSize));
        fFDCLogger.append("Transaction Branches are set to be Loosely Coupled: ", new Boolean(this.transactionBranchesLooselyCoupled));
        fFDCLogger.append("Counter of fatal connection errors on ManagedConnections created by this MCF:", new Long(this.fatalErrorCount));
        fFDCLogger.append("Validate existing connections on cleanup after a fatal connection error is detected?", this.validateAfterConnectionError ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("ResetConnectionByBackendDatabase: ", new Boolean(this.resetConnectionByBackendDatabase));
        fFDCLogger.append("Backend id checking is: ", new Boolean(!this.disableBackendIdchecking));
        fFDCLogger.append("JMSOnePhaseOptimization: ", new Boolean(this.jmsOnePhaseOptimization));
        fFDCLogger.append("Reauthentication: ", new Boolean(this.reauthEnabled));
        fFDCLogger.append("newDBConnectionValidationEnabled: ", new Boolean(this.newDBConnectionValidationEnabled));
        fFDCLogger.append("connectionRetriesDuringDBFailover: ", new Integer(this.newDBConnectionValidationRetries));
        fFDCLogger.append("connRetryDurationDuringDBFailover: ", new Long(this.newDBConnectionValidationRetryDuration));
        fFDCLogger.append("Failover count: ", new Integer(this.failoverCount == null ? 0 : this.failoverCount.get()));
        String string = this.connectionFactoryType == null ? null : (this.connectionFactoryType.equals(ConnectionFactoryRefBuilder.FACTORY_WSJdbcDataSource) ? WSJdbcDataSource.class.getName() : (this.connectionFactoryType.equals(ConnectionFactoryRefBuilder.FACTORY_WSRdbConnectionFactory) ? "com.ibm.ws.rsadapter.cci.WSRdbConnectionFactoryImpl" : "com.ibm.ws.rsadapter.cci.RdbConnectionFactoryImpl"));
        fFDCLogger.append("Connection Factory Type:", string);
        fFDCLogger.append("Listing PropertyChangeListeners:");
        try {
            Iterator iterator = this.propertyListeners.iterator();
            while (iterator.hasNext()) {
                fFDCLogger.indent(iterator.next());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        fFDCLogger.eoln();
        fFDCLogger.introspect("WSRdbDataSource Wrapper", this.dataSource);
        return fFDCLogger.toStringArray();
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        if (this.dataSource == null) {
            return this.logWriter;
        }
        return this.dataSource.getLogWriter();
    }

    public final PrintWriter getLogWriter(int n) throws SQLException {
        return this.dataSource == null ? this.logWriter : this.dataSource.getLogWriter(n);
    }

    public final J2CPerf getPMI() {
        return this.pmi;
    }

    public int getLoginTimeout() {
        if (this.dataSource == null) {
            return 0;
        }
        String string = this.getDataSourceProperties().getProperty("loginTimeout");
        return string == null ? 0 : Integer.parseInt(string);
    }

    public final int getLoginTimeout(int n) throws SQLException {
        return this.dataSource == null ? 0 : this.dataSource.getLoginTimeout(n);
    }

    public final String getDescription() {
        return this.description;
    }

    public final Class getConnectionFactoryClass() {
        Class clazz = this.connectionFactoryType == ConnectionFactoryRefBuilder.FACTORY_WSRdbConnectionFactory ? ConnectionFactory.class : DataSource.class;
        return clazz;
    }

    public final Integer getConnectionFactoryType() {
        return this.connectionFactoryType;
    }

    public final Properties getDataSourceProperties() {
        return this.dataSource.getDataSourceProperties();
    }

    public final DataStoreHelper getDataStoreHelper() {
        return this.dataStoreHelper;
    }

    public InternalDataStoreHelper getInternalDataStoreHelper() {
        return this.internalHelper;
    }

    public final Class getDataStoreHelperClass() {
        return this.dataStoreHelper.getClass();
    }

    protected final void setDatabaseType(String string) {
        this.databaseType = string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Database type is " + string);
        }
    }

    public final Object[] call(String string, Object[] objectArray, Class[] classArray, int n) throws SQLException {
        return this.call(string, objectArray, classArray, n, null);
    }

    public final Object[] call(String string, Object[] objectArray, Class[] classArray, int n, String string2) throws SQLException {
        return this.dataSource.call(string, objectArray, classArray, n, string2);
    }

    public final boolean isJTAEnabled() {
        return this.dataSource.isJTAEnabled();
    }

    public void setUserName(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "set user = " + string);
        }
        string = string.trim();
        if (this.propertyListeners == null) {
            this.adjustHashCode(this.dataSource.setUserName(string), string);
        } else {
            Object object = this.dataSource.setUserName(string);
            if (!WSManagedConnectionFactoryImpl.match(object, string)) {
                this.adjustHashCode(object, string);
                this.firePropertyChangeEvent("UserName", object, string);
            }
        }
    }

    public void setPassword(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "set password = ******");
        }
        string = string.trim();
        if (this.propertyListeners == null) {
            this.adjustHashCode(this.dataSource.setPassword(string), string);
        } else {
            Object object = this.dataSource.setPassword(string);
            if (!WSManagedConnectionFactoryImpl.match(object, string)) {
                this.adjustHashCode(object, string);
                this.firePropertyChangeEvent("Password", "******", "******");
            }
        }
    }

    public void setPmiData(String string, J2CPerf j2CPerf) {
        this.jndiName = string;
        this.pmi = j2CPerf;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setPmiData(String jndiName, J2CPerf pmiData)", new Object[]{string, j2CPerf});
        }
    }

    public String getCorrelator(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        return this.internalHelper.getCorrelator(wSRdbManagedConnectionImpl);
    }

    public final boolean isBackEndIdCheckingDisabled() {
        return this.disableBackendIdchecking;
    }

    public ConnectionManager getConnMgr(int n) {
        if (29497789 != n) {
            throw new IllegalArgumentException();
        }
        return this.connMgr;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    private Object[] getGoodConnection(PooledConnection pooledConnection, String string, String string2, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, boolean bl, Object object, int n) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getGoodConnection(PooledConnection, String, String, int ,boolean, Object)", new Object[]{pooledConnection, string, "******", new Integer(wSConnectionRequestInfoImpl.ivConfigID), new Boolean(bl), object, new Integer(n)});
        }
        Object[] objectArray = null;
        Connection connection = null;
        ResourceException resourceException = null;
        for (int i = 0; i <= this.datasourceFailoverAttempts; ++i) {
            int n2 = this.newDBConnectionValidationRetries;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getGoodConnection failover attempt #" + i + " about to go through loop " + n2 + " times");
            }
            while (n2-- > 0 && (this.failoverCount == null || n == this.failoverCount.get())) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getGoodConnection failover attempt #" + i + ", retry #" + (this.newDBConnectionValidationRetries - n2));
                    }
                    if (!bl) {
                        objectArray = this.dataSource.getPooledConnection(string, string2, wSConnectionRequestInfoImpl, n);
                        connection = this.dataSource.getConnection((PooledConnection)objectArray[0], (byte[])objectArray[1], wSConnectionRequestInfoImpl);
                        this.validateConnection(connection);
                        return new Object[]{objectArray[0], objectArray[1], connection};
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "using kerberos to get a connection");
                    }
                    pooledConnection = this.internalHelper.getPooledConnection((GSSCredential)object, this.dataSource, wSConnectionRequestInfoImpl.ivConfigID, n);
                    connection = this.dataSource.getConnection(pooledConnection, null, wSConnectionRequestInfoImpl);
                    this.validateConnection(connection);
                    return new Object[]{pooledConnection, null, connection};
                }
                catch (ResourceException resourceException2) {
                    if (((DataStoreAdapterException)resourceException2).isAuthorizationException()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception is an autherization exception, so no retries will be done.");
                        }
                        throw resourceException2;
                    }
                    resourceException = resourceException2;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "pretest failed, closing to retrying number:" + this.newDBConnectionValidationRetries);
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        if (pooledConnection != null) {
                            pooledConnection.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (n2 <= 0 && i >= this.datasourceFailoverAttempts) continue;
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "sleeping for (ms):" + this.newDBConnectionValidationRetryDuration);
                        }
                        Thread.sleep(this.newDBConnectionValidationRetryDuration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.moveToNextFailoverServer(n);
            n = this.failoverCount == null ? 0 : this.failoverCount.get();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Couldn't get good connection, throwing rEX: " + resourceException);
        }
        throw resourceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateConnection(Connection connection) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateConnection (conn, pretestString)", new Object[]{connection, this.preTestSQLString});
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(this.preTestSQLString);
            statement.close();
            statement = null;
            connection.clearWarnings();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "validateConnection successful");
            }
        }
        catch (SQLException sQLException) {
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException, this, false, currClass);
            if (dataStoreAdapterException.isConnectionError() || dataStoreAdapterException.isAuthorizationException()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateConnection failed", sQLException);
                }
                throw dataStoreAdapterException;
            }
            try {
                connection.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "validateConnection Passed but with non-SCE", sQLException);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected String getPurgePolicy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPurgePolicy");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPurgePolicy", this._purgePolicy);
        }
        return this._purgePolicy;
    }

    public void setPurgePolicyInternal(String string) {
        this._purgePolicy = string;
    }

    public void setCommitOrRollbackOnCleanup(String string) {
        this._commitOrRollbackOnCleanup = -1;
        if (string != null) {
            if (string.equalsIgnoreCase("commit")) {
                this._commitOrRollbackOnCleanup = 0;
            } else if (string.equalsIgnoreCase("rollback")) {
                this._commitOrRollbackOnCleanup = 1;
            } else {
                Tr.info(tc, "INVALID_CLEANUP_OPERATION_SPECIFIED", new Object[]{this.dataSource.getDataSourceName(), "commitOrRollbackOnCleanup", string, "commit, rollback"});
            }
        }
    }

    public int getCommitOrRollbackOnCleanup() {
        return this._commitOrRollbackOnCleanup;
    }

    public boolean ispropagateClientIdentityUsingTrustedContextEnabled() {
        return this.propagateClientIdentityUsingTrustedContext;
    }

    private Set getPrincipalUtility(final Subject subject) throws ResourceException {
        Set set = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrincipalUtility");
        }
        if (System.getSecurityManager() != null) {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return subject.getPrincipals(class$com$ibm$websphere$security$auth$IdentityPrincipal == null ? (class$com$ibm$websphere$security$auth$IdentityPrincipal = WSManagedConnectionFactoryImpl.class$("com.ibm.websphere.security.auth.IdentityPrincipal")) : class$com$ibm$websphere$security$auth$IdentityPrincipal);
                }
            };
            try {
                set = (Set)AccessController.doPrivileged(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl.getPrincipalUtility", "2717", this);
                Exception exception = privilegedActionException.getException();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPrincipalUtility with exception", exception);
                }
                throw (ResourceException)((Object)exception);
            }
        } else {
            set = subject.getPrincipals(IdentityPrincipal.class);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrincipalUtility", set);
        }
        return set;
    }

    private WSConnectionRequestInfoImpl populateCRIWithPrincipalIdentity(Set set, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateCRIWithPrincipalIdentity", new Object[]{set, AdapterUtil.toString(wSConnectionRequestInfoImpl)});
        }
        if (set == null || set.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "populateCRIWithPrincipalIdentity returning same cri, no change as principal is null");
            }
            return wSConnectionRequestInfoImpl;
        }
        final Iterator iterator = set.iterator();
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return iterator.next();
            }
        };
        IdentityPrincipal identityPrincipal = null;
        while (iterator.hasNext()) {
            if (System.getSecurityManager() != null) {
                try {
                    identityPrincipal = (IdentityPrincipal)AccessController.doPrivileged(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "populateCRIWithPrincipalIdentity", "Exception");
                    }
                    String string = "Error Iterating through Principal Object Sets.";
                    DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{string, privilegedActionException.getException()}, privilegedActionException.getException(), currClass);
                    FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), "com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl.populateCRIWithPrincipalIdentity", "2775", this, new Object[]{string, " Possible components: Security"});
                    throw dataStoreAdapterException;
                }
            } else {
                identityPrincipal = (IdentityPrincipal)iterator.next();
            }
            if (identityPrincipal == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "idPrincipal is not null: ", identityPrincipal);
            }
            try {
                wSConnectionRequestInfoImpl.setTrustedContextOriginalUser(identityPrincipal.getOriginalUser());
                wSConnectionRequestInfoImpl.setTrustedContextUserName(identityPrincipal.getName());
                wSConnectionRequestInfoImpl.setTrustedContextUserSecToken(identityPrincipal.getToken());
                wSConnectionRequestInfoImpl.setTrustedContextRealm(identityPrincipal.getRealm());
                break;
            }
            catch (SQLException sQLException) {
                throw new DataStoreAdapterException("DSA_ERROR", sQLException, this.getClass());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateCRIWithPrincipalIdentity ", AdapterUtil.toString(wSConnectionRequestInfoImpl));
        }
        return wSConnectionRequestInfoImpl;
    }

    public ConnectionRequestInfo finalizeCriForRRA(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finalizeCriForRRA (sub, cri, propagateClientIdentityUsingTrustedContext", new Object[]{subject == null ? null : "non-null subject", connectionRequestInfo, new Boolean(this.propagateClientIdentityUsingTrustedContext)});
        }
        if (this.propagateClientIdentityUsingTrustedContext && subject != null) {
            WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = (WSConnectionRequestInfoImpl)connectionRequestInfo;
            connectionRequestInfo = this.populateCRIWithPrincipalIdentity(this.getPrincipalUtility(subject), wSConnectionRequestInfoImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finalizeCriForRRA", connectionRequestInfo);
        }
        return connectionRequestInfo;
    }

    void setDBDSProperties(Properties properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting Database DataSource properties excluding non-DS props on mcf (props, mcf):", new Object[]{properties, this});
        }
        this.dbDSProperties = properties;
    }

    public Properties getDBDSProperties() {
        return this.dbDSProperties;
    }

    public String getProperty(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty");
        }
        if (!this.dataSourceProperties.containsKey(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getProperty:The custom property " + string + " is not valid.");
            }
            throw new IllegalArgumentException("The custom property " + string + " is not valid.");
        }
        Object object = this.dataSourceProperties.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty");
        }
        return object != null ? object.toString() : null;
    }

    public final Class getDataSourceClassName() {
        return this.dataSource.dataSourceImplClassClass;
    }

    public boolean getOptimizedForGetUseClose() {
        return this.optimizedForGetUseClose;
    }

    static {
        try {
            locationRestrictedFunction = (LocationRestrictedFunction)((Constructor)com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    return classLoader.loadClass("com.ibm.ws.rsadapter.spi.RestrictedServerFunction").getConstructor(null);
                }
            })).newInstance(null);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof ClassNotFoundException) {
                locationRestrictedFunction = new RestrictedClientFunction();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ManagedConnectionFactory is being initialized on the client. Server class was not found:", throwable.getMessage());
                }
            }
            FFDCFilter.processException(throwable, currClass.getName() + ".<cinit>", "295");
            throw new ExceptionInInitializerError(throwable);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            locationRestrictedFunction = new RestrictedClientFunction();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ManagedConnectionFactory is being initialized on the client. Server class was not found:", noClassDefFoundError.getMessage());
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            FFDCFilter.processException(throwable, currClass.getName() + ".<cinit>", "314");
            throw new ExceptionInInitializerError(throwable);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, currClass.getName() + ".<cinit>", "320");
            throw new ExceptionInInitializerError(exception);
        }
    }

    class Equals
    implements PrivilegedAction {
        Subject _s1;
        Subject _s2;

        Equals() {
        }

        public final void setSubjects(Subject subject, Subject subject2) {
            this._s1 = subject;
            this._s2 = subject2;
        }

        public Object run() {
            Object object;
            String string = null;
            String string2 = null;
            if (WSManagedConnectionFactoryImpl.this.perfEnhancementEnabledNotSet) {
                object = "com.ibm.websphere.security.auth.j2c.cacheReadOnlyAuthDataSubjects";
                WSManagedConnectionFactoryImpl.this.perfEnhancementEnabled = new Boolean(System.getProperty((String)object));
                WSManagedConnectionFactoryImpl.this.perfEnhancementEnabledNotSet = false;
            }
            if (WSManagedConnectionFactoryImpl.this.useRRASetEqualsNotSet) {
                WSManagedConnectionFactoryImpl.this.useRRASetEquals = Boolean.parseBoolean(WSManagedConnectionFactoryImpl.this.getDataSourceProperties().getProperty("useRRASetEquals"));
                WSManagedConnectionFactoryImpl.this.useRRASetEqualsNotSet = false;
            }
            if (WSManagedConnectionFactoryImpl.this.perfEnhancementEnabled) {
                object = null;
                Iterator iterator = this._s1.getPublicCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSManagedConnectionFactoryImpl.class$("java.util.Hashtable")) : class$java$util$Hashtable).iterator();
                if (iterator != null && iterator.hasNext()) {
                    object = (Hashtable)iterator.next();
                }
                if (object != null) {
                    string = (String)((Hashtable)object).get("com.ibm.wsspi.security.cred.cacheKey");
                    iterator = this._s2.getPublicCredentials(class$java$util$Hashtable == null ? (class$java$util$Hashtable = WSManagedConnectionFactoryImpl.class$("java.util.Hashtable")) : class$java$util$Hashtable).iterator();
                    if (iterator != null && iterator.hasNext()) {
                        object = (Hashtable)iterator.next();
                    }
                    if (object != null) {
                        string2 = (String)((Hashtable)object).get("com.ibm.wsspi.security.cred.cacheKey");
                    }
                }
                if (string != null && string2 != null) {
                    return string.equals(string2);
                }
            }
            if (string == null || string2 == null) {
                boolean bl = false;
                if (WSManagedConnectionFactoryImpl.this.useRRASetEquals) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "PK69110 - Using adapter set equals");
                    }
                    if (this.checkCredentials(this._s1.getPrivateCredentials(), this._s2.getPrivateCredentials())) {
                        bl = this.checkCredentials(this._s1.getPublicCredentials(), this._s2.getPublicCredentials());
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using JDK set equals");
                    }
                    if (this.checkPrivateCredentials(this._s2.getPrivateCredentials())) {
                        bl = this.checkPublicCredentials(this._s2.getPublicCredentials());
                    }
                }
                return new Boolean(bl);
            }
            return new Boolean(false);
        }

        private boolean checkPublicCredentials(Set set) {
            boolean bl = false;
            if (this._s1.getPublicCredentials() != set) {
                if (this._s1.getPublicCredentials() != null && set != null) {
                    bl = ((Object)this._s1.getPublicCredentials()).equals(set);
                }
            } else {
                bl = true;
            }
            return bl;
        }

        private boolean checkPrivateCredentials(Set set) {
            boolean bl = false;
            if (this._s1.getPrivateCredentials() != set) {
                if (this._s1.getPrivateCredentials() != null && set != null) {
                    bl = ((Object)this._s1.getPrivateCredentials()).equals(set);
                }
            } else {
                bl = true;
            }
            return bl;
        }

        private boolean checkCredentials(Set set, Set set2) {
            boolean bl = false;
            if (set != set2) {
                if (set != null && set2 != null) {
                    int n;
                    int n2 = set.size();
                    if (n2 == (n = set2.size())) {
                        if (n2 == 0) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Processing credential sets, both are empty, They are equal");
                            }
                            return true;
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing credential sets, sets do not contain the same number of elements. They are not equal");
                        }
                        return false;
                    }
                    if (n2 > 1) {
                        Iterator iterator = set.iterator();
                        int n3 = 0;
                        block0: while (iterator.hasNext()) {
                            Object e2 = iterator.next();
                            Iterator iterator2 = set2.iterator();
                            while (iterator2.hasNext()) {
                                Object e3 = iterator2.next();
                                if (e2 != null ? !e2.equals(e3) : e3 != null) continue;
                                ++n3;
                                continue block0;
                            }
                        }
                        if (n3 == n2) {
                            bl = true;
                        }
                    } else {
                        Iterator iterator = set.iterator();
                        Iterator iterator3 = set2.iterator();
                        Object e4 = iterator.next();
                        Object e5 = iterator3.next();
                        if (e4 != null) {
                            if (!e4.equals(e5)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "PK69110 - Objects are not equal");
                                }
                                return false;
                            }
                        } else if (e5 != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "PK69110 - Objects are not equal, one objest is null");
                            }
                            return false;
                        }
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            return bl;
        }
    }
}

