/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceElement;
import com.ibm.websphere.product.VersionInfo;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.DynamicDSConfigManager;
import com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDerbyDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDerbyNetworkServerDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalInformixDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalMicrosoftSQLServerDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalOracle10gDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalOracle11gDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalSequeLinkDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper;
import com.ibm.ws.rsadapter.spi.ParameterList;
import com.ibm.ws.rsadapter.spi.WSAtomicInteger;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.security.util.AccessController;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class WSRdbDataSource
implements Serializable,
FFDCSelfIntrospectable,
Observer {
    private static final long serialVersionUID = -7106919037814463614L;
    private static final int MILLISECOND_FACTOR = 1000;
    private static boolean warnedAboutPK54589Incompatibility;
    private Properties dataSourceProperties;
    private transient Object[] dataSources;
    transient Object cmxDataSourceProxy;
    WSManagedConnectionFactoryImpl mcf;
    private boolean jtaEnabled;
    private boolean wasUsedToGetAConnection;
    protected String currentSQLID;
    transient DataStoreHelper dataStoreHelper;
    private String dataSourceImplClass;
    transient Class dataSourceImplClassClass;
    private String dataSourceName;
    private String productName;
    private String driverType;
    transient DynamicDSConfigManager dcm;
    private transient int numConfigIDs;
    private transient String clientAccountingInformation;
    private transient String clientWorkstation;
    private transient String clientUser;
    private transient String clientApplicationInformation;
    private static final Class currClass;
    private static final TraceComponent tc;
    private static final HashMap helperMap;

    public WSRdbDataSource(Properties properties, WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) throws ResourceException {
        TraceComponent traceComponent;
        int n;
        Properties properties2;
        boolean bl;
        block84: {
            Serializable serializable;
            String string;
            boolean bl2;
            String string2;
            Object object;
            String string3;
            String string4;
            String string5;
            Properties properties3;
            block83: {
                String string6;
                Object object2;
                String string7;
                this.dataSourceProperties = null;
                this.dataSources = new Object[1];
                this.currentSQLID = null;
                this.dataStoreHelper = null;
                this.dataSourceName = null;
                this.driverType = null;
                this.clientAccountingInformation = null;
                this.clientWorkstation = null;
                this.clientUser = null;
                this.clientApplicationInformation = null;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "<init>");
                }
                bl = tc.isDebugEnabled();
                this.mcf = wSManagedConnectionFactoryImpl;
                this.dataSourceProperties = properties;
                properties2 = (Properties)properties.clone();
                properties3 = new Properties();
                this.dataSourceImplClass = (String)properties2.remove("dataSourceClass");
                if (this.dataSourceImplClass == null) {
                    throw new DataStoreAdapterException("DSIMPLCLASS_NULL", "DataSource implementation class is null.  Could not create DataSource", currClass);
                }
                String string8 = (String)properties2.remove("informixLockModeWait");
                if (string8 != null) {
                    properties3.setProperty("informixLockModeWait", string8);
                }
                if ((string7 = (String)properties2.remove("informixAllowNewLine")) != null) {
                    properties3.setProperty("informixAllowNewLine", string7);
                }
                if ((string5 = (String)properties2.remove("databaseType")) != null) {
                    properties3.setProperty("databaseType", string5);
                    wSManagedConnectionFactoryImpl.setDatabaseType(string5);
                }
                wSManagedConnectionFactoryImpl.disableBackendIdchecking = (object2 = properties2.remove("disableBackendIdChecking")) != null && new Boolean((String)object2) != false;
                object2 = properties2.remove("enableEndToEndMonitoringFeature");
                boolean bl3 = wSManagedConnectionFactoryImpl.enableEndToEndMonitoringFeature = object2 != null && new Boolean((String)object2) != false;
                if (bl) {
                    Tr.debug(tc, "disableBackendIdchecking is: ", new Boolean(wSManagedConnectionFactoryImpl.disableBackendIdchecking));
                    Tr.debug(tc, "enableEndToEndMonitoringFeature is: ", new Boolean(wSManagedConnectionFactoryImpl.enableEndToEndMonitoringFeature));
                }
                string4 = (String)properties2.remove("dataStoreHelperClass");
                string3 = (String)properties2.remove("statementCacheSize");
                object = properties2.remove("enableMultithreadedAccessDetection");
                wSManagedConnectionFactoryImpl.detectMultithreadedAccess = object != null && new Boolean((String)object) != false;
                object = properties2.remove("enableSQLJ");
                String string9 = (String)properties2.remove("oracleLogFileSizeLimit");
                if (string9 != null) {
                    properties3.setProperty("oracleLogFileSizeLimit", string9);
                }
                if ((string9 = (String)properties2.remove("oracleLogFileCount")) != null) {
                    properties3.setProperty("oracleLogFileCount", string9);
                }
                if ((string9 = (String)properties2.remove("oracleLogFileName")) != null) {
                    properties3.setProperty("oracleLogFileName", string9);
                }
                if ((string9 = (String)properties2.remove("oracleLogTraceLevel")) != null) {
                    properties3.setProperty("oracleLogTraceLevel", string9);
                }
                if ((string9 = (String)properties2.remove("oracle9iLogTraceLevel")) != null) {
                    properties3.setProperty("oracle9iLogTraceLevel", string9);
                }
                if ((string9 = (String)properties2.remove("oracleLogPackageName")) != null) {
                    properties3.setProperty("oracleLogPackageName", string9);
                }
                if ((string9 = (String)properties2.remove("oracleLogFormat")) != null) {
                    properties3.setProperty("oracleLogFormat", string9);
                }
                wSManagedConnectionFactoryImpl.disableWASConnectionPooling = (object = properties2.remove("disableWASConnectionPooling")) != null && new Boolean((String)object) != false;
                string9 = (String)properties2.remove("webSphereDefaultIsolationLevel");
                if (string9 != null) {
                    properties3.setProperty("webSphereDefaultIsolationLevel", string9);
                }
                boolean bl4 = wSManagedConnectionFactoryImpl.optimizedForGetUseClose = (string9 = (String)properties2.remove("optimizeDB2ForGetUseClose")) != null && new Boolean(string9) != false;
                if (bl) {
                    Tr.debug(tc, "optimizeDB2ForGetUseClose is set to:", new Boolean(wSManagedConnectionFactoryImpl.optimizedForGetUseClose));
                }
                if ((string9 = properties2.getProperty("traceLevel")) != null) {
                    properties3.setProperty("traceLevel", string9);
                }
                boolean bl5 = wSManagedConnectionFactoryImpl.transactionBranchesLooselyCoupled = (object = properties2.remove("transactionBranchesLooselyCoupled")) != null && new Boolean((String)object) != false;
                if (wSManagedConnectionFactoryImpl.transactionBranchesLooselyCoupled) {
                    Tr.warning(tc, "ORACLE_PATCH_WARNING");
                }
                wSManagedConnectionFactoryImpl.resetConnectionByBackendDatabase = (object = properties2.remove("resetConnectionByBackendDatabase")) != null && new Boolean((String)object) != false;
                object = properties2.remove("nondeferredreaper");
                object = properties2.remove("commitOrRollbackOnCleanup");
                wSManagedConnectionFactoryImpl.setCommitOrRollbackOnCleanup((String)object);
                if (bl) {
                    Tr.debug(tc, "commitOrRollbackOnCleanup DS custom property specified :" + object + "   mcf value:" + wSManagedConnectionFactoryImpl.getCommitOrRollbackOnCleanup());
                }
                if ((string6 = properties2.getProperty("traceFile")) != null) {
                    properties3.setProperty("traceFile", string6);
                }
                wSManagedConnectionFactoryImpl.preTestSQLString = (String)properties2.remove("preTestSQLString");
                object = properties2.remove("validateAfterConnectionError");
                wSManagedConnectionFactoryImpl.validateAfterConnectionError = object == null || new Boolean((String)object) != false;
                object = properties2.remove("jmsOnePhaseOptimization");
                if (object != null) {
                    wSManagedConnectionFactoryImpl.jmsOnePhaseOptimization = new Boolean((String)object);
                }
                if (bl) {
                    Tr.debug(tc, "The sharedDataSourceWithCMP DS custom property value is:", new Boolean(wSManagedConnectionFactoryImpl.jmsOnePhaseOptimization));
                }
                string2 = null;
                bl2 = false;
                try {
                    object = properties2.getProperty("connectionCachingEnabled");
                    if (object != null) {
                        wSManagedConnectionFactoryImpl.useDataSource = new Boolean((String)object);
                    }
                    if (tc.isDebugEnabled() && wSManagedConnectionFactoryImpl.useDataSource) {
                        Tr.debug(tc, "OracleConnectionCache is being used.  Using datasource");
                    }
                    if ((object = properties2.remove("removeExistingOracleConnectionPoolIfExists")) != null) {
                        bl2 = new Boolean((String)object);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the value of removeOraCacheifNewSpecifed is", new Boolean(bl2));
                        }
                    }
                    string2 = properties2.getProperty("connectionCacheName");
                }
                catch (Throwable throwable) {
                    if (!bl) break block83;
                    Tr.debug(tc, "something went wrong while trying to enable Oracle pooling", throwable);
                }
            }
            String string10 = (String)properties2.remove("reauthentication");
            if (string10 != null) {
                wSManagedConnectionFactoryImpl.reauthEnabled = new Boolean(string10);
                properties3.setProperty("reauthentication", string10);
            }
            if (bl) {
                Tr.debug(tc, "The Reauthentication DS custom property value is:", new Boolean(wSManagedConnectionFactoryImpl.reauthEnabled));
            }
            boolean bl6 = wSManagedConnectionFactoryImpl.propagateClientIdentityUsingTrustedContext = (object = properties2.remove("propagateClientIdentityUsingTrustedContext")) != null && new Boolean((String)object) != false;
            if (bl) {
                Tr.debug(tc, "The propagateClientIdentityUsingTrustedContext DS custom property value is:", new Boolean(wSManagedConnectionFactoryImpl.propagateClientIdentityUsingTrustedContext));
            }
            if (wSManagedConnectionFactoryImpl.propagateClientIdentityUsingTrustedContext && wSManagedConnectionFactoryImpl.reauthEnabled) {
                Tr.warning(tc, "IDENTITY_PROPAGATION_CONFLICT1_WARNING");
                wSManagedConnectionFactoryImpl.reauthEnabled = false;
            }
            this.removeFailoverProperties(properties2);
            String string11 = (String)properties2.remove("isolationLevelSwitchingSupport");
            if (string11 != null) {
                properties3.setProperty("isolationLevelSwitchingSupport", string11);
            }
            properties2.remove("CloudscapeOldDatabaseName");
            properties2.remove("CloudscapeOldClassPathName");
            object = properties2.remove("beginTranForResultSetScrollingAPIs");
            wSManagedConnectionFactoryImpl.beginTranForResultSetScrollingAPIs = Boolean.parseBoolean((String)object);
            object = properties2.remove("connectionSharing");
            if (object != null) {
                try {
                    wSManagedConnectionFactoryImpl.connectionSharing = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    Tr.warning(tc, "PROP_SET_ERROR", new Object[]{"connectionSharing", "", object});
                }
            }
            if (wSManagedConnectionFactoryImpl.connectionSharing != 0 && DSConfigurationHelper._disablePK54589) {
                wSManagedConnectionFactoryImpl.connectionSharing = 0;
                if (object != null && !warnedAboutPK54589Incompatibility) {
                    Tr.warning(tc, "PROP_SET_ERROR", new Object[]{"connectionSharing", "", "disablePK54589=true"});
                    warnedAboutPK54589Incompatibility = true;
                }
            }
            if ((string = properties2.getProperty("integratedSecurity")) != null && "true".equalsIgnoreCase(string)) {
                Tr.warning(tc, "CONFIG_WARN", "Windows authentication is enabled on the JDBC driver. If another user logs in, connections retrieved from the pool will have the wrong user. To avoid this problem, empty the connection pool whenever a different user logs in.");
            }
            String string12 = null;
            if (properties2.containsKey("currentSQLID")) {
                string12 = properties2.getProperty("currentSQLID");
            }
            if (string12 != null && string12.trim().length() > 0) {
                PropertyDescriptor[] propertyDescriptorArray = null;
                try {
                    try {
                        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws ClassNotFoundException {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        serializable = Class.forName(this.dataSourceImplClass, true, classLoader);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Tr.error(tc, "Error getting classloader: " + privilegedActionException);
                        throw (ClassNotFoundException)privilegedActionException.getException();
                    }
                    propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Class)serializable){
                        private final /* synthetic */ Class val$dsClass;
                        {
                            this.val$dsClass = clazz;
                        }

                        public Object run() throws Exception {
                            return Introspector.getBeanInfo(this.val$dsClass).getPropertyDescriptors();
                        }
                    });
                    boolean bl7 = false;
                    for (n = 0; n < propertyDescriptorArray.length; ++n) {
                        if (!propertyDescriptorArray[n].getName().equals("currentSQLID")) continue;
                        bl7 = true;
                        break;
                    }
                    if (!bl7) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting currentSQLID on DataSource to: " + string12);
                        }
                        this.currentSQLID = string12;
                        properties2.remove("currentSQLID");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentSQLID will be passed to physical DS");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, this.getClass().getName(), "420", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "<init> with exception: ", classNotFoundException);
                    }
                    throw AdapterUtil.createDataStoreAdapterException("DS_CLASS_NOT_FOUND", this.dataSourceImplClass, classNotFoundException, WSRdbDataSource.class);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "<init> with exception:", exception);
                    }
                    throw (ResourceException)((Object)exception);
                }
            }
            if (this.currentSQLID != null) {
                properties3.setProperty("currentSQLID", this.currentSQLID);
            }
            this.driverType = properties2.getProperty("driverType");
            if (this.driverType != null) {
                properties3.setProperty("driverType", this.driverType);
            }
            if (string4 == null) {
                string4 = DSConfigurationHelper.getDataStoreHelperClassName(this.dataSourceImplClass, this.driverType);
            }
            if (string4 == null) {
                string4 = DSConfigurationHelper.getDataStoreHelperClassName(this.dataSourceImplClass);
            }
            properties3.setProperty("dataSourceClass", this.dataSourceImplClass);
            this.dataStoreHelper = DSConfigurationHelper.createDataStoreHelper(string4, properties3);
            serializable = DSConfigurationHelper.parseErrorMap((String)properties2.remove("userDefinedErrorMap"));
            if (serializable != null) {
                this.dataStoreHelper.setUserDefinedMap((Map)((Object)serializable));
            }
            if (!AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper") && wSManagedConnectionFactoryImpl.optimizedForGetUseClose) {
                wSManagedConnectionFactoryImpl.optimizedForGetUseClose = false;
                Tr.warning(tc, "PROP_NOT_SUPPORTED", new Object[]{"optimizeDB2ForGetUseClose", "IBM DB2 universal driver"});
            }
            int n2 = this.dataStoreHelper.getMetaData().getHelperType();
            if (string3 != null) {
                wSManagedConnectionFactoryImpl.setStatementCacheSize(Integer.parseInt(string3));
            }
            wSManagedConnectionFactoryImpl.internalHelper = this.createInternalDataStoreHelper(string4);
            wSManagedConnectionFactoryImpl.internalHelper.setExternalHelper(this.dataStoreHelper);
            wSManagedConnectionFactoryImpl.internalHelper.setProperties(properties3);
            if (bl) {
                Tr.debug(tc, AdapterUtil.EOLN + "Database type:                          " + string5 + AdapterUtil.EOLN + "DataSource class:                       " + this.dataSourceImplClass + AdapterUtil.EOLN + "DataStoreHelper class:                  " + string4 + AdapterUtil.EOLN + "InternalDataStoreHelper class:          " + wSManagedConnectionFactoryImpl.internalHelper + AdapterUtil.EOLN + "Multithreaded access detection enabled? " + wSManagedConnectionFactoryImpl.detectMultithreadedAccess);
            }
            this.clientAccountingInformation = properties2.getProperty("clientAccountingInformation");
            this.clientWorkstation = properties2.getProperty("clientWorkstation");
            this.clientUser = properties2.getProperty("clientUser");
            this.clientApplicationInformation = properties2.getProperty("clientApplicationInformation");
            if (string2 != null && string2 != "") {
                try {
                    if (bl2 && wSManagedConnectionFactoryImpl.internalHelper.dBConnectionCacheExists(string2)) {
                        wSManagedConnectionFactoryImpl.internalHelper.removeDBConnectionCache(string2);
                    }
                }
                catch (Throwable throwable) {
                    if (!bl) break block84;
                    Tr.debug(tc, "exception when trying to checking for and removing DBConnectionCache.  Cache will not be removed", throwable);
                }
            }
        }
        properties2 = wSManagedConnectionFactoryImpl.internalHelper.validateConfiguration(properties2, this.dataSourceImplClass);
        wSManagedConnectionFactoryImpl.setDBDSProperties((Properties)properties2.clone());
        this.dataSources[0] = this.createNewDataSource(properties2);
        if (DSConfigurationHelper._runAsSystemForClientReroutePersistence) {
            wSManagedConnectionFactoryImpl.useRunAsSystemOnGetPooledConnection = true;
        }
        this.jtaEnabled = DSConfigurationHelper.is2PhaseEnabled(properties2, this.getDataSource(0));
        if (wSManagedConnectionFactoryImpl.isEndToEndMonitoringFeatureEnabled()) {
            try {
                this.cmxDataSourceProxy = wSManagedConnectionFactoryImpl.internalHelper.getCMXDataSourceProxy(this.getDataSource(0), this.jtaEnabled);
                if (bl) {
                    Tr.debug(tc, "Jndi Name :", wSManagedConnectionFactoryImpl.jndiName);
                    Tr.debug(tc, "MaxConnections allowed:  ", wSManagedConnectionFactoryImpl.initialMaxPoolSize);
                }
                if (this.cmxDataSourceProxy != null && wSManagedConnectionFactoryImpl.internalHelper.isMonitoringEnabled(this.cmxDataSourceProxy)) {
                    AdapterUtil.displayApplicationInfoAndPostCMXMsg(false, true, null, wSManagedConnectionFactoryImpl.appServerName, wSManagedConnectionFactoryImpl.internalHelper, 100, AdapterUtil.getcmxArgsObject(6, null, null, this, this.getServerVersion(), wSManagedConnectionFactoryImpl.jndiName, wSManagedConnectionFactoryImpl.initialMaxPoolSize), this.cmxDataSourceProxy);
                    try {
                        AdapterUtil.setupCMXNotification(this, this.cmxDataSourceProxy, wSManagedConnectionFactoryImpl.internalHelper);
                    }
                    catch (Throwable throwable) {
                        Tr.warning(tc, "CMX_REGISTRATION_PROBLEM", throwable);
                    }
                } else {
                    wSManagedConnectionFactoryImpl.collectDataAndPushDownToCMX = false;
                    if (bl) {
                        Tr.debug(tc, "Setting collectDataAndPushDownToCMX to false, but still attempting to push the CMX data for message 100", this);
                    }
                    AdapterUtil.displayApplicationInfoAndPostCMXMsg(false, true, null, wSManagedConnectionFactoryImpl.appServerName, wSManagedConnectionFactoryImpl.internalHelper, 100, AdapterUtil.getcmxArgsObject(6, null, null, this, this.getServerVersion(), wSManagedConnectionFactoryImpl.jndiName, wSManagedConnectionFactoryImpl.initialMaxPoolSize), this.cmxDataSourceProxy);
                    try {
                        AdapterUtil.setupCMXNotification(this, this.cmxDataSourceProxy, wSManagedConnectionFactoryImpl.internalHelper);
                    }
                    catch (Throwable throwable) {
                        Tr.debug(tc, "CMX_REGISTRATION_PROBLEM", throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    Tr.debug(tc, "got an exception while calling . Disabling the monitoring based on that.  Exception is:", throwable);
                }
                Tr.warning(tc, "CMX_MONITORING_CHECKING_PROBLEM", throwable);
                wSManagedConnectionFactoryImpl.enableEndToEndMonitoringFeature = false;
            }
        }
        if (this.jtaEnabled && wSManagedConnectionFactoryImpl.useDataSource) {
            wSManagedConnectionFactoryImpl.useDataSource = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can't use XA datasource and database connection caching. disabling caching");
            }
        }
        if ((traceComponent = wSManagedConnectionFactoryImpl.internalHelper.getTracer()) != null && traceComponent.isDebugEnabled()) {
            for (n = 0; n < this.dataSources.length; ++n) {
                this.dataSources[n] = this.getTraceableDataSource(this.dataSources[n]);
            }
        }
        if (this.jtaEnabled && wSManagedConnectionFactoryImpl.jmsOnePhaseOptimization) {
            throw new DataStoreAdapterException("INVALID_DS_CONFIGURATION", "INVALID_DS_CONFIGURATION", currClass);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    synchronized int configure(String string, Object[] objectArray, Class[] classArray, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configure", new Object[]{string, string.equals("setPassword") ? "******" : WSRdbDataSource.toString(objectArray), WSRdbDataSource.toString(classArray), new Integer(n)});
        }
        if (this.isFailoverEnabled()) {
            throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"DataSource.set*", "datasourceFailoverServers"}));
        }
        boolean bl = tc.isDebugEnabled();
        this.dcm = this.mcf.isEndToEndMonitoringFeatureEnabled() ? (this.dcm == null ? new DynamicDSConfigManager(this.getDataSource(0), this.mcf.internalHelper.getCMXDataSourceProxy(this.getDataSource(0), this.jtaEnabled)) : this.dcm) : (this.dcm == null ? new DynamicDSConfigManager(this.getDataSource(0)) : this.dcm);
        HashMap<String, ParameterList> hashMap = new HashMap<String, ParameterList>(this.dcm.getConfigMethods(n));
        hashMap.put(string, new ParameterList(classArray, objectArray));
        int n2 = this.dcm.getConfigID(hashMap);
        if (n2 < 0) {
            try {
                Object object;
                Properties properties;
                block25: {
                    properties = (Properties)this.dataSourceProperties.clone();
                    Object object2 = properties.get("removeExistingOracleConnectionPoolIfExists");
                    if (object2 != null) {
                        boolean bl2 = new Boolean((String)object2);
                        if (bl) {
                            Tr.debug(tc, "The value of removeOraCacheifNewSpecifed is", new Boolean(bl2));
                        }
                        if (bl2) {
                            object = (String)properties.remove("connectionCacheName");
                            if (object != null && !((String)object).equals("")) {
                                if (bl) {
                                    Tr.debug(tc, "The value of _oraConnectionCacheName is", object);
                                }
                                object = (String)object + (this.numConfigIDs + 1);
                                if (bl) {
                                    Tr.debug(tc, "The value for this connection cache name is", object);
                                }
                                properties.setProperty("connectionCacheName", (String)object);
                                try {
                                    if (this.mcf.internalHelper == null || !this.mcf.internalHelper.dBConnectionCacheExists((String)object)) break block25;
                                    try {
                                        this.mcf.internalHelper.removeDBConnectionCache((String)object);
                                        break block25;
                                    }
                                    catch (Throwable throwable) {
                                        Tr.warning(tc, "CAN_NOT_REMOVE_ORACLE_CONNECTION_CACHE_WARNING", new Object[]{object, throwable});
                                        if (bl) {
                                            Tr.debug(tc, "exception when trying to remove existing DB ConnectionCache.  Cache will not be removed", throwable);
                                        }
                                        break block25;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Tr.warning(tc, "CAN_NOT_CHECK_IF_ORA_CACHE_EXISTS_WARNING", new Object[]{object, throwable});
                                    if (bl) {
                                        Tr.debug(tc, "Exception trying to check if DBConnectionCache.  Cache will not be removed even if it exists", throwable);
                                    }
                                    break block25;
                                }
                            }
                            if (bl) {
                                Tr.debug(tc, "Oracle cache name is not set.");
                            }
                        }
                    } else if (bl) {
                        Tr.debug(tc, "Remove existing oracle cache if one exists is not set.");
                    }
                }
                Object object3 = this.createNewDataSource(properties);
                DynamicDSConfigManager.applyConfiguration(object3, hashMap);
                object = this.mcf.internalHelper.getTracer();
                if (object != null && ((TraceElement)object).isDebugEnabled()) {
                    object3 = this.getTraceableDataSource(object3);
                }
                n2 = ++this.numConfigIDs;
                if (this.mcf.isEndToEndMonitoringFeatureEnabled()) {
                    this.dcm.add(n2, hashMap, object3, this.mcf.internalHelper.getCMXDataSourceProxy(object3, this.jtaEnabled));
                } else {
                    this.dcm.add(n2, hashMap, object3);
                }
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, this.getClass().getName() + ".configure", "462", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "configure", (Object)resourceException);
                }
                throw AdapterUtil.toSQLException(resourceException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configure", new Integer(n2));
        }
        return n2;
    }

    private InternalDataStoreHelper createInternalDataStoreHelper(String string) throws ResourceException {
        Object object = helperMap.get(string);
        try {
            block36: {
                if (object == null) {
                    object = helperMap.get(this.dataSourceImplClass);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "searching on the dataSourceImplClass returned: ", object);
                    }
                    if (object == null) {
                        int n = this.dataStoreHelper.getMetaData().getHelperType();
                        switch (n) {
                            case 1: 
                            case 3: 
                            case 15: {
                                return new InternalDB2DataStoreHelper();
                            }
                            case 4: {
                                return new InternalDB2UniversalDataStoreHelper();
                            }
                            case 19: {
                                return new InternalDerbyDataStoreHelper();
                            }
                            case 11: 
                            case 12: {
                                return new InternalSybaseDataStoreHelper();
                            }
                            case 14: {
                                return new InternalInformixDataStoreHelper();
                            }
                            case 10: {
                                return new InternalMicrosoftSQLServerDataStoreHelper();
                            }
                            case 5: {
                                return new InternalGenericDataStoreHelper();
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                return new InternalDataDirectDataStoreHelper();
                            }
                            case 9: {
                                return new InternalSequeLinkDataStoreHelper();
                            }
                            case 13: {
                                return new InternalOracleDataStoreHelper();
                            }
                            case 17: {
                                return new InternalOracle10gDataStoreHelper();
                            }
                            case 22: {
                                return new InternalOracle11gDataStoreHelper();
                            }
                            case 18: {
                                return new InternalDerbyNetworkServerDataStoreHelper();
                            }
                            case -1: {
                                return this.getInternalHelperBasedOnInstance();
                            }
                            case 2: {
                                if (AdapterUtil.isAssignableFromNamed("com.ibm.as400.access.AS400JDBCDataSource", this.dataSourceImplClass)) {
                                    return new InternalDB2AS400ToolboxDataStoreHelper();
                                }
                                if (AdapterUtil.isAssignableFromNamed("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", this.dataSourceImplClass)) {
                                    return new InternalDB2AS400NativeDataStoreHelper();
                                }
                                if (AdapterUtil.isAssignableFromNamed("com.ibm.db2.jdbc.app.UDBXADataSource", this.dataSourceImplClass)) {
                                    return new InternalDB2AS400NativeDataStoreHelper();
                                }
                                if (!AdapterUtil.isAssignableFromNamed("com.ibm.db2.jdbc.app.DB2GenericDataSource", this.dataSourceImplClass)) break;
                                return new InternalDB2AS400NativeDataStoreHelper();
                            }
                        }
                        return new InternalGenericDataStoreHelper();
                    }
                }
                if (object.equals("com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper")) {
                    try {
                        Class<?> clazz = null;
                        try {
                            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public Object run() throws ClassNotFoundException {
                                    return Thread.currentThread().getContextClassLoader();
                                }
                            });
                            clazz = Class.forName("com.ibm.db2.jcc.SQLJContext", false, classLoader);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Tr.error(tc, "Error getting classloader: " + privilegedActionException);
                        }
                        object = "com.ibm.ws.rsadapter.spi.InternalDB2V8SQLJDataStoreHelper";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SQLJContext is implemented by DB2, change to InternalDB2V8SQLJDataStoreHelper  ", object);
                        }
                        clazz = null;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            Class<?> clazz = null;
                            try {
                                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                    public Object run() throws ClassNotFoundException {
                                        return Thread.currentThread().getContextClassLoader();
                                    }
                                });
                                clazz = Class.forName("com.ibm.db2.jcc.SQLJConnection", false, classLoader);
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                Tr.error(tc, "Error getting classloader: " + privilegedActionException);
                            }
                            object = "com.ibm.ws.rsadapter.spi.InternalDB2V8DataStoreHelper";
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "SQLJConnection is implemented by DB2, change to InternalDB2V8DataStoreHelper  ", object);
                            }
                            clazz = null;
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            if (!tc.isDebugEnabled()) break block36;
                            Tr.debug(tc, "SQLJConnection or SQLJContext is not implemented by DB2");
                        }
                    }
                }
            }
            return (InternalDataStoreHelper)DSConfigurationHelper.loadClass((String)object).newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".createInternalDataStoreHelper", "276", this);
            throw AdapterUtil.createDataStoreAdapterException("DSA_INTERNAL_ERROR", new Object[]{"Unable to locate Internal Data Store Helper for " + string, ".  Exception is: ", exception}, exception, this.getClass());
        }
    }

    final Object getDataSource(int n) {
        return this.dataSources.length == 1 ? this.dataSources[0] : this.dataSources[Math.abs(n % this.dataSources.length)];
    }

    private final InternalDataStoreHelper getInternalHelperBasedOnInstance() throws Exception {
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DB2390LocalDataStoreHelper")) {
            return new InternalDB2DataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper")) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.MicrosoftSQLServerDataStoreHelper")) {
            return new InternalMicrosoftSQLServerDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper")) {
            return new InternalDB2UniversalDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DB2390DataStoreHelper")) {
            return new InternalDB2DataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper")) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper")) {
            return new InternalDerbyNetworkServerDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.SequeLinkDataStoreHelper")) {
            return new InternalSequeLinkDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DB2DataStoreHelper")) {
            return new InternalDB2DataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.Oracle11gDataStoreHelper")) {
            return new InternalOracle11gDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper")) {
            return new InternalOracle10gDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.OracleDataStoreHelper")) {
            return new InternalOracleDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DataDirectDataStoreHelper")) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.InformixDataStoreHelper")) {
            return new InternalInformixDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.Sybase11DataStoreHelper")) {
            return new InternalSybaseDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.SybaseDataStoreHelper")) {
            return new InternalSybaseDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper")) {
            return new InternalDerbyNetworkServerDataStoreHelper();
        }
        if (AdapterUtil.isInstance(this.dataStoreHelper, "com.ibm.websphere.rsadapter.DerbyDataStoreHelper")) {
            return new InternalDerbyDataStoreHelper();
        }
        return new InternalGenericDataStoreHelper();
    }

    final Connection getConnectionUsingDS(String string, String string2, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, int n) throws ResourceException {
        Object object;
        Object object2 = object = wSConnectionRequestInfoImpl.ivConfigID == 0 ? this.getDataSource(n) : this.dcm.getDataSource(wSConnectionRequestInfoImpl.ivConfigID);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionUsingDS", new Object[]{AdapterUtil.toString(object), string, "******", new Integer(n)});
        }
        final String string3 = string == null ? null : string.trim();
        final String string4 = string2 == null ? null : string2.trim();
        Connection connection = null;
        try {
            connection = (Connection)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return string3 == null ? ((DataSource)object).getConnection() : ((DataSource)object).getConnection(string3, string4);
                }
            });
            try {
                this.postGetConnectionHandling(connection);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbDataSource.getConnectionUsingDS", "1282", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnectionUsingDS - throwing exception");
                }
                throw AdapterUtil.translateSQLException(sQLException, this.mcf, false, currClass);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionUsingDS", AdapterUtil.toString(connection));
            }
            return connection;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.rsadapter.spi.WSRdbDataSource.getConnectionUsingDS", "1372");
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", "Connection", privilegedActionException.getException(), WSRdbDataSource.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionUsingDS", "Exception");
            }
            throw dataStoreAdapterException;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, "com.ibm.ws.rsadapter.spi.WSRdbDataSource.getConnectionUsingDS", "1312");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught ClassCastException", classCastException);
            }
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("NOT_A_1_PHASE_DS", classCastException.getMessage(), null, InternalGenericDataStoreHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionUsingDS", "Exception");
            }
            throw dataStoreAdapterException;
        }
    }

    public final Object[] getPooledConnection(String string, String string2, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, int n) throws ResourceException {
        try {
            return this.mcf.internalHelper.getPooledConnection(this, string, string2, this.jtaEnabled, wSConnectionRequestInfoImpl, null, n);
        }
        catch (DataStoreAdapterException dataStoreAdapterException) {
            throw (DataStoreAdapterException)((Object)AdapterUtil.mapException((Exception)((Object)dataStoreAdapterException), null, this.mcf, false));
        }
    }

    private Object getTraceableDataSource(Object object) throws ResourceException {
        Class clazz = this.jtaEnabled ? XADataSource.class : ConnectionPoolDataSource.class;
        Class clazz2 = clazz;
        WSJdbcTracer wSJdbcTracer = new WSJdbcTracer(this.mcf.internalHelper.getTracer(), this.mcf.internalHelper.getPrintWriter(), object, clazz2, true);
        return Proxy.newProxyInstance(clazz2.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)wSJdbcTracer);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{this, object});
        }
        try {
            WSRdbDataSource wSRdbDataSource = (WSRdbDataSource)object;
            bl = this.numConfigIDs + wSRdbDataSource.numConfigIDs == 0 || this.numConfigIDs == wSRdbDataSource.numConfigIDs && AdapterUtil.match(this.dcm, wSRdbDataSource.dcm);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    boolean equals(WSRdbDataSource wSRdbDataSource, int n, int n2) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{"Configuration #" + n + " of " + this, "Configuration #" + n2 + " of " + wSRdbDataSource});
        }
        boolean bl2 = bl = this.dcm == null && wSRdbDataSource.dcm == null || AdapterUtil.match(this.dcm.getConfigMethods(n), wSRdbDataSource.dcm.getConfigMethods(n2));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    public Connection getConnection(PooledConnection pooledConnection, byte[] byArray, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnection (pcon, cookie, cri)", new Object[]{AdapterUtil.toString(pooledConnection), "cookie", wSConnectionRequestInfoImpl});
        }
        try {
            Connection connection = null;
            if (this.mcf.propagateClientIdentityUsingTrustedContext && wSConnectionRequestInfoImpl.trustedContextIdentityAttributesAreSet) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trusted  context attributes are set.  Getting a trusted connection from :", pooledConnection);
                }
                connection = this.mcf.internalHelper.getTrustedConnection(pooledConnection, wSConnectionRequestInfoImpl.tc_originalUser, wSConnectionRequestInfoImpl.tc_name, wSConnectionRequestInfoImpl.tc_realm, wSConnectionRequestInfoImpl.tc_userSecToken, byArray);
            } else {
                connection = wSConnectionRequestInfoImpl.useHetrogeneous ? this.mcf.internalHelper.getHetrogenousConnection(pooledConnection, wSConnectionRequestInfoImpl.extentionDSProps) : pooledConnection.getConnection();
            }
            this.postGetConnectionHandling(connection);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnection", AdapterUtil.toString(connection));
            }
            return connection;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbDataSource.getConnection", "260", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnection - throwing exception");
            }
            throw AdapterUtil.translateSQLException(sQLException, this.mcf, false, currClass);
        }
    }

    private void postGetConnectionHandling(Connection connection) throws SQLException, ResourceException {
        this.dataStoreHelper.doConnectionSetup(connection);
        if (!this.wasUsedToGetAConnection) {
            this.wasUsedToGetAConnection = true;
            this.mcf.internalHelper.gatherAndDisplayMetaDataInfo(connection, this);
            if (this.driverType != null) {
                Tr.info(tc, "JDBC_DRIVER_TYPE", this.driverType);
            }
        }
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        try {
            Object object = this.getDataSource(0);
            if (this.mcf.useDataSource) {
                return ((DataSource)object).getLogWriter();
            }
            if (this.jtaEnabled) {
                return ((XADataSource)object).getLogWriter();
            }
            return ((ConnectionPoolDataSource)object).getLogWriter();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbDataSource.getLogWriter", "293", this);
            throw AdapterUtil.translateSQLException(sQLException, this.mcf, false, currClass);
        }
    }

    public PrintWriter getLogWriter(int n) throws SQLException {
        Object object = n == 0 ? this.getDataSource(0) : this.dcm.getDataSource(n);
        try {
            if (this.mcf.useDataSource) {
                return ((DataSource)object).getLogWriter();
            }
            return this.jtaEnabled ? ((XADataSource)object).getLogWriter() : ((ConnectionPoolDataSource)object).getLogWriter();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getLogWriter", "621", this);
            throw AdapterUtil.mapSQLException(sQLException, this.mcf);
        }
    }

    public int getLoginTimeout(int n) throws SQLException {
        Object object = n == 0 ? this.getDataSource(0) : this.dcm.getDataSource(n);
        try {
            if (this.mcf.useDataSource) {
                return ((DataSource)object).getLoginTimeout();
            }
            return this.jtaEnabled ? ((XADataSource)object).getLoginTimeout() : ((ConnectionPoolDataSource)object).getLoginTimeout();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".getLoginTimeout", "665", this);
            throw AdapterUtil.mapSQLException(sQLException, this.mcf);
        }
    }

    public final Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("DataSource Implementation Class Name:", this.dataSourceImplClass);
        fFDCLogger.append("DataSource Name:", this.dataSourceName);
        fFDCLogger.append("DataStoreHelper:", this.dataStoreHelper);
        fFDCLogger.append("DataSource properties:", AdapterUtil.hidePassword(this.dataSourceProperties));
        fFDCLogger.append(this.jtaEnabled ? "TWO PHASE ENABLED" : "ONE PHASE ENABLED");
        fFDCLogger.append("Underlying DataSource Object: " + AdapterUtil.toString(this.getDataSource(0)), this.getDataSource(0));
        fFDCLogger.append("Counter of unique, modified DataSource configurations: " + this.numConfigIDs);
        fFDCLogger.append("Failover servers list: ", this.dataSources);
        fFDCLogger.introspect("DynamicDSConfigManager", this.dcm);
        return fFDCLogger.toStringArray();
    }

    final boolean isFailoverEnabled() {
        return this.dataSources.length > 1;
    }

    private void parseFailoverServerInfo(Object object, Properties properties, String string) {
        boolean bl = TraceComponent.isAnyTracingEnabled();
        if (bl && tc.isEntryEnabled()) {
            Tr.entry(tc, "parseFailoverServerInfo", string);
        }
        try {
            String[] stringArray = string.split(";");
            Object[] objectArray = new Object[1 + stringArray.length];
            int n = 0;
            objectArray[n] = object;
            while (n < stringArray.length) {
                String[] stringArray2 = stringArray[n++].split(",");
                for (int i = 0; i < stringArray2.length; ++i) {
                    String[] stringArray3 = stringArray2[i].split("=");
                    String string2 = stringArray3[0];
                    String string3 = stringArray3[1];
                    properties.setProperty(string2, string3);
                    if (!bl || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "failover data source " + n + ": " + string2 + " = " + string3);
                }
                objectArray[n] = DSConfigurationHelper.createDataSource(this.dataSourceImplClass);
                DSConfigurationHelper.setDataSourceProperties(objectArray[n], (Properties)properties.clone());
            }
            this.dataSources = objectArray;
            this.mcf.datasourceFailoverAttempts = this.dataSources.length - 1;
            this.mcf.failoverCount = new WSAtomicInteger();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName() + ".parseFailoverServerInfo", "2507", this);
            Tr.warning(tc, "PROP_SET_ERROR", new Object[]{"datasourceFailoverServers=" + string, throwable.getClass().getName(), throwable.getMessage()});
        }
        if (bl && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseFailoverServerInfo", this.dataSources);
        }
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting the logWriter to:", printWriter);
        }
        try {
            for (int i = 0; i < this.dataSources.length; ++i) {
                if (this.mcf.useDataSource) {
                    ((DataSource)this.dataSources[i]).setLogWriter(printWriter);
                    continue;
                }
                if (this.jtaEnabled) {
                    ((XADataSource)this.dataSources[i]).setLogWriter(printWriter);
                    continue;
                }
                ((ConnectionPoolDataSource)this.dataSources[i]).setLogWriter(printWriter);
            }
            this.mcf.logWriter = printWriter;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbDataSource.setLogWriter", "367", this);
            throw AdapterUtil.translateSQLException(sQLException, this.mcf, false, currClass);
        }
    }

    public final boolean isJTAEnabled() {
        return this.jtaEnabled;
    }

    public Object[] call(String string, Object[] objectArray, Class[] classArray, int n) throws SQLException {
        return this.call(string, objectArray, classArray, n, null);
    }

    public Object[] call(String string, Object[] objectArray, Class[] classArray, int n, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "call", new Object[]{string, string.equals("setPassword") ? "******" : WSRdbDataSource.toString(objectArray), WSRdbDataSource.toString(classArray), new Integer(n), string2});
        }
        if (this.isFailoverEnabled()) {
            throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"DataSource.*", "datasourceFailoverServers"}));
        }
        Object[] objectArray2 = new Object[2];
        if (string.startsWith("set") && objectArray != null && objectArray.length == 1 && classArray != null && classArray.length == 1) {
            objectArray2[1] = new Integer(this.configure(string, objectArray, classArray, n));
        } else {
            Object object = n == 0 ? this.getDataSource(0) : this.dcm.getDataSource(n);
            objectArray2[0] = WSJdbcUtil.call(object, string, objectArray, classArray, this.dataStoreHelper, string2);
            objectArray2[1] = new Integer(n);
        }
        if (tc.isEntryEnabled()) {
            Object[] objectArray3;
            if (string.equals("getPassword")) {
                Object[] objectArray4 = new Object[2];
                objectArray4[0] = "******";
                objectArray3 = objectArray4;
                objectArray4[1] = objectArray2[1];
            } else {
                objectArray3 = objectArray2;
            }
            Tr.exit(tc, "call", objectArray3);
        }
        return objectArray2;
    }

    public final String getDataSourceName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "datasource name is: ", this.dataSourceName);
        }
        return this.dataSourceName;
    }

    private Object createNewDataSource(final Properties properties) throws ResourceException {
        Object object;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewDataSource", new Object[]{this.dataSourceImplClass, AdapterUtil.hidePassword(properties)});
        }
        Properties properties2 = (string = (String)properties.remove("datasourceFailoverServers")) == null ? null : (Properties)properties.clone();
        try {
            object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object = DSConfigurationHelper.createDataSource(WSRdbDataSource.this.dataSourceImplClass);
                    DSConfigurationHelper.setDataSourceProperties(object, properties);
                    return object;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.rsadapter.spi.WSRdbDataSource.WSRdbDataSource", "532", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createNewDataSource", privilegedActionException.getException());
            }
            throw (ResourceException)((Object)privilegedActionException.getException());
        }
        this.dataSourceImplClassClass = object.getClass();
        if (string != null && this.dataSources.length == 1 && (this.dataSourceImplClass.startsWith("oracle") || this.dataSourceImplClass.startsWith("com.ibm.websphere.jdbc.UT"))) {
            if (object instanceof XADataSource) {
                Tr.warning(tc, "METHOD_UNSUPPORTED", new Object[]{"datasourceFailoverServers", "XADataSource"});
            } else {
                this.parseFailoverServerInfo(object, properties2, string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewDataSource", object);
        }
        return object;
    }

    public WSManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.mcf;
    }

    Object setUserName(String string) {
        String string2 = "setUser";
        Method method2 = null;
        try {
            method2 = this.dataSourceImplClassClass.getMethod(string2, String.class);
            Object[] objectArray = new Object[]{string};
            for (int i = 0; i < this.dataSources.length; ++i) {
                try {
                    method2.invoke(WSJdbcTracer.getImpl(this.dataSources[i]), objectArray);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Tr.warning(tc, "PROP_SET_ERROR", new Object[]{this.dataSourceImplClassClass.getName(), "user", illegalAccessException});
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Tr.warning(tc, "PROP_SET_ERROR", new Object[]{this.dataSourceImplClassClass.getName(), "user", invocationTargetException});
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.warning(tc, "PROP_NOT_FOUND", new Object[]{this.dataSourceImplClassClass.getName(), "user"});
        }
        return this.dataSourceProperties.setProperty("user", string);
    }

    Object setPassword(String string) {
        String string2 = "setPassword";
        Method method2 = null;
        try {
            method2 = this.dataSourceImplClassClass.getMethod(string2, String.class);
            Object[] objectArray = new Object[]{string};
            for (int i = 0; i < this.dataSources.length; ++i) {
                try {
                    method2.invoke(WSJdbcTracer.getImpl(this.dataSources[i]), objectArray);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Tr.warning(tc, "PROP_SET_ERROR", new Object[]{this.dataSourceImplClassClass.getName(), "password", illegalAccessException});
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Tr.warning(tc, "PROP_SET_ERROR", new Object[]{this.dataSourceImplClassClass.getName(), "password", invocationTargetException});
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.warning(tc, "PROP_NOT_FOUND", new Object[]{this.dataSourceImplClassClass.getName(), "password"});
        }
        return this.dataSourceProperties.setProperty("password", string);
    }

    private static String toString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("{ ");
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i]).append(", ");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
        }
        return new String(stringBuffer.append("}"));
    }

    private void removeFailoverProperties(Properties properties) {
        boolean bl;
        String string = "";
        boolean bl2 = false;
        boolean bl3 = false;
        string = (String)properties.remove("dbFailOverEnabled");
        if (string != null && string.length() > 0) {
            this.mcf.newDBConnectionValidationEnabled = new Boolean(string);
            bl2 = true;
            Tr.info(tc, "DEPRECATED_PROPERTY_SPECIFIED", new Object[]{this.dataSourceName, "dbFailOverEnabled", "validateNewConnection"});
        }
        if ((string = (String)properties.remove("connRetriesDuringDBFailover")) != null && string.length() > 0) {
            this.mcf.newDBConnectionValidationRetries = new Integer(string);
            Tr.info(tc, "DEPRECATED_PROPERTY_SPECIFIED", new Object[]{this.dataSourceName, "connRetriesDuringDBFailover", "validateNewConnectionRetryCount"});
        }
        if ((string = (String)properties.remove("connRetryIntervalDuringDBFailover")) != null && string.length() > 0) {
            this.mcf.newDBConnectionValidationRetryDuration = new Long(string);
            Tr.info(tc, "DEPRECATED_PROPERTY_SPECIFIED", new Object[]{this.dataSourceName, "connRetryIntervalDuringDBFailover", "validateNewConnectionRetryInterval"});
        }
        if (tc.isDebugEnabled() && bl2) {
            Tr.debug(tc, "DB_FAILOVER_ENABLED", new Boolean(this.mcf.newDBConnectionValidationEnabled));
            Tr.debug(tc, "DB_FAILOVER_CONNECTION_RETRY_INTERVAL", new Long(this.mcf.newDBConnectionValidationRetryDuration));
            Tr.debug(tc, "DB_FAILOVER_CONNECTION_RETRY_COUNT", new Integer(this.mcf.newDBConnectionValidationRetries));
        }
        if ((string = (String)properties.remove("validateNewConnection")) != null && (bl = new Boolean(string).booleanValue())) {
            this.mcf.newDBConnectionValidationEnabled = bl;
            bl3 = true;
            string = (String)properties.remove("validateNewConnectionRetryCount");
            if (string != null) {
                this.mcf.newDBConnectionValidationRetries = new Integer(string);
            }
            if ((string = (String)properties.remove("validateNewConnectionRetryInterval")) != null) {
                this.mcf.newDBConnectionValidationRetryDuration = new Integer(string) * 1000;
            }
        }
        properties.remove("validateNewConnectionRetryInterval");
        properties.remove("validateNewConnectionRetryCount");
        if (bl2 && bl3) {
            Object[] objectArray = new Object[]{this.dataSourceName, "dbFailOverEnabled", "validateNewConnection", "validateNewConnection", new Boolean(this.mcf.newDBConnectionValidationEnabled), "validateNewConnectionRetryCount", new Integer(this.mcf.newDBConnectionValidationRetries), "validateNewConnectionRetryInterval", new Long(this.mcf.newDBConnectionValidationRetryDuration)};
            Tr.info(tc, "DUPLICATE_VALIDATION_PROPERTIES", objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ivalid configuration dbFailOverEnabled and validateNewConnection were both specified. ");
                Tr.debug(tc, "validateNewConnection will be used.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateNewConnection", new Boolean(this.mcf.newDBConnectionValidationEnabled));
            Tr.debug(tc, "validateNewConnectionRetryCount", new Long(this.mcf.newDBConnectionValidationRetryDuration));
            Tr.debug(tc, "validateNewConnectionRetryInterval in milliseconds", new Integer(this.mcf.newDBConnectionValidationRetries));
        }
    }

    public void update(Observable observable, Object object) {
        block4: {
            boolean bl = tc.isDebugEnabled();
            if (bl) {
                Tr.debug(tc, "update: ", new Object[]{observable, object});
            }
            try {
                Object[] objectArray;
                if (object != null && (Integer)(objectArray = (Object[])object)[0] == 400) {
                    String string = "the Application Server current connection configuration will cause more connections to be created by the application servers than DB2 can handle.Maximum allowed by the database: {0}.  Potential number of connections created by the application servers {1}";
                    Tr.warning(tc, string, object);
                }
            }
            catch (Throwable throwable) {
                if (!bl) break block4;
                Tr.debug(tc, "exception received while reading event:", throwable);
            }
        }
    }

    public String getServerVersion() {
        String string = "0.0.0.0";
        try {
            string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    VersionInfo versionInfo = new VersionInfo();
                    StringWriter stringWriter = new StringWriter(2048);
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    versionInfo.runReport("text", printWriter);
                    printWriter.close();
                    String string = stringWriter.toString();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing server version information from the following string " + string);
                    }
                    try {
                        string = string.substring(string.indexOf("Installed Product"));
                        string = string.substring(string.indexOf("Version") + 7, string.indexOf("ID"));
                        String string2 = string.substring(0, string.indexOf("."));
                        String string3 = null;
                        for (int i = 1; i < string2.length() - 1; ++i) {
                            try {
                                string3 = Integer.valueOf(string2.substring(string2.length() - i)).toString();
                                continue;
                            }
                            catch (Exception exception) {
                                break;
                            }
                        }
                        string = string.substring(string.indexOf(".") + 1);
                        String string4 = string.substring(0, string.indexOf("."));
                        string = string.substring(string.indexOf(".") + 1);
                        String string5 = string.substring(0, string.indexOf("."));
                        string = string.substring(string.indexOf(".") + 1);
                        String string6 = null;
                        for (int i = 1; i < string.length() + 1; ++i) {
                            try {
                                string6 = Integer.valueOf(string.substring(0, i)).toString();
                                continue;
                            }
                            catch (Exception exception) {
                                break;
                            }
                        }
                        string = string3 + "." + string4 + "." + string5 + "." + string6;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server version is (" + string + ")");
                        }
                        return string;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not get server version from the following string " + string);
                            Tr.debug(tc, "returning default server version 0.0.0.0");
                        }
                        return "0.0.0.0";
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return string;
    }

    static {
        currClass = WSRdbDataSource.class;
        tc = Tr.register(currClass, "RRA", "IBMDataStoreAdapterNLS");
        helperMap = new HashMap(47);
        helperMap.put("com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2DataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2390DataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2390LocalDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DataDirectDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DerbyDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDerbyDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDerbyNetworkServerDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.InformixDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalInformixDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.SybaseDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.OracleDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalOracle10gDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.Oracle11gDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalOracle11gDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.MicrosoftSQLServerDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalMicrosoftSQLServerDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.SequeLinkDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalSequeLinkDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.DB2StdXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.UDBXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper");
        helperMap.put("com.ibm.as400.access.AS400JDBCXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.ProxyDataSource", "com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper");
    }
}

