/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.j2c.InteractionMetrics;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterInternalException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.CacheMap;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSConnectionEvent;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnection;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionMetaDataImpl;
import com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl;
import com.ibm.ws.rsadapter.spi.WSRdbSpiLocalTransactionImpl;
import com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl;
import com.ibm.ws.rsadapter.spi.WSStateManager;
import com.ibm.ws.security.util.AccessController;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class WSRdbManagedConnectionImpl
implements WSManagedConnection,
DissociatableManagedConnection,
LazyEnlistableManagedConnection,
FFDCSelfIntrospectable {
    private static final long INTERNAL_KEY = 29497789L;
    private static final String[] PMI_COMMIT = new String[]{java.sql.Connection.class.getName(), "commit()"};
    private static final String[] PMI_ROLLBACK = new String[]{java.sql.Connection.class.getName(), "rollback()"};
    Properties extendedDSProps;
    int extentionDSPropKey;
    byte[] trustedContextCookie;
    String mc_tc_name;
    String mc_tc_realm;
    byte[] mc_tc_userSecToken;
    String mc_tc_originalUser;
    J2EEName mc_j2eename = null;
    long mc_connectionWaitTime;
    boolean _claimedVictim;
    private transient boolean rrsGlobalTransactionReallyActive;
    boolean _mcStale;
    java.sql.Connection sqlConn;
    private PooledConnection poolConn;
    private Reassociateable[] handlesInUse = new Reassociateable[maxHandlesInUse];
    int numHandlesInUse;
    private static int maxHandlesInUse = 15;
    private ConnectionEventListener[] ivEventListeners;
    private int numListeners;
    private final int KNOWN_NUMBER_OF_CELS = 1;
    private final int CEL_ARRAY_INCREMENT_SIZE = 3;
    private InteractionMetrics metrics;
    WSManagedConnectionFactoryImpl mcf;
    InternalDataStoreHelper internalHelper;
    private WSConnectionEvent connEvent = new WSConnectionEvent(this);
    WSStateManager stateMgr;
    private LocalTransaction localTran;
    private XAResource xares;
    WSConnectionRequestInfoImpl cri;
    private Subject subject;
    protected boolean defaultAutoCommit;
    protected boolean currentAutoCommit;
    private boolean rrsTransactional = false;
    private String defaultCatalog;
    private Map defaultTypeMap;
    private boolean defaultReadOnly;
    private int currentTransactionIsolation;
    private boolean isolationChanged;
    private boolean connectionPropertyChanged;
    private final DataStoreHelperMetaData mData;
    private int currentHoldability;
    private boolean holdabilityChanged;
    private int defaultHoldability;
    private CacheMap statementCache;
    private int statementCacheSize;
    private boolean isStatementCachingEnabled;
    private WSManagedConnectionMetaDataImpl dbMetaData;
    private String databaseType;
    static final Object key = new byte[0];
    J2CPerf pmi;
    private static final Class currClass = WSRdbManagedConnectionImpl.class;
    private static final TraceComponent tc = Tr.register(currClass, "RRA", "IBMDataStoreAdapterNLS");
    boolean loggingEnabled;
    public boolean clientInfoExplicitlySet;
    public boolean clientInfoImplicitlySet;
    private String[] clientInfoHolder = new String[4];
    private static TraceComponent clientInfoPlusTc = Tr.register("WAS.clientinfopluslogging", "WAS.clientinfopluslogging", "IBMDataStoreAdapterNLS");
    private static final TraceComponent clientInfoTc = Tr.register("WAS.clientinfo", "WAS.clientinfo", "IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;
    private boolean shouldDoConPropFirstCallBeReset = true;
    private Properties doConnectoinSetupPerTranProps = null;
    private boolean is2Phase;
    boolean wasLazilyEnlisted;
    private boolean connectionErrorDetected;
    private boolean cleaningUpHandles;
    Object threadID;
    private Object defContext;
    private Object sqljContext;
    protected java.sql.Connection cachedConnection;
    boolean supportIsolvlSwitching = false;
    boolean enlistmentDisabled;
    private long fatalErrorCount;
    private int failoverCount;

    public void setRrsGlobalTransactionReallyActive(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRrsGlobalTransactionReallyActive is set to: ", new Boolean(bl));
        }
        this.rrsGlobalTransactionReallyActive = bl;
    }

    public void markMCStale() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "mark mc stale", this);
        }
        this._mcStale = true;
    }

    public boolean isMCStale() {
        return this._mcStale;
    }

    public boolean isNewDBConnectionValidationEnabled() {
        return this.mcf.newDBConnectionValidationEnabled;
    }

    void holdCurrentClientInfo(String string, String string2, String string3, String string4) {
        this.clientInfoHolder[0] = string;
        this.clientInfoHolder[1] = string2;
        this.clientInfoHolder[2] = string3;
        this.clientInfoHolder[3] = string4;
    }

    public String[] getCurrentClientInfo() {
        return this.clientInfoHolder;
    }

    public WSRdbManagedConnectionImpl(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl, PooledConnection pooledConnection, java.sql.Connection connection, Subject subject, WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, int n, String string, byte[] byArray, int n2) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{wSManagedConnectionFactoryImpl, AdapterUtil.toString(pooledConnection), AdapterUtil.toString(connection), wSConnectionRequestInfoImpl, new Integer(n), string});
        }
        this.sqlConn = connection;
        this.poolConn = pooledConnection;
        this.mcf = wSManagedConnectionFactoryImpl;
        this.internalHelper = wSManagedConnectionFactoryImpl.internalHelper;
        this.pmi = wSManagedConnectionFactoryImpl.pmi;
        this.cri = wSConnectionRequestInfoImpl;
        this.statementCacheSize = n;
        this.databaseType = string;
        this.enlistmentDisabled = this.cri.ivNoEnlist;
        this.failoverCount = n2;
        this.doConnectoinSetupPerTranProps = new Properties();
        this.doConnectoinSetupPerTranProps.setProperty("FIRST_TIME_CALLED", "true");
        this.mc_j2eename = this.cri.getJ2EEName();
        this.trustedContextCookie = byArray;
        if (wSConnectionRequestInfoImpl.trustedContextIdentityAttributesAreSet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "saving trusted Context attributes from cri in mc (cri, mc):", new Object[]{wSConnectionRequestInfoImpl, this});
            }
            this.mc_tc_name = wSConnectionRequestInfoImpl.tc_name;
            this.mc_tc_realm = wSConnectionRequestInfoImpl.tc_realm;
            this.mc_tc_userSecToken = wSConnectionRequestInfoImpl.tc_userSecToken;
            this.mc_tc_originalUser = wSConnectionRequestInfoImpl.tc_originalUser;
        }
        this.is2Phase = pooledConnection instanceof XAConnection;
        if (pooledConnection == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "##### poolConn is null which will cause is2Phase to always be false and that will cause XA to break");
        }
        this.subject = subject == null ? null : this.copySubject(subject);
        this.ivEventListeners = new ConnectionEventListener[1];
        this.numListeners = 0;
        this.threadID = wSManagedConnectionFactoryImpl.detectMultithreadedAccess ? Thread.currentThread() : this.threadID;
        this.mData = wSManagedConnectionFactoryImpl.dataStoreHelper.getMetaData();
        this.rrsTransactional = wSManagedConnectionFactoryImpl.getRRSTransactional();
        try {
            this.defaultHoldability = wSManagedConnectionFactoryImpl.getInternalDataStoreHelper().getHoldability(this.sqlConn);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".init()", "300", this);
            throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "defaultHoldability is " + AdapterUtil.getCursorHoldabilityString(this.defaultHoldability));
        }
        this.initializeConnectionProperties();
        if (!DSConfigurationHelper._disablePK54589) {
            if (!this.cri.isCRIChangable()) {
                this.cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri);
            }
            this.cri.setDefaultValues(null, null, this.defaultReadOnly, null);
        }
        this.synchronizePropertiesWithCRI();
        this.isStatementCachingEnabled = n > 0;
        if (this.isStatementCachingEnabled) {
            this.statementCache = new CacheMap(n);
        }
        this.stateMgr = new WSStateManager();
        this.supportIsolvlSwitching = this.internalHelper.isIsolationLevelSwitchingSupport();
        if (this.internalHelper.shouldTraceBeEnabled(this)) {
            this.internalHelper.enableJdbcLogging(this);
        } else if (this.internalHelper.shouldTraceBeDisabled(this)) {
            this.internalHelper.disableJdbcLogging(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private final void addHandle(Reassociateable reassociateable) {
        (this.numHandlesInUse < this.handlesInUse.length - 1 ? this.handlesInUse : this.resizeHandleList())[this.numHandlesInUse++] = reassociateable;
    }

    public final WSConnectionRequestInfoImpl createConnectionRequestInfo() throws ResourceException {
        try {
            WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = null;
            if (this.isolationChanged || this.connectionPropertyChanged || this.holdabilityChanged || this.cri.isCRIChangable()) {
                wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(this.cri.ivUserName, this.cri.ivPassword, this.isolationChanged ? this.currentTransactionIsolation : this.cri.ivIsoLevel, this.connectionPropertyChanged && this.mData.supportsGetCatalog() ? this.getCatalog() : this.cri.ivCatalog, this.connectionPropertyChanged && this.mData.supportsIsReadOnly() ? new Boolean(this.isReadOnly()) : this.cri.ivReadOnly, this.connectionPropertyChanged && this.mData.supportsGetTypeMap() ? this.getTypeMap() : this.cri.ivTypeMap, this.holdabilityChanged ? this.getHoldability() : this.cri.ivHoldability, this.cri.ivConfigID, this.cri.isJDBC, this.cri.supportIsolvlSwitching, this.cri.ivNoEnlist, this.mcf.jmsOnePhaseOptimization);
                if (!DSConfigurationHelper._disablePK54589) {
                    wSConnectionRequestInfoImpl.setDefaultValues(null, null, this.cri.defaultReadOnly, null);
                }
                wSConnectionRequestInfoImpl.markAsChangable();
                wSConnectionRequestInfoImpl.setHeterogeneousProperties(this.extendedDSProps, this.extentionDSPropKey);
                wSConnectionRequestInfoImpl.setOptimizeForGetUseClose(this.mcf.optimizedForGetUseClose);
                if (this.mcf.ispropagateClientIdentityUsingTrustedContextEnabled()) {
                    wSConnectionRequestInfoImpl.setTrustedContextOriginalUser(this.mc_tc_originalUser);
                    wSConnectionRequestInfoImpl.setTrustedContextUserName(this.mc_tc_name);
                    wSConnectionRequestInfoImpl.setTrustedContextUserSecToken(this.mc_tc_userSecToken);
                    wSConnectionRequestInfoImpl.setTrustedContextRealm(this.mc_tc_realm);
                }
                wSConnectionRequestInfoImpl.setJ2EEName(this.mc_j2eename);
            } else {
                wSConnectionRequestInfoImpl = this.cri;
            }
            return wSConnectionRequestInfoImpl;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".createConnectionRequestInfo", "379", this);
            throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
        }
    }

    private void destroyStatement(Object object) {
        block4: {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Statement cache at capacity. Discarding a statement.", AdapterUtil.toString(object));
                }
                if (this.pmi != null) {
                    this.pmi.statementDiscardedFromCache(this);
                }
                ((Statement)object).close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".discardStatement", "511", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error closing statement", new Object[]{AdapterUtil.toString(object), sQLException});
            }
        }
    }

    final void detectMultithreadedAccess() {
        Thread thread = Thread.currentThread();
        if (thread == this.threadID) {
            return;
        }
        if (this.threadID == null) {
            this.threadID = thread;
        } else {
            this.mcf.detectedMultithreadedAccess = true;
            StringWriter stringWriter = new StringWriter();
            new Error().printStackTrace(new PrintWriter(stringWriter));
            Tr.warning(tc, "MULTITHREADED_ACCESS_DETECTED", new Object[]{this, Integer.toHexString(this.threadID.hashCode()) + ' ' + this.threadID, Integer.toHexString(thread.hashCode()) + ' ' + thread, stringWriter.getBuffer().delete(0, "java.lang.Error".length())});
        }
    }

    public void dissociateConnections() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "dissociateConnections", this);
        }
        ResourceException resourceException = null;
        this.cleaningUpHandles = true;
        int n = this.numHandlesInUse;
        while (n > 0) {
            try {
                this.handlesInUse[--n].dissociate();
                this.handlesInUse[n] = null;
            }
            catch (ResourceException resourceException2) {
                ResourceException resourceException3 = this.processHandleDissociationError(n, resourceException2);
                if (resourceException != null) continue;
                resourceException = resourceException3;
            }
        }
        this.numHandlesInUse = 0;
        this.cleaningUpHandles = false;
        if (resourceException == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "dissociateConnections");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "dissociateConnections", (Object)resourceException);
            }
            throw resourceException;
        }
    }

    public final void enforceAutoCommit(boolean bl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enforceAutoCommit", new Boolean(bl));
        }
        if (bl != this.currentAutoCommit || this.internalHelper.alwaysSetAutoCommit()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "currentAutoCommit: " + this.currentAutoCommit + " --> " + bl);
            }
            this.sqlConn.setAutoCommit(bl);
            this.currentAutoCommit = bl;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enforceAutoCommit");
        }
    }

    protected void finalize() throws Throwable {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finalize", this);
        }
        if (this.numHandlesInUse > 0) {
            this.fatalErrorCount = -1L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.numHandlesInUse + " connection handles were left open by the application.");
            }
            this.cleaningUpHandles = false;
            while (this.numHandlesInUse > 0) {
                this.processConnectionClosedEvent(this.handlesInUse[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finalize");
        }
    }

    public final String getCatalog() throws SQLException {
        return this.sqlConn.getCatalog();
    }

    public final DataStoreHelperMetaData getDataStoreHelperMetaData() {
        return this.mData;
    }

    public final boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public final int getHandleCount() {
        return this.numHandlesInUse;
    }

    public final InteractionMetrics getInteractionMetrics() {
        return this.metrics;
    }

    public final Map getTypeMap() throws SQLException {
        return this.sqlConn.getTypeMap();
    }

    public final boolean inGlobalTransaction() {
        int n = this.stateMgr.transtate;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "state == WSStateManager.GLOBAL_TRANSACTION_ACTIVE", new Boolean(n == 2));
            Tr.debug(tc, "state == WSStateManager.RRS_GLOBAL_TRANSACTION_ACTIVE", new Boolean(n == 7));
            Tr.debug(tc, "rrsGlobalTransactionReallyActive is: ", new Boolean(this.rrsGlobalTransactionReallyActive));
            Tr.debug(tc, "(wasLazilyEnlisted && state == WSStateManager.LOCAL_TRANSACTION_ACTIVE)", new Boolean(this.wasLazilyEnlisted && n == 1));
            Tr.debug(tc, "wasLazilyEnlisted", new Boolean(this.wasLazilyEnlisted));
            Tr.debug(tc, "state == WSStateManager.LOCAL_TRANSACTION_ACTIVE", new Boolean(n == 1));
        }
        return n == 2 || n == 7 || this.wasLazilyEnlisted && n == 1;
    }

    private void initializeConnectionProperties() throws ResourceException {
        try {
            if (this.rrsTransactional) {
                this.defaultAutoCommit = true;
                this.currentAutoCommit = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "MCF is rrsTransactional:  forcing currentAutoCommit and defaultAutoCommit to true");
                }
            } else {
                this.currentAutoCommit = this.defaultAutoCommit = this.sqlConn.getAutoCommit();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "MCF is NOT rrsTransactional:  setting currentAutoCommit and defaultAutoCommit to " + this.defaultAutoCommit + " from underlying Connection");
                }
            }
            this.defaultCatalog = this.mData.supportsGetCatalog() ? this.sqlConn.getCatalog() : null;
            this.defaultReadOnly = this.mData.supportsIsReadOnly() ? this.sqlConn.isReadOnly() : false;
            this.defaultTypeMap = this.mData.supportsGetTypeMap() ? this.sqlConn.getTypeMap() : null;
            this.currentHoldability = this.defaultHoldability;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".initializeConnectionProperties", "381", this);
            throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
        }
    }

    public String[] introspectSelf() {
        int n;
        boolean bl;
        FFDCLogger fFDCLogger;
        block42: {
            block41: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "introspectSelf", this);
                }
                fFDCLogger = new FFDCLogger(this);
                fFDCLogger.append(this.is2Phase ? "TWO PHASE ENABLED" : "ONE PHASE ENABLED");
                fFDCLogger.append("Database Type:", this.databaseType);
                fFDCLogger.append("Transaction State:", this.getTransactionStateAsString());
                fFDCLogger.append("Statement Cache Size (maximum):", new Integer(this.statementCacheSize));
                fFDCLogger.append("Key:", key);
                fFDCLogger.append("Performance Monitoring Instrumentation:", this.pmi);
                fFDCLogger.append("Log Writer:", this.mcf.logWriter);
                fFDCLogger.append("Subject:", this.subject == null ? null : "NON-NULL");
                fFDCLogger.append("ManagedConnection:", this);
                fFDCLogger.append("Counter of fatal connection errors for the ManagedConnectionFactory as of the most recent getConnection on this ManagedConnection:", new Long(this.fatalErrorCount));
                try {
                    bl = this.sqlConn == null || this.sqlConn.isClosed();
                }
                catch (SQLException sQLException) {
                    bl = true;
                }
                fFDCLogger.append("Default AutoCommit:", new Boolean(this.defaultAutoCommit));
                fFDCLogger.append("Current AutoCommit:", new Boolean(this.currentAutoCommit));
                if (!bl) {
                    try {
                        fFDCLogger.append("AutoCommit reported by the JDBC driver:", this.sqlConn.getAutoCommit() ? Boolean.TRUE : Boolean.FALSE);
                    }
                    catch (SQLException sQLException) {
                        if (this.mcf.dataStoreHelper.isConnectionError(sQLException)) break block41;
                        Tr.warning(tc, "DSA_ERROR", new Object[]{sQLException, currClass});
                    }
                }
            }
            fFDCLogger.append("Current Isolation:", AdapterUtil.getIsolationLevelString(this.currentTransactionIsolation));
            fFDCLogger.append("Isolation level has changed? :", this.isolationChanged ? Boolean.TRUE : Boolean.FALSE);
            fFDCLogger.append("Support isolation level switching: ", new Boolean(this.supportIsolvlSwitching));
            fFDCLogger.append("The j2eename is: ").append(this.mc_j2eename == null ? null : ((Object)this.mc_j2eename).toString());
            fFDCLogger.append("The connection wait Time for the mc is: ", new Long(this.mc_connectionWaitTime));
            if (!bl) {
                try {
                    fFDCLogger.append("Isolation reported by the JDBC driver:", AdapterUtil.getIsolationLevelString(this.sqlConn.getTransactionIsolation()));
                }
                catch (SQLException sQLException) {
                    if (this.mcf.dataStoreHelper.isConnectionError(sQLException)) break block42;
                    Tr.warning(tc, "DSA_ERROR", new Object[]{sQLException, currClass});
                }
            }
        }
        fFDCLogger.append("Catalog, IsReadOnly, or TypeMap has changed? :", this.connectionPropertyChanged ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("Default Holdability:", AdapterUtil.getCursorHoldabilityString(this.defaultHoldability));
        fFDCLogger.append("Current Holdability:", AdapterUtil.getCursorHoldabilityString(this.currentHoldability));
        fFDCLogger.append("Holdability value has changed? :", this.holdabilityChanged ? Boolean.TRUE : Boolean.FALSE);
        if (!bl) {
            try {
                fFDCLogger.append("Holdability reported by the JDBC driver:", AdapterUtil.getCursorHoldabilityString(this.mcf.getInternalDataStoreHelper().getHoldability(this.sqlConn)));
            }
            catch (Throwable throwable) {
                fFDCLogger.append("Holdability reported by the JDBC driver:", AdapterUtil.getCursorHoldabilityString(0));
            }
        }
        fFDCLogger.append("Thread ID:", this.threadID);
        fFDCLogger.append("Lazily enlisted in the current transaction? :", this.wasLazilyEnlisted ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("Underlying Connection Object: " + AdapterUtil.toString(this.sqlConn), this.sqlConn);
        fFDCLogger.append("Underlying PooledConnection Object: " + AdapterUtil.toString(this.poolConn), this.poolConn);
        fFDCLogger.append("SQLJ Default Context: " + AdapterUtil.toString(this.defContext), this.defContext);
        fFDCLogger.append("Is statement caching enabled? :", this.isStatementCachingEnabled ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("Fatal connection error was detected? :", this.connectionErrorDetected ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("Currently cleaning up handles? :", this.cleaningUpHandles ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("Last ConnectionEvent sent for this ManagedConnection:");
        fFDCLogger.indent(AdapterUtil.toString((Object)this.connEvent));
        fFDCLogger.indent("Connection Handle: " + this.connEvent.getConnectionHandle());
        fFDCLogger.indent("Event ID: " + AdapterUtil.getConnectionEventString(this.connEvent.getId()));
        fFDCLogger.indent("Exception: " + this.connEvent.getException());
        fFDCLogger.eoln();
        if (!bl) {
            try {
                fFDCLogger.append("Driver version:", this.sqlConn.getMetaData().getDriverVersion());
                fFDCLogger.append("Database version:", this.sqlConn.getMetaData().getDatabaseProductVersion());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        fFDCLogger.append("Connection Event Listeners:");
        for (n = 0; n < this.numListeners; ++n) {
            try {
                fFDCLogger.indent(this.ivEventListeners[n]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        fFDCLogger.eoln();
        fFDCLogger.append("Interaction Metrics: ", this.metrics);
        fFDCLogger.append("Maximum Handle List Size: " + maxHandlesInUse);
        fFDCLogger.append("Handle Count: " + this.numHandlesInUse);
        fFDCLogger.append("Handles:");
        if (this.handlesInUse != null) {
            try {
                for (n = 0; n < this.handlesInUse.length; ++n) {
                    fFDCLogger.indent(this.handlesInUse[n]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        fFDCLogger.eoln();
        fFDCLogger.introspect("State Manager:", this.stateMgr);
        try {
            if (this.xares instanceof WSRdbXaResourceImpl) {
                ((WSRdbXaResourceImpl)this.xares).introspectThisClassOnly(fFDCLogger);
            } else if (this.xares instanceof WSRdbOnePhaseXaResourceImpl) {
                ((WSRdbOnePhaseXaResourceImpl)this.xares).introspectThisClassOnly(fFDCLogger);
            } else {
                fFDCLogger.append("XA Resource:", this.xares);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.localTran == null) {
            fFDCLogger.append("SPI LocalTransaction :", "null");
        } else {
            try {
                ((WSRdbSpiLocalTransactionImpl)this.localTran).introspectThisClassOnly(fFDCLogger);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.dbMetaData == null) {
            fFDCLogger.append("ManagedConnectionMetaData:", "null");
        } else {
            try {
                this.dbMetaData.introspectThisClassOnly(fFDCLogger);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.statementCache == null) {
            fFDCLogger.append("Statement Cache:", "null");
        } else {
            try {
                fFDCLogger.append("Statement Cache:", this.statementCache.display());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        fFDCLogger.introspect("ConnectionRequestInfo", this.cri);
        fFDCLogger.introspect("ManagedConnectionFactory", this.mcf);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "introspectSelf");
        }
        return fFDCLogger.toStringArray();
    }

    public final boolean is2Phase() {
        return this.is2Phase;
    }

    public final boolean isEnlistmentDisabled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isEnlistmentDisabled() returning: ", new Boolean(this.enlistmentDisabled));
        }
        return this.enlistmentDisabled;
    }

    public final boolean isReadOnly() throws SQLException {
        return this.sqlConn.isReadOnly();
    }

    public final boolean isStatementCachingEnabled() {
        return this.isStatementCachingEnabled;
    }

    private static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public void pmiCommit() throws SQLException {
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        Object object = this.metrics.preInteraction(PMI_COMMIT);
        try {
            this.sqlConn.commit();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiCommit", "1505", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiCommit", "1512", this);
            exception = runtimeException;
            n = 2;
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("DataSourceJNDIName", this.mcf.getJndiName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception != null) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw (RuntimeException)exception;
        }
    }

    public void pmiRollback() throws SQLException {
        int n = 0;
        Exception exception = null;
        Properties properties = null;
        Object object = this.metrics.preInteraction(PMI_ROLLBACK);
        try {
            this.sqlConn.rollback();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".pmiRollback", "1548", this);
            exception = sQLException;
            n = 2;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".pmiRollback", "1555", this);
            exception = runtimeException;
            n = 2;
        }
        switch (this.metrics.getTranDetailLevel()) {
            case 2: 
            case 3: {
                properties = new Properties();
                properties.setProperty("DataSourceJNDIName", this.mcf.getJndiName());
            }
            case 1: {
                this.metrics.postInteraction(object, n, properties);
            }
        }
        if (exception != null) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw (RuntimeException)exception;
        }
    }

    public void processConnectionClosedEvent(Reassociateable reassociateable) throws ResourceException {
        if (this.cleaningUpHandles) {
            return;
        }
        this.connEvent.recycle(1, null, reassociateable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Firing CONNECTION CLOSED event for: " + reassociateable, this);
        }
        try {
            this.removeHandle(reassociateable);
        }
        catch (NullPointerException nullPointerException) {
            if (this.handlesInUse == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "ManagedConnection already closed", this);
                }
                return;
            }
            throw nullPointerException;
        }
        if (this.numHandlesInUse == 0) {
            try {
                this.internalHelper.processLastHandleClosed(this.sqlConn, this.currentAutoCommit, this.inGlobalTransaction());
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".processConnectionClosedEvent", "1467", this);
                throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
            }
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].connectionClosed((ConnectionEvent)this.connEvent);
        }
    }

    private ResourceException processHandleDissociationError(int n, ResourceException resourceException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processHandleDissociationError", new Object[]{new Integer(n), resourceException.getMessage()});
        }
        Reassociateable reassociateable = this.handlesInUse[n];
        String string = resourceException.getErrorCode();
        if (string != null && string.equals("HANDLE_IN_USE") && reassociateable != null) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to dissociate handle because it is doing work in the database.  Closing it instead.", this.handlesInUse[n]);
                }
                ((java.sql.Connection)((Object)reassociateable)).close();
                resourceException = null;
            }
            catch (SQLException sQLException) {
                resourceException = AdapterUtil.translateSQLException(sQLException, this, true, currClass);
            }
        }
        if (resourceException != null) {
            FFDCFilter.processException((Throwable)resourceException, currClass.getName() + ".processHandleDissociationError", "1024", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Error dissociating handle. Continuing...", reassociateable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processHandleDissociationError", resourceException == null ? null : resourceException.getMessage());
        }
        return resourceException;
    }

    private ResourceException processHandleDissociationError2(Reassociateable reassociateable, ResourceException resourceException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processHandleDissociationError2", new Object[]{resourceException.getMessage(), reassociateable});
        }
        if (resourceException.getErrorCode().equals("HANDLE_IN_USE")) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to dissociate handle because it is doing work in the database.  Closing it instead.");
                }
                ((java.sql.Connection)((Object)reassociateable)).close();
                resourceException = null;
            }
            catch (SQLException sQLException) {
                resourceException = AdapterUtil.translateSQLException(sQLException, this, true, currClass);
            }
        }
        if (resourceException != null) {
            FFDCFilter.processException((Throwable)resourceException, currClass.getName() + ".processHandleDissociationError2", "1536", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Error dissociating handle. Continuing...", reassociateable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processHandleDissociationError2", resourceException == null ? null : resourceException.getMessage());
        }
        return resourceException;
    }

    public void processLocalTransactionStartedEvent(Object object) throws ResourceException {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processLocalTransactionStartedEvent", object);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            object2 = null;
            try {
                object2 = this.mcf.getCorrelator(this);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in commit, exception is: ", sQLException);
            }
            if (object2 != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append((String)object2);
                if (this.xares != null) {
                    stringBuffer.append(" Transaction : ");
                    stringBuffer.append(this.xares);
                }
                stringBuffer.append(" BEGIN");
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if ((object2 = this.stateMgr.isValid(1)) == null) {
            if (this.currentAutoCommit) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "current autocommit is true, set to false");
                    }
                    this.setAutoCommit(false);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".processLocalTransactionStartedEvent", "550", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
        } else {
            throw object2;
        }
        this.stateMgr.transtate = 1;
        this.connEvent.recycle(2, null, object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Firing LOCAL TRANSACTION STARTED event for: " + object, this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionStarted((ConnectionEvent)this.connEvent);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processLocalTransactionStartedEvent", object);
        }
    }

    public void processLocalTransactionCommittedEvent(Object object) throws ResourceException {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processLocalTransactionCommittedEvent", object);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            object2 = null;
            try {
                object2 = this.mcf.getCorrelator(this);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in commit, exception is: ", sQLException);
            }
            if (object2 != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append((String)object2);
                if (this.xares != null) {
                    stringBuffer.append(" Transaction : ");
                    stringBuffer.append(this.xares);
                }
                stringBuffer.append(" COMMIT");
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if ((object2 = this.stateMgr.isValid(2)) == null) {
            if (!this.currentAutoCommit) {
                try {
                    if (this.metrics.isInteractionMetricsEnabled()) {
                        this.pmiCommit();
                    }
                    this.sqlConn.commit();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.processLocalTransactionCommittedEvent", "554", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
        } else {
            throw object2;
        }
        this.stateMgr.transtate = 0;
        this.connEvent.recycle(3, null, object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Firing LOCAL TRANSACTION COMMITTED event for: " + object, this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionCommitted((ConnectionEvent)this.connEvent);
        }
        this.wasLazilyEnlisted = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processLocalTransactionCommittedEvent");
        }
    }

    public void processLocalTransactionRolledbackEvent(Object object) throws ResourceException {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processLocalTransactionRolledbackEvent");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            object2 = null;
            try {
                object2 = this.mcf.getCorrelator(this);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in commit, exception is: ", sQLException);
            }
            if (object2 != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append((String)object2);
                if (this.xares != null) {
                    stringBuffer.append(" Transaction : ");
                    stringBuffer.append(this.xares);
                }
                stringBuffer.append(" ROLLBACK");
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if ((object2 = this.stateMgr.isValid(3)) == null) {
            if (!this.currentAutoCommit) {
                try {
                    if (this.metrics.isInteractionMetricsEnabled()) {
                        this.pmiRollback();
                    }
                    this.sqlConn.rollback();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.processLocalTransactionRolledbackEvent", "595", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
        } else {
            throw object2;
        }
        this.stateMgr.transtate = 0;
        this.connEvent.recycle(4, null, object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Firing LOCAL TRANSACTION ROLLEDBACK event for: " + object, this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionRolledback((ConnectionEvent)this.connEvent);
        }
        this.wasLazilyEnlisted = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processLocalTransactionRolledbackEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processConnectionErrorOccurredEvent(Object object, Exception exception) {
        DataStoreAdapterException dataStoreAdapterException;
        DataStoreAdapterException dataStoreAdapterException2 = dataStoreAdapterException = exception instanceof DataStoreAdapterException ? (DataStoreAdapterException)((Object)exception) : null;
        if (this.connectionErrorDetected) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "CONNECTION_ERROR_OCCURRED event already fired for connection:", this);
            }
            return;
        }
        if (this.mcf.propagateClientIdentityUsingTrustedContext && (exception instanceof SQLException && this.mcf.internalHelper.isAnAuthorizationException((SQLException)exception) || dataStoreAdapterException != null && dataStoreAdapterException.containsSqlException() && this.mcf.internalHelper.isAnAuthorizationException((SQLException)dataStoreAdapterException.getCause()))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CONNECTION_ERROR_OCCURRED will fire an event to only purge and destroy this connection:", this);
            }
            this.connectionErrorDetected = true;
            this.closeHandles();
            this.connEvent.recycle(51, exception, object);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Firing Single CONNECTION_ERROR_OCCURRED event for handle: " + object, this);
            }
            for (int i = 0; i < this.numListeners; ++i) {
                this.ivEventListeners[i].connectionErrorOccurred((ConnectionEvent)this.connEvent);
            }
            return;
        }
        WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl = this.mcf;
        synchronized (wSManagedConnectionFactoryImpl) {
            ++this.mcf.fatalErrorCount;
        }
        if (!this.mcf.newDBConnectionValidationEnabled) {
            this.mcf.moveToNextFailoverServer(this.failoverCount);
        }
        this.connectionErrorDetected = true;
        this.closeHandles();
        this.connEvent.recycle(5, exception, object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Firing CONNECTION_ERROR_OCCURRED event for handle: " + object, this);
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].connectionErrorOccurred((ConnectionEvent)this.connEvent);
        }
    }

    public void lazyEnlist(LazyEnlistableConnectionManager lazyEnlistableConnectionManager) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "lazyEnlist", new Object[]{this, lazyEnlistableConnectionManager});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string = null;
            try {
                string = this.mcf.getCorrelator(this);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in commit, exception is: ", sQLException);
            }
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append(string);
                if (this.xares != null) {
                    stringBuffer.append(" Transaction : ");
                    stringBuffer.append(this.xares);
                    stringBuffer.append(" BEGIN");
                }
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if (this.wasLazilyEnlisted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "lazyEnlist", new Object[]{Boolean.FALSE, "ManagedConnection is already enlisted in a transaction.", this});
            }
        } else {
            lazyEnlistableConnectionManager.lazyEnlist((ManagedConnection)this);
            this.wasLazilyEnlisted |= this.stateMgr.transtate != 0;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "lazyEnlist", this.wasLazilyEnlisted ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    private final boolean removeHandle(Reassociateable reassociateable) {
        int n = this.numHandlesInUse;
        while (n > 0) {
            if (reassociateable != this.handlesInUse[--n]) continue;
            this.handlesInUse[n] = this.handlesInUse[--this.numHandlesInUse];
            this.handlesInUse[this.numHandlesInUse] = null;
            return true;
        }
        return false;
    }

    private void replaceCRI(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceCRI", new Object[]{"Current:", this.cri, "New:", wSConnectionRequestInfoImpl});
        }
        if (this.numHandlesInUse > 0 || !this.cri.isReconfigurable(wSConnectionRequestInfoImpl, this.mcf.reauthEnabled)) {
            if (this.numHandlesInUse > 0) {
                DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed on a ManagedConnection with active handles.", AdapterUtil.EOLN + "Existing CRI: " + this.cri, AdapterUtil.EOLN + "Requested CRI: " + wSConnectionRequestInfoImpl}, null, this.getClass());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "replaceCRI", dataStoreAdapterException);
                }
                throw dataStoreAdapterException;
            }
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed because the users, passwords, or DataSource configurations do not match.", AdapterUtil.EOLN + "Existing CRI: " + this.cri, AdapterUtil.EOLN + "Requested CRI: " + wSConnectionRequestInfoImpl}, null, this.getClass());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "replaceCRI", dataStoreAdapterException);
            }
            throw dataStoreAdapterException;
        }
        if (!DSConfigurationHelper._disablePK54589) {
            if (!wSConnectionRequestInfoImpl.isCRIChangable()) {
                wSConnectionRequestInfoImpl = WSConnectionRequestInfoImpl.createChangableCRIFromNon(wSConnectionRequestInfoImpl);
            }
            wSConnectionRequestInfoImpl.setDefaultValues(null, null, this.defaultReadOnly, null);
        }
        this.cri = wSConnectionRequestInfoImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceCRI");
        }
    }

    private void replaceCRIForCCI(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceCRIForCCI", new Object[]{"Current:", this.cri, "New:", wSConnectionRequestInfoImpl});
        }
        if (this.numHandlesInUse > 0 && !this.supportIsolvlSwitching) {
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed on a ManagedConnection with active handles.", AdapterUtil.EOLN + "Existing CRI: " + this.cri, AdapterUtil.EOLN + "Requested CRI: " + wSConnectionRequestInfoImpl}, null, this.getClass());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "replaceCRIForCCI", dataStoreAdapterException);
            }
            throw dataStoreAdapterException;
        }
        if (!DSConfigurationHelper._disablePK54589) {
            if (!wSConnectionRequestInfoImpl.isCRIChangable()) {
                wSConnectionRequestInfoImpl = WSConnectionRequestInfoImpl.createChangableCRIFromNon(wSConnectionRequestInfoImpl);
            }
            wSConnectionRequestInfoImpl.setDefaultValues(null, null, this.defaultReadOnly, null);
        }
        this.cri = wSConnectionRequestInfoImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceCRIForCCI");
        }
    }

    private Reassociateable[] resizeHandleList() {
        this.handlesInUse = new Reassociateable[maxHandlesInUse > this.numHandlesInUse ? maxHandlesInUse : (maxHandlesInUse = this.numHandlesInUse * 2)];
        System.arraycopy(this.handlesInUse, 0, this.handlesInUse, 0, this.numHandlesInUse);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Handle limit increased to: " + maxHandlesInUse);
        }
        return this.handlesInUse;
    }

    private void synchronizePropertiesWithCRI() throws ResourceException {
        int n = -1;
        int n2 = -1;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "synchronizePropertiesWithCRI");
        }
        try {
            this.isolationChanged = false;
            this.holdabilityChanged = false;
            if (!(!this.mcf.propagateClientIdentityUsingTrustedContext || WSRdbManagedConnectionImpl.match(this.mc_tc_name, this.cri.tc_name) && WSRdbManagedConnectionImpl.match(this.mc_tc_realm, this.cri.tc_realm) && WSRdbManagedConnectionImpl.match(this.mc_tc_originalUser, this.cri.tc_originalUser) && Arrays.equals(this.mc_tc_userSecToken, this.cri.tc_userSecToken))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "synching security attributes on this mc and then clearing ps cache:", this);
                }
                this.clearStatementCache();
                this.mcf.internalHelper.reuseTrustedConnection(this.sqlConn, this.trustedContextCookie, this.cri.tc_name, null, this.cri.tc_realm, this.cri.tc_userSecToken, this.cri.tc_originalUser, null);
                this.mc_tc_name = this.cri.tc_name;
                this.mc_tc_originalUser = this.cri.tc_originalUser;
                this.mc_tc_realm = this.cri.tc_realm;
                this.mc_tc_userSecToken = this.cri.tc_userSecToken;
                this.currentTransactionIsolation = this.sqlConn.getTransactionIsolation();
                this.currentHoldability = this.defaultHoldability;
                this.currentAutoCommit = this.sqlConn.getAutoCommit();
                this.loggingEnabled = false;
                if (this.internalHelper.shouldTraceBeEnabled(this)) {
                    this.internalHelper.enableJdbcLogging(this);
                }
            }
            if (this.cri.extentionDSPropKey != this.extentionDSPropKey) {
                this.internalHelper.reuseOrReconfigureConnection(this, this.cri.extentionDSProps);
                this.extentionDSPropKey = this.cri.extentionDSPropKey;
                this.extendedDSProps = this.cri.extentionDSProps;
            }
            this.mc_j2eename = this.cri.getJ2EEName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                n = this.getTransactionIsolation();
                n2 = this.currentHoldability;
            }
            if (this.currentTransactionIsolation != this.cri.ivIsoLevel) {
                this.setTransactionIsolation(this.cri.ivIsoLevel);
            }
            if (DSConfigurationHelper._disablePK54589) {
                if (this.cri.ivCatalog != null && this.defaultCatalog != this.cri.ivCatalog && this.mData.supportsGetCatalog()) {
                    this.setCatalog(this.cri.ivCatalog);
                }
            } else if (this.cri.ivCatalog != null && !this.cri.ivCatalog.equals(this.defaultCatalog) && this.mData.supportsGetCatalog()) {
                this.setCatalog(this.cri.ivCatalog);
            }
            if (this.cri.ivReadOnly != null && this.defaultReadOnly != this.cri.ivReadOnly && this.mData.supportsIsReadOnly()) {
                this.internalHelper.setReadOnly(this, this.cri.ivReadOnly, false);
            }
            if (this.cri.ivTypeMap != null && this.defaultTypeMap != this.cri.ivTypeMap && this.mData.supportsGetTypeMap()) {
                this.setTypeMap(this.cri.ivTypeMap);
            }
            if (this.defaultHoldability != 0) {
                int n3;
                int n4 = n3 = this.cri.ivHoldability == 0 ? this.defaultHoldability : this.cri.ivHoldability;
                if (this.currentHoldability != n3) {
                    this.setHoldability(n3);
                }
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".synchronizePropertiesWithCRI", "850", this);
            throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "previous/current value:", new Object[]{"AutoCommit: " + this.currentAutoCommit + "/" + this.currentAutoCommit, "Isolation:  " + AdapterUtil.getIsolationLevelString(n) + "/" + AdapterUtil.getIsolationLevelString(this.currentTransactionIsolation), "Catalog:    " + this.defaultCatalog + "/" + (this.cri.ivCatalog == null ? this.defaultCatalog : this.cri.ivCatalog), "IsReadOnly: " + this.defaultReadOnly + "/" + (this.cri.ivReadOnly == null ? new Boolean(this.defaultReadOnly) : this.cri.ivReadOnly), "TypeMap:    " + this.defaultTypeMap + "/" + (this.cri.ivTypeMap == null ? this.defaultTypeMap : this.cri.ivTypeMap), "Holdability:" + AdapterUtil.getCursorHoldabilityString(n2) + "/" + AdapterUtil.getCursorHoldabilityString(this.currentHoldability)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "synchronizePropertiesWithCRI");
        }
    }

    public final Object getStatement(StatementCacheKey statementCacheKey) {
        Object object = this.statementCache.remove(statementCacheKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (object == null) {
                Tr.debug(tc, "No Matching Prepared Statement found in cache");
            } else {
                Tr.debug(tc, "Matching Prepared Statement found in cache: " + object);
            }
        }
        return object;
    }

    public final Object call(String string, Object[] objectArray, Class[] classArray, WSJdbcObject wSJdbcObject) throws SQLException {
        return this.call(string, objectArray, classArray, wSJdbcObject, null);
    }

    public final Object call(String string, Object[] objectArray, Class[] classArray, WSJdbcObject wSJdbcObject, String string2) throws SQLException {
        return WSJdbcUtil.call((Object)this.poolConn, string, objectArray, classArray, wSJdbcObject, string2);
    }

    public final void cacheStatement(Statement statement, StatementCacheKey statementCacheKey) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "cacheStatement", new Object[]{AdapterUtil.toString(statement), statementCacheKey});
        }
        if ((object = this.statementCache.add(statementCacheKey, statement)) != null) {
            this.destroyStatement(object);
        }
    }

    public final WSManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.mcf;
    }

    /*
     * Unable to fully structure code
     */
    public Object getConnection(Subject var1_1, ConnectionRequestInfo var2_2) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && (WSRdbManagedConnectionImpl.tc.isEntryEnabled() || WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled())) {
            WSRdbManagedConnectionImpl.tempTc = WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled() != false ? WSRdbManagedConnectionImpl.clientInfoPlusTc : WSRdbManagedConnectionImpl.tc;
            Tr.entry(WSRdbManagedConnectionImpl.tempTc, "getConnection", new Object[]{this, var1_1 == null ? null : "Subject is not null.", AdapterUtil.toString(var2_2)});
        }
        if (this._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && WSRdbManagedConnectionImpl.tc.isDebugEnabled()) {
                Tr.debug(WSRdbManagedConnectionImpl.tc, "MC is stale", this);
            }
            throw new DataStoreAdapterException("INVALID_CONNECTION", new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION")), WSRdbManagedConnectionImpl.class);
        }
        var3_3 = this.stateMgr.transtate;
        if (var3_3 != 1 && var3_3 != 2 && var3_3 != 7 && var3_3 != 0) {
            if (TraceComponent.isAnyTracingEnabled() && (WSRdbManagedConnectionImpl.tc.isEntryEnabled() || WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled())) {
                WSRdbManagedConnectionImpl.tempTc = WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled() != false ? WSRdbManagedConnectionImpl.clientInfoPlusTc : WSRdbManagedConnectionImpl.tc;
                Tr.exit(WSRdbManagedConnectionImpl.tempTc, "getConnection - bad transaction state, throwing exception", this.getTransactionStateAsString());
            }
            var4_4 = "Operation 'getConnection' is not permitted for transaction state: " + this.getTransactionStateAsString();
            var5_6 = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", var4_4, null, WSRdbManagedConnectionImpl.currClass);
            FFDCFilter.processException((Throwable)var5_6, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "939", this, new Object[]{var4_4, ". Possible components: Connection Manager"});
            throw var5_6;
        }
        var4_5 = (WSConnectionRequestInfoImpl)var2_2;
        if (!this.supportIsolvlSwitching) {
            if (!this.cri.equals(var4_5)) {
                this.replaceCRI(var4_5);
            }
        } else {
            this.replaceCRIForCCI(var4_5);
        }
        if (this.numHandlesInUse == 0) {
            this.synchronizePropertiesWithCRI();
            if (this.stateMgr.getState() == 0 || this.stateMgr.getState() == 7 && !this.rrsGlobalTransactionReallyActive) {
                if (this.stateMgr.getState() != 7 && PmiReqMetrics.isPassCorrelatorToDB()) {
                    this.internalHelper.setEwlmCorrelator(this.metrics.getCorrelator(), this);
                }
                try {
                    this.mcf.dataStoreHelper.doConnectionSetupPerTransaction(var1_1, var1_1 != null ? null : var4_5.ivUserName, this.sqlConn, this._claimedVictim, this.doConnectoinSetupPerTranProps);
                    if (this.shouldDoConPropFirstCallBeReset) {
                        this.doConnectoinSetupPerTranProps.setProperty("FIRST_TIME_CALLED", "false");
                        this.shouldDoConPropFirstCallBeReset = false;
                    }
                }
                catch (SQLException var5_7) {
                    FFDCFilter.processException((Throwable)var5_7, WSRdbManagedConnectionImpl.currClass.getName() + ".getConnection", "2294", this);
                    throw AdapterUtil.translateSQLException(var5_7, this, true, WSRdbManagedConnectionImpl.currClass);
                }
                this.subject = var1_1;
                this._claimedVictim = false;
            }
        } else {
            if (this.extentionDSPropKey != this.cri.extentionDSPropKey) {
                throw new DataStoreAdapterException("HETEROGENOUS_USAGE_VIOLATION", "get=>use=>close must be used if extended datasource properties are set.", WSRdbManagedConnectionImpl.currClass);
            }
            if (this.supportIsolvlSwitching && this.currentTransactionIsolation != this.cri.ivIsoLevel) {
                try {
                    this.setTransactionIsolation(this.cri.ivIsoLevel);
                }
                catch (SQLException var5_8) {
                    FFDCFilter.processException((Throwable)var5_8, WSRdbManagedConnectionImpl.currClass.getName() + ".getConnection", "1867", this);
                    if (TraceComponent.isAnyTracingEnabled() && (WSRdbManagedConnectionImpl.tc.isEntryEnabled() || WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled())) {
                        WSRdbManagedConnectionImpl.tempTc = WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled() != false ? WSRdbManagedConnectionImpl.clientInfoPlusTc : WSRdbManagedConnectionImpl.tc;
                        Tr.exit(WSRdbManagedConnectionImpl.tempTc, "getConnection with exception");
                    }
                    throw AdapterUtil.translateSQLException(var5_8, this, true, WSRdbManagedConnectionImpl.currClass);
                }
            }
        }
        var5_9 = var4_5.isJDBC != false ? this.internalHelper.createJDBCConnectionWrapper(this) : WSManagedConnectionFactoryImpl.locationRestrictedFunction.getCCIConnectionHandle(this, this.sqlConn, WSRdbManagedConnectionImpl.key);
        this.addHandle(var5_9);
        if (TraceComponent.isAnyTracingEnabled() && (WSRdbManagedConnectionImpl.clientInfoTc.isDebugEnabled() || WSRdbManagedConnectionImpl.clientInfoPlusTc.isDebugEnabled()) && !this.clientInfoExplicitlySet && this.numHandlesInUse == 1) {
            if (WSRdbManagedConnectionImpl.tc.isDebugEnabled()) {
                Tr.debug(WSRdbManagedConnectionImpl.tc, "setting client info implicitly on connection: ", this);
            }
            try {
                this.internalHelper.setClientInformation(null, this, false);
            }
            catch (SQLException var6_10) {
                FFDCFilter.processException((Throwable)var6_10, WSRdbManagedConnectionImpl.currClass.getName() + ".getConnection", "2279", this);
                if (WSRdbManagedConnectionImpl.tc.isEntryEnabled() || WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled()) {
                    WSRdbManagedConnectionImpl.tempTc = WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled() != false ? WSRdbManagedConnectionImpl.clientInfoPlusTc : WSRdbManagedConnectionImpl.tc;
                    Tr.exit(WSRdbManagedConnectionImpl.tempTc, "getConnection with exception");
                }
                throw new DataStoreAdapterException("DSA_ERROR", var6_10, WSRdbManagedConnectionImpl.currClass);
            }
        }
        if (this.mcf.shouldDataBeCollectedAndPshedDownToCMX() && this.numHandlesInUse == 1 && !this.clientInfoExplicitlySet && !this.clientInfoImplicitlySet) {
            if (WSRdbManagedConnectionImpl.tc.isAnyTracingEnabled() && WSRdbManagedConnectionImpl.tc.isDebugEnabled()) {
                Tr.debug(WSRdbManagedConnectionImpl.tc, "Setting client info for end to end Monitoring feature on connection: ", this);
            }
            try {
                this.internalHelper.setClientInformationEndToEndMonitoring(this.mcf.getDataSourceProperties(), this, false);
            }
            catch (SQLException var6_11) {
                FFDCFilter.processException((Throwable)var6_11, WSRdbManagedConnectionImpl.currClass.getName() + ".getConnection", "2279", this);
                if (WSRdbManagedConnectionImpl.tc.isEntryEnabled() || WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled()) {
                    WSRdbManagedConnectionImpl.tempTc = WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled() != false ? WSRdbManagedConnectionImpl.clientInfoPlusTc : WSRdbManagedConnectionImpl.tc;
                    Tr.exit(WSRdbManagedConnectionImpl.tempTc, "getConnection with exception");
                }
                throw new DataStoreAdapterException("DSA_ERROR", var6_11, WSRdbManagedConnectionImpl.currClass);
            }
        }
        if (this.internalHelper.shouldTraceBeEnabled(this)) {
            this.internalHelper.enableJdbcLogging(this);
        } else if (this.internalHelper.shouldTraceBeDisabled(this)) {
            this.internalHelper.disableJdbcLogging(this);
        }
        if (this.numHandlesInUse == 1) {
            try {
                var6_12 = this.mcf.dataStoreHelper.doConnectionSetupPerGetConnection(this.sqlConn, this.cri.isJDBC == false, null);
                if (!TraceComponent.isAnyTracingEnabled() || !WSRdbManagedConnectionImpl.tc.isDebugEnabled()) ** GOTO lbl99
                Tr.debug(WSRdbManagedConnectionImpl.tc, "doConnectionSetupPerGetConnection on [helper, mc, sqlCon, returned value] ", new Object[]{this.mcf.dataStoreHelper, this, this.sqlConn, new Boolean(var6_12)});
            }
            catch (Throwable var6_13) {
                FFDCFilter.processException(var6_13, WSRdbManagedConnectionImpl.currClass.getName() + ".getConnection", "2849", this);
                if (var6_13 instanceof SQLException) {
                    throw AdapterUtil.translateSQLException((SQLException)var6_13, this, true, WSRdbManagedConnectionImpl.currClass);
                }
                throw new DataStoreAdapterException("DSA_ERROR", var6_13, WSRdbManagedConnectionImpl.currClass);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && WSRdbManagedConnectionImpl.tc.isDebugEnabled()) {
            Tr.debug(WSRdbManagedConnectionImpl.tc, "doConnectionSetupPerGetConnection is not called on mc because number of handles is not 1 (i.e. get=>use=>close is not followed", new Object[]{this, new Integer(this.numHandlesInUse)});
        }
lbl99:
        // 5 sources

        this.fatalErrorCount = this.mcf.fatalErrorCount;
        if (TraceComponent.isAnyTracingEnabled() && (WSRdbManagedConnectionImpl.tc.isEntryEnabled() || WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled())) {
            WSRdbManagedConnectionImpl.tempTc = WSRdbManagedConnectionImpl.clientInfoPlusTc.isEntryEnabled() != false ? WSRdbManagedConnectionImpl.clientInfoPlusTc : WSRdbManagedConnectionImpl.tc;
            Tr.exit(WSRdbManagedConnectionImpl.tempTc, "getConnection", var5_9);
        }
        try {
            if (this.mcf.shouldDataBeCollectedAndPshedDownToCMX()) {
                AdapterUtil.displayApplicationInfoAndPostCMXMsg(false, this.mcf.collectDataAndPushDownToCMX, this.mc_j2eename, this.mcf.appServerName, this.internalHelper, 110, this.mcf.collectDataAndPushDownToCMX != false ? AdapterUtil.getcmxArgsObject(3, this.mc_j2eename, this.mcf.j2cConfigPropOb, this, null, this.mcf.jndiName, null) : null, this.sqlConn);
            }
        }
        catch (Throwable var6_14) {
            if (WSRdbManagedConnectionImpl.tc.isAnyTracingEnabled() && WSRdbManagedConnectionImpl.tc.isDebugEnabled()) {
                Tr.debug(WSRdbManagedConnectionImpl.tc, "got an exception while calling . Disabling the monitoring based on that.  Exception is:", var6_14);
            }
            Tr.warning(WSRdbManagedConnectionImpl.tc, "CMX_MONITORING_CHECKING_PROBLEM", var6_14);
            this.mcf.enableEndToEndMonitoringFeature = false;
        }
        return var5_9;
    }

    public void destroy() throws ResourceException {
        ResourceException resourceException;
        block27: {
            DataStoreAdapterException dataStoreAdapterException;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.entry(tc, "destroy", this);
                                }
                                resourceException = null;
                                try {
                                    this.cleanupTransactions(false);
                                }
                                catch (ResourceException resourceException2) {
                                    FFDCFilter.processException((Throwable)resourceException2, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", "957", this);
                                    Tr.warning(tc, "DSTRY_ERROR_EX", (Object)resourceException2);
                                    if (resourceException != null) break block22;
                                    resourceException = resourceException2;
                                }
                            }
                            ResourceException resourceException3 = this.closeHandles();
                            ResourceException resourceException4 = resourceException = resourceException == null ? resourceException3 : resourceException;
                            if (this.statementCache != null) {
                                this.clearStatementCache();
                            }
                            if (this.defContext != null) {
                                try {
                                    this.internalHelper.closeDefaultContext(this.defContext);
                                }
                                catch (ResourceException resourceException5) {
                                    FFDCFilter.processException((Throwable)resourceException5, this.getClass().getName() + ".destroy", "1439", this);
                                    if (resourceException != null) break block23;
                                    resourceException = resourceException5;
                                }
                            }
                        }
                        if (this.sqljContext != null) {
                            try {
                                this.internalHelper.closeDefaultContext(this.sqljContext);
                            }
                            catch (ResourceException resourceException6) {
                                FFDCFilter.processException((Throwable)resourceException6, this.getClass().getName() + ".destroy", "2596", this);
                                if (resourceException != null) break block24;
                                resourceException = resourceException6;
                            }
                        }
                    }
                    if (this.cachedConnection != null) {
                        try {
                            this.cachedConnection.close();
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", "2607", this);
                            dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                            if (resourceException != null) break block25;
                            resourceException = dataStoreAdapterException;
                        }
                    }
                }
                if (this.sqlConn != null) {
                    try {
                        this.sqlConn.close();
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", "1005", this);
                        dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                        if (resourceException != null) break block26;
                        resourceException = dataStoreAdapterException;
                    }
                }
            }
            if (this.poolConn != null) {
                try {
                    this.poolConn.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", "1024", this);
                    dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                    if (resourceException != null) break block27;
                    resourceException = dataStoreAdapterException;
                }
            }
        }
        this.defaultCatalog = null;
        this.defaultTypeMap = null;
        this.dbMetaData = null;
        this.handlesInUse = null;
        this.mcf = null;
        this.ivEventListeners = null;
        this.metrics = null;
        this.localTran = null;
        this.xares = null;
        this.cri = null;
        this.subject = null;
        this.sqlConn = null;
        this.poolConn = null;
        this.statementCache = null;
        this.pmi = null;
        this.defContext = null;
        this.sqljContext = null;
        this.cachedConnection = null;
        this.mc_j2eename = null;
        if (resourceException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "destroy - throwing exception caught during destroy() processing");
            }
            throw resourceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void dissociateHandle(Reassociateable reassociateable) {
        if (!this.cleaningUpHandles && !this.removeHandle(reassociateable) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unable to dissociate Connection handle with current ManagedConnection because it is not currently associated with the ManagedConnection.", new Object[]{reassociateable, this});
        }
    }

    public final void cleanup() throws ResourceException {
        ResourceException resourceException;
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanup", this);
            }
            resourceException = this.numHandlesInUse < 1 ? null : this.closeHandles();
            try {
                this.cleanupTransactions(true);
            }
            catch (ResourceException resourceException2) {
                if (resourceException != null) break block12;
                resourceException = resourceException2;
            }
        }
        this.threadID = null;
        if (resourceException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup", (Object)resourceException);
            }
            throw resourceException;
        }
        this.cleanupStates();
        if (this.fatalErrorCount == -1L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup", "Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CONN_NEVER_CLOSED", null, null, this.getClass());
        }
        if (!this.connectionErrorDetected && this.mcf.validateAfterConnectionError && this.mcf.fatalErrorCount != this.fatalErrorCount && !this.mcf.getPurgePolicy().equals("EntirePool")) {
            try {
                this.preTestConnection(false);
                this.fatalErrorCount = this.mcf.fatalErrorCount;
            }
            catch (ResourceException resourceException3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "cleanup", "Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("CONN_ERROR_ON_CLEANUP", null, null, this.getClass());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    private void cleanupStates() throws ResourceException {
        boolean bl;
        this.stateMgr.transtate = 0;
        this.rrsGlobalTransactionReallyActive = false;
        try {
            this.internalHelper.resetClientInformation(this);
            this.internalHelper.doConnectionCleanupOnWrapper(this);
            bl = PmiReqMetrics.isPassCorrelatorToDB() || this.mcf.resetConnectionByBackendDatabase ? this.internalHelper.resetConnection(this) : this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
            this.internalHelper.clearWarnings(this, false);
            if (this.internalHelper.shouldTraceBeEnabled(this)) {
                this.internalHelper.enableJdbcLogging(this);
            } else if (this.internalHelper.shouldTraceBeDisabled(this)) {
                this.internalHelper.disableJdbcLogging(this);
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".cleanupStates", "1298", this);
            throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
        }
        if (this.connectionPropertyChanged || bl) {
            if (this.mData.supportsIsReadOnly()) {
                try {
                    this.internalHelper.setReadOnly(this, this.defaultReadOnly, false);
                    if (!DSConfigurationHelper._disablePK54589) {
                        if (!this.getCRI().isCRIChangable()) {
                            this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.getCRI()), 29497789L);
                        }
                        this.getCRI().setReadOnly(this.defaultReadOnly, 29497789L);
                    }
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".cleanupStates", "1226", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
            if (this.mData.supportsGetCatalog()) {
                try {
                    this.setCatalog(this.defaultCatalog);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".cleanupStates", "1227", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
            if (this.mData.supportsGetTypeMap()) {
                try {
                    this.setTypeMap(this.defaultTypeMap);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".cleanupStates", "1228", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
            this.connectionPropertyChanged = false;
            if (bl) {
                try {
                    this.currentAutoCommit = this.sqlConn.getAutoCommit();
                    if (this.cachedConnection != null) {
                        this.internalHelper.setCurrentAutoCommit(this.cachedConnection, this.currentAutoCommit);
                    }
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".cleanupStates", "1308", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
                try {
                    this.currentTransactionIsolation = this.sqlConn.getTransactionIsolation();
                    if (this.cachedConnection != null) {
                        this.internalHelper.setCurrentTransactionIsolation(this.cachedConnection, this.currentTransactionIsolation);
                    }
                    if (!this.supportIsolvlSwitching && !DSConfigurationHelper._disablePK54589) {
                        if (!this.getCRI().isCRIChangable()) {
                            this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.getCRI()), 29497789L);
                        }
                        this.getCRI().setTransactionIsolationLevel(this.currentTransactionIsolation, 29497789L);
                    }
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".cleanupStates", "1318", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
                try {
                    this.currentHoldability = this.mcf.getInternalDataStoreHelper().getHoldability(this.sqlConn);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".cleanupStates()", "3412", this);
                    throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                }
            }
        }
        this.wasLazilyEnlisted = false;
    }

    private void cleanupTransactions(boolean bl) throws ResourceException {
        block48: {
            switch (this.stateMgr.transtate) {
                case 2: {
                    try {
                        ((WSRdbXaResourceImpl)this.xares).end();
                    }
                    catch (XAException xAException) {
                        // empty catch block
                    }
                    try {
                        ((WSRdbXaResourceImpl)this.xares).rollback();
                    }
                    catch (XAException xAException) {
                        FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "1200", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Failed to end or rollback XAResource during cleanup from failure state. Continuing with cleanup.", AdapterUtil.getXAExceptionCodeString(xAException.errorCode));
                        }
                        throw new DataStoreAdapterException("DSA_ERROR", xAException, currClass);
                    }
                    if (!bl) break;
                    String string = "Cannot call 'cleanup' on a ManagedConnection while it is still in a transaction.";
                    DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", string, null, currClass);
                    FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "1562", this, new Object[]{string, " Possible components: Connection Manager, Transactions"});
                    throw dataStoreAdapterException;
                }
                case 1: 
                case 4: {
                    if (!this.currentAutoCommit) {
                        try {
                            if (this.metrics.isInteractionMetricsEnabled()) {
                                this.pmiRollback();
                            } else {
                                this.sqlConn.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "1223", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "Connection rollback failed. Continuing with cleanup.");
                            }
                            throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                        }
                    }
                    if (!bl) break;
                    String string = "Cannot call 'cleanup' on a ManagedConnection while it is still in a transaction.";
                    DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", string, null, currClass);
                    FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "1592", this, new Object[]{string, " Possible components: Connection Manager"});
                    throw dataStoreAdapterException;
                }
                case 7: {
                    if (!bl) break;
                    String string = "Cannot call 'cleanup' on a ManagedConnection while it is still in an RRS managed transaction.";
                    DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", string, null, currClass);
                    FFDCFilter.processException((Throwable)((Object)dataStoreAdapterException), "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "3340", this, new Object[]{string, " Possible components: Connection Manager"});
                    throw dataStoreAdapterException;
                }
            }
            int n = this.mcf.getCommitOrRollbackOnCleanup();
            if (n != -1) {
                if (this.mcf.dataStoreHelper.getMetaData().supportsUOWDetection()) {
                    String string = "none";
                    try {
                        if (!this.mcf.internalHelper.isInDatabaseUnitOfWork(this.sqlConn)) break block48;
                        if (n == 0) {
                            string = "commit";
                            if (!this.mcf.loggedDbUowMessage) {
                                Tr.info(tc, "RESOLVING_DB_IMPLICIT_TRANSACTIONS", string);
                                this.mcf.loggedDbUowMessage = true;
                            } else {
                                Tr.debug(tc, "committing implicit transaction");
                            }
                            if (this.metrics.isInteractionMetricsEnabled()) {
                                this.pmiCommit();
                            } else {
                                this.sqlConn.commit();
                            }
                            break block48;
                        }
                        if (n != 1) break block48;
                        string = "rollback";
                        if (!this.mcf.loggedDbUowMessage) {
                            Tr.info(tc, "RESOLVING_DB_IMPLICIT_TRANSACTIONS", string);
                            this.mcf.loggedDbUowMessage = true;
                        } else {
                            Tr.debug(tc, "rolling back implicit transaction");
                        }
                        if (this.metrics.isInteractionMetricsEnabled()) {
                            this.pmiRollback();
                            break block48;
                        }
                        this.sqlConn.rollback();
                    }
                    catch (Throwable throwable) {
                        String string2 = "Error resolving implicitly started transaction on ManagedConnection.";
                        Tr.info(tc, "ERROR_RESOLVING_DB_IMPLICIT_TRANSACTIONS", new Object[]{string, throwable});
                        FFDCFilter.processException(throwable, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "3584", this, new Object[]{string2});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error resolving implicitly started transaction on ManagedConnection.  Exception is:", throwable);
                        }
                        break block48;
                    }
                }
                try {
                    if (n == 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Commit connection automatically per custom property commitOrRollbackOnCleanup");
                        }
                        if (!this.currentAutoCommit) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "AC is false, so we will issue a commit in case there is an implicit tra.");
                            }
                            if (this.metrics.isInteractionMetricsEnabled()) {
                                this.pmiCommit();
                            } else {
                                this.sqlConn.commit();
                            }
                        }
                        break block48;
                    }
                    if (n != 1) break block48;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Rollback connection automatically per custom property commitOrRollbackOnCleanup");
                    }
                    if (this.currentAutoCommit) break block48;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "AC is false, so we will issue a rollback in case there is an implicit tra.");
                    }
                    if (this.metrics.isInteractionMetricsEnabled()) {
                        this.pmiRollback();
                        break block48;
                    }
                    this.sqlConn.rollback();
                }
                catch (Throwable throwable) {
                    String string = "Error resolving implicitly started transaction on ManagedConnection.";
                    FFDCFilter.processException(throwable, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "3622", this, new Object[]{string});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error resolving implicitly started transaction on ManagedConnection.  Exception is:", throwable);
                    }
                    break block48;
                }
            }
            if (this.mcf.dataStoreHelper.getMetaData().supportsUOWDetection()) {
                try {
                    if (this.mcf.internalHelper.isInDatabaseUnitOfWork(this.sqlConn)) {
                        if (!this.mcf.loggedImmplicitTransactionFound) {
                            Tr.info(tc, "IMPLICIT_TRANSACTION_FOUND");
                            this.mcf.loggedImmplicitTransactionFound = true;
                        }
                        if (this.metrics.isInteractionMetricsEnabled()) {
                            this.pmiRollback();
                        } else {
                            this.sqlConn.rollback();
                        }
                    }
                }
                catch (Throwable throwable) {
                    String string = "Error while attempting to rollback database implicitly started transaction on ManagedConnection.";
                    FFDCFilter.processException(throwable, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", "3761", this, new Object[]{string});
                    if (!tc.isDebugEnabled()) break block48;
                    Tr.debug(tc, "Error while attempting to rollback database implicitly started transaction on ManagedConnection.", throwable);
                }
            }
        }
    }

    public final void clearStatementCache() {
        if (this.statementCache == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "statement cache is null. caching is disabled");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearStatementCache");
        }
        Object[] objectArray = this.statementCache.removeAll();
        int n = objectArray.length;
        while (n > 0) {
            try {
                ((Statement)objectArray[--n]).close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".clearStatementCache", "2169", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Error closing statement", sQLException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearStatementCache");
        }
    }

    private ResourceException closeHandles() {
        ResourceException resourceException = null;
        Reassociateable reassociateable = null;
        this.cleaningUpHandles = true;
        int n = this.numHandlesInUse;
        while (n > 0) {
            reassociateable = this.handlesInUse[--n];
            this.handlesInUse[n] = null;
            if (reassociateable instanceof WSJdbcConnection) {
                try {
                    ((WSJdbcConnection)reassociateable).close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".closeHandles", "1414", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Error closing handle. Continuing...", reassociateable);
                    }
                    DataStoreAdapterException dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException, this, true, currClass);
                    if (resourceException != null) continue;
                    resourceException = dataStoreAdapterException;
                }
                continue;
            }
            try {
                ((Connection)reassociateable).close();
            }
            catch (ResourceException resourceException2) {
                FFDCFilter.processException((Throwable)resourceException2, currClass.getName() + ".closeHandles", "1822", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Error closing handle. Continuing...", reassociateable);
                }
                if (resourceException != null) continue;
                resourceException = resourceException2;
            }
        }
        this.numHandlesInUse = 0;
        this.cleaningUpHandles = false;
        return resourceException;
    }

    private Subject copySubject(final Subject subject) throws ResourceException {
        try {
            return (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Subject(subject.isReadOnly(), subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.copySubject", "1796", this);
            throw (ResourceException)((Object)privilegedActionException.getException());
        }
    }

    public void associateConnection(Object object) throws ResourceException {
        Reassociateable reassociateable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "associateConnection", new Object[]{this, object});
        }
        try {
            reassociateable = (Reassociateable)object;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.associateConnection", "1398", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast Connection handle to Reassociateable", new Object[]{AdapterUtil.toString(object), classCastException});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "associateConnection - failed casting connection, throwing exception");
            }
            throw new DataStoreAdapterInternalException("WS_INTERNAL_ERROR", new Object[]{"Called \"associateConnection\" with a connection type that is not recognized " + object.getClass().getName(), classCastException}, "Called \"associateConnection\" with a connection type that is not recognized " + object.getClass().getName());
        }
        try {
            ConnectionRequestInfo connectionRequestInfo;
            int n;
            WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = (WSRdbManagedConnectionImpl)reassociateable.getManagedConnection(key);
            int n2 = n = wSRdbManagedConnectionImpl == null ? 0 : wSRdbManagedConnectionImpl.stateMgr.transtate;
            if (wSRdbManagedConnectionImpl != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Old ManagedConnection rrsGlobalTransactionReallyActive :", new Boolean(wSRdbManagedConnectionImpl.rrsGlobalTransactionReallyActive));
                }
                this.rrsGlobalTransactionReallyActive = wSRdbManagedConnectionImpl.rrsGlobalTransactionReallyActive;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Old ManagedConnection transaction state:", wSRdbManagedConnectionImpl == null ? null : wSRdbManagedConnectionImpl.getTransactionStateAsString());
                Tr.debug(tc, "New ManagedConnection transaction state:", this.getTransactionStateAsString());
            }
            if (!(n != 2 && n != 7 && n != 1 || reassociateable.isReserved())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Reassociation requested within a transaction; handle reassociation will be ignored.");
                }
                reassociateable.reserve(key);
                wSRdbManagedConnectionImpl.dissociateHandle(reassociateable);
                connectionRequestInfo = reassociateable.getCRI();
            } else {
                if (reassociateable.getState() == 0) {
                    reassociateable.dissociate();
                }
                connectionRequestInfo = reassociateable.getCRI();
                reassociateable.reassociate(this, this.sqlConn, key);
            }
            if (!this.cri.equals(connectionRequestInfo)) {
                this.replaceCRI((WSConnectionRequestInfoImpl)connectionRequestInfo);
            }
            if (this.numHandlesInUse == 0) {
                this.synchronizePropertiesWithCRI();
            }
            this.addHandle(reassociateable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "associateConnection");
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.associateConnection", "1981", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "associateConnection", "Exception");
            }
            throw resourceException;
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "addConnectionEventListener", new Object[]{this, connectionEventListener});
            }
            if (connectionEventListener == null) {
                throw new NullPointerException("Cannot add null ConnectionEventListener.");
            }
            try {
                this.metrics = (InteractionMetrics)connectionEventListener;
            }
            catch (ClassCastException classCastException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Event listener doesn't implement the InteractionMetrics interface:", connectionEventListener);
            }
        }
        if (this.numListeners >= this.ivEventListeners.length) {
            ConnectionEventListener[] connectionEventListenerArray = this.ivEventListeners;
            this.ivEventListeners = new ConnectionEventListener[this.numListeners + 3];
            System.arraycopy(connectionEventListenerArray, 0, this.ivEventListeners, 0, connectionEventListenerArray.length);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "received more ConnectionEventListeners than expected, increased array size to " + this.ivEventListeners.length);
            }
        }
        this.ivEventListeners[this.numListeners++] = connectionEventListener;
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeConnectionEventListener", connectionEventListener);
        }
        if (connectionEventListener == null) {
            NullPointerException nullPointerException = new NullPointerException("Cannot remove null ConnectionEventListener.");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "removeConnectionEventListener", nullPointerException);
            }
            throw nullPointerException;
        }
        for (int i = 0; i < this.numListeners; ++i) {
            if (connectionEventListener != this.ivEventListeners[i]) continue;
            this.ivEventListeners[i] = this.ivEventListeners[--this.numListeners];
            this.ivEventListeners[this.numListeners] = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "removeConnectionEventListener");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeConnectionEventListener", "Listener not found for remove.");
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getXAResource", this);
        }
        if (this.xares != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Returning existing XAResource", this.xares);
            }
        } else if (this.is2Phase) {
            try {
                XAResource xAResource = ((XAConnection)this.poolConn).getXAResource();
                this.xares = new WSRdbXaResourceImpl(xAResource, this);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.getXAResource", "1638", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getXAResource - failed trying to create XAResource, throwing exception");
                }
                throw AdapterUtil.translateSQLException(sQLException, this, true, currClass);
            }
        } else {
            this.xares = new WSRdbOnePhaseXaResourceImpl(this.sqlConn, this.databaseType, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getXAResource");
        }
        return this.xares;
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalTransaction", this);
        }
        WSRdbSpiLocalTransactionImpl wSRdbSpiLocalTransactionImpl = this.localTran = this.localTran == null ? new WSRdbSpiLocalTransactionImpl(this, this.sqlConn) : this.localTran;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalTransaction", this.localTran);
        }
        return this.localTran;
    }

    public final int getTransactionState() {
        return this.stateMgr.transtate;
    }

    public final WSStateManager getStateManager() {
        return this.stateMgr;
    }

    public final String getTransactionStateAsString() {
        return this.stateMgr.getStateAsString();
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.dbMetaData == null ? (this.dbMetaData = new WSManagedConnectionMetaDataImpl(this.sqlConn, this)) : this.dbMetaData;
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setLogWriter on the mc is a no-op when calling this method");
        }
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        try {
            return this.mcf.getLogWriter(this.cri.ivConfigID);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, currClass.getName() + ".getLogWriter", "3529", this);
            throw new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
        }
    }

    public final boolean getAutoCommit() {
        return this.currentAutoCommit;
    }

    public final void setAutoCommit(boolean bl) throws SQLException {
        if (bl != this.currentAutoCommit || this.internalHelper.alwaysSetAutoCommit()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Set AutoCommit to " + bl);
            }
            this.sqlConn.setAutoCommit(bl);
            this.currentAutoCommit = bl;
            if (this.cachedConnection != null) {
                this.internalHelper.setCurrentAutoCommit(this.cachedConnection, this.currentAutoCommit);
            }
        }
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        if (this.currentTransactionIsolation != n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Set Isolation Level to " + AdapterUtil.getIsolationLevelString(n));
            }
            this.sqlConn.setTransactionIsolation(n);
            this.currentTransactionIsolation = n;
            if (this.cachedConnection != null) {
                this.internalHelper.setCurrentTransactionIsolation(this.cachedConnection, this.currentTransactionIsolation);
            }
            this.isolationChanged = true;
        }
    }

    public final int getTransactionIsolation() {
        return this.currentTransactionIsolation;
    }

    public final void setHoldability(int n) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHoldability", "Set Holdability to " + AdapterUtil.getCursorHoldabilityString(n));
        }
        this.sqlConn.setHoldability(n);
        this.currentHoldability = n;
        this.holdabilityChanged = true;
    }

    public final int getHoldability() throws SQLException {
        if (this.currentHoldability != 0) {
            return this.currentHoldability;
        }
        return this.sqlConn.getHoldability();
    }

    public final int getCurrentHoldability() {
        return this.currentHoldability;
    }

    public final void setCatalog(String string) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Set Catalog to " + string);
        }
        this.sqlConn.setCatalog(string);
        this.connectionPropertyChanged = true;
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Set readOnly to " + bl);
        }
        this.sqlConn.setReadOnly(bl);
        this.connectionPropertyChanged = true;
    }

    public final WSConnectionRequestInfoImpl getCRI() {
        return this.cri;
    }

    public final void setCRI(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setCRI to ", wSConnectionRequestInfoImpl);
        }
        if (l != 29497789L) {
            throw new IllegalArgumentException();
        }
        this.cri = wSConnectionRequestInfoImpl;
    }

    public final Subject getSubject() {
        return this.subject;
    }

    public final void setTypeMap(Map map) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Set TypeMap to " + map);
        }
        this.sqlConn.setTypeMap(map);
        this.connectionPropertyChanged = true;
    }

    public final Object getConnectionContext() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionContext", this);
        }
        if (this.defContext == null) {
            try {
                this.defContext = this.internalHelper.getDefaultContext(this.sqlConn);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.getConnectionContext", "2491", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnectionContext - failed trying to create SQLJ ConnectionContext, throwing exception");
                }
                throw AdapterUtil.mapSQLException(sQLException, this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionContext", this.defContext);
        }
        return this.defContext;
    }

    public final Object getSQLJConnectionContext() throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSQLJConnectionContext", this);
        }
        if (this.sqljContext == null) {
            try {
                this.sqljContext = this.internalHelper.getSQLJContext(this);
            }
            catch (SQLException sQLException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSQLJConnectionContext - failed trying to create SQLJ ConnectionContext, throwing exception");
                }
                throw AdapterUtil.mapSQLException(sQLException, this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSQLJConnectionContext", this.sqljContext);
        }
        return this.sqljContext;
    }

    public void preTestConnection() throws ResourceException {
        this.preTestConnection(true);
    }

    void preTestConnection(boolean bl) throws ResourceException {
        block33: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "preTestConnection", new Object[]{this, "preTestSQLString: " + (this.mcf.preTestSQLString == null ? "null" : "\"" + this.mcf.preTestSQLString + "\"")});
            }
            String string = null;
            if (this.mcf.preTestSQLString == null || this.mcf.preTestSQLString.equals("") || this.mcf.preTestSQLString.trim().equals("")) {
                string = "SELECT 1 FROM DUAL";
                if (bl) {
                    Tr.warning(tc, "NO_EMPTY_PRE_TEST_SQL_STRING");
                }
            } else {
                string = this.mcf.preTestSQLString;
            }
            Statement statement = null;
            try {
                statement = this.sqlConn.createStatement();
                statement.execute(string);
                if (!this.currentAutoCommit) {
                    if (this.metrics.isInteractionMetricsEnabled()) {
                        this.pmiRollback();
                    } else {
                        this.sqlConn.rollback();
                    }
                }
                statement.close();
                statement = null;
                this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
                this.sqlConn.clearWarnings();
            }
            catch (SQLException sQLException) {
                DataStoreAdapterException dataStoreAdapterException;
                block32: {
                    block31: {
                        block30: {
                            dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException, this, false, currClass);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "preTestConnection", new Object[]{AdapterUtil.getStackTraceWithState(sQLException)});
                            }
                            if (dataStoreAdapterException.isConnectionError()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "preTestConnection", "connection is bad");
                                }
                                throw dataStoreAdapterException;
                            }
                            if (dataStoreAdapterException.isAuthorizationException()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "preTestConnection", "authorization exception.  Exception will be thrown back to the application");
                                }
                                throw dataStoreAdapterException;
                            }
                            if (!this.currentAutoCommit) {
                                try {
                                    if (this.metrics.isInteractionMetricsEnabled()) {
                                        this.pmiRollback();
                                    } else {
                                        this.sqlConn.rollback();
                                    }
                                }
                                catch (SQLException sQLException2) {
                                    dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException2, this, true, currClass);
                                    if (!dataStoreAdapterException.isConnectionError()) break block30;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.exit(tc, "preTestConnection", "connection is bad");
                                    }
                                    throw dataStoreAdapterException;
                                }
                            }
                        }
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                        catch (SQLException sQLException3) {
                            dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException3, this, true, currClass);
                            if (!dataStoreAdapterException.isConnectionError()) break block31;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "preTestConnection", "connection is bad");
                            }
                            throw dataStoreAdapterException;
                        }
                    }
                    try {
                        this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
                    }
                    catch (SQLException sQLException4) {
                        dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException4, this, true, currClass);
                        if (!dataStoreAdapterException.isConnectionError()) break block32;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "preTestConnection", "connection is bad");
                        }
                        throw dataStoreAdapterException;
                    }
                }
                try {
                    this.sqlConn.clearWarnings();
                }
                catch (SQLException sQLException5) {
                    dataStoreAdapterException = AdapterUtil.translateSQLException(sQLException5, this, true, currClass);
                    if (!dataStoreAdapterException.isConnectionError()) break block33;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "preTestConnection", "connection is bad");
                    }
                    throw dataStoreAdapterException;
                }
            }
        }
    }

    public void setClaimedVictim() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "marking this mc as _claimedVicitm", this);
        }
        this._claimedVictim = true;
    }

    public String toString() {
        return "WSRdbManagedConnectionImpl" + '@' + Integer.toHexString(this.hashCode());
    }

    public int getNumberOfInUseHandles() {
        return this.numHandlesInUse;
    }

    public boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public J2EEName getJ2EEName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getJ2EEName() returned:", this.mc_j2eename);
        }
        return this.mc_j2eename;
    }

    public long getConnectionWaitTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnectionWaitTime() returned:", new Long(this.mc_connectionWaitTime));
        }
        return this.mc_connectionWaitTime;
    }

    public void setManagedConnectionWaitTime(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setManagedConnectionWaitTime(long connectionWaitTime)", new Long(l));
        }
        this.mc_connectionWaitTime = l;
    }

    public void setDynamicMaxConnection(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Push the CMX data for message 100 and max connection to " + n + " for " + this);
        }
        Object object = this.mcf.internalHelper.getCMXDataSourceProxy(this.mcf.dataSource.getDataSource(0), this.mcf.dataSource.isJTAEnabled());
        AdapterUtil.displayApplicationInfoAndPostCMXMsg(false, true, null, this.mcf.appServerName, this.mcf.internalHelper, 100, AdapterUtil.getcmxArgsObject(6, null, null, this.mcf.dataSource, this.mcf.dataSource.getServerVersion(), this.mcf.jndiName, new Integer(n)), object);
    }
}

