/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.OnePhaseXAResource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.TransactionException;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.spi.WSStateManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class WSRdbOnePhaseXaResourceImpl
implements OnePhaseXAResource,
FFDCSelfIntrospectable {
    private final Connection ivSqlConn;
    private final WSRdbManagedConnectionImpl ivManagedConnection;
    private final WSStateManager ivStateManager;
    private final String ivDatabaseType;
    private final boolean detectMultithreadedAccess;
    private static final Class currClass = WSRdbOnePhaseXaResourceImpl.class;
    private static final TraceComponent tc = Tr.register(currClass, "RRA", "IBMDataStoreAdapterNLS");

    public WSRdbOnePhaseXaResourceImpl(Connection connection, String string, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{AdapterUtil.toString(connection), string, wSRdbManagedConnectionImpl});
        }
        this.ivSqlConn = connection;
        this.ivManagedConnection = wSRdbManagedConnectionImpl;
        this.ivDatabaseType = string;
        this.ivStateManager = this.ivManagedConnection.stateMgr;
        this.detectMultithreadedAccess = this.ivManagedConnection.mcf.detectMultithreadedAccess;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        Serializable serializable;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), bl ? "ONE PHASE" : "TWO PHASE"});
        }
        if (tc.isDebugEnabled()) {
            object = null;
            try {
                object = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in commit, exception is: ", sQLException);
            }
            if (object != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append((String)object);
                if (xid != null) {
                    stringBuffer.append("Transaction ID : ");
                    stringBuffer.append(xid);
                }
                stringBuffer.append(" COMMIT");
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if (this.detectMultithreadedAccess) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        if (!bl) {
            object = new XAException(105);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", object);
            }
            throw object;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.ivManagedConnection.wasLazilyEnlisted = false;
        try {
            serializable = this.ivManagedConnection.getManagedConnectionFactory();
            if (serializable != null && serializable.isEndToEndMonitoringFeatureEnabled()) {
                boolean bl5 = serializable.shouldDataBeCollectedAndPshedDownToCMX();
                AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl5, this.ivManagedConnection.getJ2EEName(), serializable.appServerName, serializable.getInternalDataStoreHelper(), 120, bl5 ? AdapterUtil.getcmxArgsObject(8, null, null, this, null, null, null) : null, this.ivSqlConn);
            }
            this.ivSqlConn.commit();
            this.ivStateManager.setState(7);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", "105", this);
            bl2 = true;
            Tr.error(tc, "DSA_INTERNAL_ERROR", new Object[]{"Exception caught during commit on the OnePhaseXAResource", sQLException});
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "issue a rollback due to commit failure");
                }
                this.ivSqlConn.rollback();
            }
            catch (SQLException sQLException2) {
                FFDCFilter.processException((Throwable)sQLException2, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", "197", this);
                bl3 = true;
                Tr.error(tc, "DSA_INTERNAL_ERROR", new Object[]{"Exception caught during rollback on the OnePhaseXAResource after a commit failed", sQLException2});
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", "204", this);
                bl3 = true;
                Tr.error(tc, "DSA_INTERNAL_ERROR", new Object[]{"Exception caught during rollback on the OnePhaseXAResource after a commit failed", runtimeException});
            }
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", "123", this);
            Tr.error(tc, "INVALID_TX_STATE", new Object[]{"OnePhaseXAResource.commit()", this.ivManagedConnection.getTransactionStateAsString()});
            bl4 = false;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", "221", this);
            Tr.error(tc, "DSA_INTERNAL_ERROR", new Object[]{"Exception caught during commit on the OnePhaseXAResource", runtimeException});
            XAException xAException = new XAException(8);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", "Exception");
            }
            throw xAException;
        }
        if (bl3) {
            serializable = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException((XAException)serializable, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", "Exception");
            }
            throw serializable;
        }
        if (bl2) {
            serializable = new XAException(8);
            WSRdbOnePhaseXaResourceImpl.traceXAException((XAException)serializable, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", "Exception");
            }
            throw serializable;
        }
        if (bl4) {
            serializable = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException((XAException)serializable, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit", "Exception");
            }
            throw serializable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    public void end(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "end", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceEndFlagString(n)});
        }
        try {
            if (n == 0x20000000) {
                this.ivStateManager.setState(6);
            } else {
                this.ivStateManager.setState(5);
            }
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.end", "189", this);
            Tr.error(tc, "INVALID_TX_STATE", new Object[]{"OnePhaseXAResource.end()", this.ivManagedConnection.getTransactionStateAsString()});
            XAException xAException = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "end", "Exception");
            }
            throw xAException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget", AdapterUtil.toString(xid));
        }
        Tr.error(tc, "INVALID_TX_STATE", new Object[]{"OnePhaseXAResource.forget()", this.ivManagedConnection.getTransactionStateAsString()});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forget");
        }
        XAException xAException = new XAException(105);
        WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
        throw xAException;
    }

    public final String getResourceName() {
        return this.ivDatabaseType;
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    public final String[] introspectSelf() {
        return this.ivManagedConnection.introspectSelf();
    }

    void introspectThisClassOnly(FFDCLogger fFDCLogger) {
        fFDCLogger.createFFDCHeader(this);
        fFDCLogger.append("Database Type:", this.ivDatabaseType);
        fFDCLogger.append("Connection:", AdapterUtil.toString(this.ivSqlConn));
        fFDCLogger.append("ManagedConnection:", this.ivManagedConnection);
        fFDCLogger.append("Detection of multithreaded access is:", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", AdapterUtil.toString(xid));
        }
        Tr.error(tc, "INVALID_TX_STATE", new Object[]{"OnePhaseXAResource.prepare()", this.ivManagedConnection.getTransactionStateAsString()});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare");
        }
        XAException xAException = new XAException(105);
        WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
        throw xAException;
    }

    public Xid[] recover(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", AdapterUtil.getXAResourceRecoverFlagString(n));
        }
        Xid[] xidArray = new Xid[]{};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover", xidArray);
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        Serializable serializable;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid)});
        }
        if (tc.isDebugEnabled()) {
            object = null;
            try {
                object = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in commit, exception is: ", sQLException);
            }
            if (object != null) {
                serializable = new StringBuffer(200);
                serializable.append("Correlator: DB2, ID: ");
                serializable.append((String)object);
                if (xid != null) {
                    serializable.append("Transaction ID : ");
                    serializable.append(xid);
                }
                serializable.append(" ROLLBACK");
                Tr.debug(tc, serializable.toString());
            }
        }
        this.ivManagedConnection.wasLazilyEnlisted = false;
        try {
            object = this.ivManagedConnection.getManagedConnectionFactory();
            if (object != null && ((WSManagedConnectionFactoryImpl)object).isEndToEndMonitoringFeatureEnabled()) {
                boolean bl = ((WSManagedConnectionFactoryImpl)object).shouldDataBeCollectedAndPshedDownToCMX();
                AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, this.ivManagedConnection.getJ2EEName(), ((WSManagedConnectionFactoryImpl)object).appServerName, ((WSManagedConnectionFactoryImpl)object).getInternalDataStoreHelper(), 120, bl ? AdapterUtil.getcmxArgsObject(8, null, null, this, null, null, null) : null, this.ivSqlConn);
            }
            this.ivSqlConn.rollback();
            this.ivStateManager.setState(8);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.rollback", "342", this);
            Tr.error(tc, "DSA_INTERNAL_ERROR", new Object[]{"Exception caught during rollback on the OnePhaseXAResource", sQLException});
            serializable = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException((XAException)serializable, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback", "Exception");
            }
            throw serializable;
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.rollback", "351", this);
            Tr.error(tc, "INVALID_TX_STATE", new Object[]{"OnePhaseXAResource.rollback()", this.ivManagedConnection.getTransactionStateAsString()});
            serializable = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException((XAException)serializable, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback", "Exception");
            }
            throw serializable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceStartFlagString(n)});
        }
        if (this.detectMultithreadedAccess) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        try {
            this.ivManagedConnection.setAutoCommit(false);
            this.ivStateManager.setState(4);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start", "406", this);
            Tr.error(tc, "DSA_ERROR", new Object[]{sQLException, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start"});
            XAException xAException = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "Exception");
            }
            throw xAException;
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start", "407", this);
            Tr.error(tc, "INVALID_TX_STATE", new Object[]{"OnePhaseXAResource.start()", this.ivManagedConnection.getTransactionStateAsString()});
            XAException xAException = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "Exception");
            }
            throw xAException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public static final XAException traceXAException(XAException xAException, Class clazz) {
        Tr.warning(tc, "THROW_XAEXCEPTION", new Object[]{AdapterUtil.getXAExceptionCodeString(xAException.errorCode), xAException.getMessage()});
        return xAException;
    }
}

