/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.TransactionException;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.spi.WSStateManager;
import java.io.Serializable;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class WSRdbXaResourceImpl
implements XAResource,
FFDCSelfIntrospectable {
    private final XAResource ivXaRes;
    private final WSRdbManagedConnectionImpl ivManagedConnection;
    private final WSStateManager ivStateManager;
    Xid ivXid;
    private final boolean detectMultithreadedAccess;
    private static final Class currClass = WSRdbXaResourceImpl.class;
    private static final TraceComponent tc = Tr.register(currClass, "RRA", "IBMDataStoreAdapterNLS");
    private static final TraceComponent clientInfoTc = Tr.register("WAS.clientinfopluslogging", "WAS.clientinfopluslogging", "IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;

    public WSRdbXaResourceImpl(XAResource xAResource, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{xAResource, wSRdbManagedConnectionImpl});
        }
        this.ivXaRes = xAResource;
        this.ivManagedConnection = wSRdbManagedConnectionImpl;
        this.ivStateManager = wSRdbManagedConnectionImpl.stateMgr;
        this.detectMultithreadedAccess = this.ivManagedConnection.mcf.detectMultithreadedAccess;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        Serializable serializable;
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "commit", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), bl ? "ONE PHASE" : "TWO PHASE"});
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
            }
            Tr.error(tc, "INVALID_CONNECTION");
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            object = null;
            try {
                object = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in commit, exception is: ", sQLException);
            }
            if (object != null) {
                serializable = new StringBuffer(200);
                serializable.append("Correlator: DB2, ID: ");
                serializable.append((String)object);
                if (xid != null) {
                    serializable.append("Transaction ID : ");
                    serializable.append(xid);
                }
                serializable.append("COMMIT");
                Tr.debug(tc, serializable.toString());
            }
        }
        if (this.detectMultithreadedAccess) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        this.ivManagedConnection.wasLazilyEnlisted = false;
        if (this.ivXid == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "XAResource.start was never issued; allowing commit for recovery.");
            }
            try {
                this.ivStateManager.setState(9);
            }
            catch (TransactionException transactionException) {
                FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", "120", this);
                serializable = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.commit", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                this.traceXAException((XAException)serializable, currClass);
                if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "commit", serializable);
                }
                throw serializable;
            }
            this.ivXid = xid;
        } else if (!xid.equals(this.ivXid)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Xid does not match.", new Object[]{"XAResource.start:  ", AdapterUtil.toString(this.ivXid), "XAResource.commit: ", AdapterUtil.toString(xid)});
            }
            object = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "commit", AdapterUtil.toString(xid)}, -4);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "commit", object);
            }
            throw object;
        }
        this.ivXid = null;
        object = this.ivManagedConnection.getManagedConnectionFactory();
        if (object != null && ((WSManagedConnectionFactoryImpl)object).isEndToEndMonitoringFeatureEnabled()) {
            boolean bl2 = ((WSManagedConnectionFactoryImpl)object).shouldDataBeCollectedAndPshedDownToCMX();
            AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl2, this.ivManagedConnection.getJ2EEName(), ((WSManagedConnectionFactoryImpl)object).appServerName, ((WSManagedConnectionFactoryImpl)object).getInternalDataStoreHelper(), 120, bl2 ? AdapterUtil.getcmxArgsObject(5, null, null, this, null, null, null) : null, this.ivXaRes);
        }
        try {
            this.ivXaRes.commit(xid, bl);
            this.ivStateManager.setState(7);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", "113", this);
            XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.commit", this.ivManagedConnection.getTransactionStateAsString()}, -6);
            this.traceXAException(xAException, currClass);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "commit", xAException);
            }
            throw xAException;
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", "126", this);
            this.traceXAException(xAException, currClass);
            this.checkXAException(xAException);
            if (xAException.errorCode == 7 || xAException.errorCode == 8 || xAException.errorCode == 5 || xAException.errorCode == 6) {
                try {
                    this.ivStateManager.setState(13);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", "142", this);
                    Tr.warning(tc, "DSA_INTERNAL_WARNING", new Object[]{"Exception setting the transaction state to WSStateManager.HEURISTIC_END from ", this.ivManagedConnection.getTransactionStateAsString(), transactionException});
                }
            } else if (xAException.errorCode == -4 && xAException.getCause() instanceof XAException && ((XAException)xAException.getCause()).errorCode == 102) {
                try {
                    this.ivStateManager.setState(6);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), this.getClass().getName() + ".commit", "341", this);
                    XAException xAException2 = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.commit", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                    this.traceXAException(xAException2, currClass);
                    if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                        Tr.exit(clientInfoTc.isEntryEnabled() ? clientInfoTc : tc, "commit", xAException2);
                    }
                    throw xAException2;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "commit", xAException);
            }
            throw xAException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string = null;
            try {
                string = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in commit, exception is: ", sQLException);
            }
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append(string);
                if (xid != null) {
                    stringBuffer.append("Transaction ID : ");
                    stringBuffer.append(xid);
                }
                stringBuffer.append("COMMIT");
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "commit");
        }
    }

    protected final void end() throws XAException {
        this.end(this.ivXid, 0x20000000);
    }

    public void end(Xid xid, int n) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "end", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceEndFlagString(n)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
            }
            Tr.error(tc, "INVALID_CONNECTION");
            throw new XAException(-7);
        }
        if (!xid.equals(this.ivXid)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Xid does not match.", new Object[]{"XAResource.start: ", AdapterUtil.toString(this.ivXid), "XAResource.end:   ", AdapterUtil.toString(xid)});
            }
            XAException xAException = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "end", AdapterUtil.toString(xid)}, -4);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "end", xAException);
            }
            throw xAException;
        }
        WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl = this.ivManagedConnection.getManagedConnectionFactory();
        if (wSManagedConnectionFactoryImpl != null && wSManagedConnectionFactoryImpl.isEndToEndMonitoringFeatureEnabled()) {
            boolean bl = wSManagedConnectionFactoryImpl.shouldDataBeCollectedAndPshedDownToCMX();
            AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl, this.ivManagedConnection.getJ2EEName(), wSManagedConnectionFactoryImpl.appServerName, wSManagedConnectionFactoryImpl.getInternalDataStoreHelper(), 121, bl ? AdapterUtil.getcmxArgsObject(5, null, null, this, null, null, null) : null, this.ivXaRes);
        }
        try {
            this.ivStateManager.setState(5);
            this.ivXaRes.end(xid, n);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", "228", this);
            Tr.error(tc, "INVALID_TX_STATE", new Object[]{"XAResource.end()", this.ivManagedConnection.getTransactionStateAsString()});
            try {
                this.ivXaRes.rollback(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", "236", this);
                this.traceXAException(xAException, currClass);
            }
            XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.end", this.ivManagedConnection.getTransactionStateAsString()}, 100);
            this.traceXAException(xAException, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String string = null;
                try {
                    string = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
                }
                catch (SQLException sQLException) {
                    Tr.debug(tc, "got an exception trying to get the correlator in rollback during xa end fails, exception is: ", sQLException);
                }
                if (string != null) {
                    StringBuffer stringBuffer = new StringBuffer(200);
                    stringBuffer.append("Correlator: DB2, ID: ");
                    stringBuffer.append(string);
                    if (xid != null) {
                        stringBuffer.append("Transaction ID : ");
                        stringBuffer.append(xid);
                    }
                    stringBuffer.append("ROLLBACK");
                    Tr.debug(tc, stringBuffer.toString());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "end", "Exception");
            }
            throw xAException;
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", "438", this);
            this.checkXAException(xAException);
            try {
                this.ivStateManager.setState(6);
            }
            catch (TransactionException transactionException) {
                Tr.warning(tc, "DSA_INTERNAL_ERROR", new Object[]{"Error setting the state to XA_END_FAIL from ", this.ivManagedConnection.getTransactionStateAsString(), transactionException});
            }
            this.traceXAException(xAException, currClass);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "end", xAException);
            }
            throw xAException;
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "forget", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
            }
            Tr.error(tc, "INVALID_CONNECTION");
            throw new XAException(-7);
        }
        if (this.ivXid == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "XAResource.start was never issued; allowing to forget for recovery.");
        }
        if (TraceComponent.isAnyTracingEnabled() && !xid.equals(this.ivXid) && tc.isDebugEnabled()) {
            Tr.debug(tc, "Xid does not match.", new Object[]{"XAResource.start:  ", AdapterUtil.toString(this.ivXid), "XAResource.forget: ", AdapterUtil.toString(xid)});
        }
        try {
            this.ivXaRes.forget(xid);
            this.ivStateManager.setState(10);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.forget", "284", this);
            Tr.error(tc, "INVALID_TX_STATE", new Object[]{"XAResource.forget()", this.ivManagedConnection.getTransactionStateAsString()});
            this.traceXAException(new XAException(105), currClass);
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.forget", "489", this);
            this.traceXAException(xAException, currClass);
            this.checkXAException(xAException);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "forget", xAException);
            }
            throw xAException;
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "forget");
        }
    }

    public final int getTransactionTimeout() throws XAException {
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
            }
            Tr.error(tc, "INVALID_CONNECTION");
            throw new XAException(-7);
        }
        return this.ivXaRes.getTransactionTimeout();
    }

    public final String[] introspectSelf() {
        return this.ivManagedConnection.introspectSelf();
    }

    void introspectThisClassOnly(FFDCLogger fFDCLogger) {
        fFDCLogger.createFFDCHeader(this);
        fFDCLogger.append("ManagedConnection:", this.ivManagedConnection);
        fFDCLogger.append("Underlying XAResource Object: " + AdapterUtil.toString(this.ivXaRes), this.ivXaRes);
        fFDCLogger.append("Xid: ", AdapterUtil.toString(this.ivXid));
        fFDCLogger.append("Detection of multithreaded access is:", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
    }

    public final boolean isSameRM(XAResource xAResource) throws XAException {
        WSRdbXaResourceImpl wSRdbXaResourceImpl;
        boolean bl = false;
        try {
            wSRdbXaResourceImpl = (WSRdbXaResourceImpl)xAResource;
        }
        catch (ClassCastException classCastException) {
            Tr.debug(tc, "The Input XAResource is not the same type as the current XAResource", xAResource);
            return bl;
        }
        bl = this.ivXaRes.isSameRM(wSRdbXaResourceImpl.ivXaRes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isSameRM?", new Object[]{xAResource, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        return bl;
    }

    public int prepare(Xid xid) throws XAException {
        int n;
        block14: {
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.entry(tempTc, "prepare", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid)});
            }
            if (this.ivManagedConnection._mcStale) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
                }
                Tr.error(tc, "INVALID_CONNECTION");
                throw new XAException(-7);
            }
            if (!xid.equals(this.ivXid)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Xid does not match.", new Object[]{"XAResource.start:   ", AdapterUtil.toString(this.ivXid), "XAResource.prepare: ", AdapterUtil.toString(xid)});
                }
                XAException xAException = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "prepare", AdapterUtil.toString(xid)}, -4);
                if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "prepare", xAException);
                }
                throw xAException;
            }
            try {
                n = this.ivXaRes.prepare(xid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "xa.prepare() status:", new Object[]{AdapterUtil.getXAResourceVoteString(n), AdapterUtil.toString(xid)});
                }
                if (n != 3) break block14;
                try {
                    this.ivManagedConnection.wasLazilyEnlisted = false;
                    this.ivStateManager.setState(14);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.prepare", "373", this);
                    XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.prepare", this.ivManagedConnection.getTransactionStateAsString()}, 105);
                    this.traceXAException(xAException, currClass);
                    if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                        tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                        Tr.exit(tempTc, "prepare", xAException);
                    }
                    throw xAException;
                }
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.prepare", "386", this);
                this.traceXAException(xAException, currClass);
                this.checkXAException(xAException);
                if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "prepare", "Exception");
                }
                throw xAException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "prepare", new Integer(n));
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "recover", new Object[]{this, this.ivManagedConnection, AdapterUtil.getXAResourceRecoverFlagString(n)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
            }
            Tr.error(tc, "INVALID_CONNECTION");
            throw new XAException(-7);
        }
        Xid[] xidArray = null;
        try {
            xidArray = this.ivXaRes.recover(n);
            if (xidArray == null || xidArray.length == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "No oustanding transactions to recover.  Transaction state does not change.");
                }
            } else {
                this.ivStateManager.setState(9);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Outstanding transactions to recover.  Transaction state is changing to " + this.ivManagedConnection.getTransactionStateAsString());
                }
            }
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.recover", "438", this);
            Tr.warning(tc, "DSA_INTERNAL_WARNING", new Object[]{"Exception setting the transaction state to WSStateManager.XA_RECOVER from ", this.ivManagedConnection.getTransactionStateAsString(), transactionException});
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.recover", "444", this);
            this.traceXAException(xAException, currClass);
            this.checkXAException(xAException);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "recover", "Exception");
            }
            throw xAException;
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "recover", xidArray);
        }
        return xidArray;
    }

    protected final void rollback() throws XAException {
        this.rollback(this.ivXid);
    }

    public void rollback(Xid xid) throws XAException {
        Serializable serializable;
        Serializable serializable2;
        block30: {
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.entry(tempTc, "rollback", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid)});
            }
            this.ivManagedConnection.wasLazilyEnlisted = false;
            if (this.ivManagedConnection._mcStale) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
                }
                Tr.error(tc, "INVALID_CONNECTION");
                throw new XAException(-7);
            }
            if (this.ivXid == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "XAResource.start was never issued; allowing rollback for recovery.");
                }
                try {
                    this.ivStateManager.setState(9);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", "614", this);
                    XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.rollback", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                    this.traceXAException(xAException, currClass);
                    if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                        tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                        Tr.exit(tempTc, "rollback", xAException);
                    }
                    throw xAException;
                }
                this.ivXid = xid;
            } else if (!xid.equals(this.ivXid)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Xid does not match.", new Object[]{"XAResource.start:    ", AdapterUtil.toString(this.ivXid), "XAResource.rollback: ", AdapterUtil.toString(xid)});
                }
                XAException xAException = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "rollback", AdapterUtil.toString(xid)}, -4);
                if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit(tempTc, "rollback", xAException);
                }
                throw xAException;
            }
            boolean bl = true;
            serializable2 = null;
            WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl = this.ivManagedConnection.getManagedConnectionFactory();
            if (wSManagedConnectionFactoryImpl != null && wSManagedConnectionFactoryImpl.isEndToEndMonitoringFeatureEnabled()) {
                boolean bl2 = wSManagedConnectionFactoryImpl.shouldDataBeCollectedAndPshedDownToCMX();
                AdapterUtil.displayApplicationInfoAndPostCMXMsg(true, bl2, this.ivManagedConnection.getJ2EEName(), wSManagedConnectionFactoryImpl.appServerName, wSManagedConnectionFactoryImpl.getInternalDataStoreHelper(), 120, bl2 ? AdapterUtil.getcmxArgsObject(5, null, null, this, null, null, null) : null, this.ivXaRes);
            }
            try {
                this.ivXaRes.rollback(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", "524", this);
                this.traceXAException(xAException, currClass);
                this.checkXAException(xAException);
                if (xAException.errorCode == 7 || xAException.errorCode == 8 || xAException.errorCode == 5 || xAException.errorCode == 6) {
                    bl = false;
                    try {
                        this.ivStateManager.setState(13);
                    }
                    catch (TransactionException transactionException) {
                        FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", "540", this);
                        Tr.warning(tc, "DSA_INTERNAL_WARNING", new Object[]{"Exception setting the transaction state to WSStateManager.HEURISTIC_END from ", this.ivManagedConnection.getTransactionStateAsString(), transactionException});
                    }
                }
                serializable2 = xAException;
            }
            if (bl) {
                try {
                    this.ivStateManager.setState(8);
                }
                catch (TransactionException transactionException) {
                    FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", "510", this);
                    Tr.error(tc, "INVALID_TX_STATE", new Object[]{"XAResource.rollback()", this.ivManagedConnection.getTransactionStateAsString()});
                    serializable = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.rollback", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                    this.traceXAException((XAException)serializable, currClass);
                    if (serializable2 != null) break block30;
                    serializable2 = serializable;
                }
            }
        }
        this.ivXid = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string = null;
            try {
                string = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in rollback, exception is: ", sQLException);
            }
            if (string != null) {
                serializable = new StringBuffer(200);
                ((StringBuffer)serializable).append("Correlator: DB2, ID: ");
                ((StringBuffer)serializable).append(string);
                if (xid != null) {
                    ((StringBuffer)serializable).append("Transaction ID : ");
                    ((StringBuffer)serializable).append(xid);
                }
                ((StringBuffer)serializable).append(" ROLLBACK");
                Tr.debug(tc, ((StringBuffer)serializable).toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            if (serializable2 == null) {
                Tr.exit(tempTc, "rollback");
            } else {
                Tr.exit(tempTc, "rollback", serializable2);
            }
        }
        if (serializable2 != null) {
            throw serializable2;
        }
    }

    public final boolean setTransactionTimeout(int n) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setTransactionTimeout", new Integer(n));
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
            }
            Tr.error(tc, "INVALID_CONNECTION");
            throw new XAException(-7);
        }
        return this.ivXaRes.setTransactionTimeout(n);
    }

    public void start(Xid xid, int n) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry(tempTc, "start", new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceStartFlagString(n)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MC is stale throwing XAER_RMFAIL", this.ivManagedConnection);
            }
            Tr.error(tc, "INVALID_CONNECTION");
            throw new XAException(-7);
        }
        if (this.detectMultithreadedAccess) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        this.ivXid = xid;
        try {
            if (this.ivManagedConnection.mcf.transactionBranchesLooselyCoupled) {
                n = this.ivManagedConnection.mcf.getDataStoreHelper().modifyXAFlag(n);
            }
            this.ivXaRes.start(xid, n);
            this.ivStateManager.setState(4);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", "615", this);
            Tr.error(tc, "INVALID_TX_STATE", new Object[]{"XAResource.start()", this.ivManagedConnection.getTransactionStateAsString()});
            try {
                this.ivXaRes.end(xid, 0);
                this.ivXaRes.rollback(xid);
            }
            catch (XAException xAException) {
                FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", "624", this);
                this.traceXAException(xAException, currClass);
            }
            XAException xAException = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.start", this.ivManagedConnection.getTransactionStateAsString()}, 105);
            this.traceXAException(xAException, currClass);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "start", "Exception");
            }
            throw xAException;
        }
        catch (XAException xAException) {
            FFDCFilter.processException((Throwable)xAException, "com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", "639", this);
            this.traceXAException(xAException, currClass);
            this.checkXAException(xAException);
            if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit(tempTc, "start", "Exception");
            }
            throw xAException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string = null;
            try {
                string = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug(tc, "got an exception trying to get the correlator in rollback, exception is: ", sQLException);
            }
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append(string);
                if (xid != null) {
                    stringBuffer.append("Transaction ID : ");
                    stringBuffer.append(xid);
                }
                stringBuffer.append(" BEGIN");
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled())) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit(tempTc, "start");
        }
    }

    public final XAException traceXAException(XAException xAException, Class clazz) {
        String string = this.ivManagedConnection.mcf.dataStoreHelper.getXAExceptionContents(xAException);
        Tr.error(tc, "DISPLAY_XAEX_CONTENT", string);
        Tr.error(tc, "THROW_XAEXCEPTION", new Object[]{AdapterUtil.getXAExceptionCodeString(xAException.errorCode), xAException.getMessage()});
        return xAException;
    }

    private void checkXAException(XAException xAException) {
        boolean bl = false;
        switch (xAException.errorCode) {
            case -7: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "XAER_RMFAIL connection error occurred");
                }
                bl = true;
                break;
            }
            default: {
                Throwable throwable = xAException.getCause();
                if (throwable == null || !(throwable instanceof SQLException) || !(this.ivManagedConnection.mcf.dataStoreHelper.mapException((SQLException)throwable) instanceof StaleConnectionException)) break;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stale connection error occurred");
                }
                bl = true;
            }
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "process connection error occurred event for XAResource " + this);
            }
            try {
                this.ivManagedConnection.processConnectionErrorOccurredEvent(null, xAException);
            }
            catch (NullPointerException nullPointerException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Handle CLOSED or INACTIVE. Not sending CONNECTION_ERROR_OCCURRED. (caller, mc)", new Object[]{this, this.ivManagedConnection});
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "XAException was not a connection error for XAResource " + this);
        }
    }
}

